/*
 * Decompiled with CFR 0.152.
 */
package io.trino.aws.proxy.spark3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.HttpMethod;
import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.S3ClientOptions;
import com.amazonaws.services.s3.S3ResponseMetadata;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.BucketAccelerateConfiguration;
import com.amazonaws.services.s3.model.BucketCrossOriginConfiguration;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.BucketLoggingConfiguration;
import com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.services.s3.model.BucketPolicy;
import com.amazonaws.services.s3.model.BucketReplicationConfiguration;
import com.amazonaws.services.s3.model.BucketTaggingConfiguration;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.BucketWebsiteConfiguration;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.CopyPartResult;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.DeleteBucketAnalyticsConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketAnalyticsConfigurationResult;
import com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketEncryptionRequest;
import com.amazonaws.services.s3.model.DeleteBucketEncryptionResult;
import com.amazonaws.services.s3.model.DeleteBucketIntelligentTieringConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketIntelligentTieringConfigurationResult;
import com.amazonaws.services.s3.model.DeleteBucketInventoryConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketInventoryConfigurationResult;
import com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketMetricsConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketMetricsConfigurationResult;
import com.amazonaws.services.s3.model.DeleteBucketOwnershipControlsRequest;
import com.amazonaws.services.s3.model.DeleteBucketOwnershipControlsResult;
import com.amazonaws.services.s3.model.DeleteBucketPolicyRequest;
import com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketRequest;
import com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectTaggingRequest;
import com.amazonaws.services.s3.model.DeleteObjectTaggingResult;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.DeletePublicAccessBlockRequest;
import com.amazonaws.services.s3.model.DeletePublicAccessBlockResult;
import com.amazonaws.services.s3.model.DeleteVersionRequest;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.GetBucketAccelerateConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketAclRequest;
import com.amazonaws.services.s3.model.GetBucketAnalyticsConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketAnalyticsConfigurationResult;
import com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketEncryptionRequest;
import com.amazonaws.services.s3.model.GetBucketEncryptionResult;
import com.amazonaws.services.s3.model.GetBucketIntelligentTieringConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketIntelligentTieringConfigurationResult;
import com.amazonaws.services.s3.model.GetBucketInventoryConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketInventoryConfigurationResult;
import com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketLocationRequest;
import com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketMetricsConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketMetricsConfigurationResult;
import com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketOwnershipControlsRequest;
import com.amazonaws.services.s3.model.GetBucketOwnershipControlsResult;
import com.amazonaws.services.s3.model.GetBucketPolicyRequest;
import com.amazonaws.services.s3.model.GetBucketPolicyStatusRequest;
import com.amazonaws.services.s3.model.GetBucketPolicyStatusResult;
import com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest;
import com.amazonaws.services.s3.model.GetObjectAclRequest;
import com.amazonaws.services.s3.model.GetObjectLegalHoldRequest;
import com.amazonaws.services.s3.model.GetObjectLegalHoldResult;
import com.amazonaws.services.s3.model.GetObjectLockConfigurationRequest;
import com.amazonaws.services.s3.model.GetObjectLockConfigurationResult;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRetentionRequest;
import com.amazonaws.services.s3.model.GetObjectRetentionResult;
import com.amazonaws.services.s3.model.GetObjectTaggingRequest;
import com.amazonaws.services.s3.model.GetObjectTaggingResult;
import com.amazonaws.services.s3.model.GetPublicAccessBlockRequest;
import com.amazonaws.services.s3.model.GetPublicAccessBlockResult;
import com.amazonaws.services.s3.model.GetS3AccountOwnerRequest;
import com.amazonaws.services.s3.model.HeadBucketRequest;
import com.amazonaws.services.s3.model.HeadBucketResult;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListBucketAnalyticsConfigurationsRequest;
import com.amazonaws.services.s3.model.ListBucketAnalyticsConfigurationsResult;
import com.amazonaws.services.s3.model.ListBucketIntelligentTieringConfigurationsRequest;
import com.amazonaws.services.s3.model.ListBucketIntelligentTieringConfigurationsResult;
import com.amazonaws.services.s3.model.ListBucketInventoryConfigurationsRequest;
import com.amazonaws.services.s3.model.ListBucketInventoryConfigurationsResult;
import com.amazonaws.services.s3.model.ListBucketMetricsConfigurationsRequest;
import com.amazonaws.services.s3.model.ListBucketMetricsConfigurationsResult;
import com.amazonaws.services.s3.model.ListBucketsRequest;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest;
import com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ListPartsRequest;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.PartListing;
import com.amazonaws.services.s3.model.PresignedUrlDownloadRequest;
import com.amazonaws.services.s3.model.PresignedUrlDownloadResult;
import com.amazonaws.services.s3.model.PresignedUrlUploadRequest;
import com.amazonaws.services.s3.model.PresignedUrlUploadResult;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.services.s3.model.RestoreObjectRequest;
import com.amazonaws.services.s3.model.RestoreObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.SelectObjectContentRequest;
import com.amazonaws.services.s3.model.SelectObjectContentResult;
import com.amazonaws.services.s3.model.SetBucketAccelerateConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketAclRequest;
import com.amazonaws.services.s3.model.SetBucketAnalyticsConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketAnalyticsConfigurationResult;
import com.amazonaws.services.s3.model.SetBucketCrossOriginConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketEncryptionRequest;
import com.amazonaws.services.s3.model.SetBucketEncryptionResult;
import com.amazonaws.services.s3.model.SetBucketIntelligentTieringConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketIntelligentTieringConfigurationResult;
import com.amazonaws.services.s3.model.SetBucketInventoryConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketInventoryConfigurationResult;
import com.amazonaws.services.s3.model.SetBucketLifecycleConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketMetricsConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketMetricsConfigurationResult;
import com.amazonaws.services.s3.model.SetBucketNotificationConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketOwnershipControlsRequest;
import com.amazonaws.services.s3.model.SetBucketOwnershipControlsResult;
import com.amazonaws.services.s3.model.SetBucketPolicyRequest;
import com.amazonaws.services.s3.model.SetBucketReplicationConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketTaggingConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest;
import com.amazonaws.services.s3.model.SetObjectAclRequest;
import com.amazonaws.services.s3.model.SetObjectLegalHoldRequest;
import com.amazonaws.services.s3.model.SetObjectLegalHoldResult;
import com.amazonaws.services.s3.model.SetObjectLockConfigurationRequest;
import com.amazonaws.services.s3.model.SetObjectLockConfigurationResult;
import com.amazonaws.services.s3.model.SetObjectRetentionRequest;
import com.amazonaws.services.s3.model.SetObjectRetentionResult;
import com.amazonaws.services.s3.model.SetObjectTaggingRequest;
import com.amazonaws.services.s3.model.SetObjectTaggingResult;
import com.amazonaws.services.s3.model.SetPublicAccessBlockRequest;
import com.amazonaws.services.s3.model.SetPublicAccessBlockResult;
import com.amazonaws.services.s3.model.SetRequestPaymentConfigurationRequest;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.services.s3.model.VersionListing;
import com.amazonaws.services.s3.model.WriteGetObjectResponseRequest;
import com.amazonaws.services.s3.model.WriteGetObjectResponseResult;
import com.amazonaws.services.s3.model.analytics.AnalyticsConfiguration;
import com.amazonaws.services.s3.model.intelligenttiering.IntelligentTieringConfiguration;
import com.amazonaws.services.s3.model.inventory.InventoryConfiguration;
import com.amazonaws.services.s3.model.metrics.MetricsConfiguration;
import com.amazonaws.services.s3.model.ownership.OwnershipControls;
import com.amazonaws.services.s3.waiters.AmazonS3Waiters;
import com.amazonaws.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class PresignAwareAmazonS3
implements AmazonS3 {
    private static final Log log = LogFactory.getLog(PresignAwareAmazonS3.class);
    private final AmazonS3 delegate;

    PresignAwareAmazonS3(AmazonS3 delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    private Optional<Presigned> getPresignedUrl(String method, String bucket, String key) {
        return this.getPresignedUrl(method, bucket, key, Optional.empty());
    }

    private Optional<Presigned> getPresignedUrl(String method, String bucket, String key, Optional<UploadPartRequest> uploadPartRequest) {
        Map headers;
        ObjectMetadata objectMetadata;
        Optional<String> uploadId = uploadPartRequest.map(UploadPartRequest::getUploadId);
        Optional<Integer> partNumber = uploadPartRequest.map(UploadPartRequest::getPartNumber);
        log.debug((Object)"request.get-presigned-url method=%s bucket=%s key=%s uploadId=%s partNumber=%s".formatted(method, bucket, key, uploadId, partNumber));
        try {
            GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(bucket, key);
            partNumber.ifPresent(arg_0 -> ((GetObjectMetadataRequest)getObjectMetadataRequest).setPartNumber(arg_0));
            uploadId.ifPresent(id -> getObjectMetadataRequest.putCustomQueryParameter("uploadId", id));
            objectMetadata = this.delegate.getObjectMetadata(getObjectMetadataRequest);
            headers = objectMetadata.getRawMetadata();
        }
        catch (AmazonServiceException e) {
            boolean isGetOrDelete;
            boolean is404NotFound = e.getStatusCode() == 404;
            boolean bl = isGetOrDelete = method.equalsIgnoreCase("get") || method.equalsIgnoreCase("delete");
            if (is404NotFound && isGetOrDelete) {
                throw e;
            }
            headers = e.getHttpHeaders();
            ObjectMetadata work = new ObjectMetadata();
            headers.forEach((arg_0, arg_1) -> ((ObjectMetadata)work).setHeader(arg_0, arg_1));
            objectMetadata = work;
        }
        catch (RuntimeException e) {
            log.error((Object)"request.get-presigned-url.exception method=%s bucket=%s key=%s uploadId=%s partNumber=%s".formatted(method, bucket, key, uploadId, partNumber), (Throwable)e);
            throw e;
        }
        Object value = headers.get("X-Trino-Pre-Signed-Url-" + method);
        log.debug((Object)"response.get-presigned-url.exception method=%s bucket=%s key=%s uploadId=%s partNumber=%s success=%s".formatted(method, bucket, key, uploadId, partNumber, value != null));
        try {
            return value != null ? Optional.of(new Presigned(new URL(String.valueOf(value)), objectMetadata)) : Optional.empty();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setEndpoint(String endpoint) {
        this.delegate.setEndpoint(endpoint);
    }

    public void setRegion(com.amazonaws.regions.Region region) throws IllegalArgumentException {
        this.delegate.setRegion(region);
    }

    public void setS3ClientOptions(S3ClientOptions clientOptions) {
        this.delegate.setS3ClientOptions(clientOptions);
    }

    @Deprecated
    public void changeObjectStorageClass(String bucketName, String key, StorageClass newStorageClass) throws SdkClientException {
        this.delegate.changeObjectStorageClass(bucketName, key, newStorageClass);
    }

    @Deprecated
    public void setObjectRedirectLocation(String bucketName, String key, String newRedirectLocation) throws SdkClientException {
        this.delegate.setObjectRedirectLocation(bucketName, key, newRedirectLocation);
    }

    public ObjectListing listObjects(String bucketName) throws SdkClientException {
        return this.delegate.listObjects(bucketName);
    }

    public ObjectListing listObjects(String bucketName, String prefix) throws SdkClientException {
        return this.delegate.listObjects(bucketName, prefix);
    }

    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws SdkClientException {
        return this.delegate.listObjects(listObjectsRequest);
    }

    public ListObjectsV2Result listObjectsV2(String bucketName) throws SdkClientException {
        return this.delegate.listObjectsV2(bucketName);
    }

    public ListObjectsV2Result listObjectsV2(String bucketName, String prefix) throws SdkClientException {
        return this.delegate.listObjectsV2(bucketName, prefix);
    }

    public ListObjectsV2Result listObjectsV2(ListObjectsV2Request listObjectsV2Request) throws SdkClientException {
        return this.delegate.listObjectsV2(listObjectsV2Request);
    }

    public ObjectListing listNextBatchOfObjects(ObjectListing previousObjectListing) throws SdkClientException {
        return this.delegate.listNextBatchOfObjects(previousObjectListing);
    }

    public ObjectListing listNextBatchOfObjects(ListNextBatchOfObjectsRequest listNextBatchOfObjectsRequest) throws SdkClientException {
        return this.delegate.listNextBatchOfObjects(listNextBatchOfObjectsRequest);
    }

    public VersionListing listVersions(String bucketName, String prefix) throws SdkClientException {
        return this.delegate.listVersions(bucketName, prefix);
    }

    public VersionListing listNextBatchOfVersions(VersionListing previousVersionListing) throws SdkClientException {
        return this.delegate.listNextBatchOfVersions(previousVersionListing);
    }

    public VersionListing listNextBatchOfVersions(ListNextBatchOfVersionsRequest listNextBatchOfVersionsRequest) throws SdkClientException {
        return this.delegate.listNextBatchOfVersions(listNextBatchOfVersionsRequest);
    }

    public VersionListing listVersions(String bucketName, String prefix, String keyMarker, String versionIdMarker, String delimiter, Integer maxResults) throws SdkClientException {
        return this.delegate.listVersions(bucketName, prefix, keyMarker, versionIdMarker, delimiter, maxResults);
    }

    public VersionListing listVersions(ListVersionsRequest listVersionsRequest) throws SdkClientException {
        return this.delegate.listVersions(listVersionsRequest);
    }

    public Owner getS3AccountOwner() throws SdkClientException {
        return this.delegate.getS3AccountOwner();
    }

    public Owner getS3AccountOwner(GetS3AccountOwnerRequest getS3AccountOwnerRequest) throws SdkClientException {
        return this.delegate.getS3AccountOwner(getS3AccountOwnerRequest);
    }

    @Deprecated
    public boolean doesBucketExist(String bucketName) throws SdkClientException {
        return this.delegate.doesBucketExist(bucketName);
    }

    public boolean doesBucketExistV2(String bucketName) throws SdkClientException {
        return this.delegate.doesBucketExistV2(bucketName);
    }

    public HeadBucketResult headBucket(HeadBucketRequest headBucketRequest) throws SdkClientException {
        return this.delegate.headBucket(headBucketRequest);
    }

    public List<Bucket> listBuckets() throws SdkClientException {
        return this.delegate.listBuckets();
    }

    public List<Bucket> listBuckets(ListBucketsRequest listBucketsRequest) throws SdkClientException {
        return this.delegate.listBuckets(listBucketsRequest);
    }

    public String getBucketLocation(String bucketName) throws SdkClientException {
        return this.delegate.getBucketLocation(bucketName);
    }

    public String getBucketLocation(GetBucketLocationRequest getBucketLocationRequest) throws SdkClientException {
        return this.delegate.getBucketLocation(getBucketLocationRequest);
    }

    public Bucket createBucket(CreateBucketRequest createBucketRequest) throws SdkClientException {
        return this.delegate.createBucket(createBucketRequest);
    }

    public Bucket createBucket(String bucketName) throws SdkClientException {
        return this.delegate.createBucket(bucketName);
    }

    @Deprecated
    public Bucket createBucket(String bucketName, Region region) throws SdkClientException {
        return this.delegate.createBucket(bucketName, region);
    }

    @Deprecated
    public Bucket createBucket(String bucketName, String region) throws SdkClientException {
        return this.delegate.createBucket(bucketName, region);
    }

    public AccessControlList getObjectAcl(String bucketName, String key) throws SdkClientException {
        return this.delegate.getObjectAcl(bucketName, key);
    }

    public AccessControlList getObjectAcl(String bucketName, String key, String versionId) throws SdkClientException {
        return this.delegate.getObjectAcl(bucketName, key, versionId);
    }

    public AccessControlList getObjectAcl(GetObjectAclRequest getObjectAclRequest) throws SdkClientException {
        return this.delegate.getObjectAcl(getObjectAclRequest);
    }

    public void setObjectAcl(String bucketName, String key, AccessControlList acl) throws SdkClientException {
        this.delegate.setObjectAcl(bucketName, key, acl);
    }

    public void setObjectAcl(String bucketName, String key, CannedAccessControlList acl) throws SdkClientException {
        this.delegate.setObjectAcl(bucketName, key, acl);
    }

    public void setObjectAcl(String bucketName, String key, String versionId, AccessControlList acl) throws SdkClientException {
        this.delegate.setObjectAcl(bucketName, key, versionId, acl);
    }

    public void setObjectAcl(String bucketName, String key, String versionId, CannedAccessControlList acl) throws SdkClientException {
        this.delegate.setObjectAcl(bucketName, key, versionId, acl);
    }

    public void setObjectAcl(SetObjectAclRequest setObjectAclRequest) throws SdkClientException {
        this.delegate.setObjectAcl(setObjectAclRequest);
    }

    public AccessControlList getBucketAcl(String bucketName) throws SdkClientException {
        return this.delegate.getBucketAcl(bucketName);
    }

    public void setBucketAcl(SetBucketAclRequest setBucketAclRequest) throws SdkClientException {
        this.delegate.setBucketAcl(setBucketAclRequest);
    }

    public AccessControlList getBucketAcl(GetBucketAclRequest getBucketAclRequest) throws SdkClientException {
        return this.delegate.getBucketAcl(getBucketAclRequest);
    }

    public void setBucketAcl(String bucketName, AccessControlList acl) throws SdkClientException {
        this.delegate.setBucketAcl(bucketName, acl);
    }

    public void setBucketAcl(String bucketName, CannedAccessControlList acl) throws SdkClientException {
        this.delegate.setBucketAcl(bucketName, acl);
    }

    public ObjectMetadata getObjectMetadata(String bucketName, String key) throws SdkClientException {
        return this.delegate.getObjectMetadata(bucketName, key);
    }

    public ObjectMetadata getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest) throws SdkClientException {
        return this.delegate.getObjectMetadata(getObjectMetadataRequest);
    }

    public S3Object getObject(String bucketName, String key) throws SdkClientException {
        return this.delegate.getObject(bucketName, key);
    }

    public S3Object getObject(GetObjectRequest getObjectRequest) throws SdkClientException {
        return this.getPresignedUrl("GET", getObjectRequest.getBucketName(), getObjectRequest.getKey()).map(presigned -> {
            PresignedUrlDownloadRequest presignedUrlDownloadRequest = new PresignedUrlDownloadRequest(presigned.url);
            return this.delegate.download(presignedUrlDownloadRequest).getS3Object();
        }).orElseGet(() -> this.delegate.getObject(getObjectRequest));
    }

    public ObjectMetadata getObject(GetObjectRequest getObjectRequest, File destinationFile) throws SdkClientException {
        return this.getPresignedUrl("GET", getObjectRequest.getBucketName(), getObjectRequest.getKey()).map(presigned -> {
            PresignedUrlDownloadRequest presignedUrlDownloadRequest = new PresignedUrlDownloadRequest(presigned.url);
            this.delegate.download(presignedUrlDownloadRequest, destinationFile);
            return presigned.objectMetadata;
        }).orElseGet(() -> this.delegate.getObject(getObjectRequest, destinationFile));
    }

    public String getObjectAsString(String bucketName, String key) throws SdkClientException {
        S3Object object = this.getObject(bucketName, key);
        try {
            String string = IOUtils.toString((InputStream)object.getObjectContent());
            return string;
        }
        catch (IOException e) {
            throw new SdkClientException("Error streaming content from S3 during download", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)object, null);
        }
    }

    public GetObjectTaggingResult getObjectTagging(GetObjectTaggingRequest getObjectTaggingRequest) {
        return this.delegate.getObjectTagging(getObjectTaggingRequest);
    }

    public SetObjectTaggingResult setObjectTagging(SetObjectTaggingRequest setObjectTaggingRequest) {
        return this.delegate.setObjectTagging(setObjectTaggingRequest);
    }

    public DeleteObjectTaggingResult deleteObjectTagging(DeleteObjectTaggingRequest deleteObjectTaggingRequest) {
        return this.delegate.deleteObjectTagging(deleteObjectTaggingRequest);
    }

    public void deleteBucket(DeleteBucketRequest deleteBucketRequest) throws SdkClientException {
        this.delegate.deleteBucket(deleteBucketRequest);
    }

    public void deleteBucket(String bucketName) throws SdkClientException {
        this.delegate.deleteBucket(bucketName);
    }

    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws SdkClientException {
        return this.getPresignedUrl("PUT", putObjectRequest.getBucketName(), putObjectRequest.getKey()).map(presigned -> {
            PresignedUrlUploadRequest presignedUrlUploadRequest = new PresignedUrlUploadRequest(presigned.url).withMetadata(putObjectRequest.getMetadata());
            if (putObjectRequest.getFile() != null) {
                presignedUrlUploadRequest.withFile(putObjectRequest.getFile());
            }
            if (putObjectRequest.getInputStream() != null) {
                presignedUrlUploadRequest.withInputStream(putObjectRequest.getInputStream());
            }
            PresignedUrlUploadResult result = this.delegate.upload(presignedUrlUploadRequest);
            return PresignAwareAmazonS3.toPutObjectResult(result);
        }).orElseGet(() -> this.delegate.putObject(putObjectRequest));
    }

    public PutObjectResult putObject(String bucketName, String key, File file) throws SdkClientException {
        return this.getPresignedUrl("PUT", bucketName, key).map(presigned -> {
            PresignedUrlUploadRequest presignedUrlUploadRequest = new PresignedUrlUploadRequest(presigned.url).withFile(file).withMetadata(presigned.objectMetadata);
            PresignedUrlUploadResult result = this.delegate.upload(presignedUrlUploadRequest);
            return PresignAwareAmazonS3.toPutObjectResult(result);
        }).orElseGet(() -> this.delegate.putObject(bucketName, key, file));
    }

    public PutObjectResult putObject(String bucketName, String key, InputStream input, ObjectMetadata metadata) throws SdkClientException {
        return this.getPresignedUrl("PUT", bucketName, key).map(presigned -> {
            PresignedUrlUploadRequest presignedUrlUploadRequest = new PresignedUrlUploadRequest(presigned.url).withInputStream(input).withMetadata(metadata);
            PresignedUrlUploadResult result = this.delegate.upload(presignedUrlUploadRequest);
            return PresignAwareAmazonS3.toPutObjectResult(result);
        }).orElseGet(() -> this.delegate.putObject(bucketName, key, input, metadata));
    }

    public PutObjectResult putObject(String bucketName, String key, String content) throws SdkClientException {
        return this.getPresignedUrl("PUT", bucketName, key).map(presigned -> {
            PresignedUrlUploadRequest presignedUrlUploadRequest = new PresignedUrlUploadRequest(presigned.url).withInputStream((InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8))).withMetadata(presigned.objectMetadata);
            PresignedUrlUploadResult result = this.delegate.upload(presignedUrlUploadRequest);
            return PresignAwareAmazonS3.toPutObjectResult(result);
        }).orElseGet(() -> this.delegate.putObject(bucketName, key, content));
    }

    private static PutObjectResult toPutObjectResult(PresignedUrlUploadResult result) {
        PutObjectResult putObjectResult = new PutObjectResult();
        putObjectResult.setMetadata(result.getMetadata());
        putObjectResult.setContentMd5(result.getContentMd5());
        return putObjectResult;
    }

    private static UploadPartResult toUploadPartResult(PresignedUrlUploadResult result, int partNumber) {
        UploadPartResult uploadPartResult = new UploadPartResult();
        uploadPartResult.setETag(result.getMetadata().getETag());
        uploadPartResult.setPartNumber(partNumber);
        return uploadPartResult;
    }

    public CopyObjectResult copyObject(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) throws SdkClientException {
        return this.delegate.copyObject(sourceBucketName, sourceKey, destinationBucketName, destinationKey);
    }

    public CopyObjectResult copyObject(CopyObjectRequest copyObjectRequest) throws SdkClientException {
        return this.delegate.copyObject(copyObjectRequest);
    }

    public CopyPartResult copyPart(CopyPartRequest copyPartRequest) throws SdkClientException {
        return this.delegate.copyPart(copyPartRequest);
    }

    public void deleteObject(String bucketName, String key) throws SdkClientException {
        this.delegate.deleteObject(bucketName, key);
    }

    public void deleteObject(DeleteObjectRequest deleteObjectRequest) throws SdkClientException {
        this.delegate.deleteObject(deleteObjectRequest);
    }

    public DeleteObjectsResult deleteObjects(DeleteObjectsRequest deleteObjectsRequest) throws SdkClientException {
        return this.delegate.deleteObjects(deleteObjectsRequest);
    }

    public void deleteVersion(String bucketName, String key, String versionId) throws SdkClientException {
        this.delegate.deleteVersion(bucketName, key, versionId);
    }

    public void deleteVersion(DeleteVersionRequest deleteVersionRequest) throws SdkClientException {
        this.delegate.deleteVersion(deleteVersionRequest);
    }

    public BucketLoggingConfiguration getBucketLoggingConfiguration(String bucketName) throws SdkClientException {
        return this.delegate.getBucketLoggingConfiguration(bucketName);
    }

    public BucketLoggingConfiguration getBucketLoggingConfiguration(GetBucketLoggingConfigurationRequest getBucketLoggingConfigurationRequest) throws SdkClientException {
        return this.delegate.getBucketLoggingConfiguration(getBucketLoggingConfigurationRequest);
    }

    public void setBucketLoggingConfiguration(SetBucketLoggingConfigurationRequest setBucketLoggingConfigurationRequest) throws SdkClientException {
        this.delegate.setBucketLoggingConfiguration(setBucketLoggingConfigurationRequest);
    }

    public BucketVersioningConfiguration getBucketVersioningConfiguration(String bucketName) throws SdkClientException {
        return this.delegate.getBucketVersioningConfiguration(bucketName);
    }

    public BucketVersioningConfiguration getBucketVersioningConfiguration(GetBucketVersioningConfigurationRequest getBucketVersioningConfigurationRequest) throws SdkClientException {
        return this.delegate.getBucketVersioningConfiguration(getBucketVersioningConfigurationRequest);
    }

    public void setBucketVersioningConfiguration(SetBucketVersioningConfigurationRequest setBucketVersioningConfigurationRequest) throws SdkClientException {
        this.delegate.setBucketVersioningConfiguration(setBucketVersioningConfigurationRequest);
    }

    public BucketLifecycleConfiguration getBucketLifecycleConfiguration(String bucketName) {
        return this.delegate.getBucketLifecycleConfiguration(bucketName);
    }

    public BucketLifecycleConfiguration getBucketLifecycleConfiguration(GetBucketLifecycleConfigurationRequest getBucketLifecycleConfigurationRequest) {
        return this.delegate.getBucketLifecycleConfiguration(getBucketLifecycleConfigurationRequest);
    }

    public void setBucketLifecycleConfiguration(String bucketName, BucketLifecycleConfiguration bucketLifecycleConfiguration) {
        this.delegate.setBucketLifecycleConfiguration(bucketName, bucketLifecycleConfiguration);
    }

    public void setBucketLifecycleConfiguration(SetBucketLifecycleConfigurationRequest setBucketLifecycleConfigurationRequest) {
        this.delegate.setBucketLifecycleConfiguration(setBucketLifecycleConfigurationRequest);
    }

    public void deleteBucketLifecycleConfiguration(String bucketName) {
        this.delegate.deleteBucketLifecycleConfiguration(bucketName);
    }

    public void deleteBucketLifecycleConfiguration(DeleteBucketLifecycleConfigurationRequest deleteBucketLifecycleConfigurationRequest) {
        this.delegate.deleteBucketLifecycleConfiguration(deleteBucketLifecycleConfigurationRequest);
    }

    public BucketCrossOriginConfiguration getBucketCrossOriginConfiguration(String bucketName) {
        return this.delegate.getBucketCrossOriginConfiguration(bucketName);
    }

    public BucketCrossOriginConfiguration getBucketCrossOriginConfiguration(GetBucketCrossOriginConfigurationRequest getBucketCrossOriginConfigurationRequest) {
        return this.delegate.getBucketCrossOriginConfiguration(getBucketCrossOriginConfigurationRequest);
    }

    public void setBucketCrossOriginConfiguration(String bucketName, BucketCrossOriginConfiguration bucketCrossOriginConfiguration) {
        this.delegate.setBucketCrossOriginConfiguration(bucketName, bucketCrossOriginConfiguration);
    }

    public void setBucketCrossOriginConfiguration(SetBucketCrossOriginConfigurationRequest setBucketCrossOriginConfigurationRequest) {
        this.delegate.setBucketCrossOriginConfiguration(setBucketCrossOriginConfigurationRequest);
    }

    public void deleteBucketCrossOriginConfiguration(String bucketName) {
        this.delegate.deleteBucketCrossOriginConfiguration(bucketName);
    }

    public void deleteBucketCrossOriginConfiguration(DeleteBucketCrossOriginConfigurationRequest deleteBucketCrossOriginConfigurationRequest) {
        this.delegate.deleteBucketCrossOriginConfiguration(deleteBucketCrossOriginConfigurationRequest);
    }

    public BucketTaggingConfiguration getBucketTaggingConfiguration(String bucketName) {
        return this.delegate.getBucketTaggingConfiguration(bucketName);
    }

    public BucketTaggingConfiguration getBucketTaggingConfiguration(GetBucketTaggingConfigurationRequest getBucketTaggingConfigurationRequest) {
        return this.delegate.getBucketTaggingConfiguration(getBucketTaggingConfigurationRequest);
    }

    public void setBucketTaggingConfiguration(String bucketName, BucketTaggingConfiguration bucketTaggingConfiguration) {
        this.delegate.setBucketTaggingConfiguration(bucketName, bucketTaggingConfiguration);
    }

    public void setBucketTaggingConfiguration(SetBucketTaggingConfigurationRequest setBucketTaggingConfigurationRequest) {
        this.delegate.setBucketTaggingConfiguration(setBucketTaggingConfigurationRequest);
    }

    public void deleteBucketTaggingConfiguration(String bucketName) {
        this.delegate.deleteBucketTaggingConfiguration(bucketName);
    }

    public void deleteBucketTaggingConfiguration(DeleteBucketTaggingConfigurationRequest deleteBucketTaggingConfigurationRequest) {
        this.delegate.deleteBucketTaggingConfiguration(deleteBucketTaggingConfigurationRequest);
    }

    public BucketNotificationConfiguration getBucketNotificationConfiguration(String bucketName) throws SdkClientException {
        return this.delegate.getBucketNotificationConfiguration(bucketName);
    }

    public BucketNotificationConfiguration getBucketNotificationConfiguration(GetBucketNotificationConfigurationRequest getBucketNotificationConfigurationRequest) throws SdkClientException {
        return this.delegate.getBucketNotificationConfiguration(getBucketNotificationConfigurationRequest);
    }

    public void setBucketNotificationConfiguration(SetBucketNotificationConfigurationRequest setBucketNotificationConfigurationRequest) throws SdkClientException {
        this.delegate.setBucketNotificationConfiguration(setBucketNotificationConfigurationRequest);
    }

    public void setBucketNotificationConfiguration(String bucketName, BucketNotificationConfiguration bucketNotificationConfiguration) throws SdkClientException {
        this.delegate.setBucketNotificationConfiguration(bucketName, bucketNotificationConfiguration);
    }

    public BucketWebsiteConfiguration getBucketWebsiteConfiguration(String bucketName) throws SdkClientException {
        return this.delegate.getBucketWebsiteConfiguration(bucketName);
    }

    public BucketWebsiteConfiguration getBucketWebsiteConfiguration(GetBucketWebsiteConfigurationRequest getBucketWebsiteConfigurationRequest) throws SdkClientException {
        return this.delegate.getBucketWebsiteConfiguration(getBucketWebsiteConfigurationRequest);
    }

    public void setBucketWebsiteConfiguration(String bucketName, BucketWebsiteConfiguration configuration) throws SdkClientException {
        this.delegate.setBucketWebsiteConfiguration(bucketName, configuration);
    }

    public void setBucketWebsiteConfiguration(SetBucketWebsiteConfigurationRequest setBucketWebsiteConfigurationRequest) throws SdkClientException {
        this.delegate.setBucketWebsiteConfiguration(setBucketWebsiteConfigurationRequest);
    }

    public void deleteBucketWebsiteConfiguration(String bucketName) throws SdkClientException {
        this.delegate.deleteBucketWebsiteConfiguration(bucketName);
    }

    public void deleteBucketWebsiteConfiguration(DeleteBucketWebsiteConfigurationRequest deleteBucketWebsiteConfigurationRequest) throws SdkClientException {
        this.delegate.deleteBucketWebsiteConfiguration(deleteBucketWebsiteConfigurationRequest);
    }

    public BucketPolicy getBucketPolicy(String bucketName) throws SdkClientException {
        return this.delegate.getBucketPolicy(bucketName);
    }

    public BucketPolicy getBucketPolicy(GetBucketPolicyRequest getBucketPolicyRequest) throws SdkClientException {
        return this.delegate.getBucketPolicy(getBucketPolicyRequest);
    }

    public void setBucketPolicy(String bucketName, String policyText) throws SdkClientException {
        this.delegate.setBucketPolicy(bucketName, policyText);
    }

    public void setBucketPolicy(SetBucketPolicyRequest setBucketPolicyRequest) throws SdkClientException {
        this.delegate.setBucketPolicy(setBucketPolicyRequest);
    }

    public void deleteBucketPolicy(String bucketName) throws SdkClientException {
        this.delegate.deleteBucketPolicy(bucketName);
    }

    public void deleteBucketPolicy(DeleteBucketPolicyRequest deleteBucketPolicyRequest) throws SdkClientException {
        this.delegate.deleteBucketPolicy(deleteBucketPolicyRequest);
    }

    public URL generatePresignedUrl(String bucketName, String key, Date expiration) throws SdkClientException {
        return this.delegate.generatePresignedUrl(bucketName, key, expiration);
    }

    public URL generatePresignedUrl(String bucketName, String key, Date expiration, HttpMethod method) throws SdkClientException {
        return this.delegate.generatePresignedUrl(bucketName, key, expiration, method);
    }

    public URL generatePresignedUrl(GeneratePresignedUrlRequest generatePresignedUrlRequest) throws SdkClientException {
        return this.delegate.generatePresignedUrl(generatePresignedUrlRequest);
    }

    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest request) throws SdkClientException {
        return this.delegate.initiateMultipartUpload(request);
    }

    public UploadPartResult uploadPart(UploadPartRequest request) throws SdkClientException {
        return this.getPresignedUrl("PUT", request.getBucketName(), request.getKey(), Optional.of(request)).map(presigned -> {
            PresignedUrlUploadRequest presignedUrlUploadRequest = new PresignedUrlUploadRequest(presigned.url);
            if (request.getFile() != null) {
                presignedUrlUploadRequest.withFile(request.getFile());
            }
            if (request.getInputStream() != null) {
                presignedUrlUploadRequest.withInputStream(request.getInputStream());
            }
            PresignedUrlUploadResult result = this.delegate.upload(presignedUrlUploadRequest);
            return PresignAwareAmazonS3.toUploadPartResult(result, request.getPartNumber());
        }).orElseGet(() -> this.delegate.uploadPart(request));
    }

    public PartListing listParts(ListPartsRequest request) throws SdkClientException {
        return this.delegate.listParts(request);
    }

    public void abortMultipartUpload(AbortMultipartUploadRequest request) throws SdkClientException {
        this.delegate.abortMultipartUpload(request);
    }

    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest request) throws SdkClientException {
        return this.delegate.completeMultipartUpload(request);
    }

    public MultipartUploadListing listMultipartUploads(ListMultipartUploadsRequest request) throws SdkClientException {
        return this.delegate.listMultipartUploads(request);
    }

    public S3ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.delegate.getCachedResponseMetadata(request);
    }

    @Deprecated
    public void restoreObject(RestoreObjectRequest request) throws AmazonServiceException {
        this.delegate.restoreObject(request);
    }

    public RestoreObjectResult restoreObjectV2(RestoreObjectRequest request) throws AmazonServiceException {
        return this.delegate.restoreObjectV2(request);
    }

    @Deprecated
    public void restoreObject(String bucketName, String key, int expirationInDays) throws AmazonServiceException {
        this.delegate.restoreObject(bucketName, key, expirationInDays);
    }

    public void enableRequesterPays(String bucketName) throws SdkClientException {
        this.delegate.enableRequesterPays(bucketName);
    }

    public void disableRequesterPays(String bucketName) throws SdkClientException {
        this.delegate.disableRequesterPays(bucketName);
    }

    public boolean isRequesterPaysEnabled(String bucketName) throws SdkClientException {
        return this.delegate.isRequesterPaysEnabled(bucketName);
    }

    public void setRequestPaymentConfiguration(SetRequestPaymentConfigurationRequest setRequestPaymentConfigurationRequest) {
        this.delegate.setRequestPaymentConfiguration(setRequestPaymentConfigurationRequest);
    }

    public void setBucketReplicationConfiguration(String bucketName, BucketReplicationConfiguration configuration) throws SdkClientException {
        this.delegate.setBucketReplicationConfiguration(bucketName, configuration);
    }

    public void setBucketReplicationConfiguration(SetBucketReplicationConfigurationRequest setBucketReplicationConfigurationRequest) throws SdkClientException {
        this.delegate.setBucketReplicationConfiguration(setBucketReplicationConfigurationRequest);
    }

    public BucketReplicationConfiguration getBucketReplicationConfiguration(String bucketName) throws SdkClientException {
        return this.delegate.getBucketReplicationConfiguration(bucketName);
    }

    public BucketReplicationConfiguration getBucketReplicationConfiguration(GetBucketReplicationConfigurationRequest getBucketReplicationConfigurationRequest) throws SdkClientException {
        return this.delegate.getBucketReplicationConfiguration(getBucketReplicationConfigurationRequest);
    }

    public void deleteBucketReplicationConfiguration(String bucketName) throws SdkClientException {
        this.delegate.deleteBucketReplicationConfiguration(bucketName);
    }

    public void deleteBucketReplicationConfiguration(DeleteBucketReplicationConfigurationRequest request) throws SdkClientException {
        this.delegate.deleteBucketReplicationConfiguration(request);
    }

    public boolean doesObjectExist(String bucketName, String objectName) throws SdkClientException {
        return this.delegate.doesObjectExist(bucketName, objectName);
    }

    public BucketAccelerateConfiguration getBucketAccelerateConfiguration(String bucketName) throws SdkClientException {
        return this.delegate.getBucketAccelerateConfiguration(bucketName);
    }

    public BucketAccelerateConfiguration getBucketAccelerateConfiguration(GetBucketAccelerateConfigurationRequest getBucketAccelerateConfigurationRequest) throws SdkClientException {
        return this.delegate.getBucketAccelerateConfiguration(getBucketAccelerateConfigurationRequest);
    }

    public void setBucketAccelerateConfiguration(String bucketName, BucketAccelerateConfiguration accelerateConfiguration) throws SdkClientException {
        this.delegate.setBucketAccelerateConfiguration(bucketName, accelerateConfiguration);
    }

    public void setBucketAccelerateConfiguration(SetBucketAccelerateConfigurationRequest setBucketAccelerateConfigurationRequest) throws SdkClientException {
        this.delegate.setBucketAccelerateConfiguration(setBucketAccelerateConfigurationRequest);
    }

    public DeleteBucketMetricsConfigurationResult deleteBucketMetricsConfiguration(String bucketName, String id) throws SdkClientException {
        return this.delegate.deleteBucketMetricsConfiguration(bucketName, id);
    }

    public DeleteBucketMetricsConfigurationResult deleteBucketMetricsConfiguration(DeleteBucketMetricsConfigurationRequest deleteBucketMetricsConfigurationRequest) throws SdkClientException {
        return this.delegate.deleteBucketMetricsConfiguration(deleteBucketMetricsConfigurationRequest);
    }

    public GetBucketMetricsConfigurationResult getBucketMetricsConfiguration(String bucketName, String id) throws SdkClientException {
        return this.delegate.getBucketMetricsConfiguration(bucketName, id);
    }

    public GetBucketMetricsConfigurationResult getBucketMetricsConfiguration(GetBucketMetricsConfigurationRequest getBucketMetricsConfigurationRequest) throws SdkClientException {
        return this.delegate.getBucketMetricsConfiguration(getBucketMetricsConfigurationRequest);
    }

    public SetBucketMetricsConfigurationResult setBucketMetricsConfiguration(String bucketName, MetricsConfiguration metricsConfiguration) throws SdkClientException {
        return this.delegate.setBucketMetricsConfiguration(bucketName, metricsConfiguration);
    }

    public SetBucketMetricsConfigurationResult setBucketMetricsConfiguration(SetBucketMetricsConfigurationRequest setBucketMetricsConfigurationRequest) throws SdkClientException {
        return this.delegate.setBucketMetricsConfiguration(setBucketMetricsConfigurationRequest);
    }

    public ListBucketMetricsConfigurationsResult listBucketMetricsConfigurations(ListBucketMetricsConfigurationsRequest listBucketMetricsConfigurationsRequest) throws SdkClientException {
        return this.delegate.listBucketMetricsConfigurations(listBucketMetricsConfigurationsRequest);
    }

    public DeleteBucketOwnershipControlsResult deleteBucketOwnershipControls(DeleteBucketOwnershipControlsRequest deleteBucketOwnershipControlsRequest) throws SdkClientException {
        return this.delegate.deleteBucketOwnershipControls(deleteBucketOwnershipControlsRequest);
    }

    public GetBucketOwnershipControlsResult getBucketOwnershipControls(GetBucketOwnershipControlsRequest getBucketOwnershipControlsRequest) throws SdkClientException {
        return this.delegate.getBucketOwnershipControls(getBucketOwnershipControlsRequest);
    }

    public SetBucketOwnershipControlsResult setBucketOwnershipControls(String bucketName, OwnershipControls ownershipControls) throws SdkClientException {
        return this.delegate.setBucketOwnershipControls(bucketName, ownershipControls);
    }

    public SetBucketOwnershipControlsResult setBucketOwnershipControls(SetBucketOwnershipControlsRequest setBucketOwnershipControlsRequest) throws SdkClientException {
        return this.delegate.setBucketOwnershipControls(setBucketOwnershipControlsRequest);
    }

    public DeleteBucketAnalyticsConfigurationResult deleteBucketAnalyticsConfiguration(String bucketName, String id) throws SdkClientException {
        return this.delegate.deleteBucketAnalyticsConfiguration(bucketName, id);
    }

    public DeleteBucketAnalyticsConfigurationResult deleteBucketAnalyticsConfiguration(DeleteBucketAnalyticsConfigurationRequest deleteBucketAnalyticsConfigurationRequest) throws SdkClientException {
        return this.delegate.deleteBucketAnalyticsConfiguration(deleteBucketAnalyticsConfigurationRequest);
    }

    public GetBucketAnalyticsConfigurationResult getBucketAnalyticsConfiguration(String bucketName, String id) throws SdkClientException {
        return this.delegate.getBucketAnalyticsConfiguration(bucketName, id);
    }

    public GetBucketAnalyticsConfigurationResult getBucketAnalyticsConfiguration(GetBucketAnalyticsConfigurationRequest getBucketAnalyticsConfigurationRequest) throws SdkClientException {
        return this.delegate.getBucketAnalyticsConfiguration(getBucketAnalyticsConfigurationRequest);
    }

    public SetBucketAnalyticsConfigurationResult setBucketAnalyticsConfiguration(String bucketName, AnalyticsConfiguration analyticsConfiguration) throws SdkClientException {
        return this.delegate.setBucketAnalyticsConfiguration(bucketName, analyticsConfiguration);
    }

    public SetBucketAnalyticsConfigurationResult setBucketAnalyticsConfiguration(SetBucketAnalyticsConfigurationRequest setBucketAnalyticsConfigurationRequest) throws SdkClientException {
        return this.delegate.setBucketAnalyticsConfiguration(setBucketAnalyticsConfigurationRequest);
    }

    public ListBucketAnalyticsConfigurationsResult listBucketAnalyticsConfigurations(ListBucketAnalyticsConfigurationsRequest listBucketAnalyticsConfigurationsRequest) throws SdkClientException {
        return this.delegate.listBucketAnalyticsConfigurations(listBucketAnalyticsConfigurationsRequest);
    }

    public DeleteBucketIntelligentTieringConfigurationResult deleteBucketIntelligentTieringConfiguration(String bucketName, String id) throws SdkClientException {
        return this.delegate.deleteBucketIntelligentTieringConfiguration(bucketName, id);
    }

    public DeleteBucketIntelligentTieringConfigurationResult deleteBucketIntelligentTieringConfiguration(DeleteBucketIntelligentTieringConfigurationRequest deleteBucketIntelligentTieringConfigurationRequest) throws SdkClientException {
        return this.delegate.deleteBucketIntelligentTieringConfiguration(deleteBucketIntelligentTieringConfigurationRequest);
    }

    public GetBucketIntelligentTieringConfigurationResult getBucketIntelligentTieringConfiguration(String bucketName, String id) throws SdkClientException {
        return this.delegate.getBucketIntelligentTieringConfiguration(bucketName, id);
    }

    public GetBucketIntelligentTieringConfigurationResult getBucketIntelligentTieringConfiguration(GetBucketIntelligentTieringConfigurationRequest getBucketIntelligentTieringConfigurationRequest) throws SdkClientException {
        return this.delegate.getBucketIntelligentTieringConfiguration(getBucketIntelligentTieringConfigurationRequest);
    }

    public SetBucketIntelligentTieringConfigurationResult setBucketIntelligentTieringConfiguration(String bucketName, IntelligentTieringConfiguration intelligentTieringConfiguration) throws SdkClientException {
        return this.delegate.setBucketIntelligentTieringConfiguration(bucketName, intelligentTieringConfiguration);
    }

    public SetBucketIntelligentTieringConfigurationResult setBucketIntelligentTieringConfiguration(SetBucketIntelligentTieringConfigurationRequest setBucketIntelligentTieringConfigurationRequest) throws SdkClientException {
        return this.delegate.setBucketIntelligentTieringConfiguration(setBucketIntelligentTieringConfigurationRequest);
    }

    public ListBucketIntelligentTieringConfigurationsResult listBucketIntelligentTieringConfigurations(ListBucketIntelligentTieringConfigurationsRequest listBucketIntelligentTieringConfigurationsRequest) throws SdkClientException {
        return this.delegate.listBucketIntelligentTieringConfigurations(listBucketIntelligentTieringConfigurationsRequest);
    }

    public DeleteBucketInventoryConfigurationResult deleteBucketInventoryConfiguration(String bucketName, String id) throws SdkClientException {
        return this.delegate.deleteBucketInventoryConfiguration(bucketName, id);
    }

    public DeleteBucketInventoryConfigurationResult deleteBucketInventoryConfiguration(DeleteBucketInventoryConfigurationRequest deleteBucketInventoryConfigurationRequest) throws SdkClientException {
        return this.delegate.deleteBucketInventoryConfiguration(deleteBucketInventoryConfigurationRequest);
    }

    public GetBucketInventoryConfigurationResult getBucketInventoryConfiguration(String bucketName, String id) throws SdkClientException {
        return this.delegate.getBucketInventoryConfiguration(bucketName, id);
    }

    public GetBucketInventoryConfigurationResult getBucketInventoryConfiguration(GetBucketInventoryConfigurationRequest getBucketInventoryConfigurationRequest) throws SdkClientException {
        return this.delegate.getBucketInventoryConfiguration(getBucketInventoryConfigurationRequest);
    }

    public SetBucketInventoryConfigurationResult setBucketInventoryConfiguration(String bucketName, InventoryConfiguration inventoryConfiguration) throws SdkClientException {
        return this.delegate.setBucketInventoryConfiguration(bucketName, inventoryConfiguration);
    }

    public SetBucketInventoryConfigurationResult setBucketInventoryConfiguration(SetBucketInventoryConfigurationRequest setBucketInventoryConfigurationRequest) throws SdkClientException {
        return this.delegate.setBucketInventoryConfiguration(setBucketInventoryConfigurationRequest);
    }

    public ListBucketInventoryConfigurationsResult listBucketInventoryConfigurations(ListBucketInventoryConfigurationsRequest listBucketInventoryConfigurationsRequest) throws SdkClientException {
        return this.delegate.listBucketInventoryConfigurations(listBucketInventoryConfigurationsRequest);
    }

    public DeleteBucketEncryptionResult deleteBucketEncryption(String bucketName) throws SdkClientException {
        return this.delegate.deleteBucketEncryption(bucketName);
    }

    public DeleteBucketEncryptionResult deleteBucketEncryption(DeleteBucketEncryptionRequest request) throws SdkClientException {
        return this.delegate.deleteBucketEncryption(request);
    }

    public GetBucketEncryptionResult getBucketEncryption(String bucketName) throws SdkClientException {
        return this.delegate.getBucketEncryption(bucketName);
    }

    public GetBucketEncryptionResult getBucketEncryption(GetBucketEncryptionRequest request) throws SdkClientException {
        return this.delegate.getBucketEncryption(request);
    }

    public SetBucketEncryptionResult setBucketEncryption(SetBucketEncryptionRequest setBucketEncryptionRequest) throws SdkClientException {
        return this.delegate.setBucketEncryption(setBucketEncryptionRequest);
    }

    public SetPublicAccessBlockResult setPublicAccessBlock(SetPublicAccessBlockRequest request) {
        return this.delegate.setPublicAccessBlock(request);
    }

    public GetPublicAccessBlockResult getPublicAccessBlock(GetPublicAccessBlockRequest request) {
        return this.delegate.getPublicAccessBlock(request);
    }

    public DeletePublicAccessBlockResult deletePublicAccessBlock(DeletePublicAccessBlockRequest request) {
        return this.delegate.deletePublicAccessBlock(request);
    }

    public GetBucketPolicyStatusResult getBucketPolicyStatus(GetBucketPolicyStatusRequest request) {
        return this.delegate.getBucketPolicyStatus(request);
    }

    public SelectObjectContentResult selectObjectContent(SelectObjectContentRequest selectRequest) throws SdkClientException {
        return this.delegate.selectObjectContent(selectRequest);
    }

    public SetObjectLegalHoldResult setObjectLegalHold(SetObjectLegalHoldRequest setObjectLegalHoldRequest) {
        return this.delegate.setObjectLegalHold(setObjectLegalHoldRequest);
    }

    public GetObjectLegalHoldResult getObjectLegalHold(GetObjectLegalHoldRequest getObjectLegalHoldRequest) {
        return this.delegate.getObjectLegalHold(getObjectLegalHoldRequest);
    }

    public SetObjectLockConfigurationResult setObjectLockConfiguration(SetObjectLockConfigurationRequest setObjectLockConfigurationRequest) {
        return this.delegate.setObjectLockConfiguration(setObjectLockConfigurationRequest);
    }

    public GetObjectLockConfigurationResult getObjectLockConfiguration(GetObjectLockConfigurationRequest getObjectLockConfigurationRequest) {
        return this.delegate.getObjectLockConfiguration(getObjectLockConfigurationRequest);
    }

    public SetObjectRetentionResult setObjectRetention(SetObjectRetentionRequest setObjectRetentionRequest) {
        return this.delegate.setObjectRetention(setObjectRetentionRequest);
    }

    public GetObjectRetentionResult getObjectRetention(GetObjectRetentionRequest getObjectRetentionRequest) {
        return this.delegate.getObjectRetention(getObjectRetentionRequest);
    }

    public WriteGetObjectResponseResult writeGetObjectResponse(WriteGetObjectResponseRequest writeGetObjectResponseRequest) {
        return this.delegate.writeGetObjectResponse(writeGetObjectResponseRequest);
    }

    public PresignedUrlDownloadResult download(PresignedUrlDownloadRequest presignedUrlDownloadRequest) {
        return this.delegate.download(presignedUrlDownloadRequest);
    }

    public void download(PresignedUrlDownloadRequest presignedUrlDownloadRequest, File destinationFile) {
        this.delegate.download(presignedUrlDownloadRequest, destinationFile);
    }

    public PresignedUrlUploadResult upload(PresignedUrlUploadRequest presignedUrlUploadRequest) {
        return this.delegate.upload(presignedUrlUploadRequest);
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    public Region getRegion() {
        return this.delegate.getRegion();
    }

    public String getRegionName() {
        return this.delegate.getRegionName();
    }

    public URL getUrl(String bucketName, String key) {
        return this.delegate.getUrl(bucketName, key);
    }

    public AmazonS3Waiters waiters() {
        return this.delegate.waiters();
    }

    private record Presigned(URL url, ObjectMetadata objectMetadata) {
        private Presigned {
            Objects.requireNonNull(url, "url is null");
            Objects.requireNonNull(objectMetadata, "objectMetadata is null");
        }
    }
}

