package io.timothyheider.springrestdoc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author theider
 */
public class RestMethodInstance {

    private final String httpMethod;

    private final String address;

    private final Method method;

    private final List<RestParameterInstance> parameters = new ArrayList<>();

    public RestMethodInstance(String httpMethod, String address, Method method) {
        this.httpMethod = httpMethod;
        this.address = address;
        this.method = method;
    }

    public String getHttpMethod() {
        return httpMethod;
    }

    public String getAddress() {
        return address;
    }

    public Method getMethod() {
        return method;
    }

    public List<RestParameterInstance> getParameters() {
        return parameters;
    }

    public void addMethod(RestParameterInstance parameter) {
        parameters.add(parameter);
    }

    @Override
    public String toString() {
        return "RestMethodInstance{" + "method=" + method + ", address=" + address + ", parameters=" + parameters + '}';
    }

}
