package io.timothyheider.springrestdoc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 *
 * @author theider
 */
public class RestControllerInstance {

    private final Class controllerClass;

    private final List<String> addresses;

    private final List<RestMethodInstance> methods = new ArrayList<>();

    public String getAddressesText() {
        String addressesText = "";
        for(String address : getAddresses()) {
            if(!addressesText.isEmpty()) {
                addressesText += ",";
            }
            addressesText += address;
        }
        return addressesText;
    }

    public List<RestMethodInstance> getMethods() {
        return methods;
    }

    public void addMethod(RestMethodInstance method) {
        methods.add(method);
    }

    public RestControllerInstance(Class controllerClass, String[] addresses) {
        this.controllerClass = controllerClass;
        this.addresses = new ArrayList<>();
        this.addresses.addAll(Arrays.asList(addresses));
    }

    public Class getControllerClass() {
        return controllerClass;
    }

    public List<String> getAddresses() {
        return addresses;
    }

    @Override
    public String toString() {
        return "RestControllerInstance{" + "controllerClass=" + controllerClass + ", addresses=" + addresses + '}';
    }

}
