package io.timothyheider.springrestdoc;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author theider
 */
@XStreamAlias("page")
public class DocumentationPage {

    @XStreamAlias("title")
    private String pageTitle;

    @XStreamAlias("link-text")
    private String linkText;

    @XStreamAlias("inline")
    private Boolean inline;

    @XStreamAlias("path")
    private String path;

    @XStreamImplicit
    private List<DocumentationPage> pages = new ArrayList();

    public Boolean getInline() {
        return inline;
    }

    public void setInline(Boolean inline) {
        this.inline = inline;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<DocumentationPage> getPages() {
        return pages;
    }

    public void setPages(List<DocumentationPage> pages) {
        this.pages = pages;
    }

    public String getPageTitle() {
        return pageTitle;
    }

    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    public String getLinkText() {
        return linkText;
    }

    public void setLinkText(String linkText) {
        this.linkText = linkText;
    }

    @Override
    public String toString() {
        return "DocumentationPage{" + "pageTitle=" + pageTitle + ", linkText=" + linkText + ", inline=" + inline + ", path=" + path + ", pages=" + pages + '}';
    }
        
}
