/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.upgrade;

import com.alibaba.fastjson.JSONObject;
import io.tiklab.unti.Until;
import io.tiklab.upgrade.model.ApplyVersion;
import io.tiklab.upgrade.model.ProductVersion;
import io.tiklab.upgrade.model.Result;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;

public class UpgradeVersionImpl {
    static boolean state = true;

    public ApplyVersion findLocalVersion(String localVersionDir) {
        File file = new File(localVersionDir + "/version");
        if (!file.exists()) {
            throw new RuntimeException("Failed to obtain local version information!");
        }
        String read = Until.readFile(file.getAbsolutePath());
        JSONObject jsonObject = JSONObject.parseObject(read);
        String application = jsonObject.getString("application");
        String version = jsonObject.getString("version");
        String type = jsonObject.getString("type");
        if (Objects.isNull(application) || Objects.isNull(version)) {
            throw new RuntimeException("Error obtaining local version, unable to resolve local version!");
        }
        return new ApplyVersion(application, version, type);
    }

    public List<ProductVersion> findRemoteVersion(String localVersionDir, ApplyVersion applyVersion, String remoteAddress) {
        Process process;
        String sysType = "linux";
        int systemType = Until.findSystemType();
        sysType = systemType == 1 ? "windows" : (systemType == 2 ? "linux" : "mac");
        String cmd = "curl -X POST  -F \"code=" + applyVersion.getApplication() + "\" -F \"version=" + applyVersion.getVersion() + "\" -F \"type=" + applyVersion.getType() + "\" -F \"sysType=" + sysType + "\" " + remoteAddress;
        try {
            process = Until.process(localVersionDir, cmd);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String s = Until.readCommandExecResult(process);
        if (Objects.isNull(s)) {
            throw new RuntimeException("Failed to obtain remote version!");
        }
        JSONObject result = JSONObject.parseObject(s);
        Integer code = result.getInteger("code");
        if (code != 0) {
            String msg = result.getString("msg");
            throw new RuntimeException("Failed to obtain remote version," + msg);
        }
        String data = result.getString("data");
        if ("[]".equals(data)) {
            throw new RuntimeException("It is already the latest version\uff01");
        }
        return JSONObject.parseArray(data, ProductVersion.class);
    }

    public ProductVersion chooseVersion(List<ProductVersion> productVersionList) {
        int i;
        System.out.println("Please select an upgraded version...");
        int j = 1;
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (ProductVersion productVersion : productVersionList) {
            String s = productVersion.getCode() + "-" + productVersion.getType() + "-" + productVersion.getVersion();
            System.out.println(j + ": " + s);
            list.add((CallSite)((Object)(s + "    size:" + Until.findMbSize(Long.parseLong(productVersion.getSize())) + "MB")));
            ++j;
        }
        Scanner scan = new Scanner(System.in);
        System.out.print("Please enter the version number:");
        String s = scan.nextLine();
        for (i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            System.out.print("Please enter the corresponding serial number:");
            s = scan.nextLine();
        }
        while ("".equals(s) || Integer.parseInt(s) > productVersionList.size() || Integer.parseInt(s) == 0) {
            System.out.print("No such serial number, please reselect:");
            s = scan.nextLine();
            for (i = 0; i < s.length(); ++i) {
                if (Character.isDigit(s.charAt(i))) continue;
                System.out.print("Please enter the corresponding serial number:");
                s = scan.nextLine();
            }
        }
        scan.close();
        System.out.println("The system is starting to update, version\uff1a" + (String)list.get(Integer.parseInt(s) - 1));
        System.out.println("Downloading the upgrade file will take approximately 5 minutes, please wait....");
        return productVersionList.get(Integer.parseInt(s) - 1);
    }

    public void downLoadPackage(String localVersionDir, ProductVersion versionUse, String filePath) {
        Process process;
        String fileName = versionUse.getName();
        String cmd = Until.findSystemType() == 1 ? "curl -o \"" + localVersionDir + "/" + fileName + "\" \"" + filePath + "\"" : "curl -O " + filePath + " -o  " + localVersionDir + "/" + fileName;
        try {
            process = Until.process(localVersionDir, cmd);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.readCommandExecResult(process, localVersionDir + "/" + fileName, Long.parseLong(versionUse.getSize()));
        this.validPackage(localVersionDir + "/" + fileName, Long.parseLong(versionUse.getSize()));
    }

    public void readCommandExecResult(Process process, String filePath, long fileSize) {
        InputStream inputStream = process.getInputStream();
        InputStream errInputStream = process.getErrorStream();
        InputStreamReader inputStreamReader = inputStream == null ? Until.encode(errInputStream) : Until.encode(inputStream);
        Thread thread = new Thread(() -> {
            while (state) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    String formattedSize = Until.findFileSize(filePath);
                    String allSize = Until.findMbSize(fileSize);
                    System.out.print("\rDownloading : " + formattedSize + "MB/" + allSize + "MB");
                }
                String formattedSize = Until.findFileSize(filePath);
                String allSize = Until.findMbSize(fileSize);
                System.out.print("\rDownloading : " + formattedSize + "MB/" + allSize + "MB");
            }
        });
        thread.start();
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        try {
            String s;
            while ((s = bufferedReader.readLine()) != null) {
                System.out.println(s);
            }
            state = false;
            System.out.print("\n");
            thread.stop();
            inputStreamReader.close();
            bufferedReader.close();
        }
        catch (Exception e) {
            process.destroy();
        }
    }

    private void validPackage(String filePath, long size) {
        int a1;
        long fileSize;
        int a;
        File file = new File(filePath);
        if (file.exists() && ((a = (int)((fileSize = file.length()) / 1000L / 1000L)) - (a1 = (int)(size / 1000L / 1000L)) > 3 || a - a1 < -3)) {
            System.out.println("fileSize:" + fileSize + "    size:" + size);
            throw new RuntimeException("Validation update package failed!");
        }
    }

    public List<ProductVersion> requestRemoteVersion(String url, String parameters) throws IOException {
        String line;
        URL serverUrl = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)serverUrl.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        conn.setInstanceFollowRedirects(false);
        if (!Objects.isNull(parameters)) {
            conn.setDoOutput(true);
            OutputStream outputStream = conn.getOutputStream();
            outputStream.write(parameters.getBytes(StandardCharsets.UTF_8));
        }
        conn.connect();
        StringBuilder result = new StringBuilder();
        InputStream inputStream = conn.getInputStream();
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        while ((line = in.readLine()) != null) {
            result.append(line);
        }
        in.close();
        Result results = JSONObject.parseObject(result.toString(), Result.class);
        if (results.getCode() != 0) {
            throw new RuntimeException("\u83b7\u53d6\u7248\u672c\u4fe1\u606f\u5931\u8d25:" + results.getMsg());
        }
        return JSONObject.parseArray(results.getData(), ProductVersion.class);
    }

    public void requestRemoteDownload(String url, String fileAddress, long fileSize) throws IOException {
        System.out.println("begin download remote file... ");
        Thread thread = new Thread(() -> {
            while (state) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    String formattedSize = Until.findFileSize(fileAddress);
                    String allSize = Until.findMbSize(fileSize);
                    System.out.print("\rDownloading : " + formattedSize + "MB/" + allSize + "MB");
                }
                String formattedSize = Until.findFileSize(fileAddress);
                String allSize = Until.findMbSize(fileSize);
                System.out.print("\rDownloading : " + formattedSize + "MB/" + allSize + "MB");
            }
        });
        thread.start();
        URL serverUrl = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)serverUrl.openConnection();
        conn.setRequestMethod("GET");
        conn.setInstanceFollowRedirects(false);
        conn.connect();
        int responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            int bytesRead;
            InputStream inputStream = conn.getInputStream();
            FileOutputStream outputStream = new FileOutputStream(fileAddress);
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.close();
            inputStream.close();
        } else {
            System.out.println("File download failed. Response code: " + responseCode);
        }
        conn.disconnect();
        state = false;
        this.validPackage(fileAddress, fileSize);
    }
}

