/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.upgrade;

import com.alibaba.fastjson.JSONObject;
import io.tiklab.unti.Until;
import io.tiklab.upgrade.BackupsFile;
import io.tiklab.upgrade.UpgradeVersionImpl;
import io.tiklab.upgrade.model.ApplyVersion;
import io.tiklab.upgrade.model.ProductVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class UpdateApplyServerImpl {
    public void update(String path) {
        List<ProductVersion> remoteVersion;
        String domain = "http://homes.tiklab.net";
        String property = System.getProperty("file.separator");
        UpgradeVersionImpl upgradeVersion = new UpgradeVersionImpl();
        ApplyVersion localVersion = upgradeVersion.findLocalVersion(path);
        try {
            String remoteAddress = domain + "/productVersion/findLaterVersion";
            int systemType = Until.findSystemType();
            String sysType = systemType == 1 ? "windows" : "linux";
            String parameters = "code=" + localVersion.getApplication() + "&version=" + localVersion.getVersion() + "&type=" + localVersion.getType() + "&sysType=" + sysType;
            remoteVersion = upgradeVersion.requestRemoteVersion(remoteAddress, parameters);
        }
        catch (Exception e) {
            String message = e.getMessage();
            System.out.println(message);
            return;
        }
        if (remoteVersion.isEmpty()) {
            System.out.println("It is already the latest version!");
            return;
        }
        File pathFile = new File(path);
        File parentFile = pathFile.getParentFile();
        String absolutePath = parentFile.getAbsolutePath() + property + "tiklab_temp";
        BackupsFile.pathMap.put("path", absolutePath);
        ProductVersion version = upgradeVersion.chooseVersion(remoteVersion);
        String downLoad = domain + version.getProductUrl();
        try {
            System.out.println(downLoad);
            System.out.println(path + "/" + version.getName());
            upgradeVersion.requestRemoteDownload(downLoad, path + "/" + version.getName(), Long.parseLong(version.getSize()));
        }
        catch (IOException e) {
            throw new RuntimeException(downLoad + "\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25!" + e);
        }
        System.out.println("The download of the update package is complete, and the upgrade program will begin!");
        BackupsFile backupsFile = new BackupsFile();
        backupsFile.backupsLocalFile(path, version.getName());
        backupsFile.updateRemoveFile(path, version.getName());
        backupsFile.deleteDirectory(new File(path + "/" + version.getName()));
        backupsFile.dirPermission(path);
        System.out.println("System update completed,Restarting the application takes effect!");
    }

    private void shutdownPostgresql(String localFile) {
        String property = System.getProperty("file.separator");
        int postgresqlPort = this.postgresqlPort(localFile + property + "conf" + property + "application.yaml");
        if (postgresqlPort == 0 || this.portStatus(postgresqlPort) == 0) {
            // empty if block
        }
        if (this.portStatus(postgresqlPort) == 0) {
            throw new RuntimeException("Unable to obtain postgres pid, closing database failed!");
        }
    }

    private int postgresqlPort(String yamlFileAddress) {
        try {
            int port = 0;
            Yaml yaml = new Yaml();
            FileInputStream input = new FileInputStream(yamlFileAddress);
            Map load = (Map)yaml.load(input);
            JSONObject json = new JSONObject(load);
            JSONObject postgresql = json.getJSONObject("postgresql");
            JSONObject embbed = postgresql.getJSONObject("embbed");
            Boolean enable = embbed.getBoolean("enable");
            if (enable.booleanValue()) {
                JSONObject server = postgresql.getJSONObject("server");
                port = server.getInteger("port");
            }
            ((InputStream)input).close();
            return port;
        }
        catch (IOException | ClassCastException | NullPointerException e) {
            return 0;
        }
    }

    private List<String> log(InputStream inputStream) {
        InputStreamReader inputStreamReader = Until.findSystemType() == 1 ? new InputStreamReader(inputStream, Charset.forName("GBK")) : new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        try {
            String s;
            while ((s = bufferedReader.readLine()) != null) {
                list.add(s);
            }
            inputStreamReader.close();
            bufferedReader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    private int portStatus(int port) {
        if (port == 0) {
            return 0;
        }
        Socket socket = null;
        String host = "localhost";
        try {
            socket = new Socket(host, port);
            socket.close();
            return 0;
        }
        catch (IOException ex) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException e) {
                return 1;
            }
            return 1;
        }
    }
}

