/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.upgrade;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class BackupsFile {
    public static Map<String, String> pathMap = new HashMap<String, String>();

    public void backupsLocalFile(String path, String fileName) {
        File file1 = new File(path + "/backups");
        this.deleteDirectory(file1);
        File file = new File(path);
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File listFile : files) {
            String name = listFile.getName();
            if (name.equals(fileName) || "backups".equals(name)) continue;
            String backupsPath = path + "/backups";
            try {
                if (listFile.isDirectory()) {
                    this.moveDirectory(listFile, new File(backupsPath + "/" + name));
                    continue;
                }
                this.moveDirectory(listFile, new File(backupsPath));
            }
            catch (IOException e) {
                this.rollbackLocalFile(path);
                throw new RuntimeException("Source data backup failed!" + e.getMessage());
            }
        }
        System.out.println("Source data backup successful");
    }

    public void rollbackLocalFile(String path) {
        try {
            this.moveDirectory(new File(path + "/backups"), new File(path));
        }
        catch (IOException e) {
            System.out.println();
            throw new RuntimeException("Rollback failed!  " + e.getMessage());
        }
    }

    public void copyDirectory(File sourceDir, File destinationDir) throws IOException {
        File[] files;
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((files = sourceDir.listFiles()) != null) {
            for (File file : files) {
                File destination = new File(destinationDir, file.getName());
                if (file.isDirectory()) {
                    this.copyDirectory(file, destination);
                    continue;
                }
                Files.copy(file.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private void moveDirectory(File sourceDir, File destinationDir) throws IOException {
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if (sourceDir.isDirectory()) {
            File[] files = sourceDir.listFiles();
            if (files != null) {
                for (File file : files) {
                    File destination = new File(destinationDir, file.getName());
                    if (file.isDirectory()) {
                        this.moveDirectory(file, destination);
                        continue;
                    }
                    Files.move(file.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
        } else {
            String name = sourceDir.getName();
            File destination = new File(destinationDir, name);
            Files.move(sourceDir.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        sourceDir.delete();
    }

    private void extractTarGz(String tarGzFilePath, String destinationFolderPath) throws IOException {
        System.out.println("Extract files!");
        try (FileInputStream fileInputStream = new FileInputStream(tarGzFilePath);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
             GzipCompressorInputStream gzipInputStream = new GzipCompressorInputStream(bufferedInputStream);
             TarArchiveInputStream tarInputStream = new TarArchiveInputStream(gzipInputStream);){
            TarArchiveEntry entry;
            while ((entry = tarInputStream.getNextTarEntry()) != null) {
                if (entry.isDirectory()) continue;
                File outputFile = new File(destinationFolderPath, entry.getName());
                File parentDir = outputFile.getParentFile();
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(outputFile));){
                    int bytesRead;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = tarInputStream.read(buffer)) != -1) {
                        bufferedOutputStream.write(buffer, 0, bytesRead);
                    }
                }
                HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
                permissions.add(PosixFilePermission.OWNER_READ);
                permissions.add(PosixFilePermission.OWNER_WRITE);
                permissions.add(PosixFilePermission.OWNER_EXECUTE);
                permissions.add(PosixFilePermission.GROUP_READ);
                permissions.add(PosixFilePermission.GROUP_EXECUTE);
                permissions.add(PosixFilePermission.OTHERS_READ);
                permissions.add(PosixFilePermission.OTHERS_EXECUTE);
                Files.setPosixFilePermissions(outputFile.toPath(), permissions);
            }
        }
    }

    public Boolean deleteDirectory(File file) {
        String[] children;
        if (file.isDirectory() && (children = file.list()) != null) {
            for (String child : children) {
                boolean state = this.deleteDirectory(new File(file, child));
                int tryCount = 0;
                while (!state && tryCount++ < 10) {
                    System.gc();
                    state = file.delete();
                }
            }
        }
        return file.delete();
    }

    public void updateRemoveFile(String path, String fileName) {
        String remoteFilePath = pathMap.get("path");
        try {
            Files.createDirectories(Path.of(remoteFilePath, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temporary cache file!" + e.getMessage());
        }
        try {
            System.out.println("extract remote file...");
            this.unTarFile(path + "/" + fileName, remoteFilePath);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to extract remote file!");
        }
        File file = new File(remoteFilePath);
        File[] files = file.listFiles();
        if (files == null || files.length > 1) {
            this.rollbackLocalFile(path);
            throw new RuntimeException("Failed extract remote file!");
        }
        System.out.println("extract remote file success!");
        String remotePath = files[0].getAbsolutePath();
        System.out.println("valid remote file");
        File remoteFile = new File(remotePath);
        File[] files2 = remoteFile.listFiles();
        if (files2 == null) {
            this.rollbackLocalFile(path);
            throw new RuntimeException("valid remote file is empty!");
        }
        System.out.println("Start updating files!");
        for (File file1 : files2) {
            String name = file1.getName();
            try {
                if (file1.isDirectory()) {
                    this.moveDirectory(file1, new File(path + "/" + name));
                    continue;
                }
                this.moveDirectory(file1, new File(path));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to overwrite source file!");
            }
        }
        System.out.println("update files over,begin valid update file...");
        File file2 = new File(path);
        File[] files1 = file2.listFiles();
        if (files1 == null || files1.length <= 2) {
            this.rollbackLocalFile(path);
            throw new RuntimeException("Failed valid update!");
        }
        System.out.println("update file success!");
        this.deleteDirectory(file);
        this.deleteDirectory(new File(path + "/" + fileName));
        File file1 = new File(path + "/backups/licence");
        if (!file1.exists()) {
            return;
        }
        try {
            System.out.println("copy licence");
            this.copyDirectory(new File(path + "/backups/licence"), new File(path + "/licence"));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to update the licence latest file!");
        }
    }

    private void unTarFile(String file, String localPath) throws IOException {
        ArchiveEntry entry;
        Path source = Paths.get(file, new String[0]);
        Path target = Paths.get(localPath, new String[0]);
        InputStream fi = Files.newInputStream(source, new OpenOption[0]);
        BufferedInputStream bi = new BufferedInputStream(fi);
        GzipCompressorInputStream gzi = new GzipCompressorInputStream(bi);
        TarArchiveInputStream ti = new TarArchiveInputStream(gzi);
        while ((entry = ti.getNextEntry()) != null) {
            Path newPath = target.resolve(entry.getName()).normalize();
            if (entry.isDirectory()) {
                Files.createDirectories(newPath, new FileAttribute[0]);
                continue;
            }
            Path parent = newPath.getParent();
            if (parent != null && Files.notExists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.copy(ti, newPath, StandardCopyOption.REPLACE_EXISTING);
        }
        ti.close();
        gzi.close();
        bi.close();
        fi.close();
    }

    private void removeFile(String filepath, String localFile) {
        File sf = new File(filepath);
        File lf = new File(localFile);
        String property = System.getProperty("file.separator");
        if (!lf.exists()) {
            lf.mkdirs();
        }
        if (sf.isDirectory()) {
            File[] files = sf.listFiles();
            if (files == null) {
                System.out.println("Failed to overwrite source file,is null!");
                return;
            }
            for (File file : files) {
                if (file.isDirectory()) {
                    this.removeFile(file.getAbsolutePath(), localFile + property + file.getName());
                    continue;
                }
                boolean b = file.renameTo(new File(localFile + property + file.getName()));
                if (b) continue;
                throw new RuntimeException("Failed to overwrite source file!");
            }
        }
    }

    public void dirPermission(String path) {
        File file = new File(path);
        if (!file.exists()) {
            throw new RuntimeException("Failed to synchronize file permissions, file does not exist!");
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null || files.length == 0) {
                return;
            }
            for (File file1 : files) {
                String absolutePath = file1.getAbsolutePath();
                if (file1.isDirectory()) {
                    this.dirPermission(absolutePath);
                    continue;
                }
                this.filePermission(absolutePath);
            }
        } else {
            this.filePermission(path);
        }
    }

    private void filePermission(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        permissions.add(PosixFilePermission.OWNER_READ);
        permissions.add(PosixFilePermission.OWNER_WRITE);
        permissions.add(PosixFilePermission.OWNER_EXECUTE);
        permissions.add(PosixFilePermission.GROUP_READ);
        permissions.add(PosixFilePermission.GROUP_EXECUTE);
        permissions.add(PosixFilePermission.OTHERS_READ);
        permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        try {
            Files.setPosixFilePermissions(path, permissions);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to change file permissions: " + filePath + " exception:" + e);
        }
    }
}

