/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.unti;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;

public class Until {
    public static String readFile(String fileDir) {
        File file = new File(fileDir);
        if (!file.exists()) {
            throw new RuntimeException("file does not exist\uff01");
        }
        Path path = Paths.get(fileDir, new String[0]);
        StringBuilder s = new StringBuilder();
        try {
            List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
            for (String line : lines) {
                s.append(line).append("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read file information " + e.getMessage());
        }
        return s.toString();
    }

    public static Process process(String path, String order) throws IOException {
        Process process;
        Runtime runtime = Runtime.getRuntime();
        if (Until.findSystemType() == 1) {
            if (Objects.isNull(path)) {
                String[] cmd = new String[]{"cmd.exe", "/c", " " + order};
                process = runtime.exec(cmd);
            } else {
                String[] cmd = new String[]{"cmd.exe", "/c", " " + order};
                process = runtime.exec(cmd, null, new File(path));
            }
        } else if (Objects.isNull(path)) {
            String[] cmd = new String[]{"/bin/sh", "-c", " source /etc/profile;" + order};
            process = runtime.exec(cmd);
        } else {
            String[] cmd = new String[]{"/bin/sh", "-c", "cd " + path + "; source /etc/profile;" + order};
            process = runtime.exec(cmd, null, new File(path));
        }
        return process;
    }

    public static int findSystemType() {
        String property = System.getProperty("os.name");
        String[] s1 = property.split(" ");
        if ("Windows".equals(s1[0])) {
            return 1;
        }
        return 2;
    }

    public static InputStreamReader encode(InputStream inputStream) {
        if (Until.findSystemType() == 1) {
            return new InputStreamReader(inputStream, Charset.forName("GBK"));
        }
        return new InputStreamReader(inputStream, StandardCharsets.UTF_8);
    }

    public static String readCommandExecResult(Process process) {
        InputStream inputStream = process.getInputStream();
        InputStream errInputStream = process.getErrorStream();
        InputStreamReader inputStreamReader = inputStream == null ? Until.encode(errInputStream) : Until.encode(inputStream);
        StringBuilder message = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        try {
            String s;
            while ((s = bufferedReader.readLine()) != null) {
                message.append(s);
            }
            inputStreamReader.close();
            bufferedReader.close();
        }
        catch (Exception e) {
            return null;
        }
        process.destroy();
        return message.toString();
    }

    public static String findFileSize(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return Until.findMbSize(file.length());
        }
        return "0";
    }

    public static String findMbSize(long fileSize) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        return decimalFormat.format((double)fileSize / 1024.0 / 1024.0);
    }
}

