/*
 * Decompiled with CFR 0.152.
 */
package io.tapirtest.execution.gui.application.views;

import com.google.common.collect.Iterables;
import de.bmiag.tapir.bootstrap.TapirBootstrapper;
import de.bmiag.tapir.execution.TapirExecutor;
import de.bmiag.tapir.execution.model.ExecutionPlan;
import de.bmiag.tapir.execution.model.Identifiable;
import de.bmiag.tapir.execution.model.TestClass;
import de.bmiag.tapir.execution.model.TestStep;
import de.bmiag.tapir.execution.model.TestSuite;
import de.saxsys.mvvmfx.ViewModel;
import de.saxsys.mvvmfx.utils.commands.Action;
import de.saxsys.mvvmfx.utils.commands.DelegateCommand;
import io.tapirtest.execution.gui.application.components.AbstractCheckBoxTreeItem;
import io.tapirtest.execution.gui.application.components.ExecutionPlanTreeItem;
import io.tapirtest.execution.gui.application.components.TestStepTreeItem;
import io.tapirtest.execution.gui.application.data.ExecutionStatus;
import io.tapirtest.execution.gui.application.data.Property;
import io.tapirtest.execution.gui.application.filter.GUIStepExecutionInvocationHandler;
import io.tapirtest.execution.gui.application.listener.GUIExecutionListener;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.TreeItem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.springframework.context.ConfigurableApplicationContext;

@Accessors
public class MainViewModel
implements ViewModel {
    private static final Logger logger = LogManager.getLogger(MainViewModel.class);
    private final DelegateCommand reinitializeExecutionPlanCommand = this.createCommand(() -> this.performReinitializeExecutionPlan());
    private final DelegateCommand selectAllCommand = this.createCommand(() -> this.performSelectAll());
    private final DelegateCommand deselectAllCommand = this.createCommand(() -> this.performDeselectAll());
    private final DelegateCommand startTestsCommand = this.createCommand(() -> this.performStartTests());
    private final DelegateCommand addPropertyCommand = this.createCommand(() -> this.performAddProperty());
    private final DelegateCommand deletePropertyCommand = this.createCommand(() -> this.performDeleteProperty());
    private final SimpleObjectProperty<Object> refreshTableObservable = new SimpleObjectProperty();
    private final SimpleObjectProperty<AbstractCheckBoxTreeItem<ExecutionPlan>> executionPlanRoot = new SimpleObjectProperty();
    private final SimpleListProperty<Property> propertiesContent = new SimpleListProperty(FXCollections.observableArrayList());
    private final SimpleObjectProperty<Property> selectedProperty = new SimpleObjectProperty();
    private final SimpleBooleanProperty readOnlyMode = new SimpleBooleanProperty();
    private Class<?> testClass;
    private ConfigurableApplicationContext tapirContext;
    private TapirExecutor tapirExecutor;

    public void start(Application.Parameters parameters) {
        try {
            boolean bl;
            List rawParameters = parameters.getRaw();
            int n = rawParameters.size();
            boolean bl2 = bl = n < 1;
            if (bl) {
                throw new IllegalArgumentException("The tapir extensions launcher requires the test class or test suite as first parameter");
            }
            String firstParameter = (String)rawParameters.get(0);
            try {
                this.testClass = Class.forName(firstParameter);
            }
            catch (Throwable throwable) {
                if (throwable instanceof ClassNotFoundException) {
                    StringConcatenation stringConcatenation = new StringConcatenation();
                    stringConcatenation.append("The class '");
                    stringConcatenation.append(firstParameter);
                    stringConcatenation.append("' can not be found");
                    throw new IllegalArgumentException(stringConcatenation.toString());
                }
                throw Exceptions.sneakyThrow((Throwable)throwable);
            }
            this.performReinitializeExecutionPlan();
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                Exception ex_1 = (Exception)throwable;
                this.handleException(ex_1);
            }
            throw Exceptions.sneakyThrow((Throwable)throwable);
        }
    }

    private void performReinitializeExecutionPlan() {
        Functions.Function1 function1 = it -> {
            String string = it.getKey();
            return string != null;
        };
        Consumer<Property> consumer = it -> System.setProperty(it.getKey(), it.getValue());
        IterableExtensions.filter((Iterable)this.propertiesContent.getValue(), (Functions.Function1)function1).forEach(consumer);
        this.restartTapirContext();
        ExecutionPlan executionPlan = this.tapirExecutor.getExecutionPlan();
        ExecutionPlanTreeItem executionPlanItem = new ExecutionPlanTreeItem(executionPlan);
        this.executionPlanRoot.set((Object)executionPlanItem);
        this.selectAllNodes((TreeItem<Identifiable>)executionPlanItem);
        this.expandNodes((TreeItem<Identifiable>)executionPlanItem);
    }

    private TapirExecutor restartTapirContext() {
        TapirExecutor tapirExecutor = null;
        if (this.tapirContext != null) {
            this.tapirContext.close();
        }
        this.tapirContext = TapirBootstrapper.bootstrap(this.testClass);
        TapirExecutor.TapirExecutorFactory tapirExecutorFactory = (TapirExecutor.TapirExecutorFactory)this.tapirContext.getBean(TapirExecutor.TapirExecutorFactory.class);
        tapirExecutor = this.tapirExecutor = tapirExecutorFactory.getExecutorForClass(this.testClass);
        return tapirExecutor;
    }

    private void expandNodes(TreeItem<Identifiable> treeItem) {
        treeItem.setExpanded(true);
        Identifiable value = (Identifiable)treeItem.getValue();
        if (value instanceof ExecutionPlan || value instanceof TestSuite) {
            Consumer<TreeItem> consumer = it -> this.expandNodes((TreeItem<Identifiable>)it);
            treeItem.getChildren().forEach(consumer);
        } else if (value instanceof TestClass) {
            treeItem.setExpanded(false);
        }
    }

    private void performSelectAll() {
        this.selectAllNodes((TreeItem<Identifiable>)((TreeItem)this.executionPlanRoot.get()));
    }

    private void selectAllNodes(TreeItem<Identifiable> treeItem) {
        ((CheckBoxTreeItem)treeItem).setSelected(true);
        Consumer<TreeItem> consumer = it -> this.selectAllNodes((TreeItem<Identifiable>)it);
        treeItem.getChildren().forEach(consumer);
    }

    private void performDeselectAll() {
        this.deselectAllNodes((TreeItem<Identifiable>)((TreeItem)this.executionPlanRoot.get()));
    }

    private void deselectAllNodes(TreeItem<Identifiable> treeItem) {
        ((CheckBoxTreeItem)treeItem).setSelected(false);
        Consumer<TreeItem> consumer = it -> this.deselectAllNodes((TreeItem<Identifiable>)it);
        treeItem.getChildren().forEach(consumer);
    }

    private void performStartTests() {
        Runnable runnable = () -> {
            block6: {
                try {
                    this.readOnlyMode.set(true);
                    this.resetExecutionState((TreeItem<Identifiable>)((TreeItem)this.executionPlanRoot.get()));
                    List<TestStep> selectedSteps = this.getSelectedSteps((TreeItem<Identifiable>)((TreeItem)this.executionPlanRoot.get()));
                    Runnable runnable = () -> {
                        Object object = new Object();
                        this.refreshTableObservable.setValue(object);
                    };
                    Platform.runLater((Runnable)runnable);
                    GUIStepExecutionInvocationHandler stepExecutionInvocationHandler = (GUIStepExecutionInvocationHandler)this.tapirContext.getBean(GUIStepExecutionInvocationHandler.class);
                    stepExecutionInvocationHandler.setSelectedTestSteps(selectedSteps);
                    GUIExecutionListener executionListener = (GUIExecutionListener)((Object)((Object)this.tapirContext.getBean(GUIExecutionListener.class)));
                    executionListener.setExecutionPlanRoot((AbstractCheckBoxTreeItem)((Object)((Object)this.executionPlanRoot.get())));
                    executionListener.setRefreshTableObservable((ObjectProperty<Object>)this.refreshTableObservable);
                    this.tapirExecutor.execute();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof Exception) {
                        Exception ex = (Exception)throwable;
                        this.handleException(ex);
                        break block6;
                    }
                    throw Exceptions.sneakyThrow((Throwable)throwable);
                }
                finally {
                    this.readOnlyMode.set(false);
                }
            }
        };
        new Thread(runnable).start();
    }

    private void resetExecutionState(TreeItem<Identifiable> treeItem) {
        ((AbstractCheckBoxTreeItem)treeItem).setExecutionStatus(ExecutionStatus.NONE);
        Consumer<TreeItem> consumer = it -> this.resetExecutionState((TreeItem<Identifiable>)it);
        treeItem.getChildren().forEach(consumer);
    }

    private List<TestStep> getSelectedSteps(TreeItem<Identifiable> treeItem) {
        List list = null;
        if (treeItem instanceof TestStepTreeItem) {
            List list2 = null;
            boolean bl = ((CheckBoxTreeItem)treeItem).isSelected();
            if (bl) {
                Identifiable identifiable = (Identifiable)((TestStepTreeItem)treeItem).getValue();
                list2 = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TestStep[]{(TestStep)identifiable}));
            } else {
                list2 = Collections.unmodifiableList(CollectionLiterals.newArrayList());
            }
            list = list2;
        } else {
            Functions.Function1 function1 = it -> this.getSelectedSteps((TreeItem<Identifiable>)it);
            list = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)treeItem.getChildren(), (Functions.Function1)function1)));
        }
        return list;
    }

    private boolean performAddProperty() {
        Property property = new Property();
        return this.propertiesContent.add((Object)property);
    }

    private boolean performDeleteProperty() {
        boolean bl = false;
        Property selectedProperty = (Property)this.selectedProperty.get();
        boolean bl2 = false;
        if (selectedProperty != null) {
            bl2 = this.propertiesContent.remove((Object)selectedProperty);
        }
        bl = bl2;
        return bl;
    }

    private DelegateCommand createCommand(final Runnable aAction) {
        Supplier<Action> supplier = () -> new Action(){

            protected void action() throws Exception {
                try {
                    aAction.run();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof Exception) {
                        Exception ex = (Exception)throwable;
                        MainViewModel.this.handleException(ex);
                    }
                    throw Exceptions.sneakyThrow((Throwable)throwable);
                }
            }
        };
        return new DelegateCommand(supplier);
    }

    private void handleException(Exception exception) {
        Runnable runnable;
        Runnable runnable2 = runnable = () -> {
            logger.error("An exception occurred", (Throwable)exception);
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Error");
            alert.setHeaderText(exception.getLocalizedMessage());
            alert.showAndWait();
        };
        Platform.runLater((Runnable)runnable2);
    }

    @Pure
    public DelegateCommand getReinitializeExecutionPlanCommand() {
        return this.reinitializeExecutionPlanCommand;
    }

    @Pure
    public DelegateCommand getSelectAllCommand() {
        return this.selectAllCommand;
    }

    @Pure
    public DelegateCommand getDeselectAllCommand() {
        return this.deselectAllCommand;
    }

    @Pure
    public DelegateCommand getStartTestsCommand() {
        return this.startTestsCommand;
    }

    @Pure
    public DelegateCommand getAddPropertyCommand() {
        return this.addPropertyCommand;
    }

    @Pure
    public DelegateCommand getDeletePropertyCommand() {
        return this.deletePropertyCommand;
    }

    @Pure
    public SimpleObjectProperty<Object> getRefreshTableObservable() {
        return this.refreshTableObservable;
    }

    @Pure
    public SimpleObjectProperty<AbstractCheckBoxTreeItem<ExecutionPlan>> getExecutionPlanRoot() {
        return this.executionPlanRoot;
    }

    @Pure
    public SimpleListProperty<Property> getPropertiesContent() {
        return this.propertiesContent;
    }

    @Pure
    public SimpleObjectProperty<Property> getSelectedProperty() {
        return this.selectedProperty;
    }

    @Pure
    public SimpleBooleanProperty getReadOnlyMode() {
        return this.readOnlyMode;
    }

    @Pure
    public Class<?> getTestClass() {
        return this.testClass;
    }

    public void setTestClass(Class<?> testClass) {
        this.testClass = testClass;
    }

    @Pure
    public ConfigurableApplicationContext getTapirContext() {
        return this.tapirContext;
    }

    public void setTapirContext(ConfigurableApplicationContext tapirContext) {
        this.tapirContext = tapirContext;
    }

    @Pure
    public TapirExecutor getTapirExecutor() {
        return this.tapirExecutor;
    }

    public void setTapirExecutor(TapirExecutor tapirExecutor) {
        this.tapirExecutor = tapirExecutor;
    }
}

