/*
 * Decompiled with CFR 0.152.
 */
package io.tapirtest.execution.gui.application.listener;

import com.google.common.base.Objects;
import de.bmiag.tapir.execution.executor.AbstractExecutionListener;
import de.bmiag.tapir.execution.model.ExecutionPlan;
import de.bmiag.tapir.execution.model.Identifiable;
import de.bmiag.tapir.execution.model.TestClass;
import de.bmiag.tapir.execution.model.TestStep;
import de.bmiag.tapir.execution.model.TestSuite;
import io.tapirtest.execution.gui.application.components.AbstractCheckBoxTreeItem;
import io.tapirtest.execution.gui.application.data.ExecutionStatus;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.springframework.stereotype.Component;

@Component
public class GUIExecutionListener
extends AbstractExecutionListener {
    private static final Logger logger = LogManager.getLogger(GUIExecutionListener.class);
    private AbstractCheckBoxTreeItem<ExecutionPlan> executionPlanRoot;
    private ObjectProperty<Object> refreshTableObservable;

    public void classSucceeded(TestClass testClass) {
        this.setStatus((Identifiable)testClass, ExecutionStatus.SUCCEEDED);
    }

    public void classFailed(TestClass testClass, Throwable throwable) {
        this.setStatus((Identifiable)testClass, ExecutionStatus.FAILED);
    }

    public void classSkipped(TestClass testClass) {
        this.setStatus((Identifiable)testClass, ExecutionStatus.SKIPPED);
    }

    public void executionFailed(ExecutionPlan executionPlan, Throwable throwable) {
        this.setStatus((Identifiable)executionPlan, ExecutionStatus.FAILED);
    }

    public void executionSucceeded(ExecutionPlan executionPlan) {
        this.setStatus((Identifiable)executionPlan, ExecutionStatus.SUCCEEDED);
    }

    public void stepFailed(TestStep testStep, Throwable throwable) {
        this.setStatus((Identifiable)testStep, ExecutionStatus.FAILED);
    }

    public void stepSkipped(TestStep testStep) {
        this.setStatus((Identifiable)testStep, ExecutionStatus.SKIPPED);
    }

    public void stepSucceeded(TestStep testStep) {
        this.setStatus((Identifiable)testStep, ExecutionStatus.SUCCEEDED);
    }

    public void suiteFailed(TestSuite testSuite, Throwable throwable) {
        this.setStatus((Identifiable)testSuite, ExecutionStatus.FAILED);
    }

    public void suiteSkipped(TestSuite testSuite) {
        this.setStatus((Identifiable)testSuite, ExecutionStatus.SKIPPED);
    }

    public void suiteSucceeded(TestSuite testSuite) {
        this.setStatus((Identifiable)testSuite, ExecutionStatus.SUCCEEDED);
    }

    private void setStatus(Identifiable testItem, ExecutionStatus executionStatus) {
        if (this.executionPlanRoot == null) {
            return;
        }
        TreeItem<Identifiable> item = this.search((TreeItem<Identifiable>)this.executionPlanRoot, testItem);
        if (item instanceof AbstractCheckBoxTreeItem) {
            Runnable runnable = () -> {
                ((AbstractCheckBoxTreeItem)item).setExecutionStatus(executionStatus);
                Object object = new Object();
                this.refreshTableObservable.setValue(object);
            };
            Platform.runLater((Runnable)runnable);
        } else {
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("Test item with ");
            Integer n = testItem.getId();
            stringConcatenation.append((Object)n);
            stringConcatenation.append(" could not be found in the execution plan");
            logger.warn((CharSequence)stringConcatenation);
        }
    }

    private TreeItem<Identifiable> search(TreeItem<Identifiable> treeItem, Identifiable testItem) {
        Identifiable identifiable = (Identifiable)treeItem.getValue();
        boolean bl = Objects.equal((Object)identifiable, (Object)testItem);
        if (bl) {
            return treeItem;
        }
        ObservableList observableList = treeItem.getChildren();
        for (TreeItem child : observableList) {
            TreeItem<Identifiable> result = this.search((TreeItem<Identifiable>)child, testItem);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public AbstractCheckBoxTreeItem<ExecutionPlan> setExecutionPlanRoot(AbstractCheckBoxTreeItem<ExecutionPlan> executionPlanRoot) {
        this.executionPlanRoot = executionPlanRoot;
        return this.executionPlanRoot;
    }

    public ObjectProperty<Object> setRefreshTableObservable(ObjectProperty<Object> refreshTableObservable) {
        this.refreshTableObservable = refreshTableObservable;
        return this.refreshTableObservable;
    }
}

