/*
 * Decompiled with CFR 0.152.
 */
package io.tapirtest.execution.gui.application.components;

import de.bmiag.tapir.execution.model.Identifiable;
import io.tapirtest.execution.gui.application.components.AbstractCheckBoxTreeItem;
import io.tapirtest.execution.gui.application.data.ExecutionStatus;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableRow;

public final class ExecutionStatusStyledTreeTableRow
extends TreeTableRow<Identifiable> {
    protected void updateItem(Identifiable identifiable, boolean empty) {
        TreeItem treeItem;
        ExecutionStatus executionStatus;
        String newStyleClass;
        super.updateItem((Object)identifiable, empty);
        this.getStyleClass().removeAll((Object[])new String[]{"row-failed", "row-skipped", "row-succeeded"});
        TreeItem treeItem2 = this.getTreeItem();
        if (treeItem2 instanceof AbstractCheckBoxTreeItem && (newStyleClass = this.findStyleClass(executionStatus = ((AbstractCheckBoxTreeItem)(treeItem = this.getTreeItem())).getExecutionStatus())) != null) {
            this.getStyleClass().add((Object)newStyleClass);
        }
    }

    private String findStyleClass(ExecutionStatus executionStatus) {
        String string = null;
        if (executionStatus != null) {
            switch (executionStatus) {
                case FAILED: {
                    string = "row-failed";
                    break;
                }
                case SUCCEEDED: {
                    string = "row-succeeded";
                    break;
                }
                case SKIPPED: {
                    string = "row-skipped";
                    break;
                }
                case NONE: {
                    string = null;
                    break;
                }
                default: {
                    string = null;
                    break;
                }
            }
        } else {
            string = null;
        }
        return string;
    }
}

