/*
 * Decompiled with CFR 0.152.
 */
package io.tapirtest.execution.gui;

import de.saxsys.mvvmfx.FluentViewLoader;
import de.saxsys.mvvmfx.ViewTuple;
import io.tapirtest.execution.gui.application.views.MainView;
import io.tapirtest.execution.gui.application.views.MainViewModel;
import java.io.InputStream;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;

public final class GUILauncher
extends Application {
    public static void main(String[] args) {
        GUILauncher.launch((String[])args);
    }

    public void start(Stage primaryStage) throws Exception {
        try {
            ViewTuple tuple = FluentViewLoader.javaView(MainView.class).load();
            Parent parent = tuple.getView();
            Scene scene = new Scene(parent);
            primaryStage.setTitle("tapir-extensions Execution GUI");
            ObservableList observableList = primaryStage.getIcons();
            InputStream inputStream = GUILauncher.class.getClassLoader().getResourceAsStream("tapir-extensions-app-icon.png");
            Image image = new Image(inputStream);
            observableList.add((Object)image);
            primaryStage.setScene(scene);
            primaryStage.setMaximized(true);
            primaryStage.show();
            ((MainViewModel)tuple.getViewModel()).start(this.getParameters());
        }
        catch (Throwable throwable) {
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException ex = (IllegalArgumentException)throwable;
                this.printError(ex);
                this.printUsage();
            }
            throw Exceptions.sneakyThrow((Throwable)throwable);
        }
    }

    private void printError(IllegalArgumentException exception) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("Error: ");
        String string = exception.getLocalizedMessage();
        stringConcatenation.append(string);
        System.err.println(stringConcatenation);
    }

    private void printUsage() {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("Usage: java ");
        String string = GUILauncher.class.getName();
        stringConcatenation.append(string);
        stringConcatenation.append(" <test class or test suite>");
        System.err.println(stringConcatenation);
    }
}

