/**
 * MIT License
 * 
 * Copyright (c) 2018 b+m Informatik AG
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package io.tapirtest.execution.gui.application.views;

import de.bmiag.tapir.execution.model.Identifiable;
import de.saxsys.mvvmfx.InjectViewModel;
import de.saxsys.mvvmfx.JavaView;
import io.tapirtest.execution.gui.application.components.DescriptionCellValueFactory;
import io.tapirtest.execution.gui.application.components.ExecutionStatusStyledTreeTableRow;
import io.tapirtest.execution.gui.application.components.ParametersCellValueFactory;
import io.tapirtest.execution.gui.application.data.Property;
import io.tapirtest.execution.gui.application.views.MainViewModel;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.cell.CheckBoxTreeTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.control.cell.TreeItemPropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * The view of the main page.
 * 
 * @author Nils Christian Ehmke
 * 
 * @since 1.0.0
 */
@SuppressWarnings("all")
public class MainView extends VBox implements JavaView<MainViewModel>, Initializable {
  @InjectViewModel
  private MainViewModel mainViewModel;
  
  private final TreeTableView<Identifiable> executionPlanTreeTableView;
  
  private final TableView<Property> propertiesTableView;
  
  public MainView() {
    Insets _insets = new Insets(10);
    this.setPadding(_insets);
    ObservableList<String> _stylesheets = this.getStylesheets();
    String _replace = MainView.class.getCanonicalName().replace(".", "/");
    String _plus = (_replace + ".css");
    _stylesheets.add(_plus);
    ObservableList<Node> _children = this.getChildren();
    HBox _hBox = new HBox();
    final Procedure1<HBox> _function = (HBox it) -> {
      Insets _insets_1 = new Insets(0.0, 0.0, 10, 0.0);
      VBox.setMargin(it, _insets_1);
      it.setSpacing(10);
      ObservableList<Node> _children_1 = it.getChildren();
      Button _button = new Button();
      final Procedure1<Button> _function_1 = (Button it_1) -> {
        it_1.setMinWidth(180);
        it_1.setText("Select All");
        final EventHandler<ActionEvent> _function_2 = (ActionEvent it_2) -> {
          this.mainViewModel.getSelectAllCommand().execute();
        };
        it_1.setOnAction(_function_2);
      };
      Button _doubleArrow = ObjectExtensions.<Button>operator_doubleArrow(_button, _function_1);
      _children_1.add(_doubleArrow);
      ObservableList<Node> _children_2 = it.getChildren();
      Button _button_1 = new Button();
      final Procedure1<Button> _function_2 = (Button it_1) -> {
        it_1.setMinWidth(180);
        it_1.setText("Deselect All");
        final EventHandler<ActionEvent> _function_3 = (ActionEvent it_2) -> {
          this.mainViewModel.getDeselectAllCommand().execute();
        };
        it_1.setOnAction(_function_3);
      };
      Button _doubleArrow_1 = ObjectExtensions.<Button>operator_doubleArrow(_button_1, _function_2);
      _children_2.add(_doubleArrow_1);
      ObservableList<Node> _children_3 = it.getChildren();
      Button _button_2 = new Button();
      final Procedure1<Button> _function_3 = (Button it_1) -> {
        it_1.setMinWidth(180);
        it_1.setText("Reinitialize Execution Plan");
        Insets _insets_2 = new Insets(0.0, 0.0, 0.0, 20.0);
        HBox.setMargin(it_1, _insets_2);
        final EventHandler<ActionEvent> _function_4 = (ActionEvent it_2) -> {
          this.mainViewModel.getReinitializeExecutionPlanCommand().execute();
        };
        it_1.setOnAction(_function_4);
      };
      Button _doubleArrow_2 = ObjectExtensions.<Button>operator_doubleArrow(_button_2, _function_3);
      _children_3.add(_doubleArrow_2);
      ObservableList<Node> _children_4 = it.getChildren();
      Button _button_3 = new Button();
      final Procedure1<Button> _function_4 = (Button it_1) -> {
        it_1.setMinWidth(180);
        it_1.setText("Start Tests");
        Insets _insets_2 = new Insets(0.0, 0.0, 0.0, 20.0);
        HBox.setMargin(it_1, _insets_2);
        final EventHandler<ActionEvent> _function_5 = (ActionEvent it_2) -> {
          this.mainViewModel.getStartTestsCommand().execute();
        };
        it_1.setOnAction(_function_5);
      };
      Button _doubleArrow_3 = ObjectExtensions.<Button>operator_doubleArrow(_button_3, _function_4);
      _children_4.add(_doubleArrow_3);
    };
    HBox _doubleArrow = ObjectExtensions.<HBox>operator_doubleArrow(_hBox, _function);
    _children.add(_doubleArrow);
    ObservableList<Node> _children_1 = this.getChildren();
    Separator _separator = new Separator();
    final Procedure1<Separator> _function_1 = (Separator it) -> {
      Insets _insets_1 = new Insets(10.0, 0.0, 0.0, 0.0);
      VBox.setMargin(it, _insets_1);
    };
    Separator _doubleArrow_1 = ObjectExtensions.<Separator>operator_doubleArrow(_separator, _function_1);
    _children_1.add(_doubleArrow_1);
    ObservableList<Node> _children_2 = this.getChildren();
    Label _label = new Label();
    final Procedure1<Label> _function_2 = (Label it) -> {
      Insets _insets_1 = new Insets(10.0, 0.0, 0.0, 0.0);
      VBox.setMargin(it, _insets_1);
      it.setText("Execution Plan");
    };
    Label _doubleArrow_2 = ObjectExtensions.<Label>operator_doubleArrow(_label, _function_2);
    _children_2.add(_doubleArrow_2);
    TreeTableView<Identifiable> _treeTableView = new TreeTableView<Identifiable>();
    final Procedure1<TreeTableView<Identifiable>> _function_3 = (TreeTableView<Identifiable> it) -> {
      VBox.setVgrow(it, Priority.ALWAYS);
      Insets _insets_1 = new Insets(5.0, 0.0, 0.0, 0.0);
      VBox.setMargin(it, _insets_1);
      final Callback<TreeTableView<Identifiable>, TreeTableRow<Identifiable>> _function_4 = (TreeTableView<Identifiable> treeTableView) -> {
        return new ExecutionStatusStyledTreeTableRow();
      };
      it.setRowFactory(_function_4);
      it.setTableMenuButtonVisible(true);
      it.setShowRoot(false);
      it.setEditable(true);
      Label _label_1 = new Label();
      final Procedure1<Label> _function_5 = (Label it_1) -> {
        it_1.setText("No Execution Plan available");
      };
      Label _doubleArrow_3 = ObjectExtensions.<Label>operator_doubleArrow(_label_1, _function_5);
      it.setPlaceholder(_doubleArrow_3);
      ObservableList<TreeTableColumn<Identifiable, ?>> _columns = it.getColumns();
      TreeTableColumn<Identifiable, Boolean> _treeTableColumn = new TreeTableColumn<Identifiable, Boolean>();
      final Procedure1<TreeTableColumn<Identifiable, Boolean>> _function_6 = (TreeTableColumn<Identifiable, Boolean> it_1) -> {
        it_1.setText("Execute");
        it_1.setCellFactory(CheckBoxTreeTableCell.<Identifiable>forTreeTableColumn(it_1));
        final Callback<TreeTableColumn.CellDataFeatures<Identifiable, Boolean>, ObservableValue<Boolean>> _function_7 = (TreeTableColumn.CellDataFeatures<Identifiable, Boolean> cellDataFeature) -> {
          TreeItem<Identifiable> _value = cellDataFeature.getValue();
          return ((CheckBoxTreeItem<Identifiable>) _value).selectedProperty();
        };
        it_1.setCellValueFactory(_function_7);
      };
      TreeTableColumn<Identifiable, Boolean> _doubleArrow_4 = ObjectExtensions.<TreeTableColumn<Identifiable, Boolean>>operator_doubleArrow(_treeTableColumn, _function_6);
      _columns.add(_doubleArrow_4);
      ObservableList<TreeTableColumn<Identifiable, ?>> _columns_1 = it.getColumns();
      TreeTableColumn<Identifiable, String> _treeTableColumn_1 = new TreeTableColumn<Identifiable, String>();
      final Procedure1<TreeTableColumn<Identifiable, String>> _function_7 = (TreeTableColumn<Identifiable, String> it_1) -> {
        it_1.setText("Name");
        TreeItemPropertyValueFactory<Identifiable, String> _treeItemPropertyValueFactory = new TreeItemPropertyValueFactory<Identifiable, String>("name");
        it_1.setCellValueFactory(_treeItemPropertyValueFactory);
      };
      TreeTableColumn<Identifiable, String> _doubleArrow_5 = ObjectExtensions.<TreeTableColumn<Identifiable, String>>operator_doubleArrow(_treeTableColumn_1, _function_7);
      _columns_1.add(_doubleArrow_5);
      ObservableList<TreeTableColumn<Identifiable, ?>> _columns_2 = it.getColumns();
      TreeTableColumn<Identifiable, String> _treeTableColumn_2 = new TreeTableColumn<Identifiable, String>();
      final Procedure1<TreeTableColumn<Identifiable, String>> _function_8 = (TreeTableColumn<Identifiable, String> it_1) -> {
        it_1.setText("Description");
        DescriptionCellValueFactory _descriptionCellValueFactory = new DescriptionCellValueFactory();
        it_1.setCellValueFactory(_descriptionCellValueFactory);
      };
      TreeTableColumn<Identifiable, String> _doubleArrow_6 = ObjectExtensions.<TreeTableColumn<Identifiable, String>>operator_doubleArrow(_treeTableColumn_2, _function_8);
      _columns_2.add(_doubleArrow_6);
      ObservableList<TreeTableColumn<Identifiable, ?>> _columns_3 = it.getColumns();
      TreeTableColumn<Identifiable, String> _treeTableColumn_3 = new TreeTableColumn<Identifiable, String>();
      final Procedure1<TreeTableColumn<Identifiable, String>> _function_9 = (TreeTableColumn<Identifiable, String> it_1) -> {
        it_1.setText("Parameters");
        ParametersCellValueFactory _parametersCellValueFactory = new ParametersCellValueFactory();
        it_1.setCellValueFactory(_parametersCellValueFactory);
      };
      TreeTableColumn<Identifiable, String> _doubleArrow_7 = ObjectExtensions.<TreeTableColumn<Identifiable, String>>operator_doubleArrow(_treeTableColumn_3, _function_9);
      _columns_3.add(_doubleArrow_7);
      final Consumer<TreeTableColumn<Identifiable, ?>> _function_10 = (TreeTableColumn<Identifiable, ?> column) -> {
        column.prefWidthProperty().bind(it.widthProperty().divide(it.getColumns().size()));
      };
      it.getColumns().forEach(_function_10);
    };
    TreeTableView<Identifiable> _doubleArrow_3 = ObjectExtensions.<TreeTableView<Identifiable>>operator_doubleArrow(_treeTableView, _function_3);
    this.executionPlanTreeTableView = _doubleArrow_3;
    this.getChildren().add(this.executionPlanTreeTableView);
    ObservableList<Node> _children_3 = this.getChildren();
    Label _label_1 = new Label();
    final Procedure1<Label> _function_4 = (Label it) -> {
      Insets _insets_1 = new Insets(10.0, 0.0, 0.0, 0.0);
      VBox.setMargin(it, _insets_1);
      it.setText("Spring Properties");
    };
    Label _doubleArrow_4 = ObjectExtensions.<Label>operator_doubleArrow(_label_1, _function_4);
    _children_3.add(_doubleArrow_4);
    ObservableList<Node> _children_4 = this.getChildren();
    HBox _hBox_1 = new HBox();
    final Procedure1<HBox> _function_5 = (HBox it) -> {
      Insets _insets_1 = new Insets(10.0, 0.0, 0.0, 0.0);
      VBox.setMargin(it, _insets_1);
      it.setSpacing(10);
      ObservableList<Node> _children_5 = it.getChildren();
      Button _button = new Button();
      final Procedure1<Button> _function_6 = (Button it_1) -> {
        it_1.setText("Add Property");
        it_1.setMinWidth(120);
        final EventHandler<ActionEvent> _function_7 = (ActionEvent it_2) -> {
          this.mainViewModel.getAddPropertyCommand().execute();
        };
        it_1.setOnAction(_function_7);
      };
      Button _doubleArrow_5 = ObjectExtensions.<Button>operator_doubleArrow(_button, _function_6);
      _children_5.add(_doubleArrow_5);
      ObservableList<Node> _children_6 = it.getChildren();
      Button _button_1 = new Button();
      final Procedure1<Button> _function_7 = (Button it_1) -> {
        it_1.setText("Delete Property");
        it_1.setMinWidth(120);
        final EventHandler<ActionEvent> _function_8 = (ActionEvent it_2) -> {
          this.mainViewModel.getDeletePropertyCommand().execute();
        };
        it_1.setOnAction(_function_8);
      };
      Button _doubleArrow_6 = ObjectExtensions.<Button>operator_doubleArrow(_button_1, _function_7);
      _children_6.add(_doubleArrow_6);
    };
    HBox _doubleArrow_5 = ObjectExtensions.<HBox>operator_doubleArrow(_hBox_1, _function_5);
    _children_4.add(_doubleArrow_5);
    TableView<Property> _tableView = new TableView<Property>();
    final Procedure1<TableView<Property>> _function_6 = (TableView<Property> it) -> {
      Insets _insets_1 = new Insets(10.0, 0.0, 0.0, 0.0);
      VBox.setMargin(it, _insets_1);
      it.setEditable(true);
      Label _label_2 = new Label();
      final Procedure1<Label> _function_7 = (Label it_1) -> {
        it_1.setText("No Properties available");
      };
      Label _doubleArrow_6 = ObjectExtensions.<Label>operator_doubleArrow(_label_2, _function_7);
      it.setPlaceholder(_doubleArrow_6);
      ObservableList<TableColumn<Property, ?>> _columns = it.getColumns();
      TableColumn<Property, String> _tableColumn = new TableColumn<Property, String>();
      final Procedure1<TableColumn<Property, String>> _function_8 = (TableColumn<Property, String> it_1) -> {
        it_1.setText("Key");
        PropertyValueFactory<Property, String> _propertyValueFactory = new PropertyValueFactory<Property, String>("key");
        it_1.setCellValueFactory(_propertyValueFactory);
        it_1.setCellFactory(TextFieldTableCell.<Property>forTableColumn());
        final EventHandler<TableColumn.CellEditEvent<Property, String>> _function_9 = (TableColumn.CellEditEvent<Property, String> event) -> {
          final Property property = event.getTableView().getItems().get(event.getTablePosition().getRow());
          property.setKey(event.getNewValue());
        };
        it_1.setOnEditCommit(_function_9);
      };
      TableColumn<Property, String> _doubleArrow_7 = ObjectExtensions.<TableColumn<Property, String>>operator_doubleArrow(_tableColumn, _function_8);
      _columns.add(_doubleArrow_7);
      ObservableList<TableColumn<Property, ?>> _columns_1 = it.getColumns();
      TableColumn<Property, String> _tableColumn_1 = new TableColumn<Property, String>();
      final Procedure1<TableColumn<Property, String>> _function_9 = (TableColumn<Property, String> it_1) -> {
        it_1.setText("Value");
        PropertyValueFactory<Property, String> _propertyValueFactory = new PropertyValueFactory<Property, String>("value");
        it_1.setCellValueFactory(_propertyValueFactory);
        it_1.setCellFactory(TextFieldTableCell.<Property>forTableColumn());
        final EventHandler<TableColumn.CellEditEvent<Property, String>> _function_10 = (TableColumn.CellEditEvent<Property, String> event) -> {
          final Property property = event.getTableView().getItems().get(event.getTablePosition().getRow());
          property.setValue(event.getNewValue());
        };
        it_1.setOnEditCommit(_function_10);
      };
      TableColumn<Property, String> _doubleArrow_8 = ObjectExtensions.<TableColumn<Property, String>>operator_doubleArrow(_tableColumn_1, _function_9);
      _columns_1.add(_doubleArrow_8);
      final Consumer<TableColumn<Property, ?>> _function_10 = (TableColumn<Property, ?> column) -> {
        column.prefWidthProperty().bind(it.widthProperty().divide(it.getColumns().size()));
      };
      it.getColumns().forEach(_function_10);
    };
    TableView<Property> _doubleArrow_6 = ObjectExtensions.<TableView<Property>>operator_doubleArrow(_tableView, _function_6);
    this.propertiesTableView = _doubleArrow_6;
    this.getChildren().add(this.propertiesTableView);
  }
  
  @Override
  public void initialize(final URL location, final ResourceBundle resources) {
    this.disableProperty().bind(this.mainViewModel.getReadOnlyMode());
    this.executionPlanTreeTableView.rootProperty().bind(this.mainViewModel.getExecutionPlanRoot());
    final InvalidationListener _function = (Observable it) -> {
      new ChangeListener<Object>() {
        @Override
        public void changed(final ObservableValue<?> observable, final Object oldValue, final Object newValue) {
          MainView.this.executionPlanTreeTableView.refresh();
        }
      };
    };
    this.mainViewModel.getRefreshTableObservable().addListener(_function);
    this.propertiesTableView.itemsProperty().bindBidirectional(this.mainViewModel.getPropertiesContent());
    this.mainViewModel.getSelectedProperty().bind(this.propertiesTableView.getSelectionModel().selectedItemProperty());
  }
}
