/**
 * MIT License
 * 
 * Copyright (c) 2018 b+m Informatik AG
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package io.tapirtest.execution.gui.application.components;

import de.bmiag.tapir.execution.model.Identifiable;
import de.bmiag.tapir.execution.model.StructuralElement;
import de.bmiag.tapir.execution.model.TestClass;
import de.bmiag.tapir.execution.model.TestSuite;
import io.tapirtest.execution.gui.application.components.AbstractCheckBoxTreeItem;
import io.tapirtest.execution.gui.application.components.TestClassTreeItem;
import java.util.List;
import javafx.scene.control.TreeItem;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;

/**
 * A selectable tree item which holds an instance of {@link TestSuite}.
 * 
 * @author Nils Christian Ehmke
 * 
 * @since 1.0.0
 */
@SuppressWarnings("all")
public final class TestSuiteTreeItem extends AbstractCheckBoxTreeItem<TestSuite> {
  public TestSuiteTreeItem(final TestSuite testSuite) {
    super(testSuite);
  }
  
  @Override
  public boolean isLeaf() {
    Identifiable _value = this.getValue();
    return ((TestSuite) _value).getChildren().isEmpty();
  }
  
  @Override
  public List<TreeItem<Identifiable>> createChildren() {
    Identifiable _value = this.getValue();
    final Function1<StructuralElement, TreeItem<Identifiable>> _function = (StructuralElement child) -> {
      AbstractCheckBoxTreeItem<? extends Object> _xifexpression = null;
      if ((child instanceof TestClass)) {
        _xifexpression = new TestClassTreeItem(((TestClass)child));
      } else {
        TestSuiteTreeItem _xifexpression_1 = null;
        if ((child instanceof TestSuite)) {
          _xifexpression_1 = new TestSuiteTreeItem(((TestSuite)child));
        }
        _xifexpression = _xifexpression_1;
      }
      return _xifexpression;
    };
    return ListExtensions.<StructuralElement, TreeItem<Identifiable>>map(((TestSuite) _value).getChildren(), _function);
  }
}
