/**
 * MIT License
 * 
 * Copyright (c) 2018 b+m Informatik AG
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package io.tapirtest.execution.gui.application.components;

import de.bmiag.tapir.execution.model.Identifiable;
import de.bmiag.tapir.execution.model.Parameterized;
import de.bmiag.tapir.execution.model.TestParameter;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TreeTableColumn;
import javafx.util.Callback;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * A cell value factory which extracts the parameters from {@link Parameterized} elements.
 * 
 * @author Nils Christian Ehmke
 * 
 * @since 1.0.0
 */
@SuppressWarnings("all")
public final class ParametersCellValueFactory implements Callback<TreeTableColumn.CellDataFeatures<Identifiable, String>, ObservableValue<String>> {
  @Override
  public ObservableValue<String> call(final TreeTableColumn.CellDataFeatures<Identifiable, String> cellDataFeatures) {
    final Identifiable value = cellDataFeatures.getValue().getValue();
    if ((value instanceof Parameterized)) {
      final List<TestParameter> parameters = ((Parameterized)value).getParameters();
      final Function1<TestParameter, CharSequence> _function = (TestParameter parameter) -> {
        StringConcatenation _builder = new StringConcatenation();
        String _name = parameter.getName();
        _builder.append(_name);
        _builder.append(" = ");
        String _label = parameter.getLabel();
        _builder.append(_label);
        return _builder.toString();
      };
      String _join = IterableExtensions.<TestParameter>join(parameters, ",", _function);
      return new SimpleStringProperty(_join);
    }
    return null;
  }
}
