/**
 * MIT License
 * 
 * Copyright (c) 2018 b+m Informatik AG
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package io.tapirtest.execution.gui;

import de.saxsys.mvvmfx.FluentViewLoader;
import de.saxsys.mvvmfx.ViewTuple;
import io.tapirtest.execution.gui.application.views.MainView;
import io.tapirtest.execution.gui.application.views.MainViewModel;
import java.io.InputStream;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;

/**
 * This is the GUI launcher for tapir test cases. It allows to start arbitrary parts of a test case or a test suite, as long as the tests and the
 * bootstrap configuration can be found in the classpath.
 * 
 * @author Nils Christian Ehmke
 * 
 * @since 1.0.0
 */
@SuppressWarnings("all")
public final class GUILauncher extends Application {
  public static void main(final String[] args) {
    GUILauncher.launch(args);
  }
  
  @Override
  public void start(final Stage primaryStage) throws Exception {
    try {
      final ViewTuple<MainView, MainViewModel> tuple = FluentViewLoader.<MainView, MainViewModel>javaView(MainView.class).load();
      Parent _view = tuple.getView();
      final Scene scene = new Scene(_view);
      primaryStage.setTitle("tapir-extensions Execution GUI");
      ObservableList<Image> _icons = primaryStage.getIcons();
      InputStream _resourceAsStream = GUILauncher.class.getClassLoader().getResourceAsStream("tapir-extensions-app-icon.png");
      Image _image = new Image(_resourceAsStream);
      _icons.add(_image);
      primaryStage.setScene(scene);
      primaryStage.setMaximized(true);
      primaryStage.show();
      tuple.getViewModel().start(this.getParameters());
    } catch (final Throwable _t) {
      if (_t instanceof IllegalArgumentException) {
        final IllegalArgumentException ex = (IllegalArgumentException)_t;
        this.printError(ex);
        this.printUsage();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  private void printError(final IllegalArgumentException exception) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Error: ");
    String _localizedMessage = exception.getLocalizedMessage();
    _builder.append(_localizedMessage);
    System.err.println(_builder);
  }
  
  private void printUsage() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Usage: java ");
    String _name = GUILauncher.class.getName();
    _builder.append(_name);
    _builder.append(" <test class or test suite>");
    System.err.println(_builder);
  }
}
