/**
 * MIT License
 * 
 * Copyright (c) 2018 b+m Informatik AG
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package io.tapirtest.execution.gui;

import de.bmiag.tapir.bootstrap.FqnAnnotationBeanNameGenerator;
import de.bmiag.tapir.bootstrap.annotation.ModuleConfiguration;
import de.bmiag.tapir.bootstrap.annotation.NoScan;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.context.annotation.ComponentScan;

/**
 * This is the configuration for the tapir extensions execution GUI module. This is just necessary to add the invocation handler of the tapir extensions launcher to the
 * Spring context of the tapir test case.
 * 
 * @author Nils Christian Ehmke
 * 
 * @since 1.0.0
 */
@ModuleConfiguration
@AutoConfigureOrder(ExecutionGUIConfiguration.AUTO_CONFIGURE_ORDER)
@ComponentScan(basePackageClasses = ExecutionGUIConfiguration.class, nameGenerator = FqnAnnotationBeanNameGenerator.class, excludeFilters = @ComponentScan.Filter(classes = NoScan.class))
@SuppressWarnings("all")
public class ExecutionGUIConfiguration {
  public final static int AUTO_CONFIGURE_ORDER = 7000;
}
