/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.s3.get;

import io.syndesis.s3.get.AmazonS3ClientMock;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.aws.s3.S3Endpoint;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@DirtiesContext
@SpringBootApplication
@SpringBootTest(classes={TestConfiguration.class}, properties={"spring.main.banner-mode = log"})
public class S3GetObjectConnectorTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3GetObjectConnectorTest.class);
    @Autowired
    private CamelContext camelContext;

    @Test
    public void testConfiguration() throws Exception {
        S3Endpoint s3Endpoint = null;
        for (Endpoint endpoint : this.camelContext.getEndpoints()) {
            LOGGER.debug("instance:" + endpoint.getClass());
            if (!(endpoint instanceof S3Endpoint)) continue;
            s3Endpoint = (S3Endpoint)endpoint;
            break;
        }
        String uri = s3Endpoint.getEndpointUri();
        Assert.assertNotNull((String)"No s3Endpoint found", s3Endpoint);
        Assert.assertTrue((uri.startsWith("aws-s3-aws-s3-get-object-connector:") || uri.startsWith("aws-s3-aws-s3-get-object-connector-component:") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"test", (Object)s3Endpoint.getConfiguration().getBucketName());
        Assert.assertFalse((boolean)s3Endpoint.getConfiguration().isDeleteAfterRead());
    }

    public static class S3Configuration {
        @Bean
        AmazonS3ClientMock amazonS3Client() {
            return new AmazonS3ClientMock();
        }
    }

    @Configuration
    public static class TestConfiguration {
        @Bean
        public RouteBuilder routeBuilder() {
            return new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("aws-s3-get-object-connector:test?amazonS3Client=#amazonS3Client").to("mock:result");
                }
            };
        }
    }
}

