/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.s3.get;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.HttpMethod;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ResponseMetadata;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.BucketLoggingConfiguration;
import com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.services.s3.model.BucketPolicy;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.DeleteBucketRequest;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.DeleteVersionRequest;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListBucketsRequest;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListPartsRequest;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.PartListing;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.services.s3.model.VersionListing;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.util.ObjectHelper;
import org.junit.Assert;

public class AmazonS3ClientMock
extends AmazonS3Client {
    List<S3Object> objects = new CopyOnWriteArrayList<S3Object>();
    List<PutObjectRequest> putObjectRequests = new CopyOnWriteArrayList<PutObjectRequest>();
    private boolean nonExistingBucketCreated;
    private int maxCapacity = 100;

    public AmazonS3ClientMock() {
        super((AWSCredentials)new BasicAWSCredentials("myAccessKey", "mySecretKey"));
    }

    public VersionListing listNextBatchOfVersions(VersionListing previousVersionListing) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public VersionListing listVersions(String bucketName, String prefix) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public VersionListing listVersions(String bucketName, String prefix, String keyMarker, String versionIdMarker, String delimiter, Integer maxKeys) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public VersionListing listVersions(ListVersionsRequest listVersionsRequest) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public ObjectListing listObjects(String bucketName) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public ObjectListing listObjects(String bucketName, String prefix) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws AmazonClientException, AmazonServiceException {
        if ("nonExistingBucket".equals(listObjectsRequest.getBucketName()) && !this.nonExistingBucketCreated) {
            AmazonServiceException ex = new AmazonServiceException("Unknown bucket");
            ex.setStatusCode(404);
            throw ex;
        }
        ObjectListing objectListing = new ObjectListing();
        int capacity = !ObjectHelper.isEmpty((Object)listObjectsRequest.getMaxKeys()) && listObjectsRequest.getMaxKeys() != null ? listObjectsRequest.getMaxKeys() : this.maxCapacity;
        for (int index = 0; index < this.objects.size() && index < capacity; ++index) {
            S3ObjectSummary s3ObjectSummary = new S3ObjectSummary();
            s3ObjectSummary.setBucketName(this.objects.get(index).getBucketName());
            s3ObjectSummary.setKey(this.objects.get(index).getKey());
            objectListing.getObjectSummaries().add(s3ObjectSummary);
        }
        return objectListing;
    }

    public ObjectListing listNextBatchOfObjects(ObjectListing previousObjectListing) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public Owner getS3AccountOwner() throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public List<Bucket> listBuckets(ListBucketsRequest listBucketsRequest) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public List<Bucket> listBuckets() throws AmazonClientException, AmazonServiceException {
        ArrayList<Bucket> list = new ArrayList<Bucket>();
        Bucket bucket = new Bucket("camel-bucket");
        bucket.setOwner(new Owner("Camel", "camel"));
        bucket.setCreationDate(new Date());
        list.add(bucket);
        return list;
    }

    public String getBucketLocation(String bucketName) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public Bucket createBucket(String bucketName) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public Bucket createBucket(String bucketName, Region region) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public Bucket createBucket(String bucketName, String region) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public Bucket createBucket(CreateBucketRequest createBucketRequest) throws AmazonClientException, AmazonServiceException {
        if ("nonExistingBucket".equals(createBucketRequest.getBucketName())) {
            this.nonExistingBucketCreated = true;
        }
        Bucket bucket = new Bucket();
        bucket.setName(createBucketRequest.getBucketName());
        bucket.setCreationDate(new Date());
        bucket.setOwner(new Owner("c2efc7302b9011ba9a78a92ac5fd1cd47b61790499ab5ddf5a37c31f0638a8fc ", "Christian Mueller"));
        return bucket;
    }

    public AccessControlList getObjectAcl(String bucketName, String key) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public AccessControlList getObjectAcl(String bucketName, String key, String versionId) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public void setObjectAcl(String bucketName, String key, AccessControlList acl) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public void setObjectAcl(String bucketName, String key, CannedAccessControlList acl) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public void setObjectAcl(String bucketName, String key, String versionId, AccessControlList acl) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public void setObjectAcl(String bucketName, String key, String versionId, CannedAccessControlList acl) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public AccessControlList getBucketAcl(String bucketName) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public void setBucketAcl(String bucketName, AccessControlList acl) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public void setBucketAcl(String bucketName, CannedAccessControlList acl) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public ObjectMetadata getObjectMetadata(String bucketName, String key) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public ObjectMetadata getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public S3Object getObject(String bucketName, String key) throws AmazonClientException, AmazonServiceException {
        for (S3Object s3Object : this.objects) {
            if (!bucketName.equals(s3Object.getBucketName()) || !key.equals(s3Object.getKey())) continue;
            return s3Object;
        }
        return null;
    }

    public boolean doesBucketExist(String bucketName) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public void changeObjectStorageClass(String bucketName, String key, StorageClass newStorageClass) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public S3Object getObject(GetObjectRequest getObjectRequest) throws AmazonClientException, AmazonServiceException {
        return this.getObject(getObjectRequest.getBucketName(), getObjectRequest.getKey());
    }

    public ObjectMetadata getObject(GetObjectRequest getObjectRequest, File destinationFile) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public void deleteBucket(String bucketName) throws AmazonClientException, AmazonServiceException {
    }

    public void deleteBucket(DeleteBucketRequest deleteBucketRequest) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public PutObjectResult putObject(String bucketName, String key, File file) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public PutObjectResult putObject(String bucketName, String key, InputStream input, ObjectMetadata metadata) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws AmazonClientException, AmazonServiceException {
        this.putObjectRequests.add(putObjectRequest);
        S3Object s3Object = new S3Object();
        s3Object.setBucketName(putObjectRequest.getBucketName());
        s3Object.setKey(putObjectRequest.getKey());
        if (putObjectRequest.getFile() != null) {
            try {
                s3Object.setObjectContent((InputStream)new FileInputStream(putObjectRequest.getFile()));
            }
            catch (FileNotFoundException e) {
                throw new AmazonServiceException("Cannot store the file object.", (Exception)e);
            }
        } else {
            s3Object.setObjectContent(putObjectRequest.getInputStream());
        }
        this.objects.add(s3Object);
        PutObjectResult putObjectResult = new PutObjectResult();
        putObjectResult.setETag("3a5c8b1ad448bca04584ecb55b836264");
        return putObjectResult;
    }

    public CopyObjectResult copyObject(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public CopyObjectResult copyObject(CopyObjectRequest copyObjectRequest) throws AmazonClientException, AmazonServiceException {
        CopyObjectResult copyObjectResult = new CopyObjectResult();
        copyObjectResult.setETag("3a5c8b1ad448bca04584ecb55b836264");
        copyObjectResult.setVersionId("11192828ahsh2723");
        return copyObjectResult;
    }

    public void deleteObject(String bucketName, String key) throws AmazonClientException, AmazonServiceException {
    }

    public void deleteObject(DeleteObjectRequest deleteObjectRequest) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public void deleteVersion(String bucketName, String key, String versionId) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public void deleteVersion(DeleteVersionRequest deleteVersionRequest) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public void setBucketVersioningConfiguration(SetBucketVersioningConfigurationRequest setBucketVersioningConfigurationRequest) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public BucketVersioningConfiguration getBucketVersioningConfiguration(String bucketName) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public void setBucketNotificationConfiguration(String bucketName, BucketNotificationConfiguration bucketNotificationConfiguration) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public BucketNotificationConfiguration getBucketNotificationConfiguration(String bucketName) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public BucketLoggingConfiguration getBucketLoggingConfiguration(String bucketName) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public void setBucketLoggingConfiguration(SetBucketLoggingConfigurationRequest setBucketLoggingConfigurationRequest) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public BucketPolicy getBucketPolicy(String bucketName) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public void setBucketPolicy(String bucketName, String policyText) throws AmazonClientException, AmazonServiceException {
        Assert.assertEquals((Object)"nonExistingBucket", (Object)bucketName);
        Assert.assertEquals((Object)"xxx", (Object)policyText);
    }

    public void deleteBucketPolicy(String bucketName) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public URL generatePresignedUrl(String bucketName, String key, Date expiration) throws AmazonClientException {
        throw new UnsupportedOperationException();
    }

    public URL generatePresignedUrl(String bucketName, String key, Date expiration, HttpMethod method) throws AmazonClientException {
        throw new UnsupportedOperationException();
    }

    public URL generatePresignedUrl(GeneratePresignedUrlRequest generatePresignedUrlRequest) throws AmazonClientException {
        throw new UnsupportedOperationException();
    }

    public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public MultipartUploadListing listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public PartListing listParts(ListPartsRequest listPartsRequest) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws AmazonClientException, AmazonServiceException {
        throw new UnsupportedOperationException();
    }

    public S3ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        throw new UnsupportedOperationException();
    }
}

