
      package io.shiftleft.codepropertygraph.generated.edges

      import java.lang.{Boolean => JBoolean, Long => JLong}
      import java.util.{Set => JSet}
      import java.util.{List => JList}
      import org.apache.tinkerpop.gremlin.structure.Property
      import org.apache.tinkerpop.gremlin.structure.{Vertex, VertexProperty}
      import io.shiftleft.overflowdb.{EdgeLayoutInformation, EdgeFactory, NodeFactory, OdbEdge, OdbNode, OdbGraph, NodeRef}
      import scala.collection.JavaConverters._
      import org.slf4j.LoggerFactory

      object PropertyErrorRegister {
        private var errorMap = Set[(Class[_], String)]()
        private val logger = LoggerFactory.getLogger(getClass)

        def logPropertyErrorIfFirst(clazz: Class[_], propertyName: String) {
          if (!errorMap.contains((clazz, propertyName))) {
            logger.warn("Property " + propertyName + " is deprecated for " + clazz.getName + ".")
            errorMap += ((clazz, propertyName))
          }
        }
      }
      
        object Factories {
          lazy val All: List[EdgeFactory[_]] = List(AliasOf.Factory, Ast.Factory, AttachedData.Factory, Binds.Factory, BindsTo.Factory, Call.Factory, Capture.Factory, CapturedBy.Factory, Cdg.Factory, Cfg.Factory, Condition.Factory, Contains.Factory, ContainsNode.Factory, Dominate.Factory, DynamicType.Factory, EvalType.Factory, InheritsFrom.Factory, IsSensitiveDataDescrOf.Factory, IsSensitiveDataDescrOfRef.Factory, IsSensitiveDataOfType.Factory, ParameterLink.Factory, PostDominate.Factory, Propagate.Factory, ReachingDef.Factory, Receiver.Factory, Ref.Factory, TaggedBy.Factory, TaintRemove.Factory, Vtable.Factory)
          lazy val AllAsJava: java.util.List[EdgeFactory[_]] = All.asJava
        }
        

object AliasOf {
  val Label = "ALIAS_OF"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, AliasOf => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[AliasOf] {
    override val forLabel = AliasOf.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new AliasOf(graph, outNode, inNode)
  }
}
      
      class AliasOf(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, AliasOf.Label, _outNode, _inNode, AliasOf.Keys.All) {

        
      }
      

object Ast {
  val Label = "AST"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, Ast => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[Ast] {
    override val forLabel = Ast.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new Ast(graph, outNode, inNode)
  }
}
      
      class Ast(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, Ast.Label, _outNode, _inNode, Ast.Keys.All) {

        
      }
      

object AttachedData {
  val Label = "ATTACHED_DATA"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, AttachedData => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[AttachedData] {
    override val forLabel = AttachedData.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new AttachedData(graph, outNode, inNode)
  }
}
      
      class AttachedData(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, AttachedData.Label, _outNode, _inNode, AttachedData.Keys.All) {

        
      }
      

object Binds {
  val Label = "BINDS"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, Binds => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[Binds] {
    override val forLabel = Binds.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new Binds(graph, outNode, inNode)
  }
}
      
      class Binds(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, Binds.Label, _outNode, _inNode, Binds.Keys.All) {

        
      }
      

object BindsTo {
  val Label = "BINDS_TO"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, BindsTo => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[BindsTo] {
    override val forLabel = BindsTo.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new BindsTo(graph, outNode, inNode)
  }
}
      
      class BindsTo(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, BindsTo.Label, _outNode, _inNode, BindsTo.Keys.All) {

        
      }
      

object Call {
  val Label = "CALL"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, Call => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[Call] {
    override val forLabel = Call.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new Call(graph, outNode, inNode)
  }
}
      
      class Call(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, Call.Label, _outNode, _inNode, Call.Keys.All) {

        
      }
      

object Capture {
  val Label = "CAPTURE"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, Capture => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[Capture] {
    override val forLabel = Capture.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new Capture(graph, outNode, inNode)
  }
}
      
      class Capture(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, Capture.Label, _outNode, _inNode, Capture.Keys.All) {

        
      }
      

object CapturedBy {
  val Label = "CAPTURED_BY"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, CapturedBy => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[CapturedBy] {
    override val forLabel = CapturedBy.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new CapturedBy(graph, outNode, inNode)
  }
}
      
      class CapturedBy(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, CapturedBy.Label, _outNode, _inNode, CapturedBy.Keys.All) {

        
      }
      

object Cdg {
  val Label = "CDG"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, Cdg => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[Cdg] {
    override val forLabel = Cdg.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new Cdg(graph, outNode, inNode)
  }
}
      
      class Cdg(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, Cdg.Label, _outNode, _inNode, Cdg.Keys.All) {

        
      }
      

object Cfg {
  val Label = "CFG"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, Cfg => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[Cfg] {
    override val forLabel = Cfg.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new Cfg(graph, outNode, inNode)
  }
}
      
      class Cfg(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, Cfg.Label, _outNode, _inNode, Cfg.Keys.All) {

        
      }
      

object Condition {
  val Label = "CONDITION"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, Condition => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[Condition] {
    override val forLabel = Condition.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new Condition(graph, outNode, inNode)
  }
}
      
      class Condition(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, Condition.Label, _outNode, _inNode, Condition.Keys.All) {

        
      }
      

object Contains {
  val Label = "CONTAINS"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, Contains => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[Contains] {
    override val forLabel = Contains.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new Contains(graph, outNode, inNode)
  }
}
      
      class Contains(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, Contains.Label, _outNode, _inNode, Contains.Keys.All) {

        
      }
      

object ContainsNode {
  val Label = "CONTAINS_NODE"
  object Keys {
    val All: JSet[String] = Set("LOCAL_NAME", "INDEX").asJava
    val KeyToValue: Map[String, ContainsNode => Any] = Map(
       "LOCAL_NAME" -> { instance: ContainsNode => instance.localName()},
 "INDEX" -> { instance: ContainsNode => instance.index()}
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[ContainsNode] {
    override val forLabel = ContainsNode.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new ContainsNode(graph, outNode, inNode)
  }
}
      
      class ContainsNode(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, ContainsNode.Label, _outNode, _inNode, ContainsNode.Keys.All) {

        def localName(): Option[String] = {
  val tp = property("LOCAL_NAME")
  if (tp.isPresent) Option(tp.value.asInstanceOf[String])
  else None
}

def index(): Option[Integer] = {
  val tp = property("INDEX")
  if (tp.isPresent) Option(tp.value.asInstanceOf[Integer])
  else None
}
      }
      

object Dominate {
  val Label = "DOMINATE"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, Dominate => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[Dominate] {
    override val forLabel = Dominate.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new Dominate(graph, outNode, inNode)
  }
}
      
      class Dominate(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, Dominate.Label, _outNode, _inNode, Dominate.Keys.All) {

        
      }
      

object DynamicType {
  val Label = "DYNAMIC_TYPE"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, DynamicType => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[DynamicType] {
    override val forLabel = DynamicType.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new DynamicType(graph, outNode, inNode)
  }
}
      
      class DynamicType(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, DynamicType.Label, _outNode, _inNode, DynamicType.Keys.All) {

        
      }
      

object EvalType {
  val Label = "EVAL_TYPE"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, EvalType => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[EvalType] {
    override val forLabel = EvalType.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new EvalType(graph, outNode, inNode)
  }
}
      
      class EvalType(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, EvalType.Label, _outNode, _inNode, EvalType.Keys.All) {

        
      }
      

object InheritsFrom {
  val Label = "INHERITS_FROM"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, InheritsFrom => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[InheritsFrom] {
    override val forLabel = InheritsFrom.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new InheritsFrom(graph, outNode, inNode)
  }
}
      
      class InheritsFrom(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, InheritsFrom.Label, _outNode, _inNode, InheritsFrom.Keys.All) {

        
      }
      

object IsSensitiveDataDescrOf {
  val Label = "IS_SENSITIVE_DATA_DESCR_OF"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, IsSensitiveDataDescrOf => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[IsSensitiveDataDescrOf] {
    override val forLabel = IsSensitiveDataDescrOf.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new IsSensitiveDataDescrOf(graph, outNode, inNode)
  }
}
      
      class IsSensitiveDataDescrOf(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, IsSensitiveDataDescrOf.Label, _outNode, _inNode, IsSensitiveDataDescrOf.Keys.All) {

        
      }
      

object IsSensitiveDataDescrOfRef {
  val Label = "IS_SENSITIVE_DATA_DESCR_OF_REF"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, IsSensitiveDataDescrOfRef => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[IsSensitiveDataDescrOfRef] {
    override val forLabel = IsSensitiveDataDescrOfRef.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new IsSensitiveDataDescrOfRef(graph, outNode, inNode)
  }
}
      
      class IsSensitiveDataDescrOfRef(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, IsSensitiveDataDescrOfRef.Label, _outNode, _inNode, IsSensitiveDataDescrOfRef.Keys.All) {

        
      }
      

object IsSensitiveDataOfType {
  val Label = "IS_SENSITIVE_DATA_OF_TYPE"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, IsSensitiveDataOfType => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[IsSensitiveDataOfType] {
    override val forLabel = IsSensitiveDataOfType.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new IsSensitiveDataOfType(graph, outNode, inNode)
  }
}
      
      class IsSensitiveDataOfType(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, IsSensitiveDataOfType.Label, _outNode, _inNode, IsSensitiveDataOfType.Keys.All) {

        
      }
      

object ParameterLink {
  val Label = "PARAMETER_LINK"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, ParameterLink => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[ParameterLink] {
    override val forLabel = ParameterLink.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new ParameterLink(graph, outNode, inNode)
  }
}
      
      class ParameterLink(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, ParameterLink.Label, _outNode, _inNode, ParameterLink.Keys.All) {

        
      }
      

object PostDominate {
  val Label = "POST_DOMINATE"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, PostDominate => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[PostDominate] {
    override val forLabel = PostDominate.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new PostDominate(graph, outNode, inNode)
  }
}
      
      class PostDominate(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, PostDominate.Label, _outNode, _inNode, PostDominate.Keys.All) {

        
      }
      

object Propagate {
  val Label = "PROPAGATE"
  object Keys {
    val All: JSet[String] = Set("ALIAS").asJava
    val KeyToValue: Map[String, Propagate => Any] = Map(
       "ALIAS" -> { instance: Propagate => instance.alias()}
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[Propagate] {
    override val forLabel = Propagate.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new Propagate(graph, outNode, inNode)
  }
}
      
      class Propagate(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, Propagate.Label, _outNode, _inNode, Propagate.Keys.All) {

        def alias(): JBoolean = property("ALIAS").value.asInstanceOf[JBoolean]
      }
      

object ReachingDef {
  val Label = "REACHING_DEF"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, ReachingDef => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[ReachingDef] {
    override val forLabel = ReachingDef.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new ReachingDef(graph, outNode, inNode)
  }
}
      
      class ReachingDef(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, ReachingDef.Label, _outNode, _inNode, ReachingDef.Keys.All) {

        
      }
      

object Receiver {
  val Label = "RECEIVER"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, Receiver => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[Receiver] {
    override val forLabel = Receiver.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new Receiver(graph, outNode, inNode)
  }
}
      
      class Receiver(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, Receiver.Label, _outNode, _inNode, Receiver.Keys.All) {

        
      }
      

object Ref {
  val Label = "REF"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, Ref => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[Ref] {
    override val forLabel = Ref.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new Ref(graph, outNode, inNode)
  }
}
      
      class Ref(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, Ref.Label, _outNode, _inNode, Ref.Keys.All) {

        
      }
      

object TaggedBy {
  val Label = "TAGGED_BY"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, TaggedBy => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[TaggedBy] {
    override val forLabel = TaggedBy.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new TaggedBy(graph, outNode, inNode)
  }
}
      
      class TaggedBy(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, TaggedBy.Label, _outNode, _inNode, TaggedBy.Keys.All) {

        
      }
      

object TaintRemove {
  val Label = "TAINT_REMOVE"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, TaintRemove => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[TaintRemove] {
    override val forLabel = TaintRemove.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new TaintRemove(graph, outNode, inNode)
  }
}
      
      class TaintRemove(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, TaintRemove.Label, _outNode, _inNode, TaintRemove.Keys.All) {

        
      }
      

object Vtable {
  val Label = "VTABLE"
  object Keys {
    val All: JSet[String] = Set().asJava
    val KeyToValue: Map[String, Vtable => Any] = Map(
      
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, Keys.All)

  val Factory = new EdgeFactory[Vtable] {
    override val forLabel = Vtable.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new Vtable(graph, outNode, inNode)
  }
}
      
      class Vtable(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
          extends OdbEdge(_graph, Vtable.Label, _outNode, _inNode, Vtable.Keys.All) {

        
      }
      
