
      package io.shiftleft.codepropertygraph.generated.nodes

      import gremlin.scala._
      import io.shiftleft.codepropertygraph.generated.EdgeKeys
      import io.shiftleft.codepropertygraph.generated.edges
      import io.shiftleft.codepropertygraph.generated.edges._
      import java.lang.{Boolean => JBoolean, Long => JLong}
      import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
      import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
      import io.shiftleft.overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbNode, OdbGraph, OdbNodeProperty, NodeRef}
      import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
      import scala.collection.JavaConverters._
      import org.slf4j.LoggerFactory

      object PropertyErrorRegister {
        private var errorMap = Set[(Class[_], String)]()
        private val logger = LoggerFactory.getLogger(getClass)

        def logPropertyErrorIfFirst(clazz: Class[_], propertyName: String) {
          if (!errorMap.contains((clazz, propertyName))) {
            logger.warn("Property " + propertyName + " is deprecated for " + clazz.getName + ".")
            errorMap += ((clazz, propertyName))
          }
        }
      }

      trait Node extends Product {
        def label: String
        def getId: JLong

        def accept[T](visitor: NodeVisitor[T]): T = ???

        /** labels of product elements, used e.g. for pretty-printing */
        def productElementLabel(n: Int): String
      }

      /* a node that stored inside an OdbGraph (rather than e.g. DiffGraph) */
      trait StoredNode extends Vertex with Node {
        /* underlying vertex in the graph database. 
         * since this is a StoredNode, this is always set */
        def underlying: Vertex = this

        // Java does not seem to be capable of calling methods from java classes if a scala trait is in the inheritance
        // chain.
        override def getId: JLong = underlying.id.asInstanceOf[JLong]

        /* all properties plus label and id */
        def toMap: Map[String, Any] = {
          val map = valueMap
          map.put("_label", label)
          map.put("_id", getId)
          map.asScala.toMap
        }

        /* all properties */
        def valueMap: JMap[String, AnyRef]
def _aliasOfIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _astIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _attachedDataIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _bindsIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _bindsToIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _callIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _captureIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _capturedByIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _cdgIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _cfgIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _conditionIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _containsIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _containsNodeIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _dominateIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _dynamicTypeIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _evalTypeIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _inheritsFromIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _isSensitiveDataDescrOfIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _isSensitiveDataDescrOfRefIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _isSensitiveDataOfTypeIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _parameterLinkIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _postDominateIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _propagateIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _reachingDefIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _receiverIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _refIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _taggedByIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _taintRemoveIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _vtableIn(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _aliasOfOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _astOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _attachedDataOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _bindsOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _bindsToOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _callOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _captureOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _capturedByOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _cdgOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _cfgOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _conditionOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _containsOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _containsNodeOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _dominateOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _dynamicTypeOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _evalTypeOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _inheritsFromOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _isSensitiveDataDescrOfOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _isSensitiveDataDescrOfRefOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _isSensitiveDataOfTypeOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _parameterLinkOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _postDominateOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _propagateOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _reachingDefOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _receiverOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _refOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _taggedByOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _taintRemoveOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
def _vtableOut(): JIterator[StoredNode] = { JCollections.emptyIterator() }
      }

       
/* Using pattern matching would be prettier than the visitor pattern, but because the matches would 
 * contain type checks, scalac cannot compile them down to jvm `lookupswitch|tableswitch` instructions, 
 * which would make them slower. 
 * See https://github.com/ShiftLeftSecurity/codepropertygraph/pull/317 for more details. */
trait NodeVisitor[T] {
  def visit(node: Annotation): T = ???
def visit(node: AnnotationLiteral): T = ???
def visit(node: AnnotationParameter): T = ???
def visit(node: AnnotationParameterAssign): T = ???
def visit(node: ArrayInitializer): T = ???
def visit(node: Binding): T = ???
def visit(node: Block): T = ???
def visit(node: Call): T = ???
def visit(node: CallChain): T = ???
def visit(node: CallSite): T = ???
def visit(node: ClosureBinding): T = ???
def visit(node: Comment): T = ???
def visit(node: ConfigFile): T = ???
def visit(node: ControlStructure): T = ???
def visit(node: Dependency): T = ???
def visit(node: DetachedTrackingPoint): T = ???
def visit(node: DomAttribute): T = ???
def visit(node: DomNode): T = ???
def visit(node: File): T = ???
def visit(node: Finding): T = ???
def visit(node: Flow): T = ???
def visit(node: Framework): T = ???
def visit(node: FrameworkData): T = ???
def visit(node: Identifier): T = ???
def visit(node: ImplicitCall): T = ???
def visit(node: Ioflow): T = ???
def visit(node: Literal): T = ???
def visit(node: Local): T = ???
def visit(node: Location): T = ???
def visit(node: MatchInfo): T = ???
def visit(node: Member): T = ???
def visit(node: MetaData): T = ???
def visit(node: Method): T = ???
def visit(node: MethodInst): T = ???
def visit(node: MethodParameterIn): T = ???
def visit(node: MethodParameterOut): T = ???
def visit(node: MethodRef): T = ???
def visit(node: MethodReturn): T = ???
def visit(node: MethodSummary): T = ???
def visit(node: Modifier): T = ???
def visit(node: Namespace): T = ???
def visit(node: NamespaceBlock): T = ???
def visit(node: ProgramPoint): T = ???
def visit(node: Read): T = ???
def visit(node: Return): T = ???
def visit(node: Route): T = ???
def visit(node: SensitiveDataType): T = ???
def visit(node: SensitiveMember): T = ???
def visit(node: SensitiveReference): T = ???
def visit(node: SensitiveVariable): T = ???
def visit(node: Sink): T = ???
def visit(node: Source): T = ???
def visit(node: SpAnnotationParameter): T = ???
def visit(node: SpBlacklist): T = ???
def visit(node: Tag): T = ???
def visit(node: Tags): T = ???
def visit(node: TagNodePair): T = ???
def visit(node: Transform): T = ???
def visit(node: Transformation): T = ???
def visit(node: Type): T = ???
def visit(node: TypeArgument): T = ???
def visit(node: TypeDecl): T = ???
def visit(node: TypeParameter): T = ???
def visit(node: Unknown): T = ???
def visit(node: VariableInfo): T = ???
def visit(node: Write): T = ???
def visit(node: PackagePrefix): T = ???
  def visit(node: Declaration): T = ???
def visit(node: Expression): T = ???
def visit(node: LocalLike): T = ???
def visit(node: CfgNode): T = ???
def visit(node: TrackingPoint): T = ???
def visit(node: WithinMethod): T = ???
def visit(node: AstNode): T = ???
def visit(node: CallRepr): T = ???
}
trait DeclarationBase extends Node with HasName 
            trait Declaration extends StoredNode with DeclarationBase 
        
trait ExpressionBase extends Node with HasCode with HasOrder with TrackingPointBase with CfgNodeBase with AstNodeBase
            trait Expression extends StoredNode with ExpressionBase with TrackingPoint with CfgNode with AstNode
        
trait LocalLikeBase extends Node with HasName 
            trait LocalLike extends StoredNode with LocalLikeBase 
        
trait CfgNodeBase extends Node with HasLineNumber with HasColumnNumber with WithinMethodBase with AstNodeBase
            trait CfgNode extends StoredNode with CfgNodeBase with WithinMethod with AstNode
        
trait TrackingPointBase extends Node  with WithinMethodBase
            trait TrackingPoint extends StoredNode with TrackingPointBase with WithinMethod
        
trait WithinMethodBase extends Node  
            trait WithinMethod extends StoredNode with WithinMethodBase 
        
trait AstNodeBase extends Node with HasOrder 
            trait AstNode extends StoredNode with AstNodeBase 
        
trait CallReprBase extends Node with HasCode with HasName with HasSignature with CfgNodeBase
            trait CallRepr extends StoredNode with CallReprBase with CfgNode
        trait HasAliasTypeFullName { def aliasTypeFullName: Option[String] }
trait HasAnnotationFullName { def annotationFullName: String }
trait HasAnnotationName { def annotationName: String }
trait HasArgumentIndex { def argumentIndex: Integer }
trait HasAstParentFullName { def astParentFullName: String }
trait HasAstParentType { def astParentType: String }
trait HasBinarySignature { def binarySignature: Option[String] }
trait HasCategory { def category: String }
trait HasClassName { def className: String }
trait HasClosureBindingId { def closureBindingId: Option[String] }
trait HasClosureOriginalName { def closureOriginalName: Option[String] }
trait HasCode { def code: String }
trait HasColumnNumber { def columnNumber: Option[Integer] }
trait HasColumnNumberEnd { def columnNumberEnd: Option[Integer] }
trait HasContent { def content: String }
trait HasCweLink { def cweLink: String }
trait HasDependencyGroupId { def dependencyGroupId: Option[String] }
trait HasDepthFirstOrder { def depthFirstOrder: Option[Integer] }
trait HasDescription { def description: String }
trait HasDispatchType { def dispatchType: String }
trait HasDynamicTypeHintFullName { def dynamicTypeHintFullName: List[String] }
trait HasEvaluationStrategy { def evaluationStrategy: String }
trait HasEvaluationType { def evaluationType: String }
trait HasFilename { def filename: String }
trait HasFingerprint { def fingerprint: String }
trait HasFullName { def fullName: String }
trait HasHasMapping { def hasMapping: Option[JBoolean] }
trait HasInheritsFromTypeFullName { def inheritsFromTypeFullName: List[String] }
trait HasIsExternal { def isExternal: JBoolean }
trait HasIsStatic { def isStatic: JBoolean }
trait HasLanguage { def language: String }
trait HasLineNo { def lineNo: String }
trait HasLineNumber { def lineNumber: Option[Integer] }
trait HasLineNumberEnd { def lineNumberEnd: Option[Integer] }
trait HasLink { def link: String }
trait HasLiteralsToSink { def literalsToSink: List[String] }
trait HasMethodFullName { def methodFullName: String }
trait HasMethodInstFullName { def methodInstFullName: Option[String] }
trait HasMethodName { def methodName: String }
trait HasMethodShortName { def methodShortName: String }
trait HasModifierType { def modifierType: String }
trait HasName { def name: String }
trait HasNodeId { def nodeId: String }
trait HasNodeLabel { def nodeLabel: String }
trait HasOrder { def order: Integer }
trait HasOwaspLink { def owaspLink: String }
trait HasPackageName { def packageName: String }
trait HasParameter { def parameter: String }
trait HasParameterIndex { def parameterIndex: Option[Integer] }
trait HasParserTypeName { def parserTypeName: String }
trait HasPath { def path: String }
trait HasPattern { def pattern: String }
trait HasResolved { def resolved: Option[JBoolean] }
trait HasScore { def score: Integer }
trait HasSignature { def signature: String }
trait HasSinkType { def sinkType: String }
trait HasSourceType { def sourceType: String }
trait HasSpid { def spid: Option[String] }
trait HasSymbol { def symbol: String }
trait HasTitle { def title: String }
trait HasTypeDeclFullName { def typeDeclFullName: String }
trait HasTypeFullName { def typeFullName: String }
trait HasValue { def value: String }
trait HasVarType { def varType: String }
trait HasVersion { def version: String }
trait HasVulnDescr { def vulnDescr: String }
        object Factories {
          lazy val All: List[NodeFactory[_]] = List(Annotation.Factory, AnnotationLiteral.Factory, AnnotationParameter.Factory, AnnotationParameterAssign.Factory, ArrayInitializer.Factory, Binding.Factory, Block.Factory, Call.Factory, CallChain.Factory, CallSite.Factory, ClosureBinding.Factory, Comment.Factory, ConfigFile.Factory, ControlStructure.Factory, Dependency.Factory, DetachedTrackingPoint.Factory, DomAttribute.Factory, DomNode.Factory, File.Factory, Finding.Factory, Flow.Factory, Framework.Factory, FrameworkData.Factory, Identifier.Factory, ImplicitCall.Factory, Ioflow.Factory, Literal.Factory, Local.Factory, Location.Factory, MatchInfo.Factory, Member.Factory, MetaData.Factory, Method.Factory, MethodInst.Factory, MethodParameterIn.Factory, MethodParameterOut.Factory, MethodRef.Factory, MethodReturn.Factory, MethodSummary.Factory, Modifier.Factory, Namespace.Factory, NamespaceBlock.Factory, ProgramPoint.Factory, Read.Factory, Return.Factory, Route.Factory, SensitiveDataType.Factory, SensitiveMember.Factory, SensitiveReference.Factory, SensitiveVariable.Factory, Sink.Factory, Source.Factory, SpAnnotationParameter.Factory, SpBlacklist.Factory, Tag.Factory, Tags.Factory, TagNodePair.Factory, Transform.Factory, Transformation.Factory, Type.Factory, TypeArgument.Factory, TypeDecl.Factory, TypeParameter.Factory, Unknown.Factory, VariableInfo.Factory, Write.Factory, PackagePrefix.Factory)
          lazy val AllAsJava: java.util.List[NodeFactory[_]] = All.asJava
        }
        

//ANNOTATION BEGIN

      object Annotation {

        def apply(graph: OdbGraph, id: Long) = new Annotation(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation, edges.Ast.layoutInformation).asJava)

        val Label = "ANNOTATION"
        object Keys {
          val Code = "CODE" 
val Name = "NAME" 
val FullName = "FULL_NAME" 
val Order = "ORDER" 
          val All: JSet[String] = Set(Code, Name, FullName, Order).asJava
            val KeyToValue: Map[String, AnnotationDb => Any] = Map(
               "CODE" -> { instance: AnnotationDb => instance.code},
 "NAME" -> { instance: AnnotationDb => instance.name},
 "FULL_NAME" -> { instance: AnnotationDb => instance.fullName},
 "ORDER" -> { instance: AnnotationDb => instance.order}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE","AST")
          val Out: Array[String] = Array("AST","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[AnnotationDb] {
          override val forLabel = Annotation.Label

          override def createNode(ref: NodeRef[AnnotationDb]) =
            new AnnotationDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Annotation(graph, id)
        }
      }
      
trait AnnotationBase extends Node with AstNodeBase with HasCode with HasName with HasFullName with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "code" 
case 2 => "name" 
case 3 => "fullName" 
case 4 => "order" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => code
case 2 => name
case 3 => fullName
case 4 => order
      }

  override def productPrefix = "Annotation"
  override def productArity = 4 + 1 // add one for id, leaving out `_graph`
  
}
class Annotation(graph: OdbGraph, id: Long) extends NodeRef[AnnotationDb](graph, id) with AnnotationBase with StoredNode with AstNode {
override def code = get().code
override def name = get().name
override def fullName = get().fullName
override def order = get().order

override def _astOut(): JIterator[StoredNode] = get()._astOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Annotation.Label
  }
}
      class AnnotationDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with AstNode with AnnotationBase {

        override def layoutInformation: NodeLayoutInformation = Annotation.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (name != null) { properties.put("NAME", name) }
if (fullName != null) { properties.put("FULL_NAME", fullName) }
if (order != null) { properties.put("ORDER", order) }
  properties
}

        private var _code: String = null
def code(): String = _code

private var _name: String = null
def name(): String = _name

private var _fullName: String = null
def fullName(): String = _fullName

private var _order: Integer = null
def order(): Integer = _order
override def _astOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Annotation.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[AnnotationDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Annotation.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Annotation.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "FULL_NAME") this._fullName = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "CODE") this._code = null 
 else  if (key == "NAME") this._name = null 
 else  if (key == "FULL_NAME") this._fullName = null 
 else  if (key == "ORDER") this._order = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//ANNOTATION END


//ANNOTATION_LITERAL BEGIN

      object AnnotationLiteral {

        def apply(graph: OdbGraph, id: Long) = new AnnotationLiteral(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation, edges.Ast.layoutInformation).asJava)

        val Label = "ANNOTATION_LITERAL"
        object Keys {
          val Code = "CODE" 
val Name = "NAME" 
val Order = "ORDER" 
val ColumnNumber = "COLUMN_NUMBER" 
val LineNumber = "LINE_NUMBER" 
          val All: JSet[String] = Set(Code, Name, Order, ColumnNumber, LineNumber).asJava
            val KeyToValue: Map[String, AnnotationLiteralDb => Any] = Map(
               "CODE" -> { instance: AnnotationLiteralDb => instance.code},
 "NAME" -> { instance: AnnotationLiteralDb => instance.name},
 "ORDER" -> { instance: AnnotationLiteralDb => instance.order},
 "COLUMN_NUMBER" -> { instance: AnnotationLiteralDb => instance.columnNumber.orNull},
 "LINE_NUMBER" -> { instance: AnnotationLiteralDb => instance.lineNumber.orNull}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE","AST")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[AnnotationLiteralDb] {
          override val forLabel = AnnotationLiteral.Label

          override def createNode(ref: NodeRef[AnnotationLiteralDb]) =
            new AnnotationLiteralDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = AnnotationLiteral(graph, id)
        }
      }
      
trait AnnotationLiteralBase extends Node with ExpressionBase with HasCode with HasName with HasOrder with HasColumnNumber with HasLineNumber {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "code" 
case 2 => "name" 
case 3 => "order" 
case 4 => "columnNumber" 
case 5 => "lineNumber" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => code
case 2 => name
case 3 => order
case 4 => columnNumber
case 5 => lineNumber
      }

  override def productPrefix = "AnnotationLiteral"
  override def productArity = 5 + 1 // add one for id, leaving out `_graph`
  
}
class AnnotationLiteral(graph: OdbGraph, id: Long) extends NodeRef[AnnotationLiteralDb](graph, id) with AnnotationLiteralBase with StoredNode with Expression {
override def code = get().code
override def name = get().name
override def order = get().order
override def columnNumber = get().columnNumber
override def lineNumber = get().lineNumber

override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    AnnotationLiteral.Label
  }
}
      class AnnotationLiteralDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with Expression with AnnotationLiteralBase {

        override def layoutInformation: NodeLayoutInformation = AnnotationLiteral.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (name != null) { properties.put("NAME", name) }
if (order != null) { properties.put("ORDER", order) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
  properties
}

        private var _code: String = null
def code(): String = _code

private var _name: String = null
def name(): String = _name

private var _order: Integer = null
def order(): Integer = _order

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          AnnotationLiteral.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[AnnotationLiteralDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          AnnotationLiteral.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          AnnotationLiteral.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "CODE") this._code = null 
 else  if (key == "NAME") this._name = null 
 else  if (key == "ORDER") this._order = null 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = null 
 else  if (key == "LINE_NUMBER") this._lineNumber = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//ANNOTATION_LITERAL END


//ANNOTATION_PARAMETER BEGIN

      object AnnotationParameter {

        def apply(graph: OdbGraph, id: Long) = new AnnotationParameter(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation, edges.Ast.layoutInformation).asJava)

        val Label = "ANNOTATION_PARAMETER"
        object Keys {
          val Code = "CODE" 
val Order = "ORDER" 
          val All: JSet[String] = Set(Code, Order).asJava
            val KeyToValue: Map[String, AnnotationParameterDb => Any] = Map(
               "CODE" -> { instance: AnnotationParameterDb => instance.code},
 "ORDER" -> { instance: AnnotationParameterDb => instance.order}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE","AST")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[AnnotationParameterDb] {
          override val forLabel = AnnotationParameter.Label

          override def createNode(ref: NodeRef[AnnotationParameterDb]) =
            new AnnotationParameterDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = AnnotationParameter(graph, id)
        }
      }
      
trait AnnotationParameterBase extends Node with AstNodeBase with HasCode with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "code" 
case 2 => "order" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => code
case 2 => order
      }

  override def productPrefix = "AnnotationParameter"
  override def productArity = 2 + 1 // add one for id, leaving out `_graph`
  
}
class AnnotationParameter(graph: OdbGraph, id: Long) extends NodeRef[AnnotationParameterDb](graph, id) with AnnotationParameterBase with StoredNode with AstNode {
override def code = get().code
override def order = get().order

override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    AnnotationParameter.Label
  }
}
      class AnnotationParameterDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with AstNode with AnnotationParameterBase {

        override def layoutInformation: NodeLayoutInformation = AnnotationParameter.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (order != null) { properties.put("ORDER", order) }
  properties
}

        private var _code: String = null
def code(): String = _code

private var _order: Integer = null
def order(): Integer = _order
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          AnnotationParameter.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[AnnotationParameterDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          AnnotationParameter.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          AnnotationParameter.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "CODE") this._code = null 
 else  if (key == "ORDER") this._order = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//ANNOTATION_PARAMETER END


//ANNOTATION_PARAMETER_ASSIGN BEGIN

      object AnnotationParameterAssign {

        def apply(graph: OdbGraph, id: Long) = new AnnotationParameterAssign(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation, edges.Ast.layoutInformation).asJava)

        val Label = "ANNOTATION_PARAMETER_ASSIGN"
        object Keys {
          val Code = "CODE" 
val Order = "ORDER" 
          val All: JSet[String] = Set(Code, Order).asJava
            val KeyToValue: Map[String, AnnotationParameterAssignDb => Any] = Map(
               "CODE" -> { instance: AnnotationParameterAssignDb => instance.code},
 "ORDER" -> { instance: AnnotationParameterAssignDb => instance.order}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE","AST")
          val Out: Array[String] = Array("AST","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[AnnotationParameterAssignDb] {
          override val forLabel = AnnotationParameterAssign.Label

          override def createNode(ref: NodeRef[AnnotationParameterAssignDb]) =
            new AnnotationParameterAssignDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = AnnotationParameterAssign(graph, id)
        }
      }
      
trait AnnotationParameterAssignBase extends Node with AstNodeBase with HasCode with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "code" 
case 2 => "order" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => code
case 2 => order
      }

  override def productPrefix = "AnnotationParameterAssign"
  override def productArity = 2 + 1 // add one for id, leaving out `_graph`
  
}
class AnnotationParameterAssign(graph: OdbGraph, id: Long) extends NodeRef[AnnotationParameterAssignDb](graph, id) with AnnotationParameterAssignBase with StoredNode with AstNode {
override def code = get().code
override def order = get().order

override def _astOut(): JIterator[StoredNode] = get()._astOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    AnnotationParameterAssign.Label
  }
}
      class AnnotationParameterAssignDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with AstNode with AnnotationParameterAssignBase {

        override def layoutInformation: NodeLayoutInformation = AnnotationParameterAssign.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (order != null) { properties.put("ORDER", order) }
  properties
}

        private var _code: String = null
def code(): String = _code

private var _order: Integer = null
def order(): Integer = _order
override def _astOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          AnnotationParameterAssign.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[AnnotationParameterAssignDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          AnnotationParameterAssign.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          AnnotationParameterAssign.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "CODE") this._code = null 
 else  if (key == "ORDER") this._order = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//ANNOTATION_PARAMETER_ASSIGN END


//ARRAY_INITIALIZER BEGIN

      object ArrayInitializer {

        def apply(graph: OdbGraph, id: Long) = new ArrayInitializer(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Ast.layoutInformation, edges.EvalType.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation, edges.Ast.layoutInformation, edges.Condition.layoutInformation).asJava)

        val Label = "ARRAY_INITIALIZER"
        object Keys {
          val Code = "CODE" 
val ColumnNumber = "COLUMN_NUMBER" 
val LineNumber = "LINE_NUMBER" 
val Order = "ORDER" 
          val All: JSet[String] = Set(Code, ColumnNumber, LineNumber, Order).asJava
            val KeyToValue: Map[String, ArrayInitializerDb => Any] = Map(
               "CODE" -> { instance: ArrayInitializerDb => instance.code},
 "COLUMN_NUMBER" -> { instance: ArrayInitializerDb => instance.columnNumber.orNull},
 "LINE_NUMBER" -> { instance: ArrayInitializerDb => instance.lineNumber.orNull},
 "ORDER" -> { instance: ArrayInitializerDb => instance.order}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE","AST","CONDITION")
          val Out: Array[String] = Array("AST","EVAL_TYPE","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[ArrayInitializerDb] {
          override val forLabel = ArrayInitializer.Label

          override def createNode(ref: NodeRef[ArrayInitializerDb]) =
            new ArrayInitializerDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = ArrayInitializer(graph, id)
        }
      }
      
trait ArrayInitializerBase extends Node with AstNodeBase with ExpressionBase with HasCode with HasColumnNumber with HasLineNumber with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "code" 
case 2 => "columnNumber" 
case 3 => "lineNumber" 
case 4 => "order" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => code
case 2 => columnNumber
case 3 => lineNumber
case 4 => order
      }

  override def productPrefix = "ArrayInitializer"
  override def productArity = 4 + 1 // add one for id, leaving out `_graph`
  
}
class ArrayInitializer(graph: OdbGraph, id: Long) extends NodeRef[ArrayInitializerDb](graph, id) with ArrayInitializerBase with StoredNode with AstNode with Expression {
override def code = get().code
override def columnNumber = get().columnNumber
override def lineNumber = get().lineNumber
override def order = get().order

override def _astOut(): JIterator[StoredNode] = get()._astOut()
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
override def _conditionIn(): JIterator[StoredNode] = get()._conditionIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    ArrayInitializer.Label
  }
}
      class ArrayInitializerDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with AstNode with Expression with ArrayInitializerBase {

        override def layoutInformation: NodeLayoutInformation = ArrayInitializer.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
if (order != null) { properties.put("ORDER", order) }
  properties
}

        private var _code: String = null
def code(): String = _code

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _order: Integer = null
def order(): Integer = _order
override def _astOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _evalTypeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _conditionIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          ArrayInitializer.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ArrayInitializerDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          ArrayInitializer.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          ArrayInitializer.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "CODE") this._code = null 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = null 
 else  if (key == "LINE_NUMBER") this._lineNumber = null 
 else  if (key == "ORDER") this._order = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//ARRAY_INITIALIZER END


//BINDING BEGIN

      object Binding {

        def apply(graph: OdbGraph, id: Long) = new Binding(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Ref.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.Binds.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

        val Label = "BINDING"
        object Keys {
          val Name = "NAME" 
val Signature = "SIGNATURE" 
          val All: JSet[String] = Set(Name, Signature).asJava
            val KeyToValue: Map[String, BindingDb => Any] = Map(
               "NAME" -> { instance: BindingDb => instance.name},
 "SIGNATURE" -> { instance: BindingDb => instance.signature}
            )
          }
        object Edges {
          val In: Array[String] = Array("BINDS","CONTAINS_NODE")
          val Out: Array[String] = Array("REF","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[BindingDb] {
          override val forLabel = Binding.Label

          override def createNode(ref: NodeRef[BindingDb]) =
            new BindingDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Binding(graph, id)
        }
      }
      
trait BindingBase extends Node  with HasName with HasSignature {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "name" 
case 2 => "signature" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => name
case 2 => signature
      }

  override def productPrefix = "Binding"
  override def productArity = 2 + 1 // add one for id, leaving out `_graph`
  
}
class Binding(graph: OdbGraph, id: Long) extends NodeRef[BindingDb](graph, id) with BindingBase with StoredNode  {
override def name = get().name
override def signature = get().signature

override def _refOut(): JIterator[StoredNode] = get()._refOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _bindsIn(): JIterator[StoredNode] = get()._bindsIn()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Binding.Label
  }
}
      class BindingDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with BindingBase {

        override def layoutInformation: NodeLayoutInformation = Binding.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
if (signature != null) { properties.put("SIGNATURE", signature) }
  properties
}

        private var _name: String = null
def name(): String = _name

private var _signature: String = null
def signature(): String = _signature
override def _refOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _bindsIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Binding.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[BindingDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Binding.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Binding.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "SIGNATURE") this._signature = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "NAME") this._name = null 
 else  if (key == "SIGNATURE") this._signature = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//BINDING END


//BLOCK BEGIN

      object Block {

        def apply(graph: OdbGraph, id: Long) = new Block(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Ast.layoutInformation, edges.Cfg.layoutInformation, edges.DynamicType.layoutInformation, edges.Dominate.layoutInformation, edges.PostDominate.layoutInformation, edges.Cdg.layoutInformation, edges.EvalType.layoutInformation, edges.ReachingDef.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.Receiver.layoutInformation, edges.Cdg.layoutInformation, edges.ReachingDef.layoutInformation, edges.ContainsNode.layoutInformation, edges.Contains.layoutInformation, edges.Cfg.layoutInformation, edges.Ast.layoutInformation, edges.Dominate.layoutInformation, edges.PostDominate.layoutInformation, edges.Condition.layoutInformation).asJava)

        val Label = "BLOCK"
        object Keys {
          val Code = "CODE" 
val Order = "ORDER" 
val ArgumentIndex = "ARGUMENT_INDEX" 
val TypeFullName = "TYPE_FULL_NAME" 
val DynamicTypeHintFullName = "DYNAMIC_TYPE_HINT_FULL_NAME" 
val LineNumber = "LINE_NUMBER" 
val ColumnNumber = "COLUMN_NUMBER" 
val DepthFirstOrder = "DEPTH_FIRST_ORDER" 
          val All: JSet[String] = Set(Code, Order, ArgumentIndex, TypeFullName, DynamicTypeHintFullName, LineNumber, ColumnNumber, DepthFirstOrder).asJava
            val KeyToValue: Map[String, BlockDb => Any] = Map(
               "CODE" -> { instance: BlockDb => instance.code},
 "ORDER" -> { instance: BlockDb => instance.order},
 "ARGUMENT_INDEX" -> { instance: BlockDb => instance.argumentIndex},
 "TYPE_FULL_NAME" -> { instance: BlockDb => instance.typeFullName},
 "DYNAMIC_TYPE_HINT_FULL_NAME" -> { instance: BlockDb => instance.dynamicTypeHintFullName},
 "LINE_NUMBER" -> { instance: BlockDb => instance.lineNumber.orNull},
 "COLUMN_NUMBER" -> { instance: BlockDb => instance.columnNumber.orNull},
 "DEPTH_FIRST_ORDER" -> { instance: BlockDb => instance.depthFirstOrder.orNull}
            )
          }
        object Edges {
          val In: Array[String] = Array("RECEIVER","CDG","REACHING_DEF","CONTAINS_NODE","CONTAINS","CFG","AST","DOMINATE","POST_DOMINATE","CONDITION")
          val Out: Array[String] = Array("AST","CFG","DYNAMIC_TYPE","DOMINATE","POST_DOMINATE","CDG","EVAL_TYPE","REACHING_DEF","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[BlockDb] {
          override val forLabel = Block.Label

          override def createNode(ref: NodeRef[BlockDb]) =
            new BlockDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Block(graph, id)
        }
      }
      
trait BlockBase extends Node with ExpressionBase with HasCode with HasOrder with HasArgumentIndex with HasTypeFullName with HasDynamicTypeHintFullName with HasLineNumber with HasColumnNumber with HasDepthFirstOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "code" 
case 2 => "order" 
case 3 => "argumentIndex" 
case 4 => "typeFullName" 
case 5 => "dynamicTypeHintFullName" 
case 6 => "lineNumber" 
case 7 => "columnNumber" 
case 8 => "depthFirstOrder" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => code
case 2 => order
case 3 => argumentIndex
case 4 => typeFullName
case 5 => dynamicTypeHintFullName
case 6 => lineNumber
case 7 => columnNumber
case 8 => depthFirstOrder
      }

  override def productPrefix = "Block"
  override def productArity = 8 + 1 // add one for id, leaving out `_graph`
  
}
class Block(graph: OdbGraph, id: Long) extends NodeRef[BlockDb](graph, id) with BlockBase with StoredNode with Expression {
override def code = get().code
override def order = get().order
override def argumentIndex = get().argumentIndex
override def typeFullName = get().typeFullName
override def dynamicTypeHintFullName = get().dynamicTypeHintFullName
override def lineNumber = get().lineNumber
override def columnNumber = get().columnNumber
override def depthFirstOrder = get().depthFirstOrder

override def _astOut(): JIterator[StoredNode] = get()._astOut()
override def _cfgOut(): JIterator[StoredNode] = get()._cfgOut()
override def _dynamicTypeOut(): JIterator[StoredNode] = get()._dynamicTypeOut()
override def _dominateOut(): JIterator[StoredNode] = get()._dominateOut()
override def _postDominateOut(): JIterator[StoredNode] = get()._postDominateOut()
override def _cdgOut(): JIterator[StoredNode] = get()._cdgOut()
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut()
override def _reachingDefOut(): JIterator[StoredNode] = get()._reachingDefOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _receiverIn(): JIterator[StoredNode] = get()._receiverIn()
override def _cdgIn(): JIterator[StoredNode] = get()._cdgIn()
override def _reachingDefIn(): JIterator[StoredNode] = get()._reachingDefIn()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _containsIn(): JIterator[StoredNode] = get()._containsIn()
override def _cfgIn(): JIterator[StoredNode] = get()._cfgIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
override def _dominateIn(): JIterator[StoredNode] = get()._dominateIn()
override def _postDominateIn(): JIterator[StoredNode] = get()._postDominateIn()
override def _conditionIn(): JIterator[StoredNode] = get()._conditionIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Block.Label
  }
}
      class BlockDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with Expression with BlockBase {

        override def layoutInformation: NodeLayoutInformation = Block.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (order != null) { properties.put("ORDER", order) }
if (argumentIndex != null) { properties.put("ARGUMENT_INDEX", argumentIndex) }
if (typeFullName != null) { properties.put("TYPE_FULL_NAME", typeFullName) }
if (dynamicTypeHintFullName.nonEmpty) { properties.put("DYNAMIC_TYPE_HINT_FULL_NAME", dynamicTypeHintFullName.asJava) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
  properties
}

        private var _code: String = null
def code(): String = _code

private var _order: Integer = null
def order(): Integer = _order

private var _argumentIndex: Integer = null
def argumentIndex(): Integer = _argumentIndex

private var _typeFullName: String = null
def typeFullName(): String = _typeFullName

private var _dynamicTypeHintFullName: List[String] = Nil
def dynamicTypeHintFullName(): List[String] = _dynamicTypeHintFullName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder
override def _astOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _cfgOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _dynamicTypeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _dominateOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _postDominateOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _cdgOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
override def _evalTypeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
override def _reachingDefOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
override def _receiverIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]
override def _cdgIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(10).asInstanceOf[JIterator[StoredNode]]
override def _reachingDefIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(11).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(12).asInstanceOf[JIterator[StoredNode]]
override def _containsIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(13).asInstanceOf[JIterator[StoredNode]]
override def _cfgIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(14).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(15).asInstanceOf[JIterator[StoredNode]]
override def _dominateIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(16).asInstanceOf[JIterator[StoredNode]]
override def _postDominateIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(17).asInstanceOf[JIterator[StoredNode]]
override def _conditionIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(18).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Block.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[BlockDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Block.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Block.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else  if (key == "ARGUMENT_INDEX") this._argumentIndex = value.asInstanceOf[Integer] 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = value.asInstanceOf[String] 
 else if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") {
                    if (cardinality == VertexProperty.Cardinality.list) {
                      if (this._dynamicTypeHintFullName == null) { this._dynamicTypeHintFullName = Nil }
                      this._dynamicTypeHintFullName = this._dynamicTypeHintFullName :+ value.asInstanceOf[String]
                    } else {
                      this._dynamicTypeHintFullName = List(value.asInstanceOf[String])
                    }
                  }
              
 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = Option(value).asInstanceOf[Option[Integer]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "CODE") this._code = null 
 else  if (key == "ORDER") this._order = null 
 else  if (key == "ARGUMENT_INDEX") this._argumentIndex = null 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = null 
 else  if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") this._dynamicTypeHintFullName = null 
 else  if (key == "LINE_NUMBER") this._lineNumber = null 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = null 
 else  if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//BLOCK END


//CALL BEGIN

      object Call {

        def apply(graph: OdbGraph, id: Long) = new Call(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Cfg.layoutInformation, edges.Ast.layoutInformation, edges.Receiver.layoutInformation, edges.TaggedBy.layoutInformation, edges.DynamicType.layoutInformation, edges.Dominate.layoutInformation, edges.PostDominate.layoutInformation, edges.Cdg.layoutInformation, edges.Ref.layoutInformation, edges.Call.layoutInformation, edges.EvalType.layoutInformation, edges.ReachingDef.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.Receiver.layoutInformation, edges.Cdg.layoutInformation, edges.ReachingDef.layoutInformation, edges.ContainsNode.layoutInformation, edges.Contains.layoutInformation, edges.Cfg.layoutInformation, edges.Ast.layoutInformation, edges.Dominate.layoutInformation, edges.PostDominate.layoutInformation, edges.Condition.layoutInformation).asJava)

        val Label = "CALL"
        object Keys {
          val Code = "CODE" 
val Name = "NAME" 
val Order = "ORDER" 
val MethodInstFullName = "METHOD_INST_FULL_NAME" 
val MethodFullName = "METHOD_FULL_NAME" 
val ArgumentIndex = "ARGUMENT_INDEX" 
val DispatchType = "DISPATCH_TYPE" 
val Signature = "SIGNATURE" 
val TypeFullName = "TYPE_FULL_NAME" 
val DynamicTypeHintFullName = "DYNAMIC_TYPE_HINT_FULL_NAME" 
val LineNumber = "LINE_NUMBER" 
val ColumnNumber = "COLUMN_NUMBER" 
val Resolved = "RESOLVED" 
val DepthFirstOrder = "DEPTH_FIRST_ORDER" 
          val All: JSet[String] = Set(Code, Name, Order, MethodInstFullName, MethodFullName, ArgumentIndex, DispatchType, Signature, TypeFullName, DynamicTypeHintFullName, LineNumber, ColumnNumber, Resolved, DepthFirstOrder).asJava
            val KeyToValue: Map[String, CallDb => Any] = Map(
               "CODE" -> { instance: CallDb => instance.code},
 "NAME" -> { instance: CallDb => instance.name},
 "ORDER" -> { instance: CallDb => instance.order},
 "METHOD_INST_FULL_NAME" -> { instance: CallDb => instance.methodInstFullName.orNull},
 "METHOD_FULL_NAME" -> { instance: CallDb => instance.methodFullName},
 "ARGUMENT_INDEX" -> { instance: CallDb => instance.argumentIndex},
 "DISPATCH_TYPE" -> { instance: CallDb => instance.dispatchType},
 "SIGNATURE" -> { instance: CallDb => instance.signature},
 "TYPE_FULL_NAME" -> { instance: CallDb => instance.typeFullName},
 "DYNAMIC_TYPE_HINT_FULL_NAME" -> { instance: CallDb => instance.dynamicTypeHintFullName},
 "LINE_NUMBER" -> { instance: CallDb => instance.lineNumber.orNull},
 "COLUMN_NUMBER" -> { instance: CallDb => instance.columnNumber.orNull},
 "RESOLVED" -> { instance: CallDb => instance.resolved.orNull},
 "DEPTH_FIRST_ORDER" -> { instance: CallDb => instance.depthFirstOrder.orNull}
            )
          }
        object Edges {
          val In: Array[String] = Array("RECEIVER","CDG","REACHING_DEF","CONTAINS_NODE","CONTAINS","CFG","AST","DOMINATE","POST_DOMINATE","CONDITION")
          val Out: Array[String] = Array("CFG","AST","RECEIVER","TAGGED_BY","DYNAMIC_TYPE","DOMINATE","POST_DOMINATE","CDG","REF","CALL","EVAL_TYPE","REACHING_DEF","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[CallDb] {
          override val forLabel = Call.Label

          override def createNode(ref: NodeRef[CallDb]) =
            new CallDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Call(graph, id)
        }
      }
      
trait CallBase extends Node with ExpressionBase with CallReprBase with HasCode with HasName with HasOrder with HasMethodInstFullName with HasMethodFullName with HasArgumentIndex with HasDispatchType with HasSignature with HasTypeFullName with HasDynamicTypeHintFullName with HasLineNumber with HasColumnNumber with HasResolved with HasDepthFirstOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "code" 
case 2 => "name" 
case 3 => "order" 
case 4 => "methodInstFullName" 
case 5 => "methodFullName" 
case 6 => "argumentIndex" 
case 7 => "dispatchType" 
case 8 => "signature" 
case 9 => "typeFullName" 
case 10 => "dynamicTypeHintFullName" 
case 11 => "lineNumber" 
case 12 => "columnNumber" 
case 13 => "resolved" 
case 14 => "depthFirstOrder" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => code
case 2 => name
case 3 => order
case 4 => methodInstFullName
case 5 => methodFullName
case 6 => argumentIndex
case 7 => dispatchType
case 8 => signature
case 9 => typeFullName
case 10 => dynamicTypeHintFullName
case 11 => lineNumber
case 12 => columnNumber
case 13 => resolved
case 14 => depthFirstOrder
      }

  override def productPrefix = "Call"
  override def productArity = 14 + 1 // add one for id, leaving out `_graph`
  
}
class Call(graph: OdbGraph, id: Long) extends NodeRef[CallDb](graph, id) with CallBase with StoredNode with Expression with CallRepr {
override def code = get().code
override def name = get().name
override def order = get().order
override def methodInstFullName = get().methodInstFullName
override def methodFullName = get().methodFullName
override def argumentIndex = get().argumentIndex
override def dispatchType = get().dispatchType
override def signature = get().signature
override def typeFullName = get().typeFullName
override def dynamicTypeHintFullName = get().dynamicTypeHintFullName
override def lineNumber = get().lineNumber
override def columnNumber = get().columnNumber
override def resolved = get().resolved
override def depthFirstOrder = get().depthFirstOrder

override def _cfgOut(): JIterator[StoredNode] = get()._cfgOut()
override def _astOut(): JIterator[StoredNode] = get()._astOut()
override def _receiverOut(): JIterator[StoredNode] = get()._receiverOut()
override def _taggedByOut(): JIterator[StoredNode] = get()._taggedByOut()
override def _dynamicTypeOut(): JIterator[StoredNode] = get()._dynamicTypeOut()
override def _dominateOut(): JIterator[StoredNode] = get()._dominateOut()
override def _postDominateOut(): JIterator[StoredNode] = get()._postDominateOut()
override def _cdgOut(): JIterator[StoredNode] = get()._cdgOut()
override def _refOut(): JIterator[StoredNode] = get()._refOut()
override def _callOut(): JIterator[StoredNode] = get()._callOut()
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut()
override def _reachingDefOut(): JIterator[StoredNode] = get()._reachingDefOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _receiverIn(): JIterator[StoredNode] = get()._receiverIn()
override def _cdgIn(): JIterator[StoredNode] = get()._cdgIn()
override def _reachingDefIn(): JIterator[StoredNode] = get()._reachingDefIn()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _containsIn(): JIterator[StoredNode] = get()._containsIn()
override def _cfgIn(): JIterator[StoredNode] = get()._cfgIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
override def _dominateIn(): JIterator[StoredNode] = get()._dominateIn()
override def _postDominateIn(): JIterator[StoredNode] = get()._postDominateIn()
override def _conditionIn(): JIterator[StoredNode] = get()._conditionIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Call.Label
  }
}
      class CallDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with Expression with CallRepr with CallBase {

        override def layoutInformation: NodeLayoutInformation = Call.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (name != null) { properties.put("NAME", name) }
if (order != null) { properties.put("ORDER", order) }
methodInstFullName.map { value => properties.put("METHOD_INST_FULL_NAME", value) }
if (methodFullName != null) { properties.put("METHOD_FULL_NAME", methodFullName) }
if (argumentIndex != null) { properties.put("ARGUMENT_INDEX", argumentIndex) }
if (dispatchType != null) { properties.put("DISPATCH_TYPE", dispatchType) }
if (signature != null) { properties.put("SIGNATURE", signature) }
if (typeFullName != null) { properties.put("TYPE_FULL_NAME", typeFullName) }
if (dynamicTypeHintFullName.nonEmpty) { properties.put("DYNAMIC_TYPE_HINT_FULL_NAME", dynamicTypeHintFullName.asJava) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
resolved.map { value => properties.put("RESOLVED", value) }
depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
  properties
}

        private var _code: String = null
def code(): String = _code

private var _name: String = null
def name(): String = _name

private var _order: Integer = null
def order(): Integer = _order

private var _methodInstFullName: Option[String] = None
def methodInstFullName(): Option[String] = _methodInstFullName

private var _methodFullName: String = null
def methodFullName(): String = _methodFullName

private var _argumentIndex: Integer = null
def argumentIndex(): Integer = _argumentIndex

private var _dispatchType: String = null
def dispatchType(): String = _dispatchType

private var _signature: String = null
def signature(): String = _signature

private var _typeFullName: String = null
def typeFullName(): String = _typeFullName

private var _dynamicTypeHintFullName: List[String] = Nil
def dynamicTypeHintFullName(): List[String] = _dynamicTypeHintFullName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _resolved: Option[JBoolean] = None
def resolved(): Option[JBoolean] = _resolved

private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder
override def _cfgOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _astOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _receiverOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _taggedByOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _dynamicTypeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _dominateOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
override def _postDominateOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
override def _cdgOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
override def _refOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
override def _callOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]
override def _evalTypeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(10).asInstanceOf[JIterator[StoredNode]]
override def _reachingDefOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(11).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(12).asInstanceOf[JIterator[StoredNode]]
override def _receiverIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(13).asInstanceOf[JIterator[StoredNode]]
override def _cdgIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(14).asInstanceOf[JIterator[StoredNode]]
override def _reachingDefIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(15).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(16).asInstanceOf[JIterator[StoredNode]]
override def _containsIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(17).asInstanceOf[JIterator[StoredNode]]
override def _cfgIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(18).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(19).asInstanceOf[JIterator[StoredNode]]
override def _dominateIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(20).asInstanceOf[JIterator[StoredNode]]
override def _postDominateIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(21).asInstanceOf[JIterator[StoredNode]]
override def _conditionIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(22).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Call.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[CallDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Call.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Call.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else  if (key == "METHOD_INST_FULL_NAME") this._methodInstFullName = Option(value).asInstanceOf[Option[String]] 
 else  if (key == "METHOD_FULL_NAME") this._methodFullName = value.asInstanceOf[String] 
 else  if (key == "ARGUMENT_INDEX") this._argumentIndex = value.asInstanceOf[Integer] 
 else  if (key == "DISPATCH_TYPE") this._dispatchType = value.asInstanceOf[String] 
 else  if (key == "SIGNATURE") this._signature = value.asInstanceOf[String] 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = value.asInstanceOf[String] 
 else if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") {
                    if (cardinality == VertexProperty.Cardinality.list) {
                      if (this._dynamicTypeHintFullName == null) { this._dynamicTypeHintFullName = Nil }
                      this._dynamicTypeHintFullName = this._dynamicTypeHintFullName :+ value.asInstanceOf[String]
                    } else {
                      this._dynamicTypeHintFullName = List(value.asInstanceOf[String])
                    }
                  }
              
 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "RESOLVED") this._resolved = Option(value).asInstanceOf[Option[JBoolean]] 
 else  if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = Option(value).asInstanceOf[Option[Integer]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "CODE") this._code = null 
 else  if (key == "NAME") this._name = null 
 else  if (key == "ORDER") this._order = null 
 else  if (key == "METHOD_INST_FULL_NAME") this._methodInstFullName = null 
 else  if (key == "METHOD_FULL_NAME") this._methodFullName = null 
 else  if (key == "ARGUMENT_INDEX") this._argumentIndex = null 
 else  if (key == "DISPATCH_TYPE") this._dispatchType = null 
 else  if (key == "SIGNATURE") this._signature = null 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = null 
 else  if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") this._dynamicTypeHintFullName = null 
 else  if (key == "LINE_NUMBER") this._lineNumber = null 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = null 
 else  if (key == "RESOLVED") this._resolved = null 
 else  if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//CALL END


//CALL_CHAIN BEGIN

      object CallChain {

        def apply(graph: OdbGraph, id: Long) = new CallChain(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "CALL_CHAIN"
        object Keys {
          
          val All: JSet[String] = Set().asJava
            val KeyToValue: Map[String, CallChainDb => Any] = Map(
              
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[CallChainDb] {
          override val forLabel = CallChain.Label

          override def createNode(ref: NodeRef[CallChainDb]) =
            new CallChainDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = CallChain(graph, id)
        }
      }
      
trait CallChainBase extends Node   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def methods: List[MethodBase]
def calls: List[CallBase]

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        
      }

  override def productPrefix = "CallChain"
  override def productArity = 0 + 1 // add one for id, leaving out `_graph`
  
}
class CallChain(graph: OdbGraph, id: Long) extends NodeRef[CallChainDb](graph, id) with CallChainBase with StoredNode  {

def methods = get().methods
def calls = get().calls
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    CallChain.Label
  }
}
      class CallChainDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with CallChainBase {

        override def layoutInformation: NodeLayoutInformation = CallChain.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  
  properties
}

        
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          CallChain.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[CallChainDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          CallChain.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          CallChain.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
          PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
          throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type Method */
              lazy val methods: List[Method] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "methods").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Method])
                  .toList
              

              /** link to 'contained' node of type Call */
              lazy val calls: List[Call] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "calls").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Call])
                  .toList
              
      }
      
//CALL_CHAIN END


//CALL_SITE BEGIN

      object CallSite {

        def apply(graph: OdbGraph, id: Long) = new CallSite(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "CALL_SITE"
        object Keys {
          
          val All: JSet[String] = Set().asJava
            val KeyToValue: Map[String, CallSiteDb => Any] = Map(
              
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[CallSiteDb] {
          override val forLabel = CallSite.Label

          override def createNode(ref: NodeRef[CallSiteDb]) =
            new CallSiteDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = CallSite(graph, id)
        }
      }
      
trait CallSiteBase extends Node   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def method: MethodBase
def call: CallBase
def callerMethod: MethodBase

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        
      }

  override def productPrefix = "CallSite"
  override def productArity = 0 + 1 // add one for id, leaving out `_graph`
  
}
class CallSite(graph: OdbGraph, id: Long) extends NodeRef[CallSiteDb](graph, id) with CallSiteBase with StoredNode  {

def method = get().method
def call = get().call
def callerMethod = get().callerMethod
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    CallSite.Label
  }
}
      class CallSiteDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with CallSiteBase {

        override def layoutInformation: NodeLayoutInformation = CallSite.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  
  properties
}

        
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          CallSite.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[CallSiteDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          CallSite.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          CallSite.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
          PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
          throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type Method */
              lazy val method: Method =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "method").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Method])
                  .head
              

              /** link to 'contained' node of type Call */
              lazy val call: Call =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "call").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Call])
                  .head
              

              /** link to 'contained' node of type Method */
              lazy val callerMethod: Method =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "callerMethod").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Method])
                  .head
              
      }
      
//CALL_SITE END


//CLOSURE_BINDING BEGIN

      object ClosureBinding {

        def apply(graph: OdbGraph, id: Long) = new ClosureBinding(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Ref.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation, edges.CapturedBy.layoutInformation, edges.Capture.layoutInformation).asJava)

        val Label = "CLOSURE_BINDING"
        object Keys {
          val ClosureBindingId = "CLOSURE_BINDING_ID" 
val EvaluationStrategy = "EVALUATION_STRATEGY" 
val ClosureOriginalName = "CLOSURE_ORIGINAL_NAME" 
          val All: JSet[String] = Set(ClosureBindingId, EvaluationStrategy, ClosureOriginalName).asJava
            val KeyToValue: Map[String, ClosureBindingDb => Any] = Map(
               "CLOSURE_BINDING_ID" -> { instance: ClosureBindingDb => instance.closureBindingId.orNull},
 "EVALUATION_STRATEGY" -> { instance: ClosureBindingDb => instance.evaluationStrategy},
 "CLOSURE_ORIGINAL_NAME" -> { instance: ClosureBindingDb => instance.closureOriginalName.orNull}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE","CAPTURED_BY","CAPTURE")
          val Out: Array[String] = Array("REF","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[ClosureBindingDb] {
          override val forLabel = ClosureBinding.Label

          override def createNode(ref: NodeRef[ClosureBindingDb]) =
            new ClosureBindingDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = ClosureBinding(graph, id)
        }
      }
      
trait ClosureBindingBase extends Node  with HasClosureBindingId with HasEvaluationStrategy with HasClosureOriginalName {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "closureBindingId" 
case 2 => "evaluationStrategy" 
case 3 => "closureOriginalName" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => closureBindingId
case 2 => evaluationStrategy
case 3 => closureOriginalName
      }

  override def productPrefix = "ClosureBinding"
  override def productArity = 3 + 1 // add one for id, leaving out `_graph`
  
}
class ClosureBinding(graph: OdbGraph, id: Long) extends NodeRef[ClosureBindingDb](graph, id) with ClosureBindingBase with StoredNode  {
override def closureBindingId = get().closureBindingId
override def evaluationStrategy = get().evaluationStrategy
override def closureOriginalName = get().closureOriginalName

override def _refOut(): JIterator[StoredNode] = get()._refOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _capturedByIn(): JIterator[StoredNode] = get()._capturedByIn()
override def _captureIn(): JIterator[StoredNode] = get()._captureIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    ClosureBinding.Label
  }
}
      class ClosureBindingDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with ClosureBindingBase {

        override def layoutInformation: NodeLayoutInformation = ClosureBinding.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  closureBindingId.map { value => properties.put("CLOSURE_BINDING_ID", value) }
if (evaluationStrategy != null) { properties.put("EVALUATION_STRATEGY", evaluationStrategy) }
closureOriginalName.map { value => properties.put("CLOSURE_ORIGINAL_NAME", value) }
  properties
}

        private var _closureBindingId: Option[String] = None
def closureBindingId(): Option[String] = _closureBindingId

private var _evaluationStrategy: String = null
def evaluationStrategy(): String = _evaluationStrategy

private var _closureOriginalName: Option[String] = None
def closureOriginalName(): Option[String] = _closureOriginalName
override def _refOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _capturedByIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _captureIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          ClosureBinding.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ClosureBindingDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          ClosureBinding.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          ClosureBinding.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "CLOSURE_BINDING_ID") this._closureBindingId = Option(value).asInstanceOf[Option[String]] 
 else  if (key == "EVALUATION_STRATEGY") this._evaluationStrategy = value.asInstanceOf[String] 
 else  if (key == "CLOSURE_ORIGINAL_NAME") this._closureOriginalName = Option(value).asInstanceOf[Option[String]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "CLOSURE_BINDING_ID") this._closureBindingId = null 
 else  if (key == "EVALUATION_STRATEGY") this._evaluationStrategy = null 
 else  if (key == "CLOSURE_ORIGINAL_NAME") this._closureOriginalName = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//CLOSURE_BINDING END


//COMMENT BEGIN

      object Comment {

        def apply(graph: OdbGraph, id: Long) = new Comment(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation, edges.Ast.layoutInformation).asJava)

        val Label = "COMMENT"
        object Keys {
          val LineNumber = "LINE_NUMBER" 
val Code = "CODE" 
          val All: JSet[String] = Set(LineNumber, Code).asJava
            val KeyToValue: Map[String, CommentDb => Any] = Map(
               "LINE_NUMBER" -> { instance: CommentDb => instance.lineNumber.orNull},
 "CODE" -> { instance: CommentDb => instance.code}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE","AST")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[CommentDb] {
          override val forLabel = Comment.Label

          override def createNode(ref: NodeRef[CommentDb]) =
            new CommentDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Comment(graph, id)
        }
      }
      
trait CommentBase extends Node  with HasLineNumber with HasCode {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "lineNumber" 
case 2 => "code" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => lineNumber
case 2 => code
      }

  override def productPrefix = "Comment"
  override def productArity = 2 + 1 // add one for id, leaving out `_graph`
  
}
class Comment(graph: OdbGraph, id: Long) extends NodeRef[CommentDb](graph, id) with CommentBase with StoredNode  {
override def lineNumber = get().lineNumber
override def code = get().code

override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Comment.Label
  }
}
      class CommentDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with CommentBase {

        override def layoutInformation: NodeLayoutInformation = Comment.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  lineNumber.map { value => properties.put("LINE_NUMBER", value) }
if (code != null) { properties.put("CODE", code) }
  properties
}

        private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _code: String = null
def code(): String = _code
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Comment.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[CommentDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Comment.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Comment.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "CODE") this._code = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "LINE_NUMBER") this._lineNumber = null 
 else  if (key == "CODE") this._code = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//COMMENT END


//CONFIG_FILE BEGIN

      object ConfigFile {

        def apply(graph: OdbGraph, id: Long) = new ConfigFile(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Contains.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "CONFIG_FILE"
        object Keys {
          val Name = "NAME" 
val Content = "CONTENT" 
          val All: JSet[String] = Set(Name, Content).asJava
            val KeyToValue: Map[String, ConfigFileDb => Any] = Map(
               "NAME" -> { instance: ConfigFileDb => instance.name},
 "CONTENT" -> { instance: ConfigFileDb => instance.content}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[ConfigFileDb] {
          override val forLabel = ConfigFile.Label

          override def createNode(ref: NodeRef[ConfigFileDb]) =
            new ConfigFileDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = ConfigFile(graph, id)
        }
      }
      
trait ConfigFileBase extends Node  with HasName with HasContent {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "name" 
case 2 => "content" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => name
case 2 => content
      }

  override def productPrefix = "ConfigFile"
  override def productArity = 2 + 1 // add one for id, leaving out `_graph`
  
}
class ConfigFile(graph: OdbGraph, id: Long) extends NodeRef[ConfigFileDb](graph, id) with ConfigFileBase with StoredNode  {
override def name = get().name
override def content = get().content

override def _containsOut(): JIterator[StoredNode] = get()._containsOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    ConfigFile.Label
  }
}
      class ConfigFileDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with ConfigFileBase {

        override def layoutInformation: NodeLayoutInformation = ConfigFile.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
if (content != null) { properties.put("CONTENT", content) }
  properties
}

        private var _name: String = null
def name(): String = _name

private var _content: String = null
def content(): String = _content
override def _containsOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          ConfigFile.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ConfigFileDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          ConfigFile.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          ConfigFile.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "CONTENT") this._content = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "NAME") this._name = null 
 else  if (key == "CONTENT") this._content = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//CONFIG_FILE END


//CONTROL_STRUCTURE BEGIN

      object ControlStructure {

        def apply(graph: OdbGraph, id: Long) = new ControlStructure(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Ast.layoutInformation, edges.Condition.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation, edges.Ast.layoutInformation, edges.Condition.layoutInformation).asJava)

        val Label = "CONTROL_STRUCTURE"
        object Keys {
          val Code = "CODE" 
val ColumnNumber = "COLUMN_NUMBER" 
val LineNumber = "LINE_NUMBER" 
val Order = "ORDER" 
val ParserTypeName = "PARSER_TYPE_NAME" 
val ArgumentIndex = "ARGUMENT_INDEX" 
          val All: JSet[String] = Set(Code, ColumnNumber, LineNumber, Order, ParserTypeName, ArgumentIndex).asJava
            val KeyToValue: Map[String, ControlStructureDb => Any] = Map(
               "CODE" -> { instance: ControlStructureDb => instance.code},
 "COLUMN_NUMBER" -> { instance: ControlStructureDb => instance.columnNumber.orNull},
 "LINE_NUMBER" -> { instance: ControlStructureDb => instance.lineNumber.orNull},
 "ORDER" -> { instance: ControlStructureDb => instance.order},
 "PARSER_TYPE_NAME" -> { instance: ControlStructureDb => instance.parserTypeName},
 "ARGUMENT_INDEX" -> { instance: ControlStructureDb => instance.argumentIndex}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE","AST","CONDITION")
          val Out: Array[String] = Array("AST","CONDITION","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[ControlStructureDb] {
          override val forLabel = ControlStructure.Label

          override def createNode(ref: NodeRef[ControlStructureDb]) =
            new ControlStructureDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = ControlStructure(graph, id)
        }
      }
      
trait ControlStructureBase extends Node with ExpressionBase with HasCode with HasColumnNumber with HasLineNumber with HasOrder with HasParserTypeName with HasArgumentIndex {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "code" 
case 2 => "columnNumber" 
case 3 => "lineNumber" 
case 4 => "order" 
case 5 => "parserTypeName" 
case 6 => "argumentIndex" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => code
case 2 => columnNumber
case 3 => lineNumber
case 4 => order
case 5 => parserTypeName
case 6 => argumentIndex
      }

  override def productPrefix = "ControlStructure"
  override def productArity = 6 + 1 // add one for id, leaving out `_graph`
  
}
class ControlStructure(graph: OdbGraph, id: Long) extends NodeRef[ControlStructureDb](graph, id) with ControlStructureBase with StoredNode with Expression {
override def code = get().code
override def columnNumber = get().columnNumber
override def lineNumber = get().lineNumber
override def order = get().order
override def parserTypeName = get().parserTypeName
override def argumentIndex = get().argumentIndex

override def _astOut(): JIterator[StoredNode] = get()._astOut()
override def _conditionOut(): JIterator[StoredNode] = get()._conditionOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
override def _conditionIn(): JIterator[StoredNode] = get()._conditionIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    ControlStructure.Label
  }
}
      class ControlStructureDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with Expression with ControlStructureBase {

        override def layoutInformation: NodeLayoutInformation = ControlStructure.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
if (order != null) { properties.put("ORDER", order) }
if (parserTypeName != null) { properties.put("PARSER_TYPE_NAME", parserTypeName) }
if (argumentIndex != null) { properties.put("ARGUMENT_INDEX", argumentIndex) }
  properties
}

        private var _code: String = null
def code(): String = _code

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _order: Integer = null
def order(): Integer = _order

private var _parserTypeName: String = null
def parserTypeName(): String = _parserTypeName

private var _argumentIndex: Integer = null
def argumentIndex(): Integer = _argumentIndex
override def _astOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _conditionOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _conditionIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          ControlStructure.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ControlStructureDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          ControlStructure.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          ControlStructure.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else  if (key == "PARSER_TYPE_NAME") this._parserTypeName = value.asInstanceOf[String] 
 else  if (key == "ARGUMENT_INDEX") this._argumentIndex = value.asInstanceOf[Integer] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "CODE") this._code = null 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = null 
 else  if (key == "LINE_NUMBER") this._lineNumber = null 
 else  if (key == "ORDER") this._order = null 
 else  if (key == "PARSER_TYPE_NAME") this._parserTypeName = null 
 else  if (key == "ARGUMENT_INDEX") this._argumentIndex = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//CONTROL_STRUCTURE END


//DEPENDENCY BEGIN

      object Dependency {

        def apply(graph: OdbGraph, id: Long) = new Dependency(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "DEPENDENCY"
        object Keys {
          val Version = "VERSION" 
val Name = "NAME" 
val DependencyGroupId = "DEPENDENCY_GROUP_ID" 
          val All: JSet[String] = Set(Version, Name, DependencyGroupId).asJava
            val KeyToValue: Map[String, DependencyDb => Any] = Map(
               "VERSION" -> { instance: DependencyDb => instance.version},
 "NAME" -> { instance: DependencyDb => instance.name},
 "DEPENDENCY_GROUP_ID" -> { instance: DependencyDb => instance.dependencyGroupId.orNull}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[DependencyDb] {
          override val forLabel = Dependency.Label

          override def createNode(ref: NodeRef[DependencyDb]) =
            new DependencyDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Dependency(graph, id)
        }
      }
      
trait DependencyBase extends Node  with HasVersion with HasName with HasDependencyGroupId {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "version" 
case 2 => "name" 
case 3 => "dependencyGroupId" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => version
case 2 => name
case 3 => dependencyGroupId
      }

  override def productPrefix = "Dependency"
  override def productArity = 3 + 1 // add one for id, leaving out `_graph`
  
}
class Dependency(graph: OdbGraph, id: Long) extends NodeRef[DependencyDb](graph, id) with DependencyBase with StoredNode  {
override def version = get().version
override def name = get().name
override def dependencyGroupId = get().dependencyGroupId

override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Dependency.Label
  }
}
      class DependencyDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with DependencyBase {

        override def layoutInformation: NodeLayoutInformation = Dependency.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (version != null) { properties.put("VERSION", version) }
if (name != null) { properties.put("NAME", name) }
dependencyGroupId.map { value => properties.put("DEPENDENCY_GROUP_ID", value) }
  properties
}

        private var _version: String = null
def version(): String = _version

private var _name: String = null
def name(): String = _name

private var _dependencyGroupId: Option[String] = None
def dependencyGroupId(): Option[String] = _dependencyGroupId
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Dependency.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[DependencyDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Dependency.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Dependency.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "VERSION") this._version = value.asInstanceOf[String] 
 else  if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "DEPENDENCY_GROUP_ID") this._dependencyGroupId = Option(value).asInstanceOf[Option[String]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "VERSION") this._version = null 
 else  if (key == "NAME") this._name = null 
 else  if (key == "DEPENDENCY_GROUP_ID") this._dependencyGroupId = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//DEPENDENCY END


//DETACHED_TRACKING_POINT BEGIN

      object DetachedTrackingPoint {

        def apply(graph: OdbGraph, id: Long) = new DetachedTrackingPoint(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "DETACHED_TRACKING_POINT"
        object Keys {
          
          val All: JSet[String] = Set().asJava
            val KeyToValue: Map[String, DetachedTrackingPointDb => Any] = Map(
              
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[DetachedTrackingPointDb] {
          override val forLabel = DetachedTrackingPoint.Label

          override def createNode(ref: NodeRef[DetachedTrackingPointDb]) =
            new DetachedTrackingPointDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = DetachedTrackingPoint(graph, id)
        }
      }
      
trait DetachedTrackingPointBase extends Node with TrackingPointBase  {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def cfgNode: CfgNodeBase

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        
      }

  override def productPrefix = "DetachedTrackingPoint"
  override def productArity = 0 + 1 // add one for id, leaving out `_graph`
  
}
class DetachedTrackingPoint(graph: OdbGraph, id: Long) extends NodeRef[DetachedTrackingPointDb](graph, id) with DetachedTrackingPointBase with StoredNode with TrackingPoint {

def cfgNode = get().cfgNode
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    DetachedTrackingPoint.Label
  }
}
      class DetachedTrackingPointDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with TrackingPoint with DetachedTrackingPointBase {

        override def layoutInformation: NodeLayoutInformation = DetachedTrackingPoint.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  
  properties
}

        
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          DetachedTrackingPoint.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[DetachedTrackingPointDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          DetachedTrackingPoint.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          DetachedTrackingPoint.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
          PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
          throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type CfgNode */
              lazy val cfgNode: CfgNode =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "cfgNode").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[CfgNode])
                  .head
              
      }
      
//DETACHED_TRACKING_POINT END


//DOM_ATTRIBUTE BEGIN

      object DomAttribute {

        def apply(graph: OdbGraph, id: Long) = new DomAttribute(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "DOM_ATTRIBUTE"
        object Keys {
          val Name = "NAME" 
val Value = "VALUE" 
          val All: JSet[String] = Set(Name, Value).asJava
            val KeyToValue: Map[String, DomAttributeDb => Any] = Map(
               "NAME" -> { instance: DomAttributeDb => instance.name},
 "VALUE" -> { instance: DomAttributeDb => instance.value}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[DomAttributeDb] {
          override val forLabel = DomAttribute.Label

          override def createNode(ref: NodeRef[DomAttributeDb]) =
            new DomAttributeDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = DomAttribute(graph, id)
        }
      }
      
trait DomAttributeBase extends Node  with HasName with HasValue {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "name" 
case 2 => "value" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => name
case 2 => value
      }

  override def productPrefix = "DomAttribute"
  override def productArity = 2 + 1 // add one for id, leaving out `_graph`
  
}
class DomAttribute(graph: OdbGraph, id: Long) extends NodeRef[DomAttributeDb](graph, id) with DomAttributeBase with StoredNode  {
override def name = get().name
override def value = get().value

override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    DomAttribute.Label
  }
}
      class DomAttributeDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with DomAttributeBase {

        override def layoutInformation: NodeLayoutInformation = DomAttribute.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
if (value != null) { properties.put("VALUE", value) }
  properties
}

        private var _name: String = null
def name(): String = _name

private var _value: String = null
def value(): String = _value
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          DomAttribute.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[DomAttributeDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          DomAttribute.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          DomAttribute.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "VALUE") this._value = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "NAME") this._name = null 
 else  if (key == "VALUE") this._value = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//DOM_ATTRIBUTE END


//DOM_NODE BEGIN

      object DomNode {

        def apply(graph: OdbGraph, id: Long) = new DomNode(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation, edges.Contains.layoutInformation, edges.Ast.layoutInformation).asJava)

        val Label = "DOM_NODE"
        object Keys {
          val Name = "NAME" 
          val All: JSet[String] = Set(Name).asJava
            val KeyToValue: Map[String, DomNodeDb => Any] = Map(
               "NAME" -> { instance: DomNodeDb => instance.name}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE","CONTAINS","AST")
          val Out: Array[String] = Array("AST","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[DomNodeDb] {
          override val forLabel = DomNode.Label

          override def createNode(ref: NodeRef[DomNodeDb]) =
            new DomNodeDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = DomNode(graph, id)
        }
      }
      
trait DomNodeBase extends Node  with HasName {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def attributes: List[DomAttributeBase]

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "name" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => name
      }

  override def productPrefix = "DomNode"
  override def productArity = 1 + 1 // add one for id, leaving out `_graph`
  
}
class DomNode(graph: OdbGraph, id: Long) extends NodeRef[DomNodeDb](graph, id) with DomNodeBase with StoredNode  {
override def name = get().name
def attributes = get().attributes
override def _astOut(): JIterator[StoredNode] = get()._astOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _containsIn(): JIterator[StoredNode] = get()._containsIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    DomNode.Label
  }
}
      class DomNodeDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with DomNodeBase {

        override def layoutInformation: NodeLayoutInformation = DomNode.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
  properties
}

        private var _name: String = null
def name(): String = _name
override def _astOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          DomNode.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[DomNodeDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          DomNode.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          DomNode.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "NAME") this._name = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "NAME") this._name = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type DomAttribute */
              lazy val attributes: List[DomAttribute] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "attributes").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[DomAttribute])
                  .toList
              
      }
      
//DOM_NODE END


//FILE BEGIN

      object File {

        def apply(graph: OdbGraph, id: Long) = new File(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Ast.layoutInformation, edges.Contains.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "FILE"
        object Keys {
          val Name = "NAME" 
val Order = "ORDER" 
          val All: JSet[String] = Set(Name, Order).asJava
            val KeyToValue: Map[String, FileDb => Any] = Map(
               "NAME" -> { instance: FileDb => instance.name},
 "ORDER" -> { instance: FileDb => instance.order}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("AST","CONTAINS","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[FileDb] {
          override val forLabel = File.Label

          override def createNode(ref: NodeRef[FileDb]) =
            new FileDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = File(graph, id)
        }
      }
      
trait FileBase extends Node with AstNodeBase with HasName with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "name" 
case 2 => "order" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => name
case 2 => order
      }

  override def productPrefix = "File"
  override def productArity = 2 + 1 // add one for id, leaving out `_graph`
  
}
class File(graph: OdbGraph, id: Long) extends NodeRef[FileDb](graph, id) with FileBase with StoredNode with AstNode {
override def name = get().name
override def order = get().order

override def _astOut(): JIterator[StoredNode] = get()._astOut()
override def _containsOut(): JIterator[StoredNode] = get()._containsOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    File.Label
  }
}
      class FileDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with AstNode with FileBase {

        override def layoutInformation: NodeLayoutInformation = File.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
if (order != null) { properties.put("ORDER", order) }
  properties
}

        private var _name: String = null
def name(): String = _name

private var _order: Integer = null
def order(): Integer = _order
override def _astOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          File.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[FileDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          File.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          File.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "NAME") this._name = null 
 else  if (key == "ORDER") this._order = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//FILE END


//FINDING BEGIN

      object Finding {

        def apply(graph: OdbGraph, id: Long) = new Finding(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "FINDING"
        object Keys {
          val Name = "NAME" 
val Category = "CATEGORY" 
val Title = "TITLE" 
val Description = "DESCRIPTION" 
val Score = "SCORE" 
val Link = "LINK" 
val VulnDescr = "VULN_DESCR" 
val Parameter = "PARAMETER" 
val MethodName = "METHOD_NAME" 
val LineNo = "LINE_NO" 
val Filename = "FILENAME" 
val OwaspLink = "OWASP_LINK" 
val CweLink = "CWE_LINK" 
          val All: JSet[String] = Set(Name, Category, Title, Description, Score, Link, VulnDescr, Parameter, MethodName, LineNo, Filename, OwaspLink, CweLink).asJava
            val KeyToValue: Map[String, FindingDb => Any] = Map(
               "NAME" -> { instance: FindingDb => instance.name},
 "CATEGORY" -> { instance: FindingDb => instance.category},
 "TITLE" -> { instance: FindingDb => instance.title},
 "DESCRIPTION" -> { instance: FindingDb => instance.description},
 "SCORE" -> { instance: FindingDb => instance.score},
 "LINK" -> { instance: FindingDb => instance.link},
 "VULN_DESCR" -> { instance: FindingDb => instance.vulnDescr},
 "PARAMETER" -> { instance: FindingDb => instance.parameter},
 "METHOD_NAME" -> { instance: FindingDb => instance.methodName},
 "LINE_NO" -> { instance: FindingDb => instance.lineNo},
 "FILENAME" -> { instance: FindingDb => instance.filename},
 "OWASP_LINK" -> { instance: FindingDb => instance.owaspLink},
 "CWE_LINK" -> { instance: FindingDb => instance.cweLink}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[FindingDb] {
          override val forLabel = Finding.Label

          override def createNode(ref: NodeRef[FindingDb]) =
            new FindingDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Finding(graph, id)
        }
      }
      
trait FindingBase extends Node  with HasName with HasCategory with HasTitle with HasDescription with HasScore with HasLink with HasVulnDescr with HasParameter with HasMethodName with HasLineNo with HasFilename with HasOwaspLink with HasCweLink {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def ioflows: List[IoflowBase]
def methods: List[MethodBase]

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "name" 
case 2 => "category" 
case 3 => "title" 
case 4 => "description" 
case 5 => "score" 
case 6 => "link" 
case 7 => "vulnDescr" 
case 8 => "parameter" 
case 9 => "methodName" 
case 10 => "lineNo" 
case 11 => "filename" 
case 12 => "owaspLink" 
case 13 => "cweLink" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => name
case 2 => category
case 3 => title
case 4 => description
case 5 => score
case 6 => link
case 7 => vulnDescr
case 8 => parameter
case 9 => methodName
case 10 => lineNo
case 11 => filename
case 12 => owaspLink
case 13 => cweLink
      }

  override def productPrefix = "Finding"
  override def productArity = 13 + 1 // add one for id, leaving out `_graph`
  
}
class Finding(graph: OdbGraph, id: Long) extends NodeRef[FindingDb](graph, id) with FindingBase with StoredNode  {
override def name = get().name
override def category = get().category
override def title = get().title
override def description = get().description
override def score = get().score
override def link = get().link
override def vulnDescr = get().vulnDescr
override def parameter = get().parameter
override def methodName = get().methodName
override def lineNo = get().lineNo
override def filename = get().filename
override def owaspLink = get().owaspLink
override def cweLink = get().cweLink
def ioflows = get().ioflows
def methods = get().methods
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Finding.Label
  }
}
      class FindingDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with FindingBase {

        override def layoutInformation: NodeLayoutInformation = Finding.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
if (category != null) { properties.put("CATEGORY", category) }
if (title != null) { properties.put("TITLE", title) }
if (description != null) { properties.put("DESCRIPTION", description) }
if (score != null) { properties.put("SCORE", score) }
if (link != null) { properties.put("LINK", link) }
if (vulnDescr != null) { properties.put("VULN_DESCR", vulnDescr) }
if (parameter != null) { properties.put("PARAMETER", parameter) }
if (methodName != null) { properties.put("METHOD_NAME", methodName) }
if (lineNo != null) { properties.put("LINE_NO", lineNo) }
if (filename != null) { properties.put("FILENAME", filename) }
if (owaspLink != null) { properties.put("OWASP_LINK", owaspLink) }
if (cweLink != null) { properties.put("CWE_LINK", cweLink) }
  properties
}

        private var _name: String = null
def name(): String = _name

private var _category: String = null
def category(): String = _category

private var _title: String = null
def title(): String = _title

private var _description: String = null
def description(): String = _description

private var _score: Integer = null
def score(): Integer = _score

private var _link: String = null
def link(): String = _link

private var _vulnDescr: String = null
def vulnDescr(): String = _vulnDescr

private var _parameter: String = null
def parameter(): String = _parameter

private var _methodName: String = null
def methodName(): String = _methodName

private var _lineNo: String = null
def lineNo(): String = _lineNo

private var _filename: String = null
def filename(): String = _filename

private var _owaspLink: String = null
def owaspLink(): String = _owaspLink

private var _cweLink: String = null
def cweLink(): String = _cweLink
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Finding.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[FindingDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Finding.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Finding.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "CATEGORY") this._category = value.asInstanceOf[String] 
 else  if (key == "TITLE") this._title = value.asInstanceOf[String] 
 else  if (key == "DESCRIPTION") this._description = value.asInstanceOf[String] 
 else  if (key == "SCORE") this._score = value.asInstanceOf[Integer] 
 else  if (key == "LINK") this._link = value.asInstanceOf[String] 
 else  if (key == "VULN_DESCR") this._vulnDescr = value.asInstanceOf[String] 
 else  if (key == "PARAMETER") this._parameter = value.asInstanceOf[String] 
 else  if (key == "METHOD_NAME") this._methodName = value.asInstanceOf[String] 
 else  if (key == "LINE_NO") this._lineNo = value.asInstanceOf[String] 
 else  if (key == "FILENAME") this._filename = value.asInstanceOf[String] 
 else  if (key == "OWASP_LINK") this._owaspLink = value.asInstanceOf[String] 
 else  if (key == "CWE_LINK") this._cweLink = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "NAME") this._name = null 
 else  if (key == "CATEGORY") this._category = null 
 else  if (key == "TITLE") this._title = null 
 else  if (key == "DESCRIPTION") this._description = null 
 else  if (key == "SCORE") this._score = null 
 else  if (key == "LINK") this._link = null 
 else  if (key == "VULN_DESCR") this._vulnDescr = null 
 else  if (key == "PARAMETER") this._parameter = null 
 else  if (key == "METHOD_NAME") this._methodName = null 
 else  if (key == "LINE_NO") this._lineNo = null 
 else  if (key == "FILENAME") this._filename = null 
 else  if (key == "OWASP_LINK") this._owaspLink = null 
 else  if (key == "CWE_LINK") this._cweLink = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type Ioflow */
              lazy val ioflows: List[Ioflow] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "ioflows").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Ioflow])
                  .toList
              

              /** link to 'contained' node of type Method */
              lazy val methods: List[Method] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "methods").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Method])
                  .toList
              
      }
      
//FINDING END


//FLOW BEGIN

      object Flow {

        def apply(graph: OdbGraph, id: Long) = new Flow(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "FLOW"
        object Keys {
          
          val All: JSet[String] = Set().asJava
            val KeyToValue: Map[String, FlowDb => Any] = Map(
              
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[FlowDb] {
          override val forLabel = Flow.Label

          override def createNode(ref: NodeRef[FlowDb]) =
            new FlowDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Flow(graph, id)
        }
      }
      
trait FlowBase extends Node   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def points: List[ProgramPointBase]
def source: SourceBase
def sink: SinkBase
def transformations: List[TransformationBase]
def branchPoints: List[TrackingPointBase]
def cfgNodes: List[CfgNodeBase]

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        
      }

  override def productPrefix = "Flow"
  override def productArity = 0 + 1 // add one for id, leaving out `_graph`
  
}
class Flow(graph: OdbGraph, id: Long) extends NodeRef[FlowDb](graph, id) with FlowBase with StoredNode  {

def points = get().points
def source = get().source
def sink = get().sink
def transformations = get().transformations
def branchPoints = get().branchPoints
def cfgNodes = get().cfgNodes
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Flow.Label
  }
}
      class FlowDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with FlowBase {

        override def layoutInformation: NodeLayoutInformation = Flow.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  
  properties
}

        
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Flow.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[FlowDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Flow.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Flow.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
          PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
          throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type ProgramPoint */
              lazy val points: List[ProgramPoint] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "points").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[ProgramPoint])
                  .toList
              

              /** link to 'contained' node of type Source */
              lazy val source: Source =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "source").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Source])
                  .head
              

              /** link to 'contained' node of type Sink */
              lazy val sink: Sink =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "sink").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Sink])
                  .head
              

              /** link to 'contained' node of type Transformation */
              lazy val transformations: List[Transformation] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "transformations").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Transformation])
                  .toList
              

              /** link to 'contained' node of type TrackingPoint */
              lazy val branchPoints: List[TrackingPoint] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "branchPoints").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[TrackingPoint])
                  .toList
              

              /** link to 'contained' node of type CfgNode */
              lazy val cfgNodes: List[CfgNode] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "cfgNodes").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[CfgNode])
                  .toList
              
      }
      
//FLOW END


//FRAMEWORK BEGIN

      object Framework {

        def apply(graph: OdbGraph, id: Long) = new Framework(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.AttachedData.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "FRAMEWORK"
        object Keys {
          val Name = "NAME" 
          val All: JSet[String] = Set(Name).asJava
            val KeyToValue: Map[String, FrameworkDb => Any] = Map(
               "NAME" -> { instance: FrameworkDb => instance.name}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("ATTACHED_DATA","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[FrameworkDb] {
          override val forLabel = Framework.Label

          override def createNode(ref: NodeRef[FrameworkDb]) =
            new FrameworkDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Framework(graph, id)
        }
      }
      
trait FrameworkBase extends Node  with HasName {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "name" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => name
      }

  override def productPrefix = "Framework"
  override def productArity = 1 + 1 // add one for id, leaving out `_graph`
  
}
class Framework(graph: OdbGraph, id: Long) extends NodeRef[FrameworkDb](graph, id) with FrameworkBase with StoredNode  {
override def name = get().name

override def _attachedDataOut(): JIterator[StoredNode] = get()._attachedDataOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Framework.Label
  }
}
      class FrameworkDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with FrameworkBase {

        override def layoutInformation: NodeLayoutInformation = Framework.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
  properties
}

        private var _name: String = null
def name(): String = _name
override def _attachedDataOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Framework.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[FrameworkDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Framework.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Framework.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "NAME") this._name = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "NAME") this._name = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//FRAMEWORK END


//FRAMEWORK_DATA BEGIN

      object FrameworkData {

        def apply(graph: OdbGraph, id: Long) = new FrameworkData(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation, edges.AttachedData.layoutInformation).asJava)

        val Label = "FRAMEWORK_DATA"
        object Keys {
          val Name = "NAME" 
val Content = "CONTENT" 
          val All: JSet[String] = Set(Name, Content).asJava
            val KeyToValue: Map[String, FrameworkDataDb => Any] = Map(
               "NAME" -> { instance: FrameworkDataDb => instance.name},
 "CONTENT" -> { instance: FrameworkDataDb => instance.content}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE","ATTACHED_DATA")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[FrameworkDataDb] {
          override val forLabel = FrameworkData.Label

          override def createNode(ref: NodeRef[FrameworkDataDb]) =
            new FrameworkDataDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = FrameworkData(graph, id)
        }
      }
      
trait FrameworkDataBase extends Node  with HasName with HasContent {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "name" 
case 2 => "content" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => name
case 2 => content
      }

  override def productPrefix = "FrameworkData"
  override def productArity = 2 + 1 // add one for id, leaving out `_graph`
  
}
class FrameworkData(graph: OdbGraph, id: Long) extends NodeRef[FrameworkDataDb](graph, id) with FrameworkDataBase with StoredNode  {
override def name = get().name
override def content = get().content

override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _attachedDataIn(): JIterator[StoredNode] = get()._attachedDataIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    FrameworkData.Label
  }
}
      class FrameworkDataDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with FrameworkDataBase {

        override def layoutInformation: NodeLayoutInformation = FrameworkData.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
if (content != null) { properties.put("CONTENT", content) }
  properties
}

        private var _name: String = null
def name(): String = _name

private var _content: String = null
def content(): String = _content
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _attachedDataIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          FrameworkData.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[FrameworkDataDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          FrameworkData.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          FrameworkData.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "CONTENT") this._content = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "NAME") this._name = null 
 else  if (key == "CONTENT") this._content = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//FRAMEWORK_DATA END


//IDENTIFIER BEGIN

      object Identifier {

        def apply(graph: OdbGraph, id: Long) = new Identifier(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Ref.layoutInformation, edges.Cfg.layoutInformation, edges.TaggedBy.layoutInformation, edges.DynamicType.layoutInformation, edges.Dominate.layoutInformation, edges.PostDominate.layoutInformation, edges.Cdg.layoutInformation, edges.EvalType.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.Receiver.layoutInformation, edges.IsSensitiveDataDescrOf.layoutInformation, edges.Cdg.layoutInformation, edges.ContainsNode.layoutInformation, edges.Contains.layoutInformation, edges.Cfg.layoutInformation, edges.IsSensitiveDataDescrOfRef.layoutInformation, edges.Ast.layoutInformation, edges.Dominate.layoutInformation, edges.PostDominate.layoutInformation, edges.Condition.layoutInformation).asJava)

        val Label = "IDENTIFIER"
        object Keys {
          val Code = "CODE" 
val Name = "NAME" 
val Order = "ORDER" 
val ArgumentIndex = "ARGUMENT_INDEX" 
val TypeFullName = "TYPE_FULL_NAME" 
val DynamicTypeHintFullName = "DYNAMIC_TYPE_HINT_FULL_NAME" 
val LineNumber = "LINE_NUMBER" 
val ColumnNumber = "COLUMN_NUMBER" 
val DepthFirstOrder = "DEPTH_FIRST_ORDER" 
          val All: JSet[String] = Set(Code, Name, Order, ArgumentIndex, TypeFullName, DynamicTypeHintFullName, LineNumber, ColumnNumber, DepthFirstOrder).asJava
            val KeyToValue: Map[String, IdentifierDb => Any] = Map(
               "CODE" -> { instance: IdentifierDb => instance.code},
 "NAME" -> { instance: IdentifierDb => instance.name},
 "ORDER" -> { instance: IdentifierDb => instance.order},
 "ARGUMENT_INDEX" -> { instance: IdentifierDb => instance.argumentIndex},
 "TYPE_FULL_NAME" -> { instance: IdentifierDb => instance.typeFullName},
 "DYNAMIC_TYPE_HINT_FULL_NAME" -> { instance: IdentifierDb => instance.dynamicTypeHintFullName},
 "LINE_NUMBER" -> { instance: IdentifierDb => instance.lineNumber.orNull},
 "COLUMN_NUMBER" -> { instance: IdentifierDb => instance.columnNumber.orNull},
 "DEPTH_FIRST_ORDER" -> { instance: IdentifierDb => instance.depthFirstOrder.orNull}
            )
          }
        object Edges {
          val In: Array[String] = Array("RECEIVER","IS_SENSITIVE_DATA_DESCR_OF","CDG","CONTAINS_NODE","CONTAINS","CFG","IS_SENSITIVE_DATA_DESCR_OF_REF","AST","DOMINATE","POST_DOMINATE","CONDITION")
          val Out: Array[String] = Array("REF","CFG","TAGGED_BY","DYNAMIC_TYPE","DOMINATE","POST_DOMINATE","CDG","EVAL_TYPE","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[IdentifierDb] {
          override val forLabel = Identifier.Label

          override def createNode(ref: NodeRef[IdentifierDb]) =
            new IdentifierDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Identifier(graph, id)
        }
      }
      
trait IdentifierBase extends Node with ExpressionBase with LocalLikeBase with HasCode with HasName with HasOrder with HasArgumentIndex with HasTypeFullName with HasDynamicTypeHintFullName with HasLineNumber with HasColumnNumber with HasDepthFirstOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "code" 
case 2 => "name" 
case 3 => "order" 
case 4 => "argumentIndex" 
case 5 => "typeFullName" 
case 6 => "dynamicTypeHintFullName" 
case 7 => "lineNumber" 
case 8 => "columnNumber" 
case 9 => "depthFirstOrder" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => code
case 2 => name
case 3 => order
case 4 => argumentIndex
case 5 => typeFullName
case 6 => dynamicTypeHintFullName
case 7 => lineNumber
case 8 => columnNumber
case 9 => depthFirstOrder
      }

  override def productPrefix = "Identifier"
  override def productArity = 9 + 1 // add one for id, leaving out `_graph`
  
}
class Identifier(graph: OdbGraph, id: Long) extends NodeRef[IdentifierDb](graph, id) with IdentifierBase with StoredNode with Expression with LocalLike {
override def code = get().code
override def name = get().name
override def order = get().order
override def argumentIndex = get().argumentIndex
override def typeFullName = get().typeFullName
override def dynamicTypeHintFullName = get().dynamicTypeHintFullName
override def lineNumber = get().lineNumber
override def columnNumber = get().columnNumber
override def depthFirstOrder = get().depthFirstOrder

override def _refOut(): JIterator[StoredNode] = get()._refOut()
override def _cfgOut(): JIterator[StoredNode] = get()._cfgOut()
override def _taggedByOut(): JIterator[StoredNode] = get()._taggedByOut()
override def _dynamicTypeOut(): JIterator[StoredNode] = get()._dynamicTypeOut()
override def _dominateOut(): JIterator[StoredNode] = get()._dominateOut()
override def _postDominateOut(): JIterator[StoredNode] = get()._postDominateOut()
override def _cdgOut(): JIterator[StoredNode] = get()._cdgOut()
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _receiverIn(): JIterator[StoredNode] = get()._receiverIn()
override def _isSensitiveDataDescrOfIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfIn()
override def _cdgIn(): JIterator[StoredNode] = get()._cdgIn()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _containsIn(): JIterator[StoredNode] = get()._containsIn()
override def _cfgIn(): JIterator[StoredNode] = get()._cfgIn()
override def _isSensitiveDataDescrOfRefIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfRefIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
override def _dominateIn(): JIterator[StoredNode] = get()._dominateIn()
override def _postDominateIn(): JIterator[StoredNode] = get()._postDominateIn()
override def _conditionIn(): JIterator[StoredNode] = get()._conditionIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Identifier.Label
  }
}
      class IdentifierDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with Expression with LocalLike with IdentifierBase {

        override def layoutInformation: NodeLayoutInformation = Identifier.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (name != null) { properties.put("NAME", name) }
if (order != null) { properties.put("ORDER", order) }
if (argumentIndex != null) { properties.put("ARGUMENT_INDEX", argumentIndex) }
if (typeFullName != null) { properties.put("TYPE_FULL_NAME", typeFullName) }
if (dynamicTypeHintFullName.nonEmpty) { properties.put("DYNAMIC_TYPE_HINT_FULL_NAME", dynamicTypeHintFullName.asJava) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
  properties
}

        private var _code: String = null
def code(): String = _code

private var _name: String = null
def name(): String = _name

private var _order: Integer = null
def order(): Integer = _order

private var _argumentIndex: Integer = null
def argumentIndex(): Integer = _argumentIndex

private var _typeFullName: String = null
def typeFullName(): String = _typeFullName

private var _dynamicTypeHintFullName: List[String] = Nil
def dynamicTypeHintFullName(): List[String] = _dynamicTypeHintFullName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder
override def _refOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _cfgOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _taggedByOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _dynamicTypeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _dominateOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _postDominateOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
override def _cdgOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
override def _evalTypeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
override def _receiverIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]
override def _isSensitiveDataDescrOfIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(10).asInstanceOf[JIterator[StoredNode]]
override def _cdgIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(11).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(12).asInstanceOf[JIterator[StoredNode]]
override def _containsIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(13).asInstanceOf[JIterator[StoredNode]]
override def _cfgIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(14).asInstanceOf[JIterator[StoredNode]]
override def _isSensitiveDataDescrOfRefIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(15).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(16).asInstanceOf[JIterator[StoredNode]]
override def _dominateIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(17).asInstanceOf[JIterator[StoredNode]]
override def _postDominateIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(18).asInstanceOf[JIterator[StoredNode]]
override def _conditionIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(19).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Identifier.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[IdentifierDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Identifier.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Identifier.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else  if (key == "ARGUMENT_INDEX") this._argumentIndex = value.asInstanceOf[Integer] 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = value.asInstanceOf[String] 
 else if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") {
                    if (cardinality == VertexProperty.Cardinality.list) {
                      if (this._dynamicTypeHintFullName == null) { this._dynamicTypeHintFullName = Nil }
                      this._dynamicTypeHintFullName = this._dynamicTypeHintFullName :+ value.asInstanceOf[String]
                    } else {
                      this._dynamicTypeHintFullName = List(value.asInstanceOf[String])
                    }
                  }
              
 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = Option(value).asInstanceOf[Option[Integer]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "CODE") this._code = null 
 else  if (key == "NAME") this._name = null 
 else  if (key == "ORDER") this._order = null 
 else  if (key == "ARGUMENT_INDEX") this._argumentIndex = null 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = null 
 else  if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") this._dynamicTypeHintFullName = null 
 else  if (key == "LINE_NUMBER") this._lineNumber = null 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = null 
 else  if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//IDENTIFIER END


//IMPLICIT_CALL BEGIN

      object ImplicitCall {

        def apply(graph: OdbGraph, id: Long) = new ImplicitCall(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation, edges.Ast.layoutInformation).asJava)

        val Label = "IMPLICIT_CALL"
        object Keys {
          val Code = "CODE" 
val Name = "NAME" 
val Signature = "SIGNATURE" 
val LineNumber = "LINE_NUMBER" 
val ColumnNumber = "COLUMN_NUMBER" 
val Order = "ORDER" 
          val All: JSet[String] = Set(Code, Name, Signature, LineNumber, ColumnNumber, Order).asJava
            val KeyToValue: Map[String, ImplicitCallDb => Any] = Map(
               "CODE" -> { instance: ImplicitCallDb => instance.code},
 "NAME" -> { instance: ImplicitCallDb => instance.name},
 "SIGNATURE" -> { instance: ImplicitCallDb => instance.signature},
 "LINE_NUMBER" -> { instance: ImplicitCallDb => instance.lineNumber.orNull},
 "COLUMN_NUMBER" -> { instance: ImplicitCallDb => instance.columnNumber.orNull},
 "ORDER" -> { instance: ImplicitCallDb => instance.order}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE","AST")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[ImplicitCallDb] {
          override val forLabel = ImplicitCall.Label

          override def createNode(ref: NodeRef[ImplicitCallDb]) =
            new ImplicitCallDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = ImplicitCall(graph, id)
        }
      }
      
trait ImplicitCallBase extends Node with CallReprBase with TrackingPointBase with HasCode with HasName with HasSignature with HasLineNumber with HasColumnNumber with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "code" 
case 2 => "name" 
case 3 => "signature" 
case 4 => "lineNumber" 
case 5 => "columnNumber" 
case 6 => "order" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => code
case 2 => name
case 3 => signature
case 4 => lineNumber
case 5 => columnNumber
case 6 => order
      }

  override def productPrefix = "ImplicitCall"
  override def productArity = 6 + 1 // add one for id, leaving out `_graph`
  
}
class ImplicitCall(graph: OdbGraph, id: Long) extends NodeRef[ImplicitCallDb](graph, id) with ImplicitCallBase with StoredNode with CallRepr with TrackingPoint {
override def code = get().code
override def name = get().name
override def signature = get().signature
override def lineNumber = get().lineNumber
override def columnNumber = get().columnNumber
override def order = get().order

override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    ImplicitCall.Label
  }
}
      class ImplicitCallDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with CallRepr with TrackingPoint with ImplicitCallBase {

        override def layoutInformation: NodeLayoutInformation = ImplicitCall.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (name != null) { properties.put("NAME", name) }
if (signature != null) { properties.put("SIGNATURE", signature) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
if (order != null) { properties.put("ORDER", order) }
  properties
}

        private var _code: String = null
def code(): String = _code

private var _name: String = null
def name(): String = _name

private var _signature: String = null
def signature(): String = _signature

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _order: Integer = null
def order(): Integer = _order
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          ImplicitCall.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ImplicitCallDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          ImplicitCall.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          ImplicitCall.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "SIGNATURE") this._signature = value.asInstanceOf[String] 
 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "CODE") this._code = null 
 else  if (key == "NAME") this._name = null 
 else  if (key == "SIGNATURE") this._signature = null 
 else  if (key == "LINE_NUMBER") this._lineNumber = null 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = null 
 else  if (key == "ORDER") this._order = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//IMPLICIT_CALL END


//IOFLOW BEGIN

      object Ioflow {

        def apply(graph: OdbGraph, id: Long) = new Ioflow(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "IOFLOW"
        object Keys {
          val Fingerprint = "FINGERPRINT" 
val LiteralsToSink = "LITERALS_TO_SINK" 
          val All: JSet[String] = Set(Fingerprint, LiteralsToSink).asJava
            val KeyToValue: Map[String, IoflowDb => Any] = Map(
               "FINGERPRINT" -> { instance: IoflowDb => instance.fingerprint},
 "LITERALS_TO_SINK" -> { instance: IoflowDb => instance.literalsToSink}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[IoflowDb] {
          override val forLabel = Ioflow.Label

          override def createNode(ref: NodeRef[IoflowDb]) =
            new IoflowDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Ioflow(graph, id)
        }
      }
      
trait IoflowBase extends Node  with HasFingerprint with HasLiteralsToSink {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def dataTags: List[TagBase]
def sourceDescriptorTags: List[TagBase]
def sinkDescriptorTags: List[TagBase]
def source: SourceBase
def sink: SinkBase
def transforms: List[TransformBase]
def sourceDescriptorFlows: List[FlowBase]
def sinkDescriptorFlows: List[FlowBase]
def primaryFlow: FlowBase
def triggerMethods: List[MethodBase]

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "fingerprint" 
case 2 => "literalsToSink" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => fingerprint
case 2 => literalsToSink
      }

  override def productPrefix = "Ioflow"
  override def productArity = 2 + 1 // add one for id, leaving out `_graph`
  
}
class Ioflow(graph: OdbGraph, id: Long) extends NodeRef[IoflowDb](graph, id) with IoflowBase with StoredNode  {
override def fingerprint = get().fingerprint
override def literalsToSink = get().literalsToSink
def dataTags = get().dataTags
def sourceDescriptorTags = get().sourceDescriptorTags
def sinkDescriptorTags = get().sinkDescriptorTags
def source = get().source
def sink = get().sink
def transforms = get().transforms
def sourceDescriptorFlows = get().sourceDescriptorFlows
def sinkDescriptorFlows = get().sinkDescriptorFlows
def primaryFlow = get().primaryFlow
def triggerMethods = get().triggerMethods
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Ioflow.Label
  }
}
      class IoflowDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with IoflowBase {

        override def layoutInformation: NodeLayoutInformation = Ioflow.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (fingerprint != null) { properties.put("FINGERPRINT", fingerprint) }
if (literalsToSink.nonEmpty) { properties.put("LITERALS_TO_SINK", literalsToSink.asJava) }
  properties
}

        private var _fingerprint: String = null
def fingerprint(): String = _fingerprint

private var _literalsToSink: List[String] = Nil
def literalsToSink(): List[String] = _literalsToSink
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Ioflow.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[IoflowDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Ioflow.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Ioflow.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "FINGERPRINT") this._fingerprint = value.asInstanceOf[String] 
 else if (key == "LITERALS_TO_SINK") {
                    if (cardinality == VertexProperty.Cardinality.list) {
                      if (this._literalsToSink == null) { this._literalsToSink = Nil }
                      this._literalsToSink = this._literalsToSink :+ value.asInstanceOf[String]
                    } else {
                      this._literalsToSink = List(value.asInstanceOf[String])
                    }
                  }
              
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "FINGERPRINT") this._fingerprint = null 
 else  if (key == "LITERALS_TO_SINK") this._literalsToSink = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type Tag */
              lazy val dataTags: List[Tag] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "dataTags").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Tag])
                  .toList
              

              /** link to 'contained' node of type Tag */
              lazy val sourceDescriptorTags: List[Tag] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "sourceDescriptorTags").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Tag])
                  .toList
              

              /** link to 'contained' node of type Tag */
              lazy val sinkDescriptorTags: List[Tag] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "sinkDescriptorTags").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Tag])
                  .toList
              

              /** link to 'contained' node of type Source */
              lazy val source: Source =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "source").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Source])
                  .head
              

              /** link to 'contained' node of type Sink */
              lazy val sink: Sink =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "sink").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Sink])
                  .head
              

              /** link to 'contained' node of type Transform */
              lazy val transforms: List[Transform] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "transforms").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Transform])
                  .toList
              

              /** link to 'contained' node of type Flow */
              lazy val sourceDescriptorFlows: List[Flow] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "sourceDescriptorFlows").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Flow])
                  .toList
              

              /** link to 'contained' node of type Flow */
              lazy val sinkDescriptorFlows: List[Flow] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "sinkDescriptorFlows").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Flow])
                  .toList
              

              /** link to 'contained' node of type Flow */
              lazy val primaryFlow: Flow =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "primaryFlow").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Flow])
                  .head
              

              /** link to 'contained' node of type Method */
              lazy val triggerMethods: List[Method] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "triggerMethods").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Method])
                  .toList
              
      }
      
//IOFLOW END


//LITERAL BEGIN

      object Literal {

        def apply(graph: OdbGraph, id: Long) = new Literal(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Cfg.layoutInformation, edges.TaggedBy.layoutInformation, edges.DynamicType.layoutInformation, edges.Dominate.layoutInformation, edges.PostDominate.layoutInformation, edges.Cdg.layoutInformation, edges.EvalType.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.Receiver.layoutInformation, edges.Cdg.layoutInformation, edges.ContainsNode.layoutInformation, edges.Contains.layoutInformation, edges.Cfg.layoutInformation, edges.Ast.layoutInformation, edges.Dominate.layoutInformation, edges.PostDominate.layoutInformation, edges.Condition.layoutInformation).asJava)

        val Label = "LITERAL"
        object Keys {
          val Code = "CODE" 
val Order = "ORDER" 
val ArgumentIndex = "ARGUMENT_INDEX" 
val TypeFullName = "TYPE_FULL_NAME" 
val DynamicTypeHintFullName = "DYNAMIC_TYPE_HINT_FULL_NAME" 
val LineNumber = "LINE_NUMBER" 
val ColumnNumber = "COLUMN_NUMBER" 
val DepthFirstOrder = "DEPTH_FIRST_ORDER" 
          val All: JSet[String] = Set(Code, Order, ArgumentIndex, TypeFullName, DynamicTypeHintFullName, LineNumber, ColumnNumber, DepthFirstOrder).asJava
            val KeyToValue: Map[String, LiteralDb => Any] = Map(
               "CODE" -> { instance: LiteralDb => instance.code},
 "ORDER" -> { instance: LiteralDb => instance.order},
 "ARGUMENT_INDEX" -> { instance: LiteralDb => instance.argumentIndex},
 "TYPE_FULL_NAME" -> { instance: LiteralDb => instance.typeFullName},
 "DYNAMIC_TYPE_HINT_FULL_NAME" -> { instance: LiteralDb => instance.dynamicTypeHintFullName},
 "LINE_NUMBER" -> { instance: LiteralDb => instance.lineNumber.orNull},
 "COLUMN_NUMBER" -> { instance: LiteralDb => instance.columnNumber.orNull},
 "DEPTH_FIRST_ORDER" -> { instance: LiteralDb => instance.depthFirstOrder.orNull}
            )
          }
        object Edges {
          val In: Array[String] = Array("RECEIVER","CDG","CONTAINS_NODE","CONTAINS","CFG","AST","DOMINATE","POST_DOMINATE","CONDITION")
          val Out: Array[String] = Array("CFG","TAGGED_BY","DYNAMIC_TYPE","DOMINATE","POST_DOMINATE","CDG","EVAL_TYPE","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[LiteralDb] {
          override val forLabel = Literal.Label

          override def createNode(ref: NodeRef[LiteralDb]) =
            new LiteralDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Literal(graph, id)
        }
      }
      
trait LiteralBase extends Node with ExpressionBase with HasCode with HasOrder with HasArgumentIndex with HasTypeFullName with HasDynamicTypeHintFullName with HasLineNumber with HasColumnNumber with HasDepthFirstOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "code" 
case 2 => "order" 
case 3 => "argumentIndex" 
case 4 => "typeFullName" 
case 5 => "dynamicTypeHintFullName" 
case 6 => "lineNumber" 
case 7 => "columnNumber" 
case 8 => "depthFirstOrder" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => code
case 2 => order
case 3 => argumentIndex
case 4 => typeFullName
case 5 => dynamicTypeHintFullName
case 6 => lineNumber
case 7 => columnNumber
case 8 => depthFirstOrder
      }

  override def productPrefix = "Literal"
  override def productArity = 8 + 1 // add one for id, leaving out `_graph`
  
}
class Literal(graph: OdbGraph, id: Long) extends NodeRef[LiteralDb](graph, id) with LiteralBase with StoredNode with Expression {
override def code = get().code
override def order = get().order
override def argumentIndex = get().argumentIndex
override def typeFullName = get().typeFullName
override def dynamicTypeHintFullName = get().dynamicTypeHintFullName
override def lineNumber = get().lineNumber
override def columnNumber = get().columnNumber
override def depthFirstOrder = get().depthFirstOrder

override def _cfgOut(): JIterator[StoredNode] = get()._cfgOut()
override def _taggedByOut(): JIterator[StoredNode] = get()._taggedByOut()
override def _dynamicTypeOut(): JIterator[StoredNode] = get()._dynamicTypeOut()
override def _dominateOut(): JIterator[StoredNode] = get()._dominateOut()
override def _postDominateOut(): JIterator[StoredNode] = get()._postDominateOut()
override def _cdgOut(): JIterator[StoredNode] = get()._cdgOut()
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _receiverIn(): JIterator[StoredNode] = get()._receiverIn()
override def _cdgIn(): JIterator[StoredNode] = get()._cdgIn()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _containsIn(): JIterator[StoredNode] = get()._containsIn()
override def _cfgIn(): JIterator[StoredNode] = get()._cfgIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
override def _dominateIn(): JIterator[StoredNode] = get()._dominateIn()
override def _postDominateIn(): JIterator[StoredNode] = get()._postDominateIn()
override def _conditionIn(): JIterator[StoredNode] = get()._conditionIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Literal.Label
  }
}
      class LiteralDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with Expression with LiteralBase {

        override def layoutInformation: NodeLayoutInformation = Literal.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (order != null) { properties.put("ORDER", order) }
if (argumentIndex != null) { properties.put("ARGUMENT_INDEX", argumentIndex) }
if (typeFullName != null) { properties.put("TYPE_FULL_NAME", typeFullName) }
if (dynamicTypeHintFullName.nonEmpty) { properties.put("DYNAMIC_TYPE_HINT_FULL_NAME", dynamicTypeHintFullName.asJava) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
  properties
}

        private var _code: String = null
def code(): String = _code

private var _order: Integer = null
def order(): Integer = _order

private var _argumentIndex: Integer = null
def argumentIndex(): Integer = _argumentIndex

private var _typeFullName: String = null
def typeFullName(): String = _typeFullName

private var _dynamicTypeHintFullName: List[String] = Nil
def dynamicTypeHintFullName(): List[String] = _dynamicTypeHintFullName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder
override def _cfgOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _taggedByOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _dynamicTypeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _dominateOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _postDominateOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _cdgOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
override def _evalTypeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
override def _receiverIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
override def _cdgIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(10).asInstanceOf[JIterator[StoredNode]]
override def _containsIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(11).asInstanceOf[JIterator[StoredNode]]
override def _cfgIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(12).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(13).asInstanceOf[JIterator[StoredNode]]
override def _dominateIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(14).asInstanceOf[JIterator[StoredNode]]
override def _postDominateIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(15).asInstanceOf[JIterator[StoredNode]]
override def _conditionIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(16).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Literal.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[LiteralDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Literal.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Literal.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else  if (key == "ARGUMENT_INDEX") this._argumentIndex = value.asInstanceOf[Integer] 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = value.asInstanceOf[String] 
 else if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") {
                    if (cardinality == VertexProperty.Cardinality.list) {
                      if (this._dynamicTypeHintFullName == null) { this._dynamicTypeHintFullName = Nil }
                      this._dynamicTypeHintFullName = this._dynamicTypeHintFullName :+ value.asInstanceOf[String]
                    } else {
                      this._dynamicTypeHintFullName = List(value.asInstanceOf[String])
                    }
                  }
              
 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = Option(value).asInstanceOf[Option[Integer]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "CODE") this._code = null 
 else  if (key == "ORDER") this._order = null 
 else  if (key == "ARGUMENT_INDEX") this._argumentIndex = null 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = null 
 else  if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") this._dynamicTypeHintFullName = null 
 else  if (key == "LINE_NUMBER") this._lineNumber = null 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = null 
 else  if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//LITERAL END


//LOCAL BEGIN

      object Local {

        def apply(graph: OdbGraph, id: Long) = new Local(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.TaggedBy.layoutInformation, edges.DynamicType.layoutInformation, edges.EvalType.layoutInformation, edges.CapturedBy.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.IsSensitiveDataDescrOf.layoutInformation, edges.Ref.layoutInformation, edges.ContainsNode.layoutInformation, edges.IsSensitiveDataDescrOfRef.layoutInformation, edges.Ast.layoutInformation).asJava)

        val Label = "LOCAL"
        object Keys {
          val Code = "CODE" 
val Name = "NAME" 
val ClosureBindingId = "CLOSURE_BINDING_ID" 
val TypeFullName = "TYPE_FULL_NAME" 
val DynamicTypeHintFullName = "DYNAMIC_TYPE_HINT_FULL_NAME" 
val LineNumber = "LINE_NUMBER" 
val ColumnNumber = "COLUMN_NUMBER" 
val Order = "ORDER" 
          val All: JSet[String] = Set(Code, Name, ClosureBindingId, TypeFullName, DynamicTypeHintFullName, LineNumber, ColumnNumber, Order).asJava
            val KeyToValue: Map[String, LocalDb => Any] = Map(
               "CODE" -> { instance: LocalDb => instance.code},
 "NAME" -> { instance: LocalDb => instance.name},
 "CLOSURE_BINDING_ID" -> { instance: LocalDb => instance.closureBindingId.orNull},
 "TYPE_FULL_NAME" -> { instance: LocalDb => instance.typeFullName},
 "DYNAMIC_TYPE_HINT_FULL_NAME" -> { instance: LocalDb => instance.dynamicTypeHintFullName},
 "LINE_NUMBER" -> { instance: LocalDb => instance.lineNumber.orNull},
 "COLUMN_NUMBER" -> { instance: LocalDb => instance.columnNumber.orNull},
 "ORDER" -> { instance: LocalDb => instance.order}
            )
          }
        object Edges {
          val In: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF","REF","CONTAINS_NODE","IS_SENSITIVE_DATA_DESCR_OF_REF","AST")
          val Out: Array[String] = Array("TAGGED_BY","DYNAMIC_TYPE","EVAL_TYPE","CAPTURED_BY","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[LocalDb] {
          override val forLabel = Local.Label

          override def createNode(ref: NodeRef[LocalDb]) =
            new LocalDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Local(graph, id)
        }
      }
      
trait LocalBase extends Node with DeclarationBase with LocalLikeBase with AstNodeBase with HasCode with HasName with HasClosureBindingId with HasTypeFullName with HasDynamicTypeHintFullName with HasLineNumber with HasColumnNumber with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "code" 
case 2 => "name" 
case 3 => "closureBindingId" 
case 4 => "typeFullName" 
case 5 => "dynamicTypeHintFullName" 
case 6 => "lineNumber" 
case 7 => "columnNumber" 
case 8 => "order" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => code
case 2 => name
case 3 => closureBindingId
case 4 => typeFullName
case 5 => dynamicTypeHintFullName
case 6 => lineNumber
case 7 => columnNumber
case 8 => order
      }

  override def productPrefix = "Local"
  override def productArity = 8 + 1 // add one for id, leaving out `_graph`
  
}
class Local(graph: OdbGraph, id: Long) extends NodeRef[LocalDb](graph, id) with LocalBase with StoredNode with Declaration with LocalLike with AstNode {
override def code = get().code
override def name = get().name
override def closureBindingId = get().closureBindingId
override def typeFullName = get().typeFullName
override def dynamicTypeHintFullName = get().dynamicTypeHintFullName
override def lineNumber = get().lineNumber
override def columnNumber = get().columnNumber
override def order = get().order

override def _taggedByOut(): JIterator[StoredNode] = get()._taggedByOut()
override def _dynamicTypeOut(): JIterator[StoredNode] = get()._dynamicTypeOut()
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut()
override def _capturedByOut(): JIterator[StoredNode] = get()._capturedByOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _isSensitiveDataDescrOfIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfIn()
override def _refIn(): JIterator[StoredNode] = get()._refIn()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _isSensitiveDataDescrOfRefIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfRefIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Local.Label
  }
}
      class LocalDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with Declaration with LocalLike with AstNode with LocalBase {

        override def layoutInformation: NodeLayoutInformation = Local.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (name != null) { properties.put("NAME", name) }
closureBindingId.map { value => properties.put("CLOSURE_BINDING_ID", value) }
if (typeFullName != null) { properties.put("TYPE_FULL_NAME", typeFullName) }
if (dynamicTypeHintFullName.nonEmpty) { properties.put("DYNAMIC_TYPE_HINT_FULL_NAME", dynamicTypeHintFullName.asJava) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
if (order != null) { properties.put("ORDER", order) }
  properties
}

        private var _code: String = null
def code(): String = _code

private var _name: String = null
def name(): String = _name

private var _closureBindingId: Option[String] = None
def closureBindingId(): Option[String] = _closureBindingId

private var _typeFullName: String = null
def typeFullName(): String = _typeFullName

private var _dynamicTypeHintFullName: List[String] = Nil
def dynamicTypeHintFullName(): List[String] = _dynamicTypeHintFullName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _order: Integer = null
def order(): Integer = _order
override def _taggedByOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _dynamicTypeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _evalTypeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _capturedByOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _isSensitiveDataDescrOfIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
override def _refIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
override def _isSensitiveDataDescrOfRefIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Local.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[LocalDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Local.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Local.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "CLOSURE_BINDING_ID") this._closureBindingId = Option(value).asInstanceOf[Option[String]] 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = value.asInstanceOf[String] 
 else if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") {
                    if (cardinality == VertexProperty.Cardinality.list) {
                      if (this._dynamicTypeHintFullName == null) { this._dynamicTypeHintFullName = Nil }
                      this._dynamicTypeHintFullName = this._dynamicTypeHintFullName :+ value.asInstanceOf[String]
                    } else {
                      this._dynamicTypeHintFullName = List(value.asInstanceOf[String])
                    }
                  }
              
 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "CODE") this._code = null 
 else  if (key == "NAME") this._name = null 
 else  if (key == "CLOSURE_BINDING_ID") this._closureBindingId = null 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = null 
 else  if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") this._dynamicTypeHintFullName = null 
 else  if (key == "LINE_NUMBER") this._lineNumber = null 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = null 
 else  if (key == "ORDER") this._order = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//LOCAL END


//LOCATION BEGIN

      object Location {

        def apply(graph: OdbGraph, id: Long) = new Location(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "LOCATION"
        object Keys {
          val Symbol = "SYMBOL" 
val MethodFullName = "METHOD_FULL_NAME" 
val MethodShortName = "METHOD_SHORT_NAME" 
val PackageName = "PACKAGE_NAME" 
val LineNumber = "LINE_NUMBER" 
val ClassName = "CLASS_NAME" 
val NodeLabel = "NODE_LABEL" 
val Filename = "FILENAME" 
          val All: JSet[String] = Set(Symbol, MethodFullName, MethodShortName, PackageName, LineNumber, ClassName, NodeLabel, Filename).asJava
            val KeyToValue: Map[String, LocationDb => Any] = Map(
               "SYMBOL" -> { instance: LocationDb => instance.symbol},
 "METHOD_FULL_NAME" -> { instance: LocationDb => instance.methodFullName},
 "METHOD_SHORT_NAME" -> { instance: LocationDb => instance.methodShortName},
 "PACKAGE_NAME" -> { instance: LocationDb => instance.packageName},
 "LINE_NUMBER" -> { instance: LocationDb => instance.lineNumber.orNull},
 "CLASS_NAME" -> { instance: LocationDb => instance.className},
 "NODE_LABEL" -> { instance: LocationDb => instance.nodeLabel},
 "FILENAME" -> { instance: LocationDb => instance.filename}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[LocationDb] {
          override val forLabel = Location.Label

          override def createNode(ref: NodeRef[LocationDb]) =
            new LocationDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Location(graph, id)
        }
      }
      
trait LocationBase extends Node  with HasSymbol with HasMethodFullName with HasMethodShortName with HasPackageName with HasLineNumber with HasClassName with HasNodeLabel with HasFilename {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def node: Option[Node]

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "symbol" 
case 2 => "methodFullName" 
case 3 => "methodShortName" 
case 4 => "packageName" 
case 5 => "lineNumber" 
case 6 => "className" 
case 7 => "nodeLabel" 
case 8 => "filename" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => symbol
case 2 => methodFullName
case 3 => methodShortName
case 4 => packageName
case 5 => lineNumber
case 6 => className
case 7 => nodeLabel
case 8 => filename
      }

  override def productPrefix = "Location"
  override def productArity = 8 + 1 // add one for id, leaving out `_graph`
  
}
class Location(graph: OdbGraph, id: Long) extends NodeRef[LocationDb](graph, id) with LocationBase with StoredNode  {
override def symbol = get().symbol
override def methodFullName = get().methodFullName
override def methodShortName = get().methodShortName
override def packageName = get().packageName
override def lineNumber = get().lineNumber
override def className = get().className
override def nodeLabel = get().nodeLabel
override def filename = get().filename
def node = get().node
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Location.Label
  }
}
      class LocationDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with LocationBase {

        override def layoutInformation: NodeLayoutInformation = Location.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (symbol != null) { properties.put("SYMBOL", symbol) }
if (methodFullName != null) { properties.put("METHOD_FULL_NAME", methodFullName) }
if (methodShortName != null) { properties.put("METHOD_SHORT_NAME", methodShortName) }
if (packageName != null) { properties.put("PACKAGE_NAME", packageName) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
if (className != null) { properties.put("CLASS_NAME", className) }
if (nodeLabel != null) { properties.put("NODE_LABEL", nodeLabel) }
if (filename != null) { properties.put("FILENAME", filename) }
  properties
}

        private var _symbol: String = null
def symbol(): String = _symbol

private var _methodFullName: String = null
def methodFullName(): String = _methodFullName

private var _methodShortName: String = null
def methodShortName(): String = _methodShortName

private var _packageName: String = null
def packageName(): String = _packageName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _className: String = null
def className(): String = _className

private var _nodeLabel: String = null
def nodeLabel(): String = _nodeLabel

private var _filename: String = null
def filename(): String = _filename
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Location.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[LocationDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Location.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Location.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "SYMBOL") this._symbol = value.asInstanceOf[String] 
 else  if (key == "METHOD_FULL_NAME") this._methodFullName = value.asInstanceOf[String] 
 else  if (key == "METHOD_SHORT_NAME") this._methodShortName = value.asInstanceOf[String] 
 else  if (key == "PACKAGE_NAME") this._packageName = value.asInstanceOf[String] 
 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "CLASS_NAME") this._className = value.asInstanceOf[String] 
 else  if (key == "NODE_LABEL") this._nodeLabel = value.asInstanceOf[String] 
 else  if (key == "FILENAME") this._filename = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "SYMBOL") this._symbol = null 
 else  if (key == "METHOD_FULL_NAME") this._methodFullName = null 
 else  if (key == "METHOD_SHORT_NAME") this._methodShortName = null 
 else  if (key == "PACKAGE_NAME") this._packageName = null 
 else  if (key == "LINE_NUMBER") this._lineNumber = null 
 else  if (key == "CLASS_NAME") this._className = null 
 else  if (key == "NODE_LABEL") this._nodeLabel = null 
 else  if (key == "FILENAME") this._filename = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type Node */
              lazy val node: Option[Node] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "node").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Node])
                  .headOption
              
      }
      
//LOCATION END


//MATCH_INFO BEGIN

      object MatchInfo {

        def apply(graph: OdbGraph, id: Long) = new MatchInfo(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "MATCH_INFO"
        object Keys {
          val Pattern = "PATTERN" 
val Category = "CATEGORY" 
          val All: JSet[String] = Set(Pattern, Category).asJava
            val KeyToValue: Map[String, MatchInfoDb => Any] = Map(
               "PATTERN" -> { instance: MatchInfoDb => instance.pattern},
 "CATEGORY" -> { instance: MatchInfoDb => instance.category}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[MatchInfoDb] {
          override val forLabel = MatchInfo.Label

          override def createNode(ref: NodeRef[MatchInfoDb]) =
            new MatchInfoDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = MatchInfo(graph, id)
        }
      }
      
trait MatchInfoBase extends Node  with HasPattern with HasCategory {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "pattern" 
case 2 => "category" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => pattern
case 2 => category
      }

  override def productPrefix = "MatchInfo"
  override def productArity = 2 + 1 // add one for id, leaving out `_graph`
  
}
class MatchInfo(graph: OdbGraph, id: Long) extends NodeRef[MatchInfoDb](graph, id) with MatchInfoBase with StoredNode  {
override def pattern = get().pattern
override def category = get().category

override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MatchInfo.Label
  }
}
      class MatchInfoDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with MatchInfoBase {

        override def layoutInformation: NodeLayoutInformation = MatchInfo.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (pattern != null) { properties.put("PATTERN", pattern) }
if (category != null) { properties.put("CATEGORY", category) }
  properties
}

        private var _pattern: String = null
def pattern(): String = _pattern

private var _category: String = null
def category(): String = _category
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          MatchInfo.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MatchInfoDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          MatchInfo.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          MatchInfo.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "PATTERN") this._pattern = value.asInstanceOf[String] 
 else  if (key == "CATEGORY") this._category = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "PATTERN") this._pattern = null 
 else  if (key == "CATEGORY") this._category = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//MATCH_INFO END


//MEMBER BEGIN

      object Member {

        def apply(graph: OdbGraph, id: Long) = new Member(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.DynamicType.layoutInformation, edges.EvalType.layoutInformation, edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.IsSensitiveDataDescrOf.layoutInformation, edges.Ref.layoutInformation, edges.ContainsNode.layoutInformation, edges.Ast.layoutInformation).asJava)

        val Label = "MEMBER"
        object Keys {
          val Code = "CODE" 
val Name = "NAME" 
val TypeFullName = "TYPE_FULL_NAME" 
val DynamicTypeHintFullName = "DYNAMIC_TYPE_HINT_FULL_NAME" 
val Order = "ORDER" 
          val All: JSet[String] = Set(Code, Name, TypeFullName, DynamicTypeHintFullName, Order).asJava
            val KeyToValue: Map[String, MemberDb => Any] = Map(
               "CODE" -> { instance: MemberDb => instance.code},
 "NAME" -> { instance: MemberDb => instance.name},
 "TYPE_FULL_NAME" -> { instance: MemberDb => instance.typeFullName},
 "DYNAMIC_TYPE_HINT_FULL_NAME" -> { instance: MemberDb => instance.dynamicTypeHintFullName},
 "ORDER" -> { instance: MemberDb => instance.order}
            )
          }
        object Edges {
          val In: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF","REF","CONTAINS_NODE","AST")
          val Out: Array[String] = Array("DYNAMIC_TYPE","EVAL_TYPE","AST","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[MemberDb] {
          override val forLabel = Member.Label

          override def createNode(ref: NodeRef[MemberDb]) =
            new MemberDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Member(graph, id)
        }
      }
      
trait MemberBase extends Node with DeclarationBase with AstNodeBase with HasCode with HasName with HasTypeFullName with HasDynamicTypeHintFullName with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "code" 
case 2 => "name" 
case 3 => "typeFullName" 
case 4 => "dynamicTypeHintFullName" 
case 5 => "order" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => code
case 2 => name
case 3 => typeFullName
case 4 => dynamicTypeHintFullName
case 5 => order
      }

  override def productPrefix = "Member"
  override def productArity = 5 + 1 // add one for id, leaving out `_graph`
  
}
class Member(graph: OdbGraph, id: Long) extends NodeRef[MemberDb](graph, id) with MemberBase with StoredNode with Declaration with AstNode {
override def code = get().code
override def name = get().name
override def typeFullName = get().typeFullName
override def dynamicTypeHintFullName = get().dynamicTypeHintFullName
override def order = get().order

override def _dynamicTypeOut(): JIterator[StoredNode] = get()._dynamicTypeOut()
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut()
override def _astOut(): JIterator[StoredNode] = get()._astOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _isSensitiveDataDescrOfIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfIn()
override def _refIn(): JIterator[StoredNode] = get()._refIn()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Member.Label
  }
}
      class MemberDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with Declaration with AstNode with MemberBase {

        override def layoutInformation: NodeLayoutInformation = Member.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (name != null) { properties.put("NAME", name) }
if (typeFullName != null) { properties.put("TYPE_FULL_NAME", typeFullName) }
if (dynamicTypeHintFullName.nonEmpty) { properties.put("DYNAMIC_TYPE_HINT_FULL_NAME", dynamicTypeHintFullName.asJava) }
if (order != null) { properties.put("ORDER", order) }
  properties
}

        private var _code: String = null
def code(): String = _code

private var _name: String = null
def name(): String = _name

private var _typeFullName: String = null
def typeFullName(): String = _typeFullName

private var _dynamicTypeHintFullName: List[String] = Nil
def dynamicTypeHintFullName(): List[String] = _dynamicTypeHintFullName

private var _order: Integer = null
def order(): Integer = _order
override def _dynamicTypeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _evalTypeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _astOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _isSensitiveDataDescrOfIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _refIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Member.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MemberDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Member.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Member.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = value.asInstanceOf[String] 
 else if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") {
                    if (cardinality == VertexProperty.Cardinality.list) {
                      if (this._dynamicTypeHintFullName == null) { this._dynamicTypeHintFullName = Nil }
                      this._dynamicTypeHintFullName = this._dynamicTypeHintFullName :+ value.asInstanceOf[String]
                    } else {
                      this._dynamicTypeHintFullName = List(value.asInstanceOf[String])
                    }
                  }
              
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "CODE") this._code = null 
 else  if (key == "NAME") this._name = null 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = null 
 else  if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") this._dynamicTypeHintFullName = null 
 else  if (key == "ORDER") this._order = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//MEMBER END


//META_DATA BEGIN

      object MetaData {

        def apply(graph: OdbGraph, id: Long) = new MetaData(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "META_DATA"
        object Keys {
          val Language = "LANGUAGE" 
val Version = "VERSION" 
val Spid = "SPID" 
          val All: JSet[String] = Set(Language, Version, Spid).asJava
            val KeyToValue: Map[String, MetaDataDb => Any] = Map(
               "LANGUAGE" -> { instance: MetaDataDb => instance.language},
 "VERSION" -> { instance: MetaDataDb => instance.version},
 "SPID" -> { instance: MetaDataDb => instance.spid.orNull}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[MetaDataDb] {
          override val forLabel = MetaData.Label

          override def createNode(ref: NodeRef[MetaDataDb]) =
            new MetaDataDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = MetaData(graph, id)
        }
      }
      
trait MetaDataBase extends Node  with HasLanguage with HasVersion with HasSpid {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "language" 
case 2 => "version" 
case 3 => "spid" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => language
case 2 => version
case 3 => spid
      }

  override def productPrefix = "MetaData"
  override def productArity = 3 + 1 // add one for id, leaving out `_graph`
  
}
class MetaData(graph: OdbGraph, id: Long) extends NodeRef[MetaDataDb](graph, id) with MetaDataBase with StoredNode  {
override def language = get().language
override def version = get().version
override def spid = get().spid

override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MetaData.Label
  }
}
      class MetaDataDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with MetaDataBase {

        override def layoutInformation: NodeLayoutInformation = MetaData.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (language != null) { properties.put("LANGUAGE", language) }
if (version != null) { properties.put("VERSION", version) }
spid.map { value => properties.put("SPID", value) }
  properties
}

        private var _language: String = null
def language(): String = _language

private var _version: String = null
def version(): String = _version

private var _spid: Option[String] = None
def spid(): Option[String] = _spid
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          MetaData.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MetaDataDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          MetaData.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          MetaData.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "LANGUAGE") this._language = value.asInstanceOf[String] 
 else  if (key == "VERSION") this._version = value.asInstanceOf[String] 
 else  if (key == "SPID") this._spid = Option(value).asInstanceOf[Option[String]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "LANGUAGE") this._language = null 
 else  if (key == "VERSION") this._version = null 
 else  if (key == "SPID") this._spid = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//META_DATA END


//METHOD BEGIN

      object Method {

        def apply(graph: OdbGraph, id: Long) = new Method(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Ast.layoutInformation, edges.Dominate.layoutInformation, edges.Cfg.layoutInformation, edges.TaggedBy.layoutInformation, edges.ReachingDef.layoutInformation, edges.Contains.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.Ref.layoutInformation, edges.DynamicType.layoutInformation, edges.ContainsNode.layoutInformation, edges.Contains.layoutInformation, edges.Vtable.layoutInformation, edges.Call.layoutInformation, edges.Ast.layoutInformation, edges.PostDominate.layoutInformation).asJava)

        val Label = "METHOD"
        object Keys {
          val Name = "NAME" 
val FullName = "FULL_NAME" 
val IsExternal = "IS_EXTERNAL" 
val Signature = "SIGNATURE" 
val AstParentType = "AST_PARENT_TYPE" 
val AstParentFullName = "AST_PARENT_FULL_NAME" 
val LineNumber = "LINE_NUMBER" 
val ColumnNumber = "COLUMN_NUMBER" 
val LineNumberEnd = "LINE_NUMBER_END" 
val ColumnNumberEnd = "COLUMN_NUMBER_END" 
val Order = "ORDER" 
val HasMapping = "HAS_MAPPING" 
val DepthFirstOrder = "DEPTH_FIRST_ORDER" 
val BinarySignature = "BINARY_SIGNATURE" 
          val All: JSet[String] = Set(Name, FullName, IsExternal, Signature, AstParentType, AstParentFullName, LineNumber, ColumnNumber, LineNumberEnd, ColumnNumberEnd, Order, HasMapping, DepthFirstOrder, BinarySignature).asJava
            val KeyToValue: Map[String, MethodDb => Any] = Map(
               "NAME" -> { instance: MethodDb => instance.name},
 "FULL_NAME" -> { instance: MethodDb => instance.fullName},
 "IS_EXTERNAL" -> { instance: MethodDb => instance.isExternal},
 "SIGNATURE" -> { instance: MethodDb => instance.signature},
 "AST_PARENT_TYPE" -> { instance: MethodDb => instance.astParentType},
 "AST_PARENT_FULL_NAME" -> { instance: MethodDb => instance.astParentFullName},
 "LINE_NUMBER" -> { instance: MethodDb => instance.lineNumber.orNull},
 "COLUMN_NUMBER" -> { instance: MethodDb => instance.columnNumber.orNull},
 "LINE_NUMBER_END" -> { instance: MethodDb => instance.lineNumberEnd.orNull},
 "COLUMN_NUMBER_END" -> { instance: MethodDb => instance.columnNumberEnd.orNull},
 "ORDER" -> { instance: MethodDb => instance.order},
 "HAS_MAPPING" -> { instance: MethodDb => instance.hasMapping.orNull},
 "DEPTH_FIRST_ORDER" -> { instance: MethodDb => instance.depthFirstOrder.orNull},
 "BINARY_SIGNATURE" -> { instance: MethodDb => instance.binarySignature.orNull}
            )
          }
        object Edges {
          val In: Array[String] = Array("REF","DYNAMIC_TYPE","CONTAINS_NODE","CONTAINS","VTABLE","CALL","AST","POST_DOMINATE")
          val Out: Array[String] = Array("AST","DOMINATE","CFG","TAGGED_BY","REACHING_DEF","CONTAINS","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[MethodDb] {
          override val forLabel = Method.Label

          override def createNode(ref: NodeRef[MethodDb]) =
            new MethodDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Method(graph, id)
        }
      }
      
trait MethodBase extends Node with DeclarationBase with CfgNodeBase with AstNodeBase with HasName with HasFullName with HasIsExternal with HasSignature with HasAstParentType with HasAstParentFullName with HasLineNumber with HasColumnNumber with HasLineNumberEnd with HasColumnNumberEnd with HasOrder with HasHasMapping with HasDepthFirstOrder with HasBinarySignature {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "name" 
case 2 => "fullName" 
case 3 => "isExternal" 
case 4 => "signature" 
case 5 => "astParentType" 
case 6 => "astParentFullName" 
case 7 => "lineNumber" 
case 8 => "columnNumber" 
case 9 => "lineNumberEnd" 
case 10 => "columnNumberEnd" 
case 11 => "order" 
case 12 => "hasMapping" 
case 13 => "depthFirstOrder" 
case 14 => "binarySignature" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => name
case 2 => fullName
case 3 => isExternal
case 4 => signature
case 5 => astParentType
case 6 => astParentFullName
case 7 => lineNumber
case 8 => columnNumber
case 9 => lineNumberEnd
case 10 => columnNumberEnd
case 11 => order
case 12 => hasMapping
case 13 => depthFirstOrder
case 14 => binarySignature
      }

  override def productPrefix = "Method"
  override def productArity = 14 + 1 // add one for id, leaving out `_graph`
  
}
class Method(graph: OdbGraph, id: Long) extends NodeRef[MethodDb](graph, id) with MethodBase with StoredNode with Declaration with CfgNode with AstNode {
override def name = get().name
override def fullName = get().fullName
override def isExternal = get().isExternal
override def signature = get().signature
override def astParentType = get().astParentType
override def astParentFullName = get().astParentFullName
override def lineNumber = get().lineNumber
override def columnNumber = get().columnNumber
override def lineNumberEnd = get().lineNumberEnd
override def columnNumberEnd = get().columnNumberEnd
override def order = get().order
override def hasMapping = get().hasMapping
override def depthFirstOrder = get().depthFirstOrder
override def binarySignature = get().binarySignature

override def _astOut(): JIterator[StoredNode] = get()._astOut()
override def _dominateOut(): JIterator[StoredNode] = get()._dominateOut()
override def _cfgOut(): JIterator[StoredNode] = get()._cfgOut()
override def _taggedByOut(): JIterator[StoredNode] = get()._taggedByOut()
override def _reachingDefOut(): JIterator[StoredNode] = get()._reachingDefOut()
override def _containsOut(): JIterator[StoredNode] = get()._containsOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _refIn(): JIterator[StoredNode] = get()._refIn()
override def _dynamicTypeIn(): JIterator[StoredNode] = get()._dynamicTypeIn()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _containsIn(): JIterator[StoredNode] = get()._containsIn()
override def _vtableIn(): JIterator[StoredNode] = get()._vtableIn()
override def _callIn(): JIterator[StoredNode] = get()._callIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
override def _postDominateIn(): JIterator[StoredNode] = get()._postDominateIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Method.Label
  }
}
      class MethodDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with Declaration with CfgNode with AstNode with MethodBase {

        override def layoutInformation: NodeLayoutInformation = Method.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
if (fullName != null) { properties.put("FULL_NAME", fullName) }
if (isExternal != null) { properties.put("IS_EXTERNAL", isExternal) }
if (signature != null) { properties.put("SIGNATURE", signature) }
if (astParentType != null) { properties.put("AST_PARENT_TYPE", astParentType) }
if (astParentFullName != null) { properties.put("AST_PARENT_FULL_NAME", astParentFullName) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
lineNumberEnd.map { value => properties.put("LINE_NUMBER_END", value) }
columnNumberEnd.map { value => properties.put("COLUMN_NUMBER_END", value) }
if (order != null) { properties.put("ORDER", order) }
hasMapping.map { value => properties.put("HAS_MAPPING", value) }
depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
binarySignature.map { value => properties.put("BINARY_SIGNATURE", value) }
  properties
}

        private var _name: String = null
def name(): String = _name

private var _fullName: String = null
def fullName(): String = _fullName

private var _isExternal: JBoolean = null
def isExternal(): JBoolean = _isExternal

private var _signature: String = null
def signature(): String = _signature

private var _astParentType: String = null
def astParentType(): String = _astParentType

private var _astParentFullName: String = null
def astParentFullName(): String = _astParentFullName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _lineNumberEnd: Option[Integer] = None
def lineNumberEnd(): Option[Integer] = _lineNumberEnd

private var _columnNumberEnd: Option[Integer] = None
def columnNumberEnd(): Option[Integer] = _columnNumberEnd

private var _order: Integer = null
def order(): Integer = _order

private var _hasMapping: Option[JBoolean] = None
def hasMapping(): Option[JBoolean] = _hasMapping

private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder

private var _binarySignature: Option[String] = None
def binarySignature(): Option[String] = _binarySignature
override def _astOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _dominateOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _cfgOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _taggedByOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _reachingDefOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _containsOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
override def _refIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
override def _dynamicTypeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]
override def _containsIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(10).asInstanceOf[JIterator[StoredNode]]
override def _vtableIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(11).asInstanceOf[JIterator[StoredNode]]
override def _callIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(12).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(13).asInstanceOf[JIterator[StoredNode]]
override def _postDominateIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(14).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Method.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MethodDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Method.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Method.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "FULL_NAME") this._fullName = value.asInstanceOf[String] 
 else  if (key == "IS_EXTERNAL") this._isExternal = value.asInstanceOf[JBoolean] 
 else  if (key == "SIGNATURE") this._signature = value.asInstanceOf[String] 
 else  if (key == "AST_PARENT_TYPE") this._astParentType = value.asInstanceOf[String] 
 else  if (key == "AST_PARENT_FULL_NAME") this._astParentFullName = value.asInstanceOf[String] 
 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "LINE_NUMBER_END") this._lineNumberEnd = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "COLUMN_NUMBER_END") this._columnNumberEnd = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else  if (key == "HAS_MAPPING") this._hasMapping = Option(value).asInstanceOf[Option[JBoolean]] 
 else  if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "BINARY_SIGNATURE") this._binarySignature = Option(value).asInstanceOf[Option[String]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "NAME") this._name = null 
 else  if (key == "FULL_NAME") this._fullName = null 
 else  if (key == "IS_EXTERNAL") this._isExternal = null 
 else  if (key == "SIGNATURE") this._signature = null 
 else  if (key == "AST_PARENT_TYPE") this._astParentType = null 
 else  if (key == "AST_PARENT_FULL_NAME") this._astParentFullName = null 
 else  if (key == "LINE_NUMBER") this._lineNumber = null 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = null 
 else  if (key == "LINE_NUMBER_END") this._lineNumberEnd = null 
 else  if (key == "COLUMN_NUMBER_END") this._columnNumberEnd = null 
 else  if (key == "ORDER") this._order = null 
 else  if (key == "HAS_MAPPING") this._hasMapping = null 
 else  if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = null 
 else  if (key == "BINARY_SIGNATURE") this._binarySignature = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//METHOD END


//METHOD_INST BEGIN

      object MethodInst {

        def apply(graph: OdbGraph, id: Long) = new MethodInst(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "METHOD_INST"
        object Keys {
          val Name = "NAME" 
val Signature = "SIGNATURE" 
val FullName = "FULL_NAME" 
val MethodFullName = "METHOD_FULL_NAME" 
val Order = "ORDER" 
          val All: JSet[String] = Set(Name, Signature, FullName, MethodFullName, Order).asJava
            val KeyToValue: Map[String, MethodInstDb => Any] = Map(
               "NAME" -> { instance: MethodInstDb => instance.name},
 "SIGNATURE" -> { instance: MethodInstDb => instance.signature},
 "FULL_NAME" -> { instance: MethodInstDb => instance.fullName},
 "METHOD_FULL_NAME" -> { instance: MethodInstDb => instance.methodFullName},
 "ORDER" -> { instance: MethodInstDb => instance.order}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("AST","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[MethodInstDb] {
          override val forLabel = MethodInst.Label

          override def createNode(ref: NodeRef[MethodInstDb]) =
            new MethodInstDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = MethodInst(graph, id)
        }
      }
      
trait MethodInstBase extends Node with AstNodeBase with HasName with HasSignature with HasFullName with HasMethodFullName with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "name" 
case 2 => "signature" 
case 3 => "fullName" 
case 4 => "methodFullName" 
case 5 => "order" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => name
case 2 => signature
case 3 => fullName
case 4 => methodFullName
case 5 => order
      }

  override def productPrefix = "MethodInst"
  override def productArity = 5 + 1 // add one for id, leaving out `_graph`
  
}
class MethodInst(graph: OdbGraph, id: Long) extends NodeRef[MethodInstDb](graph, id) with MethodInstBase with StoredNode with AstNode {
override def name = get().name
override def signature = get().signature
override def fullName = get().fullName
override def methodFullName = get().methodFullName
override def order = get().order

override def _astOut(): JIterator[StoredNode] = get()._astOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MethodInst.Label
  }
}
      class MethodInstDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with AstNode with MethodInstBase {

        override def layoutInformation: NodeLayoutInformation = MethodInst.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
if (signature != null) { properties.put("SIGNATURE", signature) }
if (fullName != null) { properties.put("FULL_NAME", fullName) }
if (methodFullName != null) { properties.put("METHOD_FULL_NAME", methodFullName) }
if (order != null) { properties.put("ORDER", order) }
  properties
}

        private var _name: String = null
def name(): String = _name

private var _signature: String = null
def signature(): String = _signature

private var _fullName: String = null
def fullName(): String = _fullName

private var _methodFullName: String = null
def methodFullName(): String = _methodFullName

private var _order: Integer = null
def order(): Integer = _order
override def _astOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          MethodInst.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MethodInstDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          MethodInst.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          MethodInst.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "SIGNATURE") this._signature = value.asInstanceOf[String] 
 else  if (key == "FULL_NAME") this._fullName = value.asInstanceOf[String] 
 else  if (key == "METHOD_FULL_NAME") this._methodFullName = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "NAME") this._name = null 
 else  if (key == "SIGNATURE") this._signature = null 
 else  if (key == "FULL_NAME") this._fullName = null 
 else  if (key == "METHOD_FULL_NAME") this._methodFullName = null 
 else  if (key == "ORDER") this._order = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//METHOD_INST END


//METHOD_PARAMETER_IN BEGIN

      object MethodParameterIn {

        def apply(graph: OdbGraph, id: Long) = new MethodParameterIn(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.TaggedBy.layoutInformation, edges.DynamicType.layoutInformation, edges.TaintRemove.layoutInformation, edges.Propagate.layoutInformation, edges.EvalType.layoutInformation, edges.ReachingDef.layoutInformation, edges.ParameterLink.layoutInformation, edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.IsSensitiveDataDescrOf.layoutInformation, edges.Ref.layoutInformation, edges.ContainsNode.layoutInformation, edges.IsSensitiveDataDescrOfRef.layoutInformation, edges.Ast.layoutInformation).asJava)

        val Label = "METHOD_PARAMETER_IN"
        object Keys {
          val Code = "CODE" 
val Order = "ORDER" 
val Name = "NAME" 
val EvaluationStrategy = "EVALUATION_STRATEGY" 
val TypeFullName = "TYPE_FULL_NAME" 
val DynamicTypeHintFullName = "DYNAMIC_TYPE_HINT_FULL_NAME" 
val LineNumber = "LINE_NUMBER" 
val ColumnNumber = "COLUMN_NUMBER" 
          val All: JSet[String] = Set(Code, Order, Name, EvaluationStrategy, TypeFullName, DynamicTypeHintFullName, LineNumber, ColumnNumber).asJava
            val KeyToValue: Map[String, MethodParameterInDb => Any] = Map(
               "CODE" -> { instance: MethodParameterInDb => instance.code},
 "ORDER" -> { instance: MethodParameterInDb => instance.order},
 "NAME" -> { instance: MethodParameterInDb => instance.name},
 "EVALUATION_STRATEGY" -> { instance: MethodParameterInDb => instance.evaluationStrategy},
 "TYPE_FULL_NAME" -> { instance: MethodParameterInDb => instance.typeFullName},
 "DYNAMIC_TYPE_HINT_FULL_NAME" -> { instance: MethodParameterInDb => instance.dynamicTypeHintFullName},
 "LINE_NUMBER" -> { instance: MethodParameterInDb => instance.lineNumber.orNull},
 "COLUMN_NUMBER" -> { instance: MethodParameterInDb => instance.columnNumber.orNull}
            )
          }
        object Edges {
          val In: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF","REF","CONTAINS_NODE","IS_SENSITIVE_DATA_DESCR_OF_REF","AST")
          val Out: Array[String] = Array("TAGGED_BY","DYNAMIC_TYPE","TAINT_REMOVE","PROPAGATE","EVAL_TYPE","REACHING_DEF","PARAMETER_LINK","AST","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[MethodParameterInDb] {
          override val forLabel = MethodParameterIn.Label

          override def createNode(ref: NodeRef[MethodParameterInDb]) =
            new MethodParameterInDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = MethodParameterIn(graph, id)
        }
      }
      
trait MethodParameterInBase extends Node with DeclarationBase with LocalLikeBase with TrackingPointBase with AstNodeBase with HasCode with HasOrder with HasName with HasEvaluationStrategy with HasTypeFullName with HasDynamicTypeHintFullName with HasLineNumber with HasColumnNumber {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "code" 
case 2 => "order" 
case 3 => "name" 
case 4 => "evaluationStrategy" 
case 5 => "typeFullName" 
case 6 => "dynamicTypeHintFullName" 
case 7 => "lineNumber" 
case 8 => "columnNumber" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => code
case 2 => order
case 3 => name
case 4 => evaluationStrategy
case 5 => typeFullName
case 6 => dynamicTypeHintFullName
case 7 => lineNumber
case 8 => columnNumber
      }

  override def productPrefix = "MethodParameterIn"
  override def productArity = 8 + 1 // add one for id, leaving out `_graph`
  
}
class MethodParameterIn(graph: OdbGraph, id: Long) extends NodeRef[MethodParameterInDb](graph, id) with MethodParameterInBase with StoredNode with Declaration with LocalLike with TrackingPoint with AstNode {
override def code = get().code
override def order = get().order
override def name = get().name
override def evaluationStrategy = get().evaluationStrategy
override def typeFullName = get().typeFullName
override def dynamicTypeHintFullName = get().dynamicTypeHintFullName
override def lineNumber = get().lineNumber
override def columnNumber = get().columnNumber

override def _taggedByOut(): JIterator[StoredNode] = get()._taggedByOut()
override def _dynamicTypeOut(): JIterator[StoredNode] = get()._dynamicTypeOut()
override def _taintRemoveOut(): JIterator[StoredNode] = get()._taintRemoveOut()
override def _propagateOut(): JIterator[StoredNode] = get()._propagateOut()
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut()
override def _reachingDefOut(): JIterator[StoredNode] = get()._reachingDefOut()
override def _parameterLinkOut(): JIterator[StoredNode] = get()._parameterLinkOut()
override def _astOut(): JIterator[StoredNode] = get()._astOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _isSensitiveDataDescrOfIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfIn()
override def _refIn(): JIterator[StoredNode] = get()._refIn()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _isSensitiveDataDescrOfRefIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfRefIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MethodParameterIn.Label
  }
}
      class MethodParameterInDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with Declaration with LocalLike with TrackingPoint with AstNode with MethodParameterInBase {

        override def layoutInformation: NodeLayoutInformation = MethodParameterIn.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (order != null) { properties.put("ORDER", order) }
if (name != null) { properties.put("NAME", name) }
if (evaluationStrategy != null) { properties.put("EVALUATION_STRATEGY", evaluationStrategy) }
if (typeFullName != null) { properties.put("TYPE_FULL_NAME", typeFullName) }
if (dynamicTypeHintFullName.nonEmpty) { properties.put("DYNAMIC_TYPE_HINT_FULL_NAME", dynamicTypeHintFullName.asJava) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
  properties
}

        private var _code: String = null
def code(): String = _code

private var _order: Integer = null
def order(): Integer = _order

private var _name: String = null
def name(): String = _name

private var _evaluationStrategy: String = null
def evaluationStrategy(): String = _evaluationStrategy

private var _typeFullName: String = null
def typeFullName(): String = _typeFullName

private var _dynamicTypeHintFullName: List[String] = Nil
def dynamicTypeHintFullName(): List[String] = _dynamicTypeHintFullName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber
override def _taggedByOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _dynamicTypeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _taintRemoveOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _propagateOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _evalTypeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _reachingDefOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
override def _parameterLinkOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
override def _astOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
override def _isSensitiveDataDescrOfIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]
override def _refIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(10).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(11).asInstanceOf[JIterator[StoredNode]]
override def _isSensitiveDataDescrOfRefIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(12).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(13).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          MethodParameterIn.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MethodParameterInDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          MethodParameterIn.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          MethodParameterIn.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else  if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "EVALUATION_STRATEGY") this._evaluationStrategy = value.asInstanceOf[String] 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = value.asInstanceOf[String] 
 else if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") {
                    if (cardinality == VertexProperty.Cardinality.list) {
                      if (this._dynamicTypeHintFullName == null) { this._dynamicTypeHintFullName = Nil }
                      this._dynamicTypeHintFullName = this._dynamicTypeHintFullName :+ value.asInstanceOf[String]
                    } else {
                      this._dynamicTypeHintFullName = List(value.asInstanceOf[String])
                    }
                  }
              
 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "CODE") this._code = null 
 else  if (key == "ORDER") this._order = null 
 else  if (key == "NAME") this._name = null 
 else  if (key == "EVALUATION_STRATEGY") this._evaluationStrategy = null 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = null 
 else  if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") this._dynamicTypeHintFullName = null 
 else  if (key == "LINE_NUMBER") this._lineNumber = null 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//METHOD_PARAMETER_IN END


//METHOD_PARAMETER_OUT BEGIN

      object MethodParameterOut {

        def apply(graph: OdbGraph, id: Long) = new MethodParameterOut(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.TaggedBy.layoutInformation, edges.EvalType.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.ParameterLink.layoutInformation, edges.Propagate.layoutInformation, edges.TaintRemove.layoutInformation, edges.ContainsNode.layoutInformation, edges.Ast.layoutInformation).asJava)

        val Label = "METHOD_PARAMETER_OUT"
        object Keys {
          val Code = "CODE" 
val Order = "ORDER" 
val Name = "NAME" 
val EvaluationStrategy = "EVALUATION_STRATEGY" 
val TypeFullName = "TYPE_FULL_NAME" 
val LineNumber = "LINE_NUMBER" 
val ColumnNumber = "COLUMN_NUMBER" 
          val All: JSet[String] = Set(Code, Order, Name, EvaluationStrategy, TypeFullName, LineNumber, ColumnNumber).asJava
            val KeyToValue: Map[String, MethodParameterOutDb => Any] = Map(
               "CODE" -> { instance: MethodParameterOutDb => instance.code},
 "ORDER" -> { instance: MethodParameterOutDb => instance.order},
 "NAME" -> { instance: MethodParameterOutDb => instance.name},
 "EVALUATION_STRATEGY" -> { instance: MethodParameterOutDb => instance.evaluationStrategy},
 "TYPE_FULL_NAME" -> { instance: MethodParameterOutDb => instance.typeFullName},
 "LINE_NUMBER" -> { instance: MethodParameterOutDb => instance.lineNumber.orNull},
 "COLUMN_NUMBER" -> { instance: MethodParameterOutDb => instance.columnNumber.orNull}
            )
          }
        object Edges {
          val In: Array[String] = Array("PARAMETER_LINK","PROPAGATE","TAINT_REMOVE","CONTAINS_NODE","AST")
          val Out: Array[String] = Array("TAGGED_BY","EVAL_TYPE","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[MethodParameterOutDb] {
          override val forLabel = MethodParameterOut.Label

          override def createNode(ref: NodeRef[MethodParameterOutDb]) =
            new MethodParameterOutDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = MethodParameterOut(graph, id)
        }
      }
      
trait MethodParameterOutBase extends Node with DeclarationBase with TrackingPointBase with AstNodeBase with HasCode with HasOrder with HasName with HasEvaluationStrategy with HasTypeFullName with HasLineNumber with HasColumnNumber {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "code" 
case 2 => "order" 
case 3 => "name" 
case 4 => "evaluationStrategy" 
case 5 => "typeFullName" 
case 6 => "lineNumber" 
case 7 => "columnNumber" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => code
case 2 => order
case 3 => name
case 4 => evaluationStrategy
case 5 => typeFullName
case 6 => lineNumber
case 7 => columnNumber
      }

  override def productPrefix = "MethodParameterOut"
  override def productArity = 7 + 1 // add one for id, leaving out `_graph`
  
}
class MethodParameterOut(graph: OdbGraph, id: Long) extends NodeRef[MethodParameterOutDb](graph, id) with MethodParameterOutBase with StoredNode with Declaration with TrackingPoint with AstNode {
override def code = get().code
override def order = get().order
override def name = get().name
override def evaluationStrategy = get().evaluationStrategy
override def typeFullName = get().typeFullName
override def lineNumber = get().lineNumber
override def columnNumber = get().columnNumber

override def _taggedByOut(): JIterator[StoredNode] = get()._taggedByOut()
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _parameterLinkIn(): JIterator[StoredNode] = get()._parameterLinkIn()
override def _propagateIn(): JIterator[StoredNode] = get()._propagateIn()
override def _taintRemoveIn(): JIterator[StoredNode] = get()._taintRemoveIn()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MethodParameterOut.Label
  }
}
      class MethodParameterOutDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with Declaration with TrackingPoint with AstNode with MethodParameterOutBase {

        override def layoutInformation: NodeLayoutInformation = MethodParameterOut.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (order != null) { properties.put("ORDER", order) }
if (name != null) { properties.put("NAME", name) }
if (evaluationStrategy != null) { properties.put("EVALUATION_STRATEGY", evaluationStrategy) }
if (typeFullName != null) { properties.put("TYPE_FULL_NAME", typeFullName) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
  properties
}

        private var _code: String = null
def code(): String = _code

private var _order: Integer = null
def order(): Integer = _order

private var _name: String = null
def name(): String = _name

private var _evaluationStrategy: String = null
def evaluationStrategy(): String = _evaluationStrategy

private var _typeFullName: String = null
def typeFullName(): String = _typeFullName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber
override def _taggedByOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _evalTypeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _parameterLinkIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _propagateIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _taintRemoveIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          MethodParameterOut.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MethodParameterOutDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          MethodParameterOut.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          MethodParameterOut.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else  if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "EVALUATION_STRATEGY") this._evaluationStrategy = value.asInstanceOf[String] 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = value.asInstanceOf[String] 
 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "CODE") this._code = null 
 else  if (key == "ORDER") this._order = null 
 else  if (key == "NAME") this._name = null 
 else  if (key == "EVALUATION_STRATEGY") this._evaluationStrategy = null 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = null 
 else  if (key == "LINE_NUMBER") this._lineNumber = null 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//METHOD_PARAMETER_OUT END


//METHOD_REF BEGIN

      object MethodRef {

        def apply(graph: OdbGraph, id: Long) = new MethodRef(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Cfg.layoutInformation, edges.Capture.layoutInformation, edges.Dominate.layoutInformation, edges.PostDominate.layoutInformation, edges.Cdg.layoutInformation, edges.Ref.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.Receiver.layoutInformation, edges.Cdg.layoutInformation, edges.ContainsNode.layoutInformation, edges.Contains.layoutInformation, edges.Cfg.layoutInformation, edges.Ast.layoutInformation, edges.Dominate.layoutInformation, edges.PostDominate.layoutInformation, edges.Condition.layoutInformation).asJava)

        val Label = "METHOD_REF"
        object Keys {
          val Code = "CODE" 
val Order = "ORDER" 
val ArgumentIndex = "ARGUMENT_INDEX" 
val MethodInstFullName = "METHOD_INST_FULL_NAME" 
val MethodFullName = "METHOD_FULL_NAME" 
val LineNumber = "LINE_NUMBER" 
val ColumnNumber = "COLUMN_NUMBER" 
val DepthFirstOrder = "DEPTH_FIRST_ORDER" 
          val All: JSet[String] = Set(Code, Order, ArgumentIndex, MethodInstFullName, MethodFullName, LineNumber, ColumnNumber, DepthFirstOrder).asJava
            val KeyToValue: Map[String, MethodRefDb => Any] = Map(
               "CODE" -> { instance: MethodRefDb => instance.code},
 "ORDER" -> { instance: MethodRefDb => instance.order},
 "ARGUMENT_INDEX" -> { instance: MethodRefDb => instance.argumentIndex},
 "METHOD_INST_FULL_NAME" -> { instance: MethodRefDb => instance.methodInstFullName.orNull},
 "METHOD_FULL_NAME" -> { instance: MethodRefDb => instance.methodFullName},
 "LINE_NUMBER" -> { instance: MethodRefDb => instance.lineNumber.orNull},
 "COLUMN_NUMBER" -> { instance: MethodRefDb => instance.columnNumber.orNull},
 "DEPTH_FIRST_ORDER" -> { instance: MethodRefDb => instance.depthFirstOrder.orNull}
            )
          }
        object Edges {
          val In: Array[String] = Array("RECEIVER","CDG","CONTAINS_NODE","CONTAINS","CFG","AST","DOMINATE","POST_DOMINATE","CONDITION")
          val Out: Array[String] = Array("CFG","CAPTURE","DOMINATE","POST_DOMINATE","CDG","REF","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[MethodRefDb] {
          override val forLabel = MethodRef.Label

          override def createNode(ref: NodeRef[MethodRefDb]) =
            new MethodRefDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = MethodRef(graph, id)
        }
      }
      
trait MethodRefBase extends Node with ExpressionBase with HasCode with HasOrder with HasArgumentIndex with HasMethodInstFullName with HasMethodFullName with HasLineNumber with HasColumnNumber with HasDepthFirstOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "code" 
case 2 => "order" 
case 3 => "argumentIndex" 
case 4 => "methodInstFullName" 
case 5 => "methodFullName" 
case 6 => "lineNumber" 
case 7 => "columnNumber" 
case 8 => "depthFirstOrder" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => code
case 2 => order
case 3 => argumentIndex
case 4 => methodInstFullName
case 5 => methodFullName
case 6 => lineNumber
case 7 => columnNumber
case 8 => depthFirstOrder
      }

  override def productPrefix = "MethodRef"
  override def productArity = 8 + 1 // add one for id, leaving out `_graph`
  
}
class MethodRef(graph: OdbGraph, id: Long) extends NodeRef[MethodRefDb](graph, id) with MethodRefBase with StoredNode with Expression {
override def code = get().code
override def order = get().order
override def argumentIndex = get().argumentIndex
override def methodInstFullName = get().methodInstFullName
override def methodFullName = get().methodFullName
override def lineNumber = get().lineNumber
override def columnNumber = get().columnNumber
override def depthFirstOrder = get().depthFirstOrder

override def _cfgOut(): JIterator[StoredNode] = get()._cfgOut()
override def _captureOut(): JIterator[StoredNode] = get()._captureOut()
override def _dominateOut(): JIterator[StoredNode] = get()._dominateOut()
override def _postDominateOut(): JIterator[StoredNode] = get()._postDominateOut()
override def _cdgOut(): JIterator[StoredNode] = get()._cdgOut()
override def _refOut(): JIterator[StoredNode] = get()._refOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _receiverIn(): JIterator[StoredNode] = get()._receiverIn()
override def _cdgIn(): JIterator[StoredNode] = get()._cdgIn()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _containsIn(): JIterator[StoredNode] = get()._containsIn()
override def _cfgIn(): JIterator[StoredNode] = get()._cfgIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
override def _dominateIn(): JIterator[StoredNode] = get()._dominateIn()
override def _postDominateIn(): JIterator[StoredNode] = get()._postDominateIn()
override def _conditionIn(): JIterator[StoredNode] = get()._conditionIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MethodRef.Label
  }
}
      class MethodRefDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with Expression with MethodRefBase {

        override def layoutInformation: NodeLayoutInformation = MethodRef.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (order != null) { properties.put("ORDER", order) }
if (argumentIndex != null) { properties.put("ARGUMENT_INDEX", argumentIndex) }
methodInstFullName.map { value => properties.put("METHOD_INST_FULL_NAME", value) }
if (methodFullName != null) { properties.put("METHOD_FULL_NAME", methodFullName) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
  properties
}

        private var _code: String = null
def code(): String = _code

private var _order: Integer = null
def order(): Integer = _order

private var _argumentIndex: Integer = null
def argumentIndex(): Integer = _argumentIndex

private var _methodInstFullName: Option[String] = None
def methodInstFullName(): Option[String] = _methodInstFullName

private var _methodFullName: String = null
def methodFullName(): String = _methodFullName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder
override def _cfgOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _captureOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _dominateOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _postDominateOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _cdgOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _refOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
override def _receiverIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
override def _cdgIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]
override def _containsIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(10).asInstanceOf[JIterator[StoredNode]]
override def _cfgIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(11).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(12).asInstanceOf[JIterator[StoredNode]]
override def _dominateIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(13).asInstanceOf[JIterator[StoredNode]]
override def _postDominateIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(14).asInstanceOf[JIterator[StoredNode]]
override def _conditionIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(15).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          MethodRef.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MethodRefDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          MethodRef.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          MethodRef.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else  if (key == "ARGUMENT_INDEX") this._argumentIndex = value.asInstanceOf[Integer] 
 else  if (key == "METHOD_INST_FULL_NAME") this._methodInstFullName = Option(value).asInstanceOf[Option[String]] 
 else  if (key == "METHOD_FULL_NAME") this._methodFullName = value.asInstanceOf[String] 
 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = Option(value).asInstanceOf[Option[Integer]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "CODE") this._code = null 
 else  if (key == "ORDER") this._order = null 
 else  if (key == "ARGUMENT_INDEX") this._argumentIndex = null 
 else  if (key == "METHOD_INST_FULL_NAME") this._methodInstFullName = null 
 else  if (key == "METHOD_FULL_NAME") this._methodFullName = null 
 else  if (key == "LINE_NUMBER") this._lineNumber = null 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = null 
 else  if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//METHOD_REF END


//METHOD_RETURN BEGIN

      object MethodReturn {

        def apply(graph: OdbGraph, id: Long) = new MethodReturn(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.TaggedBy.layoutInformation, edges.DynamicType.layoutInformation, edges.PostDominate.layoutInformation, edges.EvalType.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.ReachingDef.layoutInformation, edges.Propagate.layoutInformation, edges.ContainsNode.layoutInformation, edges.Cfg.layoutInformation, edges.Ast.layoutInformation, edges.Dominate.layoutInformation).asJava)

        val Label = "METHOD_RETURN"
        object Keys {
          val Code = "CODE" 
val EvaluationStrategy = "EVALUATION_STRATEGY" 
val TypeFullName = "TYPE_FULL_NAME" 
val DynamicTypeHintFullName = "DYNAMIC_TYPE_HINT_FULL_NAME" 
val LineNumber = "LINE_NUMBER" 
val ColumnNumber = "COLUMN_NUMBER" 
val Order = "ORDER" 
val DepthFirstOrder = "DEPTH_FIRST_ORDER" 
          val All: JSet[String] = Set(Code, EvaluationStrategy, TypeFullName, DynamicTypeHintFullName, LineNumber, ColumnNumber, Order, DepthFirstOrder).asJava
            val KeyToValue: Map[String, MethodReturnDb => Any] = Map(
               "CODE" -> { instance: MethodReturnDb => instance.code},
 "EVALUATION_STRATEGY" -> { instance: MethodReturnDb => instance.evaluationStrategy},
 "TYPE_FULL_NAME" -> { instance: MethodReturnDb => instance.typeFullName},
 "DYNAMIC_TYPE_HINT_FULL_NAME" -> { instance: MethodReturnDb => instance.dynamicTypeHintFullName},
 "LINE_NUMBER" -> { instance: MethodReturnDb => instance.lineNumber.orNull},
 "COLUMN_NUMBER" -> { instance: MethodReturnDb => instance.columnNumber.orNull},
 "ORDER" -> { instance: MethodReturnDb => instance.order},
 "DEPTH_FIRST_ORDER" -> { instance: MethodReturnDb => instance.depthFirstOrder.orNull}
            )
          }
        object Edges {
          val In: Array[String] = Array("REACHING_DEF","PROPAGATE","CONTAINS_NODE","CFG","AST","DOMINATE")
          val Out: Array[String] = Array("TAGGED_BY","DYNAMIC_TYPE","POST_DOMINATE","EVAL_TYPE","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[MethodReturnDb] {
          override val forLabel = MethodReturn.Label

          override def createNode(ref: NodeRef[MethodReturnDb]) =
            new MethodReturnDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = MethodReturn(graph, id)
        }
      }
      
trait MethodReturnBase extends Node with CfgNodeBase with TrackingPointBase with HasCode with HasEvaluationStrategy with HasTypeFullName with HasDynamicTypeHintFullName with HasLineNumber with HasColumnNumber with HasOrder with HasDepthFirstOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "code" 
case 2 => "evaluationStrategy" 
case 3 => "typeFullName" 
case 4 => "dynamicTypeHintFullName" 
case 5 => "lineNumber" 
case 6 => "columnNumber" 
case 7 => "order" 
case 8 => "depthFirstOrder" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => code
case 2 => evaluationStrategy
case 3 => typeFullName
case 4 => dynamicTypeHintFullName
case 5 => lineNumber
case 6 => columnNumber
case 7 => order
case 8 => depthFirstOrder
      }

  override def productPrefix = "MethodReturn"
  override def productArity = 8 + 1 // add one for id, leaving out `_graph`
  
}
class MethodReturn(graph: OdbGraph, id: Long) extends NodeRef[MethodReturnDb](graph, id) with MethodReturnBase with StoredNode with CfgNode with TrackingPoint {
override def code = get().code
override def evaluationStrategy = get().evaluationStrategy
override def typeFullName = get().typeFullName
override def dynamicTypeHintFullName = get().dynamicTypeHintFullName
override def lineNumber = get().lineNumber
override def columnNumber = get().columnNumber
override def order = get().order
override def depthFirstOrder = get().depthFirstOrder

override def _taggedByOut(): JIterator[StoredNode] = get()._taggedByOut()
override def _dynamicTypeOut(): JIterator[StoredNode] = get()._dynamicTypeOut()
override def _postDominateOut(): JIterator[StoredNode] = get()._postDominateOut()
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _reachingDefIn(): JIterator[StoredNode] = get()._reachingDefIn()
override def _propagateIn(): JIterator[StoredNode] = get()._propagateIn()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _cfgIn(): JIterator[StoredNode] = get()._cfgIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
override def _dominateIn(): JIterator[StoredNode] = get()._dominateIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MethodReturn.Label
  }
}
      class MethodReturnDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with CfgNode with TrackingPoint with MethodReturnBase {

        override def layoutInformation: NodeLayoutInformation = MethodReturn.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (evaluationStrategy != null) { properties.put("EVALUATION_STRATEGY", evaluationStrategy) }
if (typeFullName != null) { properties.put("TYPE_FULL_NAME", typeFullName) }
if (dynamicTypeHintFullName.nonEmpty) { properties.put("DYNAMIC_TYPE_HINT_FULL_NAME", dynamicTypeHintFullName.asJava) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
if (order != null) { properties.put("ORDER", order) }
depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
  properties
}

        private var _code: String = null
def code(): String = _code

private var _evaluationStrategy: String = null
def evaluationStrategy(): String = _evaluationStrategy

private var _typeFullName: String = null
def typeFullName(): String = _typeFullName

private var _dynamicTypeHintFullName: List[String] = Nil
def dynamicTypeHintFullName(): List[String] = _dynamicTypeHintFullName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _order: Integer = null
def order(): Integer = _order

private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder
override def _taggedByOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _dynamicTypeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _postDominateOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _evalTypeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _reachingDefIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
override def _propagateIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
override def _cfgIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]
override def _dominateIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(10).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          MethodReturn.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MethodReturnDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          MethodReturn.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          MethodReturn.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "EVALUATION_STRATEGY") this._evaluationStrategy = value.asInstanceOf[String] 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = value.asInstanceOf[String] 
 else if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") {
                    if (cardinality == VertexProperty.Cardinality.list) {
                      if (this._dynamicTypeHintFullName == null) { this._dynamicTypeHintFullName = Nil }
                      this._dynamicTypeHintFullName = this._dynamicTypeHintFullName :+ value.asInstanceOf[String]
                    } else {
                      this._dynamicTypeHintFullName = List(value.asInstanceOf[String])
                    }
                  }
              
 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else  if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = Option(value).asInstanceOf[Option[Integer]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "CODE") this._code = null 
 else  if (key == "EVALUATION_STRATEGY") this._evaluationStrategy = null 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = null 
 else  if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") this._dynamicTypeHintFullName = null 
 else  if (key == "LINE_NUMBER") this._lineNumber = null 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = null 
 else  if (key == "ORDER") this._order = null 
 else  if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//METHOD_RETURN END


//METHOD_SUMMARY BEGIN

      object MethodSummary {

        def apply(graph: OdbGraph, id: Long) = new MethodSummary(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "METHOD_SUMMARY"
        object Keys {
          val IsStatic = "IS_STATIC" 
val IsExternal = "IS_EXTERNAL" 
val BinarySignature = "BINARY_SIGNATURE" 
          val All: JSet[String] = Set(IsStatic, IsExternal, BinarySignature).asJava
            val KeyToValue: Map[String, MethodSummaryDb => Any] = Map(
               "IS_STATIC" -> { instance: MethodSummaryDb => instance.isStatic},
 "IS_EXTERNAL" -> { instance: MethodSummaryDb => instance.isExternal},
 "BINARY_SIGNATURE" -> { instance: MethodSummaryDb => instance.binarySignature.orNull}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[MethodSummaryDb] {
          override val forLabel = MethodSummary.Label

          override def createNode(ref: NodeRef[MethodSummaryDb]) =
            new MethodSummaryDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = MethodSummary(graph, id)
        }
      }
      
trait MethodSummaryBase extends Node  with HasIsStatic with HasIsExternal with HasBinarySignature {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def method: MethodBase
def parameters: List[MethodParameterInBase]
def outParameters: List[MethodParameterOutBase]
def returnParameter: MethodReturnBase
def paramTypes: List[TypeBase]
def returnParameterType: TypeBase
def tags: List[TagBase]
def paramTags: List[TagsBase]
def outParamTags: List[TagsBase]
def returnParamTags: List[TagBase]
def annotationParameters: List[SpAnnotationParameterBase]
def modifiers: List[ModifierBase]
def routes: List[RouteBase]

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "isStatic" 
case 2 => "isExternal" 
case 3 => "binarySignature" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => isStatic
case 2 => isExternal
case 3 => binarySignature
      }

  override def productPrefix = "MethodSummary"
  override def productArity = 3 + 1 // add one for id, leaving out `_graph`
  
}
class MethodSummary(graph: OdbGraph, id: Long) extends NodeRef[MethodSummaryDb](graph, id) with MethodSummaryBase with StoredNode  {
override def isStatic = get().isStatic
override def isExternal = get().isExternal
override def binarySignature = get().binarySignature
def method = get().method
def parameters = get().parameters
def outParameters = get().outParameters
def returnParameter = get().returnParameter
def paramTypes = get().paramTypes
def returnParameterType = get().returnParameterType
def tags = get().tags
def paramTags = get().paramTags
def outParamTags = get().outParamTags
def returnParamTags = get().returnParamTags
def annotationParameters = get().annotationParameters
def modifiers = get().modifiers
def routes = get().routes
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MethodSummary.Label
  }
}
      class MethodSummaryDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with MethodSummaryBase {

        override def layoutInformation: NodeLayoutInformation = MethodSummary.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (isStatic != null) { properties.put("IS_STATIC", isStatic) }
if (isExternal != null) { properties.put("IS_EXTERNAL", isExternal) }
binarySignature.map { value => properties.put("BINARY_SIGNATURE", value) }
  properties
}

        private var _isStatic: JBoolean = null
def isStatic(): JBoolean = _isStatic

private var _isExternal: JBoolean = null
def isExternal(): JBoolean = _isExternal

private var _binarySignature: Option[String] = None
def binarySignature(): Option[String] = _binarySignature
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          MethodSummary.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MethodSummaryDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          MethodSummary.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          MethodSummary.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "IS_STATIC") this._isStatic = value.asInstanceOf[JBoolean] 
 else  if (key == "IS_EXTERNAL") this._isExternal = value.asInstanceOf[JBoolean] 
 else  if (key == "BINARY_SIGNATURE") this._binarySignature = Option(value).asInstanceOf[Option[String]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "IS_STATIC") this._isStatic = null 
 else  if (key == "IS_EXTERNAL") this._isExternal = null 
 else  if (key == "BINARY_SIGNATURE") this._binarySignature = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type Method */
              lazy val method: Method =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "method").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Method])
                  .head
              

              /** link to 'contained' node of type MethodParameterIn */
              lazy val parameters: List[MethodParameterIn] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "parameters").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[MethodParameterIn])
                  .toList
              

              /** link to 'contained' node of type MethodParameterOut */
              lazy val outParameters: List[MethodParameterOut] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "outParameters").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[MethodParameterOut])
                  .toList
              

              /** link to 'contained' node of type MethodReturn */
              lazy val returnParameter: MethodReturn =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "returnParameter").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[MethodReturn])
                  .head
              

              /** link to 'contained' node of type Type */
              lazy val paramTypes: List[Type] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "paramTypes").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Type])
                  .toList
              

              /** link to 'contained' node of type Type */
              lazy val returnParameterType: Type =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "returnParameterType").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Type])
                  .head
              

              /** link to 'contained' node of type Tag */
              lazy val tags: List[Tag] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "tags").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Tag])
                  .toList
              

              /** link to 'contained' node of type Tags */
              lazy val paramTags: List[Tags] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "paramTags").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Tags])
                  .toList
              

              /** link to 'contained' node of type Tags */
              lazy val outParamTags: List[Tags] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "outParamTags").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Tags])
                  .toList
              

              /** link to 'contained' node of type Tag */
              lazy val returnParamTags: List[Tag] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "returnParamTags").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Tag])
                  .toList
              

              /** link to 'contained' node of type SpAnnotationParameter */
              lazy val annotationParameters: List[SpAnnotationParameter] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "annotationParameters").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[SpAnnotationParameter])
                  .toList
              

              /** link to 'contained' node of type Modifier */
              lazy val modifiers: List[Modifier] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "modifiers").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Modifier])
                  .toList
              

              /** link to 'contained' node of type Route */
              lazy val routes: List[Route] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "routes").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Route])
                  .toList
              
      }
      
//METHOD_SUMMARY END


//MODIFIER BEGIN

      object Modifier {

        def apply(graph: OdbGraph, id: Long) = new Modifier(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation, edges.Ast.layoutInformation).asJava)

        val Label = "MODIFIER"
        object Keys {
          val ModifierType = "MODIFIER_TYPE" 
val Order = "ORDER" 
          val All: JSet[String] = Set(ModifierType, Order).asJava
            val KeyToValue: Map[String, ModifierDb => Any] = Map(
               "MODIFIER_TYPE" -> { instance: ModifierDb => instance.modifierType},
 "ORDER" -> { instance: ModifierDb => instance.order}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE","AST")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[ModifierDb] {
          override val forLabel = Modifier.Label

          override def createNode(ref: NodeRef[ModifierDb]) =
            new ModifierDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Modifier(graph, id)
        }
      }
      
trait ModifierBase extends Node with AstNodeBase with HasModifierType with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "modifierType" 
case 2 => "order" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => modifierType
case 2 => order
      }

  override def productPrefix = "Modifier"
  override def productArity = 2 + 1 // add one for id, leaving out `_graph`
  
}
class Modifier(graph: OdbGraph, id: Long) extends NodeRef[ModifierDb](graph, id) with ModifierBase with StoredNode with AstNode {
override def modifierType = get().modifierType
override def order = get().order

override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Modifier.Label
  }
}
      class ModifierDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with AstNode with ModifierBase {

        override def layoutInformation: NodeLayoutInformation = Modifier.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (modifierType != null) { properties.put("MODIFIER_TYPE", modifierType) }
if (order != null) { properties.put("ORDER", order) }
  properties
}

        private var _modifierType: String = null
def modifierType(): String = _modifierType

private var _order: Integer = null
def order(): Integer = _order
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Modifier.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ModifierDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Modifier.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Modifier.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "MODIFIER_TYPE") this._modifierType = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "MODIFIER_TYPE") this._modifierType = null 
 else  if (key == "ORDER") this._order = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//MODIFIER END


//NAMESPACE BEGIN

      object Namespace {

        def apply(graph: OdbGraph, id: Long) = new Namespace(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.Ref.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

        val Label = "NAMESPACE"
        object Keys {
          val Name = "NAME" 
val Order = "ORDER" 
          val All: JSet[String] = Set(Name, Order).asJava
            val KeyToValue: Map[String, NamespaceDb => Any] = Map(
               "NAME" -> { instance: NamespaceDb => instance.name},
 "ORDER" -> { instance: NamespaceDb => instance.order}
            )
          }
        object Edges {
          val In: Array[String] = Array("REF","CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[NamespaceDb] {
          override val forLabel = Namespace.Label

          override def createNode(ref: NodeRef[NamespaceDb]) =
            new NamespaceDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Namespace(graph, id)
        }
      }
      
trait NamespaceBase extends Node with AstNodeBase with HasName with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "name" 
case 2 => "order" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => name
case 2 => order
      }

  override def productPrefix = "Namespace"
  override def productArity = 2 + 1 // add one for id, leaving out `_graph`
  
}
class Namespace(graph: OdbGraph, id: Long) extends NodeRef[NamespaceDb](graph, id) with NamespaceBase with StoredNode with AstNode {
override def name = get().name
override def order = get().order

override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _refIn(): JIterator[StoredNode] = get()._refIn()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Namespace.Label
  }
}
      class NamespaceDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with AstNode with NamespaceBase {

        override def layoutInformation: NodeLayoutInformation = Namespace.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
if (order != null) { properties.put("ORDER", order) }
  properties
}

        private var _name: String = null
def name(): String = _name

private var _order: Integer = null
def order(): Integer = _order
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _refIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Namespace.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[NamespaceDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Namespace.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Namespace.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "NAME") this._name = null 
 else  if (key == "ORDER") this._order = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//NAMESPACE END


//NAMESPACE_BLOCK BEGIN

      object NamespaceBlock {

        def apply(graph: OdbGraph, id: Long) = new NamespaceBlock(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Ast.layoutInformation, edges.Ref.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation, edges.Ast.layoutInformation).asJava)

        val Label = "NAMESPACE_BLOCK"
        object Keys {
          val Name = "NAME" 
val FullName = "FULL_NAME" 
val Order = "ORDER" 
          val All: JSet[String] = Set(Name, FullName, Order).asJava
            val KeyToValue: Map[String, NamespaceBlockDb => Any] = Map(
               "NAME" -> { instance: NamespaceBlockDb => instance.name},
 "FULL_NAME" -> { instance: NamespaceBlockDb => instance.fullName},
 "ORDER" -> { instance: NamespaceBlockDb => instance.order}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE","AST")
          val Out: Array[String] = Array("AST","REF","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[NamespaceBlockDb] {
          override val forLabel = NamespaceBlock.Label

          override def createNode(ref: NodeRef[NamespaceBlockDb]) =
            new NamespaceBlockDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = NamespaceBlock(graph, id)
        }
      }
      
trait NamespaceBlockBase extends Node with AstNodeBase with HasName with HasFullName with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "name" 
case 2 => "fullName" 
case 3 => "order" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => name
case 2 => fullName
case 3 => order
      }

  override def productPrefix = "NamespaceBlock"
  override def productArity = 3 + 1 // add one for id, leaving out `_graph`
  
}
class NamespaceBlock(graph: OdbGraph, id: Long) extends NodeRef[NamespaceBlockDb](graph, id) with NamespaceBlockBase with StoredNode with AstNode {
override def name = get().name
override def fullName = get().fullName
override def order = get().order

override def _astOut(): JIterator[StoredNode] = get()._astOut()
override def _refOut(): JIterator[StoredNode] = get()._refOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    NamespaceBlock.Label
  }
}
      class NamespaceBlockDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with AstNode with NamespaceBlockBase {

        override def layoutInformation: NodeLayoutInformation = NamespaceBlock.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
if (fullName != null) { properties.put("FULL_NAME", fullName) }
if (order != null) { properties.put("ORDER", order) }
  properties
}

        private var _name: String = null
def name(): String = _name

private var _fullName: String = null
def fullName(): String = _fullName

private var _order: Integer = null
def order(): Integer = _order
override def _astOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _refOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          NamespaceBlock.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[NamespaceBlockDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          NamespaceBlock.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          NamespaceBlock.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "FULL_NAME") this._fullName = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "NAME") this._name = null 
 else  if (key == "FULL_NAME") this._fullName = null 
 else  if (key == "ORDER") this._order = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//NAMESPACE_BLOCK END


//PROGRAM_POINT BEGIN

      object ProgramPoint {

        def apply(graph: OdbGraph, id: Long) = new ProgramPoint(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "PROGRAM_POINT"
        object Keys {
          
          val All: JSet[String] = Set().asJava
            val KeyToValue: Map[String, ProgramPointDb => Any] = Map(
              
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[ProgramPointDb] {
          override val forLabel = ProgramPoint.Label

          override def createNode(ref: NodeRef[ProgramPointDb]) =
            new ProgramPointDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = ProgramPoint(graph, id)
        }
      }
      
trait ProgramPointBase extends Node   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def elem: TrackingPointBase
def method: Option[MethodBase]
def methodTags: List[TagBase]
def paramTags: List[TagBase]

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        
      }

  override def productPrefix = "ProgramPoint"
  override def productArity = 0 + 1 // add one for id, leaving out `_graph`
  
}
class ProgramPoint(graph: OdbGraph, id: Long) extends NodeRef[ProgramPointDb](graph, id) with ProgramPointBase with StoredNode  {

def elem = get().elem
def method = get().method
def methodTags = get().methodTags
def paramTags = get().paramTags
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    ProgramPoint.Label
  }
}
      class ProgramPointDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with ProgramPointBase {

        override def layoutInformation: NodeLayoutInformation = ProgramPoint.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  
  properties
}

        
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          ProgramPoint.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ProgramPointDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          ProgramPoint.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          ProgramPoint.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
          PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
          throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type TrackingPoint */
              lazy val elem: TrackingPoint =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "elem").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[TrackingPoint])
                  .head
              

              /** link to 'contained' node of type Method */
              lazy val method: Option[Method] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "method").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Method])
                  .headOption
              

              /** link to 'contained' node of type Tag */
              lazy val methodTags: List[Tag] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "methodTags").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Tag])
                  .toList
              

              /** link to 'contained' node of type Tag */
              lazy val paramTags: List[Tag] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "paramTags").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Tag])
                  .toList
              
      }
      
//PROGRAM_POINT END


//READ BEGIN

      object Read {

        def apply(graph: OdbGraph, id: Long) = new Read(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "READ"
        object Keys {
          
          val All: JSet[String] = Set().asJava
            val KeyToValue: Map[String, ReadDb => Any] = Map(
              
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[ReadDb] {
          override val forLabel = Read.Label

          override def createNode(ref: NodeRef[ReadDb]) =
            new ReadDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Read(graph, id)
        }
      }
      
trait ReadBase extends Node   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def triggerCallChains: List[CallChainBase]
def descriptorFlows: List[FlowBase]
def source: SourceBase

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        
      }

  override def productPrefix = "Read"
  override def productArity = 0 + 1 // add one for id, leaving out `_graph`
  
}
class Read(graph: OdbGraph, id: Long) extends NodeRef[ReadDb](graph, id) with ReadBase with StoredNode  {

def triggerCallChains = get().triggerCallChains
def descriptorFlows = get().descriptorFlows
def source = get().source
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Read.Label
  }
}
      class ReadDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with ReadBase {

        override def layoutInformation: NodeLayoutInformation = Read.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  
  properties
}

        
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Read.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ReadDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Read.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Read.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
          PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
          throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type CallChain */
              lazy val triggerCallChains: List[CallChain] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "triggerCallChains").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[CallChain])
                  .toList
              

              /** link to 'contained' node of type Flow */
              lazy val descriptorFlows: List[Flow] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "descriptorFlows").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Flow])
                  .toList
              

              /** link to 'contained' node of type Source */
              lazy val source: Source =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "source").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Source])
                  .head
              
      }
      
//READ END


//RETURN BEGIN

      object Return {

        def apply(graph: OdbGraph, id: Long) = new Return(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Ast.layoutInformation, edges.Cfg.layoutInformation, edges.Dominate.layoutInformation, edges.PostDominate.layoutInformation, edges.ReachingDef.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.Cdg.layoutInformation, edges.ReachingDef.layoutInformation, edges.ContainsNode.layoutInformation, edges.Contains.layoutInformation, edges.Cfg.layoutInformation, edges.Ast.layoutInformation, edges.Dominate.layoutInformation, edges.PostDominate.layoutInformation, edges.Condition.layoutInformation).asJava)

        val Label = "RETURN"
        object Keys {
          val LineNumber = "LINE_NUMBER" 
val ColumnNumber = "COLUMN_NUMBER" 
val Order = "ORDER" 
val ArgumentIndex = "ARGUMENT_INDEX" 
val Code = "CODE" 
val DepthFirstOrder = "DEPTH_FIRST_ORDER" 
          val All: JSet[String] = Set(LineNumber, ColumnNumber, Order, ArgumentIndex, Code, DepthFirstOrder).asJava
            val KeyToValue: Map[String, ReturnDb => Any] = Map(
               "LINE_NUMBER" -> { instance: ReturnDb => instance.lineNumber.orNull},
 "COLUMN_NUMBER" -> { instance: ReturnDb => instance.columnNumber.orNull},
 "ORDER" -> { instance: ReturnDb => instance.order},
 "ARGUMENT_INDEX" -> { instance: ReturnDb => instance.argumentIndex},
 "CODE" -> { instance: ReturnDb => instance.code},
 "DEPTH_FIRST_ORDER" -> { instance: ReturnDb => instance.depthFirstOrder.orNull}
            )
          }
        object Edges {
          val In: Array[String] = Array("CDG","REACHING_DEF","CONTAINS_NODE","CONTAINS","CFG","AST","DOMINATE","POST_DOMINATE","CONDITION")
          val Out: Array[String] = Array("AST","CFG","DOMINATE","POST_DOMINATE","REACHING_DEF","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[ReturnDb] {
          override val forLabel = Return.Label

          override def createNode(ref: NodeRef[ReturnDb]) =
            new ReturnDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Return(graph, id)
        }
      }
      
trait ReturnBase extends Node with ExpressionBase with HasLineNumber with HasColumnNumber with HasOrder with HasArgumentIndex with HasCode with HasDepthFirstOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "lineNumber" 
case 2 => "columnNumber" 
case 3 => "order" 
case 4 => "argumentIndex" 
case 5 => "code" 
case 6 => "depthFirstOrder" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => lineNumber
case 2 => columnNumber
case 3 => order
case 4 => argumentIndex
case 5 => code
case 6 => depthFirstOrder
      }

  override def productPrefix = "Return"
  override def productArity = 6 + 1 // add one for id, leaving out `_graph`
  
}
class Return(graph: OdbGraph, id: Long) extends NodeRef[ReturnDb](graph, id) with ReturnBase with StoredNode with Expression {
override def lineNumber = get().lineNumber
override def columnNumber = get().columnNumber
override def order = get().order
override def argumentIndex = get().argumentIndex
override def code = get().code
override def depthFirstOrder = get().depthFirstOrder

override def _astOut(): JIterator[StoredNode] = get()._astOut()
override def _cfgOut(): JIterator[StoredNode] = get()._cfgOut()
override def _dominateOut(): JIterator[StoredNode] = get()._dominateOut()
override def _postDominateOut(): JIterator[StoredNode] = get()._postDominateOut()
override def _reachingDefOut(): JIterator[StoredNode] = get()._reachingDefOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _cdgIn(): JIterator[StoredNode] = get()._cdgIn()
override def _reachingDefIn(): JIterator[StoredNode] = get()._reachingDefIn()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _containsIn(): JIterator[StoredNode] = get()._containsIn()
override def _cfgIn(): JIterator[StoredNode] = get()._cfgIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
override def _dominateIn(): JIterator[StoredNode] = get()._dominateIn()
override def _postDominateIn(): JIterator[StoredNode] = get()._postDominateIn()
override def _conditionIn(): JIterator[StoredNode] = get()._conditionIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Return.Label
  }
}
      class ReturnDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with Expression with ReturnBase {

        override def layoutInformation: NodeLayoutInformation = Return.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
if (order != null) { properties.put("ORDER", order) }
if (argumentIndex != null) { properties.put("ARGUMENT_INDEX", argumentIndex) }
if (code != null) { properties.put("CODE", code) }
depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
  properties
}

        private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _order: Integer = null
def order(): Integer = _order

private var _argumentIndex: Integer = null
def argumentIndex(): Integer = _argumentIndex

private var _code: String = null
def code(): String = _code

private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder
override def _astOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _cfgOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _dominateOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _postDominateOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _reachingDefOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
override def _cdgIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
override def _reachingDefIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
override def _containsIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]
override def _cfgIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(10).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(11).asInstanceOf[JIterator[StoredNode]]
override def _dominateIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(12).asInstanceOf[JIterator[StoredNode]]
override def _postDominateIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(13).asInstanceOf[JIterator[StoredNode]]
override def _conditionIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(14).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Return.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ReturnDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Return.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Return.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else  if (key == "ARGUMENT_INDEX") this._argumentIndex = value.asInstanceOf[Integer] 
 else  if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = Option(value).asInstanceOf[Option[Integer]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "LINE_NUMBER") this._lineNumber = null 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = null 
 else  if (key == "ORDER") this._order = null 
 else  if (key == "ARGUMENT_INDEX") this._argumentIndex = null 
 else  if (key == "CODE") this._code = null 
 else  if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//RETURN END


//ROUTE BEGIN

      object Route {

        def apply(graph: OdbGraph, id: Long) = new Route(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "ROUTE"
        object Keys {
          val Path = "PATH" 
          val All: JSet[String] = Set(Path).asJava
            val KeyToValue: Map[String, RouteDb => Any] = Map(
               "PATH" -> { instance: RouteDb => instance.path}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[RouteDb] {
          override val forLabel = Route.Label

          override def createNode(ref: NodeRef[RouteDb]) =
            new RouteDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Route(graph, id)
        }
      }
      
trait RouteBase extends Node  with HasPath {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "path" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => path
      }

  override def productPrefix = "Route"
  override def productArity = 1 + 1 // add one for id, leaving out `_graph`
  
}
class Route(graph: OdbGraph, id: Long) extends NodeRef[RouteDb](graph, id) with RouteBase with StoredNode  {
override def path = get().path

override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Route.Label
  }
}
      class RouteDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with RouteBase {

        override def layoutInformation: NodeLayoutInformation = Route.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (path != null) { properties.put("PATH", path) }
  properties
}

        private var _path: String = null
def path(): String = _path
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Route.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[RouteDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Route.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Route.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "PATH") this._path = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "PATH") this._path = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//ROUTE END


//SENSITIVE_DATA_TYPE BEGIN

      object SensitiveDataType {

        def apply(graph: OdbGraph, id: Long) = new SensitiveDataType(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.IsSensitiveDataDescrOf.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation, edges.IsSensitiveDataOfType.layoutInformation).asJava)

        val Label = "SENSITIVE_DATA_TYPE"
        object Keys {
          val FullName = "FULL_NAME" 
          val All: JSet[String] = Set(FullName).asJava
            val KeyToValue: Map[String, SensitiveDataTypeDb => Any] = Map(
               "FULL_NAME" -> { instance: SensitiveDataTypeDb => instance.fullName}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE","IS_SENSITIVE_DATA_OF_TYPE")
          val Out: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[SensitiveDataTypeDb] {
          override val forLabel = SensitiveDataType.Label

          override def createNode(ref: NodeRef[SensitiveDataTypeDb]) =
            new SensitiveDataTypeDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = SensitiveDataType(graph, id)
        }
      }
      
trait SensitiveDataTypeBase extends Node  with HasFullName {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def names: List[MatchInfoBase]
def members: List[SensitiveMemberBase]

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "fullName" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => fullName
      }

  override def productPrefix = "SensitiveDataType"
  override def productArity = 1 + 1 // add one for id, leaving out `_graph`
  
}
class SensitiveDataType(graph: OdbGraph, id: Long) extends NodeRef[SensitiveDataTypeDb](graph, id) with SensitiveDataTypeBase with StoredNode  {
override def fullName = get().fullName
def names = get().names
def members = get().members
override def _isSensitiveDataDescrOfOut(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _isSensitiveDataOfTypeIn(): JIterator[StoredNode] = get()._isSensitiveDataOfTypeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    SensitiveDataType.Label
  }
}
      class SensitiveDataTypeDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with SensitiveDataTypeBase {

        override def layoutInformation: NodeLayoutInformation = SensitiveDataType.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (fullName != null) { properties.put("FULL_NAME", fullName) }
  properties
}

        private var _fullName: String = null
def fullName(): String = _fullName
override def _isSensitiveDataDescrOfOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _isSensitiveDataOfTypeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          SensitiveDataType.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SensitiveDataTypeDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          SensitiveDataType.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          SensitiveDataType.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "FULL_NAME") this._fullName = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "FULL_NAME") this._fullName = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type MatchInfo */
              lazy val names: List[MatchInfo] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "names").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[MatchInfo])
                  .toList
              

              /** link to 'contained' node of type SensitiveMember */
              lazy val members: List[SensitiveMember] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "members").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[SensitiveMember])
                  .toList
              
      }
      
//SENSITIVE_DATA_TYPE END


//SENSITIVE_MEMBER BEGIN

      object SensitiveMember {

        def apply(graph: OdbGraph, id: Long) = new SensitiveMember(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.IsSensitiveDataDescrOf.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "SENSITIVE_MEMBER"
        object Keys {
          val Name = "NAME" 
          val All: JSet[String] = Set(Name).asJava
            val KeyToValue: Map[String, SensitiveMemberDb => Any] = Map(
               "NAME" -> { instance: SensitiveMemberDb => instance.name}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[SensitiveMemberDb] {
          override val forLabel = SensitiveMember.Label

          override def createNode(ref: NodeRef[SensitiveMemberDb]) =
            new SensitiveMemberDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = SensitiveMember(graph, id)
        }
      }
      
trait SensitiveMemberBase extends Node  with HasName {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def names: List[MatchInfoBase]

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "name" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => name
      }

  override def productPrefix = "SensitiveMember"
  override def productArity = 1 + 1 // add one for id, leaving out `_graph`
  
}
class SensitiveMember(graph: OdbGraph, id: Long) extends NodeRef[SensitiveMemberDb](graph, id) with SensitiveMemberBase with StoredNode  {
override def name = get().name
def names = get().names
override def _isSensitiveDataDescrOfOut(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    SensitiveMember.Label
  }
}
      class SensitiveMemberDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with SensitiveMemberBase {

        override def layoutInformation: NodeLayoutInformation = SensitiveMember.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
  properties
}

        private var _name: String = null
def name(): String = _name
override def _isSensitiveDataDescrOfOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          SensitiveMember.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SensitiveMemberDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          SensitiveMember.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          SensitiveMember.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "NAME") this._name = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "NAME") this._name = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type MatchInfo */
              lazy val names: List[MatchInfo] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "names").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[MatchInfo])
                  .toList
              
      }
      
//SENSITIVE_MEMBER END


//SENSITIVE_REFERENCE BEGIN

      object SensitiveReference {

        def apply(graph: OdbGraph, id: Long) = new SensitiveReference(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.IsSensitiveDataDescrOfRef.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation, edges.IsSensitiveDataDescrOfRef.layoutInformation).asJava)

        val Label = "SENSITIVE_REFERENCE"
        object Keys {
          
          val All: JSet[String] = Set().asJava
            val KeyToValue: Map[String, SensitiveReferenceDb => Any] = Map(
              
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE","IS_SENSITIVE_DATA_DESCR_OF_REF")
          val Out: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF_REF","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[SensitiveReferenceDb] {
          override val forLabel = SensitiveReference.Label

          override def createNode(ref: NodeRef[SensitiveReferenceDb]) =
            new SensitiveReferenceDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = SensitiveReference(graph, id)
        }
      }
      
trait SensitiveReferenceBase extends Node   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def ioflows: List[IoflowBase]

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        
      }

  override def productPrefix = "SensitiveReference"
  override def productArity = 0 + 1 // add one for id, leaving out `_graph`
  
}
class SensitiveReference(graph: OdbGraph, id: Long) extends NodeRef[SensitiveReferenceDb](graph, id) with SensitiveReferenceBase with StoredNode  {

def ioflows = get().ioflows
override def _isSensitiveDataDescrOfRefOut(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfRefOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _isSensitiveDataDescrOfRefIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfRefIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    SensitiveReference.Label
  }
}
      class SensitiveReferenceDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with SensitiveReferenceBase {

        override def layoutInformation: NodeLayoutInformation = SensitiveReference.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  
  properties
}

        
override def _isSensitiveDataDescrOfRefOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _isSensitiveDataDescrOfRefIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          SensitiveReference.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SensitiveReferenceDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          SensitiveReference.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          SensitiveReference.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
          PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
          throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type Ioflow */
              lazy val ioflows: List[Ioflow] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "ioflows").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Ioflow])
                  .toList
              
      }
      
//SENSITIVE_REFERENCE END


//SENSITIVE_VARIABLE BEGIN

      object SensitiveVariable {

        def apply(graph: OdbGraph, id: Long) = new SensitiveVariable(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.IsSensitiveDataDescrOf.layoutInformation, edges.IsSensitiveDataDescrOfRef.layoutInformation, edges.IsSensitiveDataOfType.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "SENSITIVE_VARIABLE"
        object Keys {
          val Name = "NAME" 
          val All: JSet[String] = Set(Name).asJava
            val KeyToValue: Map[String, SensitiveVariableDb => Any] = Map(
               "NAME" -> { instance: SensitiveVariableDb => instance.name}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF","IS_SENSITIVE_DATA_DESCR_OF_REF","IS_SENSITIVE_DATA_OF_TYPE","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[SensitiveVariableDb] {
          override val forLabel = SensitiveVariable.Label

          override def createNode(ref: NodeRef[SensitiveVariableDb]) =
            new SensitiveVariableDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = SensitiveVariable(graph, id)
        }
      }
      
trait SensitiveVariableBase extends Node  with HasName {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def names: List[MatchInfoBase]
def evalType: TypeBase

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "name" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => name
      }

  override def productPrefix = "SensitiveVariable"
  override def productArity = 1 + 1 // add one for id, leaving out `_graph`
  
}
class SensitiveVariable(graph: OdbGraph, id: Long) extends NodeRef[SensitiveVariableDb](graph, id) with SensitiveVariableBase with StoredNode  {
override def name = get().name
def names = get().names
def evalType = get().evalType
override def _isSensitiveDataDescrOfOut(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfOut()
override def _isSensitiveDataDescrOfRefOut(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfRefOut()
override def _isSensitiveDataOfTypeOut(): JIterator[StoredNode] = get()._isSensitiveDataOfTypeOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    SensitiveVariable.Label
  }
}
      class SensitiveVariableDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with SensitiveVariableBase {

        override def layoutInformation: NodeLayoutInformation = SensitiveVariable.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
  properties
}

        private var _name: String = null
def name(): String = _name
override def _isSensitiveDataDescrOfOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _isSensitiveDataDescrOfRefOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _isSensitiveDataOfTypeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          SensitiveVariable.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SensitiveVariableDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          SensitiveVariable.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          SensitiveVariable.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "NAME") this._name = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "NAME") this._name = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type MatchInfo */
              lazy val names: List[MatchInfo] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "names").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[MatchInfo])
                  .toList
              

              /** link to 'contained' node of type Type */
              lazy val evalType: Type =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "evalType").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Type])
                  .head
              
      }
      
//SENSITIVE_VARIABLE END


//SINK BEGIN

      object Sink {

        def apply(graph: OdbGraph, id: Long) = new Sink(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "SINK"
        object Keys {
          val SinkType = "SINK_TYPE" 
          val All: JSet[String] = Set(SinkType).asJava
            val KeyToValue: Map[String, SinkDb => Any] = Map(
               "SINK_TYPE" -> { instance: SinkDb => instance.sinkType}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[SinkDb] {
          override val forLabel = Sink.Label

          override def createNode(ref: NodeRef[SinkDb]) =
            new SinkDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Sink(graph, id)
        }
      }
      
trait SinkBase extends Node  with HasSinkType {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def node: TrackingPointBase
def method: MethodBase
def methodTags: List[TagBase]
def callingMethod: Option[MethodBase]
def callsite: Option[CallBase]
def parameterIn: Option[MethodParameterInBase]
def parameterInTags: List[TagBase]

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "sinkType" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => sinkType
      }

  override def productPrefix = "Sink"
  override def productArity = 1 + 1 // add one for id, leaving out `_graph`
  
}
class Sink(graph: OdbGraph, id: Long) extends NodeRef[SinkDb](graph, id) with SinkBase with StoredNode  {
override def sinkType = get().sinkType
def node = get().node
def method = get().method
def methodTags = get().methodTags
def callingMethod = get().callingMethod
def callsite = get().callsite
def parameterIn = get().parameterIn
def parameterInTags = get().parameterInTags
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Sink.Label
  }
}
      class SinkDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with SinkBase {

        override def layoutInformation: NodeLayoutInformation = Sink.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (sinkType != null) { properties.put("SINK_TYPE", sinkType) }
  properties
}

        private var _sinkType: String = null
def sinkType(): String = _sinkType
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Sink.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SinkDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Sink.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Sink.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "SINK_TYPE") this._sinkType = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "SINK_TYPE") this._sinkType = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type TrackingPoint */
              lazy val node: TrackingPoint =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "node").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[TrackingPoint])
                  .head
              

              /** link to 'contained' node of type Method */
              lazy val method: Method =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "method").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Method])
                  .head
              

              /** link to 'contained' node of type Tag */
              lazy val methodTags: List[Tag] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "methodTags").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Tag])
                  .toList
              

              /** link to 'contained' node of type Method */
              lazy val callingMethod: Option[Method] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "callingMethod").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Method])
                  .headOption
              

              /** link to 'contained' node of type Call */
              lazy val callsite: Option[Call] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "callsite").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Call])
                  .headOption
              

              /** link to 'contained' node of type MethodParameterIn */
              lazy val parameterIn: Option[MethodParameterIn] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "parameterIn").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[MethodParameterIn])
                  .headOption
              

              /** link to 'contained' node of type Tag */
              lazy val parameterInTags: List[Tag] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "parameterInTags").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Tag])
                  .toList
              
      }
      
//SINK END


//SOURCE BEGIN

      object Source {

        def apply(graph: OdbGraph, id: Long) = new Source(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "SOURCE"
        object Keys {
          val SourceType = "SOURCE_TYPE" 
          val All: JSet[String] = Set(SourceType).asJava
            val KeyToValue: Map[String, SourceDb => Any] = Map(
               "SOURCE_TYPE" -> { instance: SourceDb => instance.sourceType}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[SourceDb] {
          override val forLabel = Source.Label

          override def createNode(ref: NodeRef[SourceDb]) =
            new SourceDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Source(graph, id)
        }
      }
      
trait SourceBase extends Node  with HasSourceType {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def node: TrackingPointBase
def method: MethodBase
def methodTags: List[TagBase]
def callingMethod: Option[MethodBase]
def callsite: Option[CallBase]
def tags: List[TagBase]
def nodeType: TypeBase

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "sourceType" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => sourceType
      }

  override def productPrefix = "Source"
  override def productArity = 1 + 1 // add one for id, leaving out `_graph`
  
}
class Source(graph: OdbGraph, id: Long) extends NodeRef[SourceDb](graph, id) with SourceBase with StoredNode  {
override def sourceType = get().sourceType
def node = get().node
def method = get().method
def methodTags = get().methodTags
def callingMethod = get().callingMethod
def callsite = get().callsite
def tags = get().tags
def nodeType = get().nodeType
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Source.Label
  }
}
      class SourceDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with SourceBase {

        override def layoutInformation: NodeLayoutInformation = Source.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (sourceType != null) { properties.put("SOURCE_TYPE", sourceType) }
  properties
}

        private var _sourceType: String = null
def sourceType(): String = _sourceType
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Source.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SourceDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Source.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Source.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "SOURCE_TYPE") this._sourceType = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "SOURCE_TYPE") this._sourceType = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type TrackingPoint */
              lazy val node: TrackingPoint =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "node").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[TrackingPoint])
                  .head
              

              /** link to 'contained' node of type Method */
              lazy val method: Method =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "method").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Method])
                  .head
              

              /** link to 'contained' node of type Tag */
              lazy val methodTags: List[Tag] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "methodTags").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Tag])
                  .toList
              

              /** link to 'contained' node of type Method */
              lazy val callingMethod: Option[Method] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "callingMethod").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Method])
                  .headOption
              

              /** link to 'contained' node of type Call */
              lazy val callsite: Option[Call] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "callsite").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Call])
                  .headOption
              

              /** link to 'contained' node of type Tag */
              lazy val tags: List[Tag] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "tags").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Tag])
                  .toList
              

              /** link to 'contained' node of type Type */
              lazy val nodeType: Type =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "nodeType").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Type])
                  .head
              
      }
      
//SOURCE END


//SP_ANNOTATION_PARAMETER BEGIN

      object SpAnnotationParameter {

        def apply(graph: OdbGraph, id: Long) = new SpAnnotationParameter(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "SP_ANNOTATION_PARAMETER"
        object Keys {
          val AnnotationName = "ANNOTATION_NAME" 
val AnnotationFullName = "ANNOTATION_FULL_NAME" 
val Name = "NAME" 
val Value = "VALUE" 
          val All: JSet[String] = Set(AnnotationName, AnnotationFullName, Name, Value).asJava
            val KeyToValue: Map[String, SpAnnotationParameterDb => Any] = Map(
               "ANNOTATION_NAME" -> { instance: SpAnnotationParameterDb => instance.annotationName},
 "ANNOTATION_FULL_NAME" -> { instance: SpAnnotationParameterDb => instance.annotationFullName},
 "NAME" -> { instance: SpAnnotationParameterDb => instance.name},
 "VALUE" -> { instance: SpAnnotationParameterDb => instance.value}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[SpAnnotationParameterDb] {
          override val forLabel = SpAnnotationParameter.Label

          override def createNode(ref: NodeRef[SpAnnotationParameterDb]) =
            new SpAnnotationParameterDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = SpAnnotationParameter(graph, id)
        }
      }
      
trait SpAnnotationParameterBase extends Node  with HasAnnotationName with HasAnnotationFullName with HasName with HasValue {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "annotationName" 
case 2 => "annotationFullName" 
case 3 => "name" 
case 4 => "value" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => annotationName
case 2 => annotationFullName
case 3 => name
case 4 => value
      }

  override def productPrefix = "SpAnnotationParameter"
  override def productArity = 4 + 1 // add one for id, leaving out `_graph`
  
}
class SpAnnotationParameter(graph: OdbGraph, id: Long) extends NodeRef[SpAnnotationParameterDb](graph, id) with SpAnnotationParameterBase with StoredNode  {
override def annotationName = get().annotationName
override def annotationFullName = get().annotationFullName
override def name = get().name
override def value = get().value

override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    SpAnnotationParameter.Label
  }
}
      class SpAnnotationParameterDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with SpAnnotationParameterBase {

        override def layoutInformation: NodeLayoutInformation = SpAnnotationParameter.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (annotationName != null) { properties.put("ANNOTATION_NAME", annotationName) }
if (annotationFullName != null) { properties.put("ANNOTATION_FULL_NAME", annotationFullName) }
if (name != null) { properties.put("NAME", name) }
if (value != null) { properties.put("VALUE", value) }
  properties
}

        private var _annotationName: String = null
def annotationName(): String = _annotationName

private var _annotationFullName: String = null
def annotationFullName(): String = _annotationFullName

private var _name: String = null
def name(): String = _name

private var _value: String = null
def value(): String = _value
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          SpAnnotationParameter.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SpAnnotationParameterDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          SpAnnotationParameter.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          SpAnnotationParameter.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "ANNOTATION_NAME") this._annotationName = value.asInstanceOf[String] 
 else  if (key == "ANNOTATION_FULL_NAME") this._annotationFullName = value.asInstanceOf[String] 
 else  if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "VALUE") this._value = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "ANNOTATION_NAME") this._annotationName = null 
 else  if (key == "ANNOTATION_FULL_NAME") this._annotationFullName = null 
 else  if (key == "NAME") this._name = null 
 else  if (key == "VALUE") this._value = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//SP_ANNOTATION_PARAMETER END


//SP_BLACKLIST BEGIN

      object SpBlacklist {

        def apply(graph: OdbGraph, id: Long) = new SpBlacklist(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "SP_BLACKLIST"
        object Keys {
          
          val All: JSet[String] = Set().asJava
            val KeyToValue: Map[String, SpBlacklistDb => Any] = Map(
              
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[SpBlacklistDb] {
          override val forLabel = SpBlacklist.Label

          override def createNode(ref: NodeRef[SpBlacklistDb]) =
            new SpBlacklistDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = SpBlacklist(graph, id)
        }
      }
      
trait SpBlacklistBase extends Node   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def tags: List[TagBase]

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        
      }

  override def productPrefix = "SpBlacklist"
  override def productArity = 0 + 1 // add one for id, leaving out `_graph`
  
}
class SpBlacklist(graph: OdbGraph, id: Long) extends NodeRef[SpBlacklistDb](graph, id) with SpBlacklistBase with StoredNode  {

def tags = get().tags
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    SpBlacklist.Label
  }
}
      class SpBlacklistDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with SpBlacklistBase {

        override def layoutInformation: NodeLayoutInformation = SpBlacklist.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  
  properties
}

        
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          SpBlacklist.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SpBlacklistDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          SpBlacklist.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          SpBlacklist.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
          PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
          throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type Tag */
              lazy val tags: List[Tag] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "tags").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Tag])
                  .toList
              
      }
      
//SP_BLACKLIST END


//TAG BEGIN

      object Tag {

        def apply(graph: OdbGraph, id: Long) = new Tag(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.TaggedBy.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

        val Label = "TAG"
        object Keys {
          val Name = "NAME" 
val Value = "VALUE" 
          val All: JSet[String] = Set(Name, Value).asJava
            val KeyToValue: Map[String, TagDb => Any] = Map(
               "NAME" -> { instance: TagDb => instance.name},
 "VALUE" -> { instance: TagDb => instance.value}
            )
          }
        object Edges {
          val In: Array[String] = Array("TAGGED_BY","CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[TagDb] {
          override val forLabel = Tag.Label

          override def createNode(ref: NodeRef[TagDb]) =
            new TagDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Tag(graph, id)
        }
      }
      
trait TagBase extends Node  with HasName with HasValue {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "name" 
case 2 => "value" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => name
case 2 => value
      }

  override def productPrefix = "Tag"
  override def productArity = 2 + 1 // add one for id, leaving out `_graph`
  
}
class Tag(graph: OdbGraph, id: Long) extends NodeRef[TagDb](graph, id) with TagBase with StoredNode  {
override def name = get().name
override def value = get().value

override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _taggedByIn(): JIterator[StoredNode] = get()._taggedByIn()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Tag.Label
  }
}
      class TagDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with TagBase {

        override def layoutInformation: NodeLayoutInformation = Tag.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
if (value != null) { properties.put("VALUE", value) }
  properties
}

        private var _name: String = null
def name(): String = _name

private var _value: String = null
def value(): String = _value
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _taggedByIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Tag.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[TagDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Tag.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Tag.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "VALUE") this._value = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "NAME") this._name = null 
 else  if (key == "VALUE") this._value = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//TAG END


//TAGS BEGIN

      object Tags {

        def apply(graph: OdbGraph, id: Long) = new Tags(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "TAGS"
        object Keys {
          
          val All: JSet[String] = Set().asJava
            val KeyToValue: Map[String, TagsDb => Any] = Map(
              
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[TagsDb] {
          override val forLabel = Tags.Label

          override def createNode(ref: NodeRef[TagsDb]) =
            new TagsDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Tags(graph, id)
        }
      }
      
trait TagsBase extends Node   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def tags: List[TagBase]

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        
      }

  override def productPrefix = "Tags"
  override def productArity = 0 + 1 // add one for id, leaving out `_graph`
  
}
class Tags(graph: OdbGraph, id: Long) extends NodeRef[TagsDb](graph, id) with TagsBase with StoredNode  {

def tags = get().tags
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Tags.Label
  }
}
      class TagsDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with TagsBase {

        override def layoutInformation: NodeLayoutInformation = Tags.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  
  properties
}

        
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Tags.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[TagsDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Tags.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Tags.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
          PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
          throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type Tag */
              lazy val tags: List[Tag] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "tags").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Tag])
                  .toList
              
      }
      
//TAGS END


//TAG_NODE_PAIR BEGIN

      object TagNodePair {

        def apply(graph: OdbGraph, id: Long) = new TagNodePair(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "TAG_NODE_PAIR"
        object Keys {
          
          val All: JSet[String] = Set().asJava
            val KeyToValue: Map[String, TagNodePairDb => Any] = Map(
              
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[TagNodePairDb] {
          override val forLabel = TagNodePair.Label

          override def createNode(ref: NodeRef[TagNodePairDb]) =
            new TagNodePairDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = TagNodePair(graph, id)
        }
      }
      
trait TagNodePairBase extends Node   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def tag: TagBase
def node: Node

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        
      }

  override def productPrefix = "TagNodePair"
  override def productArity = 0 + 1 // add one for id, leaving out `_graph`
  
}
class TagNodePair(graph: OdbGraph, id: Long) extends NodeRef[TagNodePairDb](graph, id) with TagNodePairBase with StoredNode  {

def tag = get().tag
def node = get().node
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    TagNodePair.Label
  }
}
      class TagNodePairDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with TagNodePairBase {

        override def layoutInformation: NodeLayoutInformation = TagNodePair.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  
  properties
}

        
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          TagNodePair.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[TagNodePairDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          TagNodePair.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          TagNodePair.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
          PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
          throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type Tag */
              lazy val tag: Tag =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "tag").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Tag])
                  .head
              

              /** link to 'contained' node of type Node */
              lazy val node: Node =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "node").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Node])
                  .head
              
      }
      
//TAG_NODE_PAIR END


//TRANSFORM BEGIN

      object Transform {

        def apply(graph: OdbGraph, id: Long) = new Transform(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "TRANSFORM"
        object Keys {
          
          val All: JSet[String] = Set().asJava
            val KeyToValue: Map[String, TransformDb => Any] = Map(
              
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[TransformDb] {
          override val forLabel = Transform.Label

          override def createNode(ref: NodeRef[TransformDb]) =
            new TransformDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Transform(graph, id)
        }
      }
      
trait TransformBase extends Node   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def triggerCallChains: List[CallChainBase]
def descriptorFlows: List[FlowBase]
def call: CallBase
def sink: SinkBase

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        
      }

  override def productPrefix = "Transform"
  override def productArity = 0 + 1 // add one for id, leaving out `_graph`
  
}
class Transform(graph: OdbGraph, id: Long) extends NodeRef[TransformDb](graph, id) with TransformBase with StoredNode  {

def triggerCallChains = get().triggerCallChains
def descriptorFlows = get().descriptorFlows
def call = get().call
def sink = get().sink
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Transform.Label
  }
}
      class TransformDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with TransformBase {

        override def layoutInformation: NodeLayoutInformation = Transform.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  
  properties
}

        
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Transform.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[TransformDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Transform.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Transform.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
          PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
          throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type CallChain */
              lazy val triggerCallChains: List[CallChain] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "triggerCallChains").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[CallChain])
                  .toList
              

              /** link to 'contained' node of type Flow */
              lazy val descriptorFlows: List[Flow] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "descriptorFlows").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Flow])
                  .toList
              

              /** link to 'contained' node of type Call */
              lazy val call: Call =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "call").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Call])
                  .head
              

              /** link to 'contained' node of type Sink */
              lazy val sink: Sink =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "sink").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Sink])
                  .head
              
      }
      
//TRANSFORM END


//TRANSFORMATION BEGIN

      object Transformation {

        def apply(graph: OdbGraph, id: Long) = new Transformation(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "TRANSFORMATION"
        object Keys {
          
          val All: JSet[String] = Set().asJava
            val KeyToValue: Map[String, TransformationDb => Any] = Map(
              
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[TransformationDb] {
          override val forLabel = Transformation.Label

          override def createNode(ref: NodeRef[TransformationDb]) =
            new TransformationDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Transformation(graph, id)
        }
      }
      
trait TransformationBase extends Node   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def node: TrackingPointBase

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        
      }

  override def productPrefix = "Transformation"
  override def productArity = 0 + 1 // add one for id, leaving out `_graph`
  
}
class Transformation(graph: OdbGraph, id: Long) extends NodeRef[TransformationDb](graph, id) with TransformationBase with StoredNode  {

def node = get().node
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Transformation.Label
  }
}
      class TransformationDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with TransformationBase {

        override def layoutInformation: NodeLayoutInformation = Transformation.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  
  properties
}

        
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Transformation.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[TransformationDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Transformation.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Transformation.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
          PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
          throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type TrackingPoint */
              lazy val node: TrackingPoint =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "node").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[TrackingPoint])
                  .head
              
      }
      
//TRANSFORMATION END


//TYPE BEGIN

      object Type {

        def apply(graph: OdbGraph, id: Long) = new Type(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Ast.layoutInformation, edges.Ref.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.IsSensitiveDataDescrOf.layoutInformation, edges.Ref.layoutInformation, edges.EvalType.layoutInformation, edges.ContainsNode.layoutInformation, edges.AliasOf.layoutInformation, edges.InheritsFrom.layoutInformation).asJava)

        val Label = "TYPE"
        object Keys {
          val Name = "NAME" 
val FullName = "FULL_NAME" 
val TypeDeclFullName = "TYPE_DECL_FULL_NAME" 
          val All: JSet[String] = Set(Name, FullName, TypeDeclFullName).asJava
            val KeyToValue: Map[String, TypeDb => Any] = Map(
               "NAME" -> { instance: TypeDb => instance.name},
 "FULL_NAME" -> { instance: TypeDb => instance.fullName},
 "TYPE_DECL_FULL_NAME" -> { instance: TypeDb => instance.typeDeclFullName}
            )
          }
        object Edges {
          val In: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF","REF","EVAL_TYPE","CONTAINS_NODE","ALIAS_OF","INHERITS_FROM")
          val Out: Array[String] = Array("AST","REF","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[TypeDb] {
          override val forLabel = Type.Label

          override def createNode(ref: NodeRef[TypeDb]) =
            new TypeDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Type(graph, id)
        }
      }
      
trait TypeBase extends Node  with HasName with HasFullName with HasTypeDeclFullName {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "name" 
case 2 => "fullName" 
case 3 => "typeDeclFullName" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => name
case 2 => fullName
case 3 => typeDeclFullName
      }

  override def productPrefix = "Type"
  override def productArity = 3 + 1 // add one for id, leaving out `_graph`
  
}
class Type(graph: OdbGraph, id: Long) extends NodeRef[TypeDb](graph, id) with TypeBase with StoredNode  {
override def name = get().name
override def fullName = get().fullName
override def typeDeclFullName = get().typeDeclFullName

override def _astOut(): JIterator[StoredNode] = get()._astOut()
override def _refOut(): JIterator[StoredNode] = get()._refOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _isSensitiveDataDescrOfIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfIn()
override def _refIn(): JIterator[StoredNode] = get()._refIn()
override def _evalTypeIn(): JIterator[StoredNode] = get()._evalTypeIn()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _aliasOfIn(): JIterator[StoredNode] = get()._aliasOfIn()
override def _inheritsFromIn(): JIterator[StoredNode] = get()._inheritsFromIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Type.Label
  }
}
      class TypeDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with TypeBase {

        override def layoutInformation: NodeLayoutInformation = Type.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
if (fullName != null) { properties.put("FULL_NAME", fullName) }
if (typeDeclFullName != null) { properties.put("TYPE_DECL_FULL_NAME", typeDeclFullName) }
  properties
}

        private var _name: String = null
def name(): String = _name

private var _fullName: String = null
def fullName(): String = _fullName

private var _typeDeclFullName: String = null
def typeDeclFullName(): String = _typeDeclFullName
override def _astOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _refOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _isSensitiveDataDescrOfIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _refIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _evalTypeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
override def _aliasOfIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
override def _inheritsFromIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Type.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[TypeDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Type.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Type.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "FULL_NAME") this._fullName = value.asInstanceOf[String] 
 else  if (key == "TYPE_DECL_FULL_NAME") this._typeDeclFullName = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "NAME") this._name = null 
 else  if (key == "FULL_NAME") this._fullName = null 
 else  if (key == "TYPE_DECL_FULL_NAME") this._typeDeclFullName = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//TYPE END


//TYPE_ARGUMENT BEGIN

      object TypeArgument {

        def apply(graph: OdbGraph, id: Long) = new TypeArgument(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Ref.layoutInformation, edges.BindsTo.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation, edges.Ast.layoutInformation).asJava)

        val Label = "TYPE_ARGUMENT"
        object Keys {
          val Order = "ORDER" 
          val All: JSet[String] = Set(Order).asJava
            val KeyToValue: Map[String, TypeArgumentDb => Any] = Map(
               "ORDER" -> { instance: TypeArgumentDb => instance.order}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE","AST")
          val Out: Array[String] = Array("REF","BINDS_TO","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[TypeArgumentDb] {
          override val forLabel = TypeArgument.Label

          override def createNode(ref: NodeRef[TypeArgumentDb]) =
            new TypeArgumentDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = TypeArgument(graph, id)
        }
      }
      
trait TypeArgumentBase extends Node with AstNodeBase with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "order" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => order
      }

  override def productPrefix = "TypeArgument"
  override def productArity = 1 + 1 // add one for id, leaving out `_graph`
  
}
class TypeArgument(graph: OdbGraph, id: Long) extends NodeRef[TypeArgumentDb](graph, id) with TypeArgumentBase with StoredNode with AstNode {
override def order = get().order

override def _refOut(): JIterator[StoredNode] = get()._refOut()
override def _bindsToOut(): JIterator[StoredNode] = get()._bindsToOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    TypeArgument.Label
  }
}
      class TypeArgumentDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with AstNode with TypeArgumentBase {

        override def layoutInformation: NodeLayoutInformation = TypeArgument.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (order != null) { properties.put("ORDER", order) }
  properties
}

        private var _order: Integer = null
def order(): Integer = _order
override def _refOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _bindsToOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          TypeArgument.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[TypeArgumentDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          TypeArgument.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          TypeArgument.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "ORDER") this._order = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//TYPE_ARGUMENT END


//TYPE_DECL BEGIN

      object TypeDecl {

        def apply(graph: OdbGraph, id: Long) = new TypeDecl(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Ast.layoutInformation, edges.AliasOf.layoutInformation, edges.InheritsFrom.layoutInformation, edges.Vtable.layoutInformation, edges.Binds.layoutInformation, edges.Contains.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.IsSensitiveDataDescrOf.layoutInformation, edges.Ref.layoutInformation, edges.DynamicType.layoutInformation, edges.ContainsNode.layoutInformation, edges.Contains.layoutInformation, edges.Ast.layoutInformation).asJava)

        val Label = "TYPE_DECL"
        object Keys {
          val Name = "NAME" 
val FullName = "FULL_NAME" 
val IsExternal = "IS_EXTERNAL" 
val InheritsFromTypeFullName = "INHERITS_FROM_TYPE_FULL_NAME" 
val AstParentType = "AST_PARENT_TYPE" 
val AstParentFullName = "AST_PARENT_FULL_NAME" 
val AliasTypeFullName = "ALIAS_TYPE_FULL_NAME" 
val Order = "ORDER" 
          val All: JSet[String] = Set(Name, FullName, IsExternal, InheritsFromTypeFullName, AstParentType, AstParentFullName, AliasTypeFullName, Order).asJava
            val KeyToValue: Map[String, TypeDeclDb => Any] = Map(
               "NAME" -> { instance: TypeDeclDb => instance.name},
 "FULL_NAME" -> { instance: TypeDeclDb => instance.fullName},
 "IS_EXTERNAL" -> { instance: TypeDeclDb => instance.isExternal},
 "INHERITS_FROM_TYPE_FULL_NAME" -> { instance: TypeDeclDb => instance.inheritsFromTypeFullName},
 "AST_PARENT_TYPE" -> { instance: TypeDeclDb => instance.astParentType},
 "AST_PARENT_FULL_NAME" -> { instance: TypeDeclDb => instance.astParentFullName},
 "ALIAS_TYPE_FULL_NAME" -> { instance: TypeDeclDb => instance.aliasTypeFullName.orNull},
 "ORDER" -> { instance: TypeDeclDb => instance.order}
            )
          }
        object Edges {
          val In: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF","REF","DYNAMIC_TYPE","CONTAINS_NODE","CONTAINS","AST")
          val Out: Array[String] = Array("AST","ALIAS_OF","INHERITS_FROM","VTABLE","BINDS","CONTAINS","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[TypeDeclDb] {
          override val forLabel = TypeDecl.Label

          override def createNode(ref: NodeRef[TypeDeclDb]) =
            new TypeDeclDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = TypeDecl(graph, id)
        }
      }
      
trait TypeDeclBase extends Node with AstNodeBase with HasName with HasFullName with HasIsExternal with HasInheritsFromTypeFullName with HasAstParentType with HasAstParentFullName with HasAliasTypeFullName with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "name" 
case 2 => "fullName" 
case 3 => "isExternal" 
case 4 => "inheritsFromTypeFullName" 
case 5 => "astParentType" 
case 6 => "astParentFullName" 
case 7 => "aliasTypeFullName" 
case 8 => "order" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => name
case 2 => fullName
case 3 => isExternal
case 4 => inheritsFromTypeFullName
case 5 => astParentType
case 6 => astParentFullName
case 7 => aliasTypeFullName
case 8 => order
      }

  override def productPrefix = "TypeDecl"
  override def productArity = 8 + 1 // add one for id, leaving out `_graph`
  
}
class TypeDecl(graph: OdbGraph, id: Long) extends NodeRef[TypeDeclDb](graph, id) with TypeDeclBase with StoredNode with AstNode {
override def name = get().name
override def fullName = get().fullName
override def isExternal = get().isExternal
override def inheritsFromTypeFullName = get().inheritsFromTypeFullName
override def astParentType = get().astParentType
override def astParentFullName = get().astParentFullName
override def aliasTypeFullName = get().aliasTypeFullName
override def order = get().order

override def _astOut(): JIterator[StoredNode] = get()._astOut()
override def _aliasOfOut(): JIterator[StoredNode] = get()._aliasOfOut()
override def _inheritsFromOut(): JIterator[StoredNode] = get()._inheritsFromOut()
override def _vtableOut(): JIterator[StoredNode] = get()._vtableOut()
override def _bindsOut(): JIterator[StoredNode] = get()._bindsOut()
override def _containsOut(): JIterator[StoredNode] = get()._containsOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _isSensitiveDataDescrOfIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfIn()
override def _refIn(): JIterator[StoredNode] = get()._refIn()
override def _dynamicTypeIn(): JIterator[StoredNode] = get()._dynamicTypeIn()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _containsIn(): JIterator[StoredNode] = get()._containsIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    TypeDecl.Label
  }
}
      class TypeDeclDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with AstNode with TypeDeclBase {

        override def layoutInformation: NodeLayoutInformation = TypeDecl.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
if (fullName != null) { properties.put("FULL_NAME", fullName) }
if (isExternal != null) { properties.put("IS_EXTERNAL", isExternal) }
if (inheritsFromTypeFullName.nonEmpty) { properties.put("INHERITS_FROM_TYPE_FULL_NAME", inheritsFromTypeFullName.asJava) }
if (astParentType != null) { properties.put("AST_PARENT_TYPE", astParentType) }
if (astParentFullName != null) { properties.put("AST_PARENT_FULL_NAME", astParentFullName) }
aliasTypeFullName.map { value => properties.put("ALIAS_TYPE_FULL_NAME", value) }
if (order != null) { properties.put("ORDER", order) }
  properties
}

        private var _name: String = null
def name(): String = _name

private var _fullName: String = null
def fullName(): String = _fullName

private var _isExternal: JBoolean = null
def isExternal(): JBoolean = _isExternal

private var _inheritsFromTypeFullName: List[String] = Nil
def inheritsFromTypeFullName(): List[String] = _inheritsFromTypeFullName

private var _astParentType: String = null
def astParentType(): String = _astParentType

private var _astParentFullName: String = null
def astParentFullName(): String = _astParentFullName

private var _aliasTypeFullName: Option[String] = None
def aliasTypeFullName(): Option[String] = _aliasTypeFullName

private var _order: Integer = null
def order(): Integer = _order
override def _astOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _aliasOfOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _inheritsFromOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _vtableOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _bindsOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _containsOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
override def _isSensitiveDataDescrOfIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
override def _refIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
override def _dynamicTypeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(10).asInstanceOf[JIterator[StoredNode]]
override def _containsIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(11).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(12).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          TypeDecl.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[TypeDeclDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          TypeDecl.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          TypeDecl.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "FULL_NAME") this._fullName = value.asInstanceOf[String] 
 else  if (key == "IS_EXTERNAL") this._isExternal = value.asInstanceOf[JBoolean] 
 else if (key == "INHERITS_FROM_TYPE_FULL_NAME") {
                    if (cardinality == VertexProperty.Cardinality.list) {
                      if (this._inheritsFromTypeFullName == null) { this._inheritsFromTypeFullName = Nil }
                      this._inheritsFromTypeFullName = this._inheritsFromTypeFullName :+ value.asInstanceOf[String]
                    } else {
                      this._inheritsFromTypeFullName = List(value.asInstanceOf[String])
                    }
                  }
              
 else  if (key == "AST_PARENT_TYPE") this._astParentType = value.asInstanceOf[String] 
 else  if (key == "AST_PARENT_FULL_NAME") this._astParentFullName = value.asInstanceOf[String] 
 else  if (key == "ALIAS_TYPE_FULL_NAME") this._aliasTypeFullName = Option(value).asInstanceOf[Option[String]] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "NAME") this._name = null 
 else  if (key == "FULL_NAME") this._fullName = null 
 else  if (key == "IS_EXTERNAL") this._isExternal = null 
 else  if (key == "INHERITS_FROM_TYPE_FULL_NAME") this._inheritsFromTypeFullName = null 
 else  if (key == "AST_PARENT_TYPE") this._astParentType = null 
 else  if (key == "AST_PARENT_FULL_NAME") this._astParentFullName = null 
 else  if (key == "ALIAS_TYPE_FULL_NAME") this._aliasTypeFullName = null 
 else  if (key == "ORDER") this._order = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//TYPE_DECL END


//TYPE_PARAMETER BEGIN

      object TypeParameter {

        def apply(graph: OdbGraph, id: Long) = new TypeParameter(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.BindsTo.layoutInformation, edges.ContainsNode.layoutInformation, edges.Ast.layoutInformation).asJava)

        val Label = "TYPE_PARAMETER"
        object Keys {
          val Name = "NAME" 
val Order = "ORDER" 
          val All: JSet[String] = Set(Name, Order).asJava
            val KeyToValue: Map[String, TypeParameterDb => Any] = Map(
               "NAME" -> { instance: TypeParameterDb => instance.name},
 "ORDER" -> { instance: TypeParameterDb => instance.order}
            )
          }
        object Edges {
          val In: Array[String] = Array("BINDS_TO","CONTAINS_NODE","AST")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[TypeParameterDb] {
          override val forLabel = TypeParameter.Label

          override def createNode(ref: NodeRef[TypeParameterDb]) =
            new TypeParameterDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = TypeParameter(graph, id)
        }
      }
      
trait TypeParameterBase extends Node with AstNodeBase with HasName with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "name" 
case 2 => "order" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => name
case 2 => order
      }

  override def productPrefix = "TypeParameter"
  override def productArity = 2 + 1 // add one for id, leaving out `_graph`
  
}
class TypeParameter(graph: OdbGraph, id: Long) extends NodeRef[TypeParameterDb](graph, id) with TypeParameterBase with StoredNode with AstNode {
override def name = get().name
override def order = get().order

override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _bindsToIn(): JIterator[StoredNode] = get()._bindsToIn()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    TypeParameter.Label
  }
}
      class TypeParameterDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with AstNode with TypeParameterBase {

        override def layoutInformation: NodeLayoutInformation = TypeParameter.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
if (order != null) { properties.put("ORDER", order) }
  properties
}

        private var _name: String = null
def name(): String = _name

private var _order: Integer = null
def order(): Integer = _order
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _bindsToIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          TypeParameter.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[TypeParameterDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          TypeParameter.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          TypeParameter.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "NAME") this._name = null 
 else  if (key == "ORDER") this._order = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//TYPE_PARAMETER END


//UNKNOWN BEGIN

      object Unknown {

        def apply(graph: OdbGraph, id: Long) = new Unknown(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.Cfg.layoutInformation, edges.Ast.layoutInformation, edges.TaggedBy.layoutInformation, edges.DynamicType.layoutInformation, edges.Dominate.layoutInformation, edges.PostDominate.layoutInformation, edges.Cdg.layoutInformation, edges.ReachingDef.layoutInformation, edges.EvalType.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
          List(edges.Receiver.layoutInformation, edges.Cdg.layoutInformation, edges.ContainsNode.layoutInformation, edges.Contains.layoutInformation, edges.Cfg.layoutInformation, edges.Ast.layoutInformation, edges.Dominate.layoutInformation, edges.PostDominate.layoutInformation, edges.Condition.layoutInformation).asJava)

        val Label = "UNKNOWN"
        object Keys {
          val Code = "CODE" 
val ParserTypeName = "PARSER_TYPE_NAME" 
val Order = "ORDER" 
val ArgumentIndex = "ARGUMENT_INDEX" 
val TypeFullName = "TYPE_FULL_NAME" 
val DynamicTypeHintFullName = "DYNAMIC_TYPE_HINT_FULL_NAME" 
val LineNumber = "LINE_NUMBER" 
val ColumnNumber = "COLUMN_NUMBER" 
val DepthFirstOrder = "DEPTH_FIRST_ORDER" 
          val All: JSet[String] = Set(Code, ParserTypeName, Order, ArgumentIndex, TypeFullName, DynamicTypeHintFullName, LineNumber, ColumnNumber, DepthFirstOrder).asJava
            val KeyToValue: Map[String, UnknownDb => Any] = Map(
               "CODE" -> { instance: UnknownDb => instance.code},
 "PARSER_TYPE_NAME" -> { instance: UnknownDb => instance.parserTypeName},
 "ORDER" -> { instance: UnknownDb => instance.order},
 "ARGUMENT_INDEX" -> { instance: UnknownDb => instance.argumentIndex},
 "TYPE_FULL_NAME" -> { instance: UnknownDb => instance.typeFullName},
 "DYNAMIC_TYPE_HINT_FULL_NAME" -> { instance: UnknownDb => instance.dynamicTypeHintFullName},
 "LINE_NUMBER" -> { instance: UnknownDb => instance.lineNumber.orNull},
 "COLUMN_NUMBER" -> { instance: UnknownDb => instance.columnNumber.orNull},
 "DEPTH_FIRST_ORDER" -> { instance: UnknownDb => instance.depthFirstOrder.orNull}
            )
          }
        object Edges {
          val In: Array[String] = Array("RECEIVER","CDG","CONTAINS_NODE","CONTAINS","CFG","AST","DOMINATE","POST_DOMINATE","CONDITION")
          val Out: Array[String] = Array("CFG","AST","TAGGED_BY","DYNAMIC_TYPE","DOMINATE","POST_DOMINATE","CDG","REACHING_DEF","EVAL_TYPE","CONTAINS_NODE")
        }

        val Factory = new NodeFactory[UnknownDb] {
          override val forLabel = Unknown.Label

          override def createNode(ref: NodeRef[UnknownDb]) =
            new UnknownDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Unknown(graph, id)
        }
      }
      
trait UnknownBase extends Node with ExpressionBase with HasCode with HasParserTypeName with HasOrder with HasArgumentIndex with HasTypeFullName with HasDynamicTypeHintFullName with HasLineNumber with HasColumnNumber with HasDepthFirstOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "code" 
case 2 => "parserTypeName" 
case 3 => "order" 
case 4 => "argumentIndex" 
case 5 => "typeFullName" 
case 6 => "dynamicTypeHintFullName" 
case 7 => "lineNumber" 
case 8 => "columnNumber" 
case 9 => "depthFirstOrder" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => code
case 2 => parserTypeName
case 3 => order
case 4 => argumentIndex
case 5 => typeFullName
case 6 => dynamicTypeHintFullName
case 7 => lineNumber
case 8 => columnNumber
case 9 => depthFirstOrder
      }

  override def productPrefix = "Unknown"
  override def productArity = 9 + 1 // add one for id, leaving out `_graph`
  
}
class Unknown(graph: OdbGraph, id: Long) extends NodeRef[UnknownDb](graph, id) with UnknownBase with StoredNode with Expression {
override def code = get().code
override def parserTypeName = get().parserTypeName
override def order = get().order
override def argumentIndex = get().argumentIndex
override def typeFullName = get().typeFullName
override def dynamicTypeHintFullName = get().dynamicTypeHintFullName
override def lineNumber = get().lineNumber
override def columnNumber = get().columnNumber
override def depthFirstOrder = get().depthFirstOrder

override def _cfgOut(): JIterator[StoredNode] = get()._cfgOut()
override def _astOut(): JIterator[StoredNode] = get()._astOut()
override def _taggedByOut(): JIterator[StoredNode] = get()._taggedByOut()
override def _dynamicTypeOut(): JIterator[StoredNode] = get()._dynamicTypeOut()
override def _dominateOut(): JIterator[StoredNode] = get()._dominateOut()
override def _postDominateOut(): JIterator[StoredNode] = get()._postDominateOut()
override def _cdgOut(): JIterator[StoredNode] = get()._cdgOut()
override def _reachingDefOut(): JIterator[StoredNode] = get()._reachingDefOut()
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut()
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _receiverIn(): JIterator[StoredNode] = get()._receiverIn()
override def _cdgIn(): JIterator[StoredNode] = get()._cdgIn()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
override def _containsIn(): JIterator[StoredNode] = get()._containsIn()
override def _cfgIn(): JIterator[StoredNode] = get()._cfgIn()
override def _astIn(): JIterator[StoredNode] = get()._astIn()
override def _dominateIn(): JIterator[StoredNode] = get()._dominateIn()
override def _postDominateIn(): JIterator[StoredNode] = get()._postDominateIn()
override def _conditionIn(): JIterator[StoredNode] = get()._conditionIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Unknown.Label
  }
}
      class UnknownDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
        with Expression with UnknownBase {

        override def layoutInformation: NodeLayoutInformation = Unknown.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (parserTypeName != null) { properties.put("PARSER_TYPE_NAME", parserTypeName) }
if (order != null) { properties.put("ORDER", order) }
if (argumentIndex != null) { properties.put("ARGUMENT_INDEX", argumentIndex) }
if (typeFullName != null) { properties.put("TYPE_FULL_NAME", typeFullName) }
if (dynamicTypeHintFullName.nonEmpty) { properties.put("DYNAMIC_TYPE_HINT_FULL_NAME", dynamicTypeHintFullName.asJava) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
  properties
}

        private var _code: String = null
def code(): String = _code

private var _parserTypeName: String = null
def parserTypeName(): String = _parserTypeName

private var _order: Integer = null
def order(): Integer = _order

private var _argumentIndex: Integer = null
def argumentIndex(): Integer = _argumentIndex

private var _typeFullName: String = null
def typeFullName(): String = _typeFullName

private var _dynamicTypeHintFullName: List[String] = Nil
def dynamicTypeHintFullName(): List[String] = _dynamicTypeHintFullName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder
override def _cfgOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _astOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _taggedByOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _dynamicTypeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _dominateOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _postDominateOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
override def _cdgOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
override def _reachingDefOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
override def _evalTypeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]
override def _receiverIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(10).asInstanceOf[JIterator[StoredNode]]
override def _cdgIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(11).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(12).asInstanceOf[JIterator[StoredNode]]
override def _containsIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(13).asInstanceOf[JIterator[StoredNode]]
override def _cfgIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(14).asInstanceOf[JIterator[StoredNode]]
override def _astIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(15).asInstanceOf[JIterator[StoredNode]]
override def _dominateIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(16).asInstanceOf[JIterator[StoredNode]]
override def _postDominateIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(17).asInstanceOf[JIterator[StoredNode]]
override def _conditionIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(18).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Unknown.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[UnknownDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Unknown.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Unknown.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "PARSER_TYPE_NAME") this._parserTypeName = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else  if (key == "ARGUMENT_INDEX") this._argumentIndex = value.asInstanceOf[Integer] 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = value.asInstanceOf[String] 
 else if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") {
                    if (cardinality == VertexProperty.Cardinality.list) {
                      if (this._dynamicTypeHintFullName == null) { this._dynamicTypeHintFullName = Nil }
                      this._dynamicTypeHintFullName = this._dynamicTypeHintFullName :+ value.asInstanceOf[String]
                    } else {
                      this._dynamicTypeHintFullName = List(value.asInstanceOf[String])
                    }
                  }
              
 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = Option(value).asInstanceOf[Option[Integer]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "CODE") this._code = null 
 else  if (key == "PARSER_TYPE_NAME") this._parserTypeName = null 
 else  if (key == "ORDER") this._order = null 
 else  if (key == "ARGUMENT_INDEX") this._argumentIndex = null 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = null 
 else  if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") this._dynamicTypeHintFullName = null 
 else  if (key == "LINE_NUMBER") this._lineNumber = null 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = null 
 else  if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//UNKNOWN END


//VARIABLE_INFO BEGIN

      object VariableInfo {

        def apply(graph: OdbGraph, id: Long) = new VariableInfo(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "VARIABLE_INFO"
        object Keys {
          val VarType = "VAR_TYPE" 
val EvaluationType = "EVALUATION_TYPE" 
val ParameterIndex = "PARAMETER_INDEX" 
          val All: JSet[String] = Set(VarType, EvaluationType, ParameterIndex).asJava
            val KeyToValue: Map[String, VariableInfoDb => Any] = Map(
               "VAR_TYPE" -> { instance: VariableInfoDb => instance.varType},
 "EVALUATION_TYPE" -> { instance: VariableInfoDb => instance.evaluationType},
 "PARAMETER_INDEX" -> { instance: VariableInfoDb => instance.parameterIndex.orNull}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[VariableInfoDb] {
          override val forLabel = VariableInfo.Label

          override def createNode(ref: NodeRef[VariableInfoDb]) =
            new VariableInfoDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = VariableInfo(graph, id)
        }
      }
      
trait VariableInfoBase extends Node  with HasVarType with HasEvaluationType with HasParameterIndex {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "varType" 
case 2 => "evaluationType" 
case 3 => "parameterIndex" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => varType
case 2 => evaluationType
case 3 => parameterIndex
      }

  override def productPrefix = "VariableInfo"
  override def productArity = 3 + 1 // add one for id, leaving out `_graph`
  
}
class VariableInfo(graph: OdbGraph, id: Long) extends NodeRef[VariableInfoDb](graph, id) with VariableInfoBase with StoredNode  {
override def varType = get().varType
override def evaluationType = get().evaluationType
override def parameterIndex = get().parameterIndex

override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    VariableInfo.Label
  }
}
      class VariableInfoDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with VariableInfoBase {

        override def layoutInformation: NodeLayoutInformation = VariableInfo.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (varType != null) { properties.put("VAR_TYPE", varType) }
if (evaluationType != null) { properties.put("EVALUATION_TYPE", evaluationType) }
parameterIndex.map { value => properties.put("PARAMETER_INDEX", value) }
  properties
}

        private var _varType: String = null
def varType(): String = _varType

private var _evaluationType: String = null
def evaluationType(): String = _evaluationType

private var _parameterIndex: Option[Integer] = None
def parameterIndex(): Option[Integer] = _parameterIndex
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          VariableInfo.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[VariableInfoDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          VariableInfo.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          VariableInfo.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "VAR_TYPE") this._varType = value.asInstanceOf[String] 
 else  if (key == "EVALUATION_TYPE") this._evaluationType = value.asInstanceOf[String] 
 else  if (key == "PARAMETER_INDEX") this._parameterIndex = Option(value).asInstanceOf[Option[Integer]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "VAR_TYPE") this._varType = null 
 else  if (key == "EVALUATION_TYPE") this._evaluationType = null 
 else  if (key == "PARAMETER_INDEX") this._parameterIndex = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//VARIABLE_INFO END


//WRITE BEGIN

      object Write {

        def apply(graph: OdbGraph, id: Long) = new Write(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "WRITE"
        object Keys {
          
          val All: JSet[String] = Set().asJava
            val KeyToValue: Map[String, WriteDb => Any] = Map(
              
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[WriteDb] {
          override val forLabel = Write.Label

          override def createNode(ref: NodeRef[WriteDb]) =
            new WriteDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = Write(graph, id)
        }
      }
      
trait WriteBase extends Node   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  def triggerCallChains: List[CallChainBase]
def descriptorFlows: List[FlowBase]
def sink: SinkBase
def flows: List[FlowBase]

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        
      }

  override def productPrefix = "Write"
  override def productArity = 0 + 1 // add one for id, leaving out `_graph`
  
}
class Write(graph: OdbGraph, id: Long) extends NodeRef[WriteDb](graph, id) with WriteBase with StoredNode  {

def triggerCallChains = get().triggerCallChains
def descriptorFlows = get().descriptorFlows
def sink = get().sink
def flows = get().flows
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Write.Label
  }
}
      class WriteDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with WriteBase {

        override def layoutInformation: NodeLayoutInformation = Write.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  
  properties
}

        
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          Write.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[WriteDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          Write.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          Write.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
          PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
          throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
              /** link to 'contained' node of type CallChain */
              lazy val triggerCallChains: List[CallChain] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "triggerCallChains").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[CallChain])
                  .toList
              

              /** link to 'contained' node of type Flow */
              lazy val descriptorFlows: List[Flow] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "descriptorFlows").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Flow])
                  .toList
              

              /** link to 'contained' node of type Sink */
              lazy val sink: Sink =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "sink").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Sink])
                  .head
              

              /** link to 'contained' node of type Flow */
              lazy val flows: List[Flow] =
                edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
                  .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "flows").getOrElse(false))
                  .sortBy(_.valueOption(EdgeKeys.INDEX))
                  .map(_.inVertex.asInstanceOf[Flow])
                  .toList
              
      }
      
//WRITE END


//PACKAGE_PREFIX BEGIN

      object PackagePrefix {

        def apply(graph: OdbGraph, id: Long) = new PackagePrefix(graph, id)

        val layoutInformation = new NodeLayoutInformation(
          Keys.All,
          List(edges.ContainsNode.layoutInformation).asJava,
          List(edges.ContainsNode.layoutInformation).asJava)

        val Label = "PACKAGE_PREFIX"
        object Keys {
          val Value = "VALUE" 
          val All: JSet[String] = Set(Value).asJava
            val KeyToValue: Map[String, PackagePrefixDb => Any] = Map(
               "VALUE" -> { instance: PackagePrefixDb => instance.value}
            )
          }
        object Edges {
          val In: Array[String] = Array("CONTAINS_NODE")
          val Out: Array[String] = Array("CONTAINS_NODE")
        }

        val Factory = new NodeFactory[PackagePrefixDb] {
          override val forLabel = PackagePrefix.Label

          override def createNode(ref: NodeRef[PackagePrefixDb]) =
            new PackagePrefixDb(ref.asInstanceOf[NodeRef[OdbNode]])

          override def createNodeRef(graph: OdbGraph, id: Long) = PackagePrefix(graph, id)
        }
      }
      
trait PackagePrefixBase extends Node  with HasValue {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]
  override def getId: JLong = -1l

  

  override def productElementLabel(n: Int): String =
      n match {
        case 0 => "id"
        case 1 => "value" 
      }

  override def productElement(n: Int): Any =
      n match {
        case 0 => getId
        case 1 => value
      }

  override def productPrefix = "PackagePrefix"
  override def productArity = 1 + 1 // add one for id, leaving out `_graph`
  
}
class PackagePrefix(graph: OdbGraph, id: Long) extends NodeRef[PackagePrefixDb](graph, id) with PackagePrefixBase with StoredNode  {
override def value = get().value

override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut()
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn()
  override def accept[T](visitor: NodeVisitor[T]): T = {
    visitor.visit(this)
  }
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    PackagePrefix.Label
  }
}
      class PackagePrefixDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode 
         with PackagePrefixBase {

        override def layoutInformation: NodeLayoutInformation = PackagePrefix.layoutInformation

        /* all properties */
        override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (value != null) { properties.put("VALUE", value) }
  properties
}

        private var _value: String = null
def value(): String = _value
override def _containsNodeOut : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn : JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]


        override def label: String = {
          PackagePrefix.Label
        }

        override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[PackagePrefixDb]

        /* performance optimisation to save instantiating an iterator for each property lookup */
        override protected def specificProperty[A](key: String): VertexProperty[A] = {
          PackagePrefix.Keys.KeyToValue.get(key) match {
            case None => VertexProperty.empty[A]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null | None => VertexProperty.empty[A]
                case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
                case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
                case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
              }
          }
        }

        override protected def specificProperties[A](key: String): JIterator[VertexProperty[A]] = {
          PackagePrefix.Keys.KeyToValue.get(key) match {
            case None => JCollections.emptyIterator[VertexProperty[A]]
            case Some(fieldAccess) => 
              fieldAccess(this) match {
                case null => JCollections.emptyIterator[VertexProperty[A]]
                case values: List[_] => 
                  values.map { value => 
                    new OdbNodeProperty(-1, this, key, value).asInstanceOf[VertexProperty[A]]
                  }.toIterator.asJava
                case value => IteratorUtils.of(new OdbNodeProperty(-1, this, key, value.asInstanceOf[A]))
              }
          }
        }

        override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
           if (key == "VALUE") this._value = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
          new OdbNodeProperty(-1, this, key, value)
        }

        override protected def removeSpecificProperty(key: String): Unit =
           if (key == "VALUE") this._value = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

        
      }
      
//PACKAGE_PREFIX END

