package io.shiftleft.codepropertygraph.generated.nodes

import overflowdb._
import scala.jdk.CollectionConverters._

object Dependency {
  def apply(graph: Graph, id: Long) = new Dependency(graph, id)

  val Label = "DEPENDENCY"

  object PropertyNames {
    val DependencyGroupId                = "DEPENDENCY_GROUP_ID"
    val Name                             = "NAME"
    val Version                          = "VERSION"
    val all: Set[String]                 = Set(DependencyGroupId, Name, Version)
    val allAsJava: java.util.Set[String] = all.asJava
  }

  object Properties {
    val DependencyGroupId = new overflowdb.PropertyKey[String]("DEPENDENCY_GROUP_ID")
    val Name              = new overflowdb.PropertyKey[String]("NAME")
    val Version           = new overflowdb.PropertyKey[String]("VERSION")

  }

  object PropertyDefaults {
    val Name    = "<empty>"
    val Version = "<empty>"
  }

  val layoutInformation = new NodeLayoutInformation(Label, PropertyNames.allAsJava, List().asJava, List().asJava)

  object Edges {
    val Out: Array[String] = Array()
    val In: Array[String]  = Array()
  }

  val factory = new NodeFactory[DependencyDb] {
    override val forLabel = Dependency.Label

    override def createNode(ref: NodeRef[DependencyDb]) =
      new DependencyDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = Dependency(graph, id)
  }
}

trait DependencyBase extends AbstractNode {
  def asStored: StoredNode = this.asInstanceOf[StoredNode]

  def dependencyGroupId: Option[String]
  def name: String
  def version: String

}

class Dependency(graph: Graph, id: Long) extends NodeRef[DependencyDb](graph, id) with DependencyBase with StoredNode {
  override def dependencyGroupId: Option[String] = get().dependencyGroupId
  override def name: String                      = get().name
  override def version: String                   = get().version
  override def propertyDefaultValue(propertyKey: String) =
    propertyKey match {
      case "NAME"    => Dependency.PropertyDefaults.Name
      case "VERSION" => Dependency.PropertyDefaults.Version
      case _         => super.propertyDefaultValue(propertyKey)
    }

  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def canEqual(that: Any): Boolean                                        = get.canEqual(that)
  override def label: String = {
    Dependency.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id"
      case 1 => "dependencyGroupId"
      case 2 => "name"
      case 3 => "version"
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
      case 1 => dependencyGroupId
      case 2 => name
      case 3 => version
    }

  override def productPrefix = "Dependency"
  override def productArity  = 4
}

class DependencyDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode with DependencyBase {

  override def layoutInformation: NodeLayoutInformation = Dependency.layoutInformation

  private var _dependencyGroupId: String = null
  def dependencyGroupId: Option[String]  = Option(_dependencyGroupId)
  private var _name: String              = Dependency.PropertyDefaults.Name
  def name: String                       = _name
  private var _version: String           = Dependency.PropertyDefaults.Version
  def version: String                    = _version

  /** faster than the default implementation */
  override def propertiesMap: java.util.Map[String, Any] = {
    val properties = new java.util.HashMap[String, Any]
    dependencyGroupId.map { value => properties.put("DEPENDENCY_GROUP_ID", value) }
    properties.put("NAME", name)
    properties.put("VERSION", version)

    properties
  }

  /** faster than the default implementation */
  override def propertiesMapForStorage: java.util.Map[String, Any] = {
    val properties = new java.util.HashMap[String, Any]
    dependencyGroupId.map { value => properties.put("DEPENDENCY_GROUP_ID", value) }
    if (!(("<empty>") == name)) { properties.put("NAME", name) }
    if (!(("<empty>") == version)) { properties.put("VERSION", version) }

    properties
  }

  override def label: String = {
    Dependency.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id"
      case 1 => "dependencyGroupId"
      case 2 => "name"
      case 3 => "version"
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
      case 1 => dependencyGroupId
      case 2 => name
      case 3 => version
    }

  override def productPrefix = "Dependency"
  override def productArity  = 4

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[DependencyDb]

  override def property(key: String): Any = {
    key match {
      case "DEPENDENCY_GROUP_ID" => this._dependencyGroupId
      case "NAME"                => this._name
      case "VERSION"             => this._version

      case _ => null
    }
  }

  override protected def updateSpecificProperty(key: String, value: Object): Unit = {
    key match {
      case "DEPENDENCY_GROUP_ID" => this._dependencyGroupId = value.asInstanceOf[String]
      case "NAME"                => this._name = value.asInstanceOf[String]
      case "VERSION"             => this._version = value.asInstanceOf[String]

      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

  override def removeSpecificProperty(key: String): Unit =
    this.updateSpecificProperty(key, null)

  override def _initializeFromDetached(
    data: overflowdb.DetachedNodeData,
    mapper: java.util.function.Function[overflowdb.DetachedNodeData, Node]
  ) =
    fromNewNode(data.asInstanceOf[NewNode], nn => mapper.apply(nn).asInstanceOf[StoredNode])

  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = {
    this._dependencyGroupId = newNode.asInstanceOf[NewDependency].dependencyGroupId.orNull
    this._name = newNode.asInstanceOf[NewDependency].name
    this._version = newNode.asInstanceOf[NewDependency].version

  }

}
