package io.shiftleft.codepropertygraph.generated.nodes

import overflowdb._
import scala.jdk.CollectionConverters._

object Call {
  def apply(graph: Graph, id: Long) = new Call(graph, id)

  val Label = "CALL"

  object PropertyNames {
    val ArgumentIndex           = "ARGUMENT_INDEX"
    val ArgumentName            = "ARGUMENT_NAME"
    val Code                    = "CODE"
    val ColumnNumber            = "COLUMN_NUMBER"
    val DispatchType            = "DISPATCH_TYPE"
    val DynamicTypeHintFullName = "DYNAMIC_TYPE_HINT_FULL_NAME"
    val LineNumber              = "LINE_NUMBER"
    val MethodFullName          = "METHOD_FULL_NAME"
    val Name                    = "NAME"
    val Order                   = "ORDER"
    val Signature               = "SIGNATURE"
    val TypeFullName            = "TYPE_FULL_NAME"
    val all: Set[String] = Set(
      ArgumentIndex,
      ArgumentName,
      Code,
      ColumnNumber,
      DispatchType,
      DynamicTypeHintFullName,
      LineNumber,
      MethodFullName,
      Name,
      Order,
      Signature,
      TypeFullName
    )
    val allAsJava: java.util.Set[String] = all.asJava
  }

  object Properties {
    val ArgumentIndex           = new overflowdb.PropertyKey[scala.Int]("ARGUMENT_INDEX")
    val ArgumentName            = new overflowdb.PropertyKey[String]("ARGUMENT_NAME")
    val Code                    = new overflowdb.PropertyKey[String]("CODE")
    val ColumnNumber            = new overflowdb.PropertyKey[Integer]("COLUMN_NUMBER")
    val DispatchType            = new overflowdb.PropertyKey[String]("DISPATCH_TYPE")
    val DynamicTypeHintFullName = new overflowdb.PropertyKey[IndexedSeq[String]]("DYNAMIC_TYPE_HINT_FULL_NAME")
    val LineNumber              = new overflowdb.PropertyKey[Integer]("LINE_NUMBER")
    val MethodFullName          = new overflowdb.PropertyKey[String]("METHOD_FULL_NAME")
    val Name                    = new overflowdb.PropertyKey[String]("NAME")
    val Order                   = new overflowdb.PropertyKey[scala.Int]("ORDER")
    val Signature               = new overflowdb.PropertyKey[String]("SIGNATURE")
    val TypeFullName            = new overflowdb.PropertyKey[String]("TYPE_FULL_NAME")

  }

  object PropertyDefaults {
    val ArgumentIndex  = -1: Int
    val Code           = "<empty>"
    val DispatchType   = "<empty>"
    val MethodFullName = "<empty>"
    val Name           = "<empty>"
    val Order          = -1: Int
    val Signature      = ""
    val TypeFullName   = "<empty>"
  }

  val layoutInformation = new NodeLayoutInformation(
    Label,
    PropertyNames.allAsJava,
    List(
      io.shiftleft.codepropertygraph.generated.edges.Argument.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.PointsTo.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.Ast.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.EvalType.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.Ref.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.Cfg.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.TaggedBy.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.Call.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.Cdg.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.Dominate.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.ReachingDef.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.Receiver.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.PostDominate.layoutInformation
    ).asJava,
    List(
      io.shiftleft.codepropertygraph.generated.edges.Argument.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.PointsTo.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.Condition.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.Ast.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.Cfg.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.Contains.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.Cdg.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.Dominate.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.ReachingDef.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.Receiver.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.PostDominate.layoutInformation
    ).asJava
  )

  object Edges {
    val Out: Array[String] = Array(
      "ARGUMENT",
      "AST",
      "CALL",
      "CDG",
      "CFG",
      "DOMINATE",
      "EVAL_TYPE",
      "POINTS_TO",
      "POST_DOMINATE",
      "REACHING_DEF",
      "RECEIVER",
      "REF",
      "TAGGED_BY"
    )
    val In: Array[String] = Array(
      "ARGUMENT",
      "AST",
      "CDG",
      "CFG",
      "CONDITION",
      "CONTAINS",
      "DOMINATE",
      "POINTS_TO",
      "POST_DOMINATE",
      "REACHING_DEF",
      "RECEIVER"
    )
  }

  val factory = new NodeFactory[CallDb] {
    override val forLabel = Call.Label

    override def createNode(ref: NodeRef[CallDb]) =
      new CallDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = Call(graph, id)
  }
}

trait CallBase extends AbstractNode with ExpressionBase with CallReprBase {
  def asStored: StoredNode = this.asInstanceOf[StoredNode]

  def argumentIndex: scala.Int
  def argumentName: Option[String]
  def code: String
  def columnNumber: Option[Integer]
  def dispatchType: String
  def dynamicTypeHintFullName: IndexedSeq[String]
  def lineNumber: Option[Integer]
  def methodFullName: String
  def name: String
  def order: scala.Int
  def signature: String
  def typeFullName: String

}

class Call(graph: Graph, id: Long)
    extends NodeRef[CallDb](graph, id)
    with CallBase
    with StoredNode
    with Expression
    with CallRepr {
  override def argumentIndex: scala.Int                    = get().argumentIndex
  override def argumentName: Option[String]                = get().argumentName
  override def code: String                                = get().code
  override def columnNumber: Option[Integer]               = get().columnNumber
  override def dispatchType: String                        = get().dispatchType
  override def dynamicTypeHintFullName: IndexedSeq[String] = get().dynamicTypeHintFullName
  override def lineNumber: Option[Integer]                 = get().lineNumber
  override def methodFullName: String                      = get().methodFullName
  override def name: String                                = get().name
  override def order: scala.Int                            = get().order
  override def signature: String                           = get().signature
  override def typeFullName: String                        = get().typeFullName
  override def propertyDefaultValue(propertyKey: String) =
    propertyKey match {
      case "ARGUMENT_INDEX"   => Call.PropertyDefaults.ArgumentIndex
      case "CODE"             => Call.PropertyDefaults.Code
      case "DISPATCH_TYPE"    => Call.PropertyDefaults.DispatchType
      case "METHOD_FULL_NAME" => Call.PropertyDefaults.MethodFullName
      case "NAME"             => Call.PropertyDefaults.Name
      case "ORDER"            => Call.PropertyDefaults.Order
      case "SIGNATURE"        => Call.PropertyDefaults.Signature
      case "TYPE_FULL_NAME"   => Call.PropertyDefaults.TypeFullName
      case _                  => super.propertyDefaultValue(propertyKey)
    }

  def argumentOut: overflowdb.traversal.Traversal[CfgNode] = get().argumentOut
  override def _argumentOut                                = get()._argumentOut

  /** Traverse to CONTROL_STRUCTURE via ARGUMENT OUT edge.
    */
  def _controlStructureViaArgumentOut: overflowdb.traversal.Traversal[ControlStructure] =
    get()._controlStructureViaArgumentOut

  /** Traverse to JUMP_TARGET via ARGUMENT OUT edge.
    */
  def _jumpTargetViaArgumentOut: overflowdb.traversal.Traversal[JumpTarget] = get()._jumpTargetViaArgumentOut

  /** Traverse to CALL via ARGUMENT OUT edge.
    */
  def _callViaArgumentOut: overflowdb.traversal.Traversal[Call] = get()._callViaArgumentOut

  /** Traverse to UNKNOWN via ARGUMENT OUT edge.
    */
  def _unknownViaArgumentOut: overflowdb.traversal.Traversal[Unknown] = get()._unknownViaArgumentOut

  /** Traverse to LITERAL via ARGUMENT OUT edge.
    */
  def _literalViaArgumentOut: overflowdb.traversal.Traversal[Literal] = get()._literalViaArgumentOut

  /** Traverse to METHOD_REF via ARGUMENT OUT edge.
    */
  def _methodRefViaArgumentOut: overflowdb.traversal.Traversal[MethodRef] = get()._methodRefViaArgumentOut

  /** Traverse to BLOCK via ARGUMENT OUT edge.
    */
  def _blockViaArgumentOut: overflowdb.traversal.Traversal[Block] = get()._blockViaArgumentOut

  /** Traverse to IDENTIFIER via ARGUMENT OUT edge.
    */
  def _identifierViaArgumentOut: overflowdb.traversal.Traversal[Identifier] = get()._identifierViaArgumentOut

  /** Traverse to TYPE_REF via ARGUMENT OUT edge.
    */
  def _typeRefViaArgumentOut: overflowdb.traversal.Traversal[TypeRef] = get()._typeRefViaArgumentOut

  /** Traverse to FIELD_IDENTIFIER via ARGUMENT OUT edge.
    */
  def _fieldIdentifierViaArgumentOut: overflowdb.traversal.Traversal[FieldIdentifier] =
    get()._fieldIdentifierViaArgumentOut

  def pointsToOut: overflowdb.traversal.Traversal[CfgNode] = get().pointsToOut
  override def _pointsToOut                                = get()._pointsToOut

  def astOut: overflowdb.traversal.Traversal[Expression] = get().astOut
  override def _astOut                                   = get()._astOut

  /** Traverse to FIELD_IDENTIFIER via AST OUT edge.
    */
  def _fieldIdentifierViaAstOut: overflowdb.traversal.Traversal[FieldIdentifier] = get()._fieldIdentifierViaAstOut

  /** Traverse to BLOCK via AST OUT edge.
    */
  def _blockViaAstOut: overflowdb.traversal.Traversal[Block] = get()._blockViaAstOut

  /** Traverse to CONTROL_STRUCTURE via AST OUT edge.
    */
  def _controlStructureViaAstOut: overflowdb.traversal.Traversal[ControlStructure] = get()._controlStructureViaAstOut

  /** Traverse to IDENTIFIER via AST OUT edge.
    */
  def _identifierViaAstOut: overflowdb.traversal.Traversal[Identifier] = get()._identifierViaAstOut

  /** Traverse to LITERAL via AST OUT edge.
    */
  def _literalViaAstOut: overflowdb.traversal.Traversal[Literal] = get()._literalViaAstOut

  /** Traverse to TYPE_REF via AST OUT edge.
    */
  def _typeRefViaAstOut: overflowdb.traversal.Traversal[TypeRef] = get()._typeRefViaAstOut

  /** Traverse to CALL via AST OUT edge.
    */
  def _callViaAstOut: overflowdb.traversal.Traversal[Call] = get()._callViaAstOut

  /** Traverse to RETURN via AST OUT edge.
    */
  def _returnViaAstOut: overflowdb.traversal.Traversal[Return] = get()._returnViaAstOut

  /** Traverse to METHOD_REF via AST OUT edge.
    */
  def _methodRefViaAstOut: overflowdb.traversal.Traversal[MethodRef] = get()._methodRefViaAstOut

  def evalTypeOut: overflowdb.traversal.Traversal[Type] = get().evalTypeOut
  override def _evalTypeOut                             = get()._evalTypeOut

  /** Traverse to TYPE via EVAL_TYPE OUT edge.
    */
  def _typeViaEvalTypeOut: overflowdb.traversal.Traversal[Type] = get()._typeViaEvalTypeOut

  def refOut: overflowdb.traversal.Traversal[Member] = get().refOut
  override def _refOut                               = get()._refOut

  /** Traverse to referenced members Traverse to MEMBER via REF OUT edge.
    */
  /** Traverse to referenced members */
  @overflowdb.traversal.help.Doc(info = """Traverse to referenced members""")
  def referencedMember: overflowdb.traversal.Traversal[Member] = get().referencedMember

  def cfgOut: overflowdb.traversal.Traversal[CfgNode] = get().cfgOut
  override def _cfgOut                                = get()._cfgOut

  /** Traverse to CFG_NODE via CFG OUT edge.
    */
  def _cfgNodeViaCfgOut: overflowdb.traversal.Traversal[CfgNode] = get()._cfgNodeViaCfgOut

  def taggedByOut: overflowdb.traversal.Traversal[Tag] = get().taggedByOut
  override def _taggedByOut                            = get()._taggedByOut

  /** Traverse to TAG via TAGGED_BY OUT edge.
    */
  def _tagViaTaggedByOut: overflowdb.traversal.Traversal[Tag] = get()._tagViaTaggedByOut

  def callOut: overflowdb.traversal.Traversal[Method] = get().callOut
  override def _callOut                               = get()._callOut

  /** Traverse to METHOD via CALL OUT edge.
    */
  def _methodViaCallOut: overflowdb.traversal.Traversal[Method] = get()._methodViaCallOut

  def cdgOut: overflowdb.traversal.Traversal[CfgNode] = get().cdgOut
  override def _cdgOut                                = get()._cdgOut

  /** Traverse to JUMP_TARGET via CDG OUT edge.
    */
  def _jumpTargetViaCdgOut: overflowdb.traversal.Traversal[JumpTarget] = get()._jumpTargetViaCdgOut

  /** Traverse to METHOD_REF via CDG OUT edge.
    */
  def _methodRefViaCdgOut: overflowdb.traversal.Traversal[MethodRef] = get()._methodRefViaCdgOut

  /** Traverse to LITERAL via CDG OUT edge.
    */
  def _literalViaCdgOut: overflowdb.traversal.Traversal[Literal] = get()._literalViaCdgOut

  /** Traverse to RETURN via CDG OUT edge.
    */
  def _returnViaCdgOut: overflowdb.traversal.Traversal[Return] = get()._returnViaCdgOut

  /** Traverse to BLOCK via CDG OUT edge.
    */
  def _blockViaCdgOut: overflowdb.traversal.Traversal[Block] = get()._blockViaCdgOut

  /** Traverse to TYPE_REF via CDG OUT edge.
    */
  def _typeRefViaCdgOut: overflowdb.traversal.Traversal[TypeRef] = get()._typeRefViaCdgOut

  /** Traverse to METHOD_RETURN via CDG OUT edge.
    */
  def _methodReturnViaCdgOut: overflowdb.traversal.Traversal[MethodReturn] = get()._methodReturnViaCdgOut

  /** Traverse to CALL via CDG OUT edge.
    */
  def _callViaCdgOut: overflowdb.traversal.Traversal[Call] = get()._callViaCdgOut

  /** Traverse to FIELD_IDENTIFIER via CDG OUT edge.
    */
  def _fieldIdentifierViaCdgOut: overflowdb.traversal.Traversal[FieldIdentifier] = get()._fieldIdentifierViaCdgOut

  /** Traverse to IDENTIFIER via CDG OUT edge.
    */
  def _identifierViaCdgOut: overflowdb.traversal.Traversal[Identifier] = get()._identifierViaCdgOut

  /** Traverse to UNKNOWN via CDG OUT edge.
    */
  def _unknownViaCdgOut: overflowdb.traversal.Traversal[Unknown] = get()._unknownViaCdgOut

  /** Traverse to CONTROL_STRUCTURE via CDG OUT edge.
    */
  def _controlStructureViaCdgOut: overflowdb.traversal.Traversal[ControlStructure] = get()._controlStructureViaCdgOut

  def dominateOut: overflowdb.traversal.Traversal[CfgNode] = get().dominateOut
  override def _dominateOut                                = get()._dominateOut

  /** Traverse to LITERAL via DOMINATE OUT edge.
    */
  def _literalViaDominateOut: overflowdb.traversal.Traversal[Literal] = get()._literalViaDominateOut

  /** Traverse to METHOD_REF via DOMINATE OUT edge.
    */
  def _methodRefViaDominateOut: overflowdb.traversal.Traversal[MethodRef] = get()._methodRefViaDominateOut

  /** Traverse to METHOD_RETURN via DOMINATE OUT edge.
    */
  def _methodReturnViaDominateOut: overflowdb.traversal.Traversal[MethodReturn] = get()._methodReturnViaDominateOut

  /** Traverse to CALL via DOMINATE OUT edge.
    */
  def _callViaDominateOut: overflowdb.traversal.Traversal[Call] = get()._callViaDominateOut

  /** Traverse to UNKNOWN via DOMINATE OUT edge.
    */
  def _unknownViaDominateOut: overflowdb.traversal.Traversal[Unknown] = get()._unknownViaDominateOut

  /** Traverse to IDENTIFIER via DOMINATE OUT edge.
    */
  def _identifierViaDominateOut: overflowdb.traversal.Traversal[Identifier] = get()._identifierViaDominateOut

  /** Traverse to JUMP_TARGET via DOMINATE OUT edge.
    */
  def _jumpTargetViaDominateOut: overflowdb.traversal.Traversal[JumpTarget] = get()._jumpTargetViaDominateOut

  /** Traverse to CONTROL_STRUCTURE via DOMINATE OUT edge.
    */
  def _controlStructureViaDominateOut: overflowdb.traversal.Traversal[ControlStructure] =
    get()._controlStructureViaDominateOut

  /** Traverse to RETURN via DOMINATE OUT edge.
    */
  def _returnViaDominateOut: overflowdb.traversal.Traversal[Return] = get()._returnViaDominateOut

  /** Traverse to TYPE_REF via DOMINATE OUT edge.
    */
  def _typeRefViaDominateOut: overflowdb.traversal.Traversal[TypeRef] = get()._typeRefViaDominateOut

  /** Traverse to BLOCK via DOMINATE OUT edge.
    */
  def _blockViaDominateOut: overflowdb.traversal.Traversal[Block] = get()._blockViaDominateOut

  /** Traverse to FIELD_IDENTIFIER via DOMINATE OUT edge.
    */
  def _fieldIdentifierViaDominateOut: overflowdb.traversal.Traversal[FieldIdentifier] =
    get()._fieldIdentifierViaDominateOut

  def reachingDefOut: overflowdb.traversal.Traversal[CfgNode] = get().reachingDefOut
  override def _reachingDefOut                                = get()._reachingDefOut

  /** Traverse to CALL via REACHING_DEF OUT edge.
    */
  def _callViaReachingDefOut: overflowdb.traversal.Traversal[Call] = get()._callViaReachingDefOut

  /** Traverse to IDENTIFIER via REACHING_DEF OUT edge.
    */
  def _identifierViaReachingDefOut: overflowdb.traversal.Traversal[Identifier] = get()._identifierViaReachingDefOut

  /** Traverse to METHOD_PARAMETER_OUT via REACHING_DEF OUT edge.
    */
  def _methodParameterOutViaReachingDefOut: overflowdb.traversal.Traversal[MethodParameterOut] =
    get()._methodParameterOutViaReachingDefOut

  /** Traverse to METHOD_REF via REACHING_DEF OUT edge.
    */
  def _methodRefViaReachingDefOut: overflowdb.traversal.Traversal[MethodRef] = get()._methodRefViaReachingDefOut

  /** Traverse to TYPE_REF via REACHING_DEF OUT edge.
    */
  def _typeRefViaReachingDefOut: overflowdb.traversal.Traversal[TypeRef] = get()._typeRefViaReachingDefOut

  /** Traverse to LITERAL via REACHING_DEF OUT edge.
    */
  def _literalViaReachingDefOut: overflowdb.traversal.Traversal[Literal] = get()._literalViaReachingDefOut

  /** Traverse to RETURN via REACHING_DEF OUT edge.
    */
  def _returnViaReachingDefOut: overflowdb.traversal.Traversal[Return] = get()._returnViaReachingDefOut

  def receiverOut: overflowdb.traversal.Traversal[Expression] = get().receiverOut
  override def _receiverOut                                   = get()._receiverOut

  /** Traverse to BLOCK via RECEIVER OUT edge.
    */
  def _blockViaReceiverOut: Option[Block] = get()._blockViaReceiverOut

  /** Traverse to UNKNOWN via RECEIVER OUT edge.
    */
  def _unknownViaReceiverOut: overflowdb.traversal.Traversal[Unknown] = get()._unknownViaReceiverOut

  /** Traverse to LITERAL via RECEIVER OUT edge.
    */
  def _literalViaReceiverOut: Option[Literal] = get()._literalViaReceiverOut

  /** Traverse to CALL via RECEIVER OUT edge.
    */
  def _callViaReceiverOut: Option[Call] = get()._callViaReceiverOut

  /** Traverse to TYPE_REF via RECEIVER OUT edge.
    */
  def _typeRefViaReceiverOut: overflowdb.traversal.Traversal[TypeRef] = get()._typeRefViaReceiverOut

  /** Traverse to METHOD_REF via RECEIVER OUT edge.
    */
  def _methodRefViaReceiverOut: Option[MethodRef] = get()._methodRefViaReceiverOut

  /** Traverse to CONTROL_STRUCTURE via RECEIVER OUT edge.
    */
  def _controlStructureViaReceiverOut: overflowdb.traversal.Traversal[ControlStructure] =
    get()._controlStructureViaReceiverOut

  /** Traverse to IDENTIFIER via RECEIVER OUT edge.
    */
  def _identifierViaReceiverOut: Option[Identifier] = get()._identifierViaReceiverOut

  def postDominateOut: overflowdb.traversal.Traversal[CfgNode] = get().postDominateOut
  override def _postDominateOut                                = get()._postDominateOut

  /** Traverse to BLOCK via POST_DOMINATE OUT edge.
    */
  def _blockViaPostDominateOut: overflowdb.traversal.Traversal[Block] = get()._blockViaPostDominateOut

  /** Traverse to LITERAL via POST_DOMINATE OUT edge.
    */
  def _literalViaPostDominateOut: overflowdb.traversal.Traversal[Literal] = get()._literalViaPostDominateOut

  /** Traverse to UNKNOWN via POST_DOMINATE OUT edge.
    */
  def _unknownViaPostDominateOut: overflowdb.traversal.Traversal[Unknown] = get()._unknownViaPostDominateOut

  /** Traverse to TYPE_REF via POST_DOMINATE OUT edge.
    */
  def _typeRefViaPostDominateOut: overflowdb.traversal.Traversal[TypeRef] = get()._typeRefViaPostDominateOut

  /** Traverse to FIELD_IDENTIFIER via POST_DOMINATE OUT edge.
    */
  def _fieldIdentifierViaPostDominateOut: overflowdb.traversal.Traversal[FieldIdentifier] =
    get()._fieldIdentifierViaPostDominateOut

  /** Traverse to CALL via POST_DOMINATE OUT edge.
    */
  def _callViaPostDominateOut: overflowdb.traversal.Traversal[Call] = get()._callViaPostDominateOut

  /** Traverse to JUMP_TARGET via POST_DOMINATE OUT edge.
    */
  def _jumpTargetViaPostDominateOut: overflowdb.traversal.Traversal[JumpTarget] = get()._jumpTargetViaPostDominateOut

  /** Traverse to IDENTIFIER via POST_DOMINATE OUT edge.
    */
  def _identifierViaPostDominateOut: overflowdb.traversal.Traversal[Identifier] = get()._identifierViaPostDominateOut

  /** Traverse to CONTROL_STRUCTURE via POST_DOMINATE OUT edge.
    */
  def _controlStructureViaPostDominateOut: overflowdb.traversal.Traversal[ControlStructure] =
    get()._controlStructureViaPostDominateOut

  /** Traverse to METHOD_REF via POST_DOMINATE OUT edge.
    */
  def _methodRefViaPostDominateOut: overflowdb.traversal.Traversal[MethodRef] = get()._methodRefViaPostDominateOut

  /** Traverse to RETURN via POST_DOMINATE OUT edge.
    */
  def _returnViaPostDominateOut: overflowdb.traversal.Traversal[Return] = get()._returnViaPostDominateOut

  /** Traverse to METHOD via POST_DOMINATE OUT edge.
    */
  def _methodViaPostDominateOut: overflowdb.traversal.Traversal[Method] = get()._methodViaPostDominateOut

  def argumentIn: overflowdb.traversal.Traversal[Expression] = get().argumentIn
  override def _argumentIn                                   = get()._argumentIn

  /** Traverse to CALL via ARGUMENT IN edge.
    */
  def _callViaArgumentIn: Option[Call] = get()._callViaArgumentIn

  /** Traverse to RETURN via ARGUMENT IN edge.
    */
  def _returnViaArgumentIn: Option[Return] = get()._returnViaArgumentIn

  def pointsToIn: overflowdb.traversal.Traversal[CfgNode] = get().pointsToIn
  override def _pointsToIn                                = get()._pointsToIn

  def conditionIn: overflowdb.traversal.Traversal[ControlStructure] = get().conditionIn
  override def _conditionIn                                         = get()._conditionIn

  /** Traverse to CONTROL_STRUCTURE via CONDITION IN edge.
    */
  def _controlStructureViaConditionIn: overflowdb.traversal.Traversal[ControlStructure] =
    get()._controlStructureViaConditionIn

  def astIn: overflowdb.traversal.Traversal[Expression] = get().astIn
  override def _astIn                                   = get()._astIn

  /** Traverse to BLOCK via AST IN edge.
    */
  def _blockViaAstIn: overflowdb.traversal.Traversal[Block] = get()._blockViaAstIn

  /** Traverse to CALL via AST IN edge.
    */
  def _callViaAstIn: overflowdb.traversal.Traversal[Call] = get()._callViaAstIn

  /** Traverse to UNKNOWN via AST IN edge.
    */
  def _unknownViaAstIn: overflowdb.traversal.Traversal[Unknown] = get()._unknownViaAstIn

  /** Traverse to CONTROL_STRUCTURE via AST IN edge.
    */
  def _controlStructureViaAstIn: ControlStructure = get()._controlStructureViaAstIn

  /** Traverse to RETURN via AST IN edge.
    */
  def _returnViaAstIn: overflowdb.traversal.Traversal[Return] = get()._returnViaAstIn

  def cfgIn: overflowdb.traversal.Traversal[CfgNode] = get().cfgIn
  override def _cfgIn                                = get()._cfgIn

  def containsIn: overflowdb.traversal.Traversal[Method] = get().containsIn
  override def _containsIn                               = get()._containsIn

  /** Traverse to METHOD via CONTAINS IN edge.
    */
  def _methodViaContainsIn: overflowdb.traversal.Traversal[Method] = get()._methodViaContainsIn

  def cdgIn: overflowdb.traversal.Traversal[CfgNode] = get().cdgIn
  override def _cdgIn                                = get()._cdgIn

  /** Traverse to JUMP_TARGET via CDG IN edge.
    */
  def _jumpTargetViaCdgIn: overflowdb.traversal.Traversal[JumpTarget] = get()._jumpTargetViaCdgIn

  /** Traverse to METHOD_REF via CDG IN edge.
    */
  def _methodRefViaCdgIn: overflowdb.traversal.Traversal[MethodRef] = get()._methodRefViaCdgIn

  /** Traverse to LITERAL via CDG IN edge.
    */
  def _literalViaCdgIn: overflowdb.traversal.Traversal[Literal] = get()._literalViaCdgIn

  /** Traverse to BLOCK via CDG IN edge.
    */
  def _blockViaCdgIn: overflowdb.traversal.Traversal[Block] = get()._blockViaCdgIn

  /** Traverse to TYPE_REF via CDG IN edge.
    */
  def _typeRefViaCdgIn: overflowdb.traversal.Traversal[TypeRef] = get()._typeRefViaCdgIn

  /** Traverse to CALL via CDG IN edge.
    */
  def _callViaCdgIn: overflowdb.traversal.Traversal[Call] = get()._callViaCdgIn

  /** Traverse to FIELD_IDENTIFIER via CDG IN edge.
    */
  def _fieldIdentifierViaCdgIn: overflowdb.traversal.Traversal[FieldIdentifier] = get()._fieldIdentifierViaCdgIn

  /** Traverse to IDENTIFIER via CDG IN edge.
    */
  def _identifierViaCdgIn: overflowdb.traversal.Traversal[Identifier] = get()._identifierViaCdgIn

  /** Traverse to UNKNOWN via CDG IN edge.
    */
  def _unknownViaCdgIn: overflowdb.traversal.Traversal[Unknown] = get()._unknownViaCdgIn

  /** Traverse to CONTROL_STRUCTURE via CDG IN edge.
    */
  def _controlStructureViaCdgIn: overflowdb.traversal.Traversal[ControlStructure] = get()._controlStructureViaCdgIn

  def dominateIn: overflowdb.traversal.Traversal[CfgNode] = get().dominateIn
  override def _dominateIn                                = get()._dominateIn

  /** Traverse to METHOD via DOMINATE IN edge.
    */
  def _methodViaDominateIn: overflowdb.traversal.Traversal[Method] = get()._methodViaDominateIn

  /** Traverse to LITERAL via DOMINATE IN edge.
    */
  def _literalViaDominateIn: overflowdb.traversal.Traversal[Literal] = get()._literalViaDominateIn

  /** Traverse to METHOD_REF via DOMINATE IN edge.
    */
  def _methodRefViaDominateIn: overflowdb.traversal.Traversal[MethodRef] = get()._methodRefViaDominateIn

  /** Traverse to CALL via DOMINATE IN edge.
    */
  def _callViaDominateIn: overflowdb.traversal.Traversal[Call] = get()._callViaDominateIn

  /** Traverse to UNKNOWN via DOMINATE IN edge.
    */
  def _unknownViaDominateIn: overflowdb.traversal.Traversal[Unknown] = get()._unknownViaDominateIn

  /** Traverse to IDENTIFIER via DOMINATE IN edge.
    */
  def _identifierViaDominateIn: overflowdb.traversal.Traversal[Identifier] = get()._identifierViaDominateIn

  /** Traverse to JUMP_TARGET via DOMINATE IN edge.
    */
  def _jumpTargetViaDominateIn: overflowdb.traversal.Traversal[JumpTarget] = get()._jumpTargetViaDominateIn

  /** Traverse to CONTROL_STRUCTURE via DOMINATE IN edge.
    */
  def _controlStructureViaDominateIn: overflowdb.traversal.Traversal[ControlStructure] =
    get()._controlStructureViaDominateIn

  /** Traverse to RETURN via DOMINATE IN edge.
    */
  def _returnViaDominateIn: overflowdb.traversal.Traversal[Return] = get()._returnViaDominateIn

  /** Traverse to TYPE_REF via DOMINATE IN edge.
    */
  def _typeRefViaDominateIn: overflowdb.traversal.Traversal[TypeRef] = get()._typeRefViaDominateIn

  /** Traverse to BLOCK via DOMINATE IN edge.
    */
  def _blockViaDominateIn: overflowdb.traversal.Traversal[Block] = get()._blockViaDominateIn

  /** Traverse to FIELD_IDENTIFIER via DOMINATE IN edge.
    */
  def _fieldIdentifierViaDominateIn: overflowdb.traversal.Traversal[FieldIdentifier] =
    get()._fieldIdentifierViaDominateIn

  def reachingDefIn: overflowdb.traversal.Traversal[CfgNode] = get().reachingDefIn
  override def _reachingDefIn                                = get()._reachingDefIn

  /** Traverse to UNKNOWN via REACHING_DEF IN edge.
    */
  def _unknownViaReachingDefIn: overflowdb.traversal.Traversal[Unknown] = get()._unknownViaReachingDefIn

  /** Traverse to CALL via REACHING_DEF IN edge.
    */
  def _callViaReachingDefIn: overflowdb.traversal.Traversal[Call] = get()._callViaReachingDefIn

  /** Traverse to IDENTIFIER via REACHING_DEF IN edge.
    */
  def _identifierViaReachingDefIn: overflowdb.traversal.Traversal[Identifier] = get()._identifierViaReachingDefIn

  /** Traverse to CONTROL_STRUCTURE via REACHING_DEF IN edge.
    */
  def _controlStructureViaReachingDefIn: overflowdb.traversal.Traversal[ControlStructure] =
    get()._controlStructureViaReachingDefIn

  /** Traverse to METHOD_PARAMETER_OUT via REACHING_DEF IN edge.
    */
  def _methodParameterOutViaReachingDefIn: overflowdb.traversal.Traversal[MethodParameterOut] =
    get()._methodParameterOutViaReachingDefIn

  /** Traverse to BLOCK via REACHING_DEF IN edge.
    */
  def _blockViaReachingDefIn: overflowdb.traversal.Traversal[Block] = get()._blockViaReachingDefIn

  /** Traverse to METHOD_PARAMETER_IN via REACHING_DEF IN edge.
    */
  def _methodParameterInViaReachingDefIn: overflowdb.traversal.Traversal[MethodParameterIn] =
    get()._methodParameterInViaReachingDefIn

  /** Traverse to METHOD_REF via REACHING_DEF IN edge.
    */
  def _methodRefViaReachingDefIn: overflowdb.traversal.Traversal[MethodRef] = get()._methodRefViaReachingDefIn

  /** Traverse to TYPE_REF via REACHING_DEF IN edge.
    */
  def _typeRefViaReachingDefIn: overflowdb.traversal.Traversal[TypeRef] = get()._typeRefViaReachingDefIn

  /** Traverse to LITERAL via REACHING_DEF IN edge.
    */
  def _literalViaReachingDefIn: overflowdb.traversal.Traversal[Literal] = get()._literalViaReachingDefIn

  /** Traverse to METHOD via REACHING_DEF IN edge.
    */
  def _methodViaReachingDefIn: overflowdb.traversal.Traversal[Method] = get()._methodViaReachingDefIn

  def receiverIn: overflowdb.traversal.Traversal[Call] = get().receiverIn
  override def _receiverIn                             = get()._receiverIn

  /** Traverse to CALL via RECEIVER IN edge.
    */
  def _callViaReceiverIn: Option[Call] = get()._callViaReceiverIn

  def postDominateIn: overflowdb.traversal.Traversal[CfgNode] = get().postDominateIn
  override def _postDominateIn                                = get()._postDominateIn

  /** Traverse to BLOCK via POST_DOMINATE IN edge.
    */
  def _blockViaPostDominateIn: overflowdb.traversal.Traversal[Block] = get()._blockViaPostDominateIn

  /** Traverse to LITERAL via POST_DOMINATE IN edge.
    */
  def _literalViaPostDominateIn: overflowdb.traversal.Traversal[Literal] = get()._literalViaPostDominateIn

  /** Traverse to UNKNOWN via POST_DOMINATE IN edge.
    */
  def _unknownViaPostDominateIn: overflowdb.traversal.Traversal[Unknown] = get()._unknownViaPostDominateIn

  /** Traverse to TYPE_REF via POST_DOMINATE IN edge.
    */
  def _typeRefViaPostDominateIn: overflowdb.traversal.Traversal[TypeRef] = get()._typeRefViaPostDominateIn

  /** Traverse to FIELD_IDENTIFIER via POST_DOMINATE IN edge.
    */
  def _fieldIdentifierViaPostDominateIn: overflowdb.traversal.Traversal[FieldIdentifier] =
    get()._fieldIdentifierViaPostDominateIn

  /** Traverse to METHOD_RETURN via POST_DOMINATE IN edge.
    */
  def _methodReturnViaPostDominateIn: overflowdb.traversal.Traversal[MethodReturn] =
    get()._methodReturnViaPostDominateIn

  /** Traverse to CALL via POST_DOMINATE IN edge.
    */
  def _callViaPostDominateIn: overflowdb.traversal.Traversal[Call] = get()._callViaPostDominateIn

  /** Traverse to JUMP_TARGET via POST_DOMINATE IN edge.
    */
  def _jumpTargetViaPostDominateIn: overflowdb.traversal.Traversal[JumpTarget] = get()._jumpTargetViaPostDominateIn

  /** Traverse to IDENTIFIER via POST_DOMINATE IN edge.
    */
  def _identifierViaPostDominateIn: overflowdb.traversal.Traversal[Identifier] = get()._identifierViaPostDominateIn

  /** Traverse to CONTROL_STRUCTURE via POST_DOMINATE IN edge.
    */
  def _controlStructureViaPostDominateIn: overflowdb.traversal.Traversal[ControlStructure] =
    get()._controlStructureViaPostDominateIn

  /** Traverse to METHOD_REF via POST_DOMINATE IN edge.
    */
  def _methodRefViaPostDominateIn: overflowdb.traversal.Traversal[MethodRef] = get()._methodRefViaPostDominateIn

  /** Traverse to RETURN via POST_DOMINATE IN edge.
    */
  def _returnViaPostDominateIn: overflowdb.traversal.Traversal[Return] = get()._returnViaPostDominateIn

  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def canEqual(that: Any): Boolean                                        = get.canEqual(that)
  override def label: String = {
    Call.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0  => "id"
      case 1  => "argumentIndex"
      case 2  => "argumentName"
      case 3  => "code"
      case 4  => "columnNumber"
      case 5  => "dispatchType"
      case 6  => "dynamicTypeHintFullName"
      case 7  => "lineNumber"
      case 8  => "methodFullName"
      case 9  => "name"
      case 10 => "order"
      case 11 => "signature"
      case 12 => "typeFullName"
    }

  override def productElement(n: Int): Any =
    n match {
      case 0  => id
      case 1  => argumentIndex
      case 2  => argumentName
      case 3  => code
      case 4  => columnNumber
      case 5  => dispatchType
      case 6  => dynamicTypeHintFullName
      case 7  => lineNumber
      case 8  => methodFullName
      case 9  => name
      case 10 => order
      case 11 => signature
      case 12 => typeFullName
    }

  override def productPrefix = "Call"
  override def productArity  = 13
}

class CallDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode with Expression with CallRepr with CallBase {

  override def layoutInformation: NodeLayoutInformation = Call.layoutInformation

  private var _argumentIndex: scala.Int                    = Call.PropertyDefaults.ArgumentIndex
  def argumentIndex: scala.Int                             = _argumentIndex
  private var _argumentName: String                        = null
  def argumentName: Option[String]                         = Option(_argumentName)
  private var _code: String                                = Call.PropertyDefaults.Code
  def code: String                                         = _code
  private var _columnNumber: Integer                       = null
  def columnNumber: Option[Integer]                        = Option(_columnNumber)
  private var _dispatchType: String                        = Call.PropertyDefaults.DispatchType
  def dispatchType: String                                 = _dispatchType
  private var _dynamicTypeHintFullName: IndexedSeq[String] = collection.immutable.ArraySeq.empty
  def dynamicTypeHintFullName: IndexedSeq[String]          = _dynamicTypeHintFullName
  private var _lineNumber: Integer                         = null
  def lineNumber: Option[Integer]                          = Option(_lineNumber)
  private var _methodFullName: String                      = Call.PropertyDefaults.MethodFullName
  def methodFullName: String                               = _methodFullName
  private var _name: String                                = Call.PropertyDefaults.Name
  def name: String                                         = _name
  private var _order: scala.Int                            = Call.PropertyDefaults.Order
  def order: scala.Int                                     = _order
  private var _signature: String                           = Call.PropertyDefaults.Signature
  def signature: String                                    = _signature
  private var _typeFullName: String                        = Call.PropertyDefaults.TypeFullName
  def typeFullName: String                                 = _typeFullName

  /** faster than the default implementation */
  override def propertiesMap: java.util.Map[String, Any] = {
    val properties = new java.util.HashMap[String, Any]
    properties.put("ARGUMENT_INDEX", argumentIndex)
    argumentName.map { value => properties.put("ARGUMENT_NAME", value) }
    properties.put("CODE", code)
    columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
    properties.put("DISPATCH_TYPE", dispatchType)
    if (this._dynamicTypeHintFullName != null && this._dynamicTypeHintFullName.nonEmpty) {
      properties.put("DYNAMIC_TYPE_HINT_FULL_NAME", dynamicTypeHintFullName)
    }
    lineNumber.map { value => properties.put("LINE_NUMBER", value) }
    properties.put("METHOD_FULL_NAME", methodFullName)
    properties.put("NAME", name)
    properties.put("ORDER", order)
    properties.put("SIGNATURE", signature)
    properties.put("TYPE_FULL_NAME", typeFullName)

    properties
  }

  /** faster than the default implementation */
  override def propertiesMapForStorage: java.util.Map[String, Any] = {
    val properties = new java.util.HashMap[String, Any]
    if (!((-1: Int) == argumentIndex)) { properties.put("ARGUMENT_INDEX", argumentIndex) }
    argumentName.map { value => properties.put("ARGUMENT_NAME", value) }
    if (!(("<empty>") == code)) { properties.put("CODE", code) }
    columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
    if (!(("<empty>") == dispatchType)) { properties.put("DISPATCH_TYPE", dispatchType) }
    if (this._dynamicTypeHintFullName != null && this._dynamicTypeHintFullName.nonEmpty) {
      properties.put("DYNAMIC_TYPE_HINT_FULL_NAME", dynamicTypeHintFullName)
    }
    lineNumber.map { value => properties.put("LINE_NUMBER", value) }
    if (!(("<empty>") == methodFullName)) { properties.put("METHOD_FULL_NAME", methodFullName) }
    if (!(("<empty>") == name)) { properties.put("NAME", name) }
    if (!((-1: Int) == order)) { properties.put("ORDER", order) }
    if (!(("") == signature)) { properties.put("SIGNATURE", signature) }
    if (!(("<empty>") == typeFullName)) { properties.put("TYPE_FULL_NAME", typeFullName) }

    properties
  }

  def argumentOut: overflowdb.traversal.Traversal[CfgNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[CfgNode](0))
  override def _argumentOut = createAdjacentNodeIteratorByOffSet[StoredNode](0)
  def _controlStructureViaArgumentOut: overflowdb.traversal.Traversal[ControlStructure] =
    argumentOut.collectAll[ControlStructure]
  def _jumpTargetViaArgumentOut: overflowdb.traversal.Traversal[JumpTarget] = argumentOut.collectAll[JumpTarget]
  def _callViaArgumentOut: overflowdb.traversal.Traversal[Call]             = argumentOut.collectAll[Call]
  def _unknownViaArgumentOut: overflowdb.traversal.Traversal[Unknown]       = argumentOut.collectAll[Unknown]
  def _literalViaArgumentOut: overflowdb.traversal.Traversal[Literal]       = argumentOut.collectAll[Literal]
  def _methodRefViaArgumentOut: overflowdb.traversal.Traversal[MethodRef]   = argumentOut.collectAll[MethodRef]
  def _blockViaArgumentOut: overflowdb.traversal.Traversal[Block]           = argumentOut.collectAll[Block]
  def _identifierViaArgumentOut: overflowdb.traversal.Traversal[Identifier] = argumentOut.collectAll[Identifier]
  def _typeRefViaArgumentOut: overflowdb.traversal.Traversal[TypeRef]       = argumentOut.collectAll[TypeRef]
  def _fieldIdentifierViaArgumentOut: overflowdb.traversal.Traversal[FieldIdentifier] =
    argumentOut.collectAll[FieldIdentifier]

  def pointsToOut: overflowdb.traversal.Traversal[CfgNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[CfgNode](1))
  override def _pointsToOut = createAdjacentNodeIteratorByOffSet[StoredNode](1)

  def astOut: overflowdb.traversal.Traversal[Expression] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[Expression](2))
  override def _astOut = createAdjacentNodeIteratorByOffSet[StoredNode](2)
  def _fieldIdentifierViaAstOut: overflowdb.traversal.Traversal[FieldIdentifier]   = astOut.collectAll[FieldIdentifier]
  def _blockViaAstOut: overflowdb.traversal.Traversal[Block]                       = astOut.collectAll[Block]
  def _controlStructureViaAstOut: overflowdb.traversal.Traversal[ControlStructure] = astOut.collectAll[ControlStructure]
  def _identifierViaAstOut: overflowdb.traversal.Traversal[Identifier]             = astOut.collectAll[Identifier]
  def _literalViaAstOut: overflowdb.traversal.Traversal[Literal]                   = astOut.collectAll[Literal]
  def _typeRefViaAstOut: overflowdb.traversal.Traversal[TypeRef]                   = astOut.collectAll[TypeRef]
  def _callViaAstOut: overflowdb.traversal.Traversal[Call]                         = astOut.collectAll[Call]
  def _returnViaAstOut: overflowdb.traversal.Traversal[Return]                     = astOut.collectAll[Return]
  def _methodRefViaAstOut: overflowdb.traversal.Traversal[MethodRef]               = astOut.collectAll[MethodRef]

  def evalTypeOut: overflowdb.traversal.Traversal[Type] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[Type](3))
  override def _evalTypeOut                                     = createAdjacentNodeIteratorByOffSet[StoredNode](3)
  def _typeViaEvalTypeOut: overflowdb.traversal.Traversal[Type] = evalTypeOut.collectAll[Type]

  def refOut: overflowdb.traversal.Traversal[Member] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[Member](4))
  override def _refOut                                         = createAdjacentNodeIteratorByOffSet[StoredNode](4)
  def referencedMember: overflowdb.traversal.Traversal[Member] = refOut.collectAll[Member]

  def cfgOut: overflowdb.traversal.Traversal[CfgNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[CfgNode](5))
  override def _cfgOut                                           = createAdjacentNodeIteratorByOffSet[StoredNode](5)
  def _cfgNodeViaCfgOut: overflowdb.traversal.Traversal[CfgNode] = cfgOut.collectAll[CfgNode]

  def taggedByOut: overflowdb.traversal.Traversal[Tag] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[Tag](6))
  override def _taggedByOut                                   = createAdjacentNodeIteratorByOffSet[StoredNode](6)
  def _tagViaTaggedByOut: overflowdb.traversal.Traversal[Tag] = taggedByOut.collectAll[Tag]

  def callOut: overflowdb.traversal.Traversal[Method] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[Method](7))
  override def _callOut                                         = createAdjacentNodeIteratorByOffSet[StoredNode](7)
  def _methodViaCallOut: overflowdb.traversal.Traversal[Method] = callOut.collectAll[Method]

  def cdgOut: overflowdb.traversal.Traversal[CfgNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[CfgNode](8))
  override def _cdgOut = createAdjacentNodeIteratorByOffSet[StoredNode](8)
  def _jumpTargetViaCdgOut: overflowdb.traversal.Traversal[JumpTarget]             = cdgOut.collectAll[JumpTarget]
  def _methodRefViaCdgOut: overflowdb.traversal.Traversal[MethodRef]               = cdgOut.collectAll[MethodRef]
  def _literalViaCdgOut: overflowdb.traversal.Traversal[Literal]                   = cdgOut.collectAll[Literal]
  def _returnViaCdgOut: overflowdb.traversal.Traversal[Return]                     = cdgOut.collectAll[Return]
  def _blockViaCdgOut: overflowdb.traversal.Traversal[Block]                       = cdgOut.collectAll[Block]
  def _typeRefViaCdgOut: overflowdb.traversal.Traversal[TypeRef]                   = cdgOut.collectAll[TypeRef]
  def _methodReturnViaCdgOut: overflowdb.traversal.Traversal[MethodReturn]         = cdgOut.collectAll[MethodReturn]
  def _callViaCdgOut: overflowdb.traversal.Traversal[Call]                         = cdgOut.collectAll[Call]
  def _fieldIdentifierViaCdgOut: overflowdb.traversal.Traversal[FieldIdentifier]   = cdgOut.collectAll[FieldIdentifier]
  def _identifierViaCdgOut: overflowdb.traversal.Traversal[Identifier]             = cdgOut.collectAll[Identifier]
  def _unknownViaCdgOut: overflowdb.traversal.Traversal[Unknown]                   = cdgOut.collectAll[Unknown]
  def _controlStructureViaCdgOut: overflowdb.traversal.Traversal[ControlStructure] = cdgOut.collectAll[ControlStructure]

  def dominateOut: overflowdb.traversal.Traversal[CfgNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[CfgNode](9))
  override def _dominateOut = createAdjacentNodeIteratorByOffSet[StoredNode](9)
  def _literalViaDominateOut: overflowdb.traversal.Traversal[Literal]           = dominateOut.collectAll[Literal]
  def _methodRefViaDominateOut: overflowdb.traversal.Traversal[MethodRef]       = dominateOut.collectAll[MethodRef]
  def _methodReturnViaDominateOut: overflowdb.traversal.Traversal[MethodReturn] = dominateOut.collectAll[MethodReturn]
  def _callViaDominateOut: overflowdb.traversal.Traversal[Call]                 = dominateOut.collectAll[Call]
  def _unknownViaDominateOut: overflowdb.traversal.Traversal[Unknown]           = dominateOut.collectAll[Unknown]
  def _identifierViaDominateOut: overflowdb.traversal.Traversal[Identifier]     = dominateOut.collectAll[Identifier]
  def _jumpTargetViaDominateOut: overflowdb.traversal.Traversal[JumpTarget]     = dominateOut.collectAll[JumpTarget]
  def _controlStructureViaDominateOut: overflowdb.traversal.Traversal[ControlStructure] =
    dominateOut.collectAll[ControlStructure]
  def _returnViaDominateOut: overflowdb.traversal.Traversal[Return]   = dominateOut.collectAll[Return]
  def _typeRefViaDominateOut: overflowdb.traversal.Traversal[TypeRef] = dominateOut.collectAll[TypeRef]
  def _blockViaDominateOut: overflowdb.traversal.Traversal[Block]     = dominateOut.collectAll[Block]
  def _fieldIdentifierViaDominateOut: overflowdb.traversal.Traversal[FieldIdentifier] =
    dominateOut.collectAll[FieldIdentifier]

  def reachingDefOut: overflowdb.traversal.Traversal[CfgNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[CfgNode](10))
  override def _reachingDefOut                                     = createAdjacentNodeIteratorByOffSet[StoredNode](10)
  def _callViaReachingDefOut: overflowdb.traversal.Traversal[Call] = reachingDefOut.collectAll[Call]
  def _identifierViaReachingDefOut: overflowdb.traversal.Traversal[Identifier] = reachingDefOut.collectAll[Identifier]
  def _methodParameterOutViaReachingDefOut: overflowdb.traversal.Traversal[MethodParameterOut] =
    reachingDefOut.collectAll[MethodParameterOut]
  def _methodRefViaReachingDefOut: overflowdb.traversal.Traversal[MethodRef] = reachingDefOut.collectAll[MethodRef]
  def _typeRefViaReachingDefOut: overflowdb.traversal.Traversal[TypeRef]     = reachingDefOut.collectAll[TypeRef]
  def _literalViaReachingDefOut: overflowdb.traversal.Traversal[Literal]     = reachingDefOut.collectAll[Literal]
  def _returnViaReachingDefOut: overflowdb.traversal.Traversal[Return]       = reachingDefOut.collectAll[Return]

  def receiverOut: overflowdb.traversal.Traversal[Expression] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[Expression](11))
  override def _receiverOut               = createAdjacentNodeIteratorByOffSet[StoredNode](11)
  def _blockViaReceiverOut: Option[Block] = receiverOut.collectAll[Block].nextOption()
  def _unknownViaReceiverOut: overflowdb.traversal.Traversal[Unknown] = receiverOut.collectAll[Unknown]
  def _literalViaReceiverOut: Option[Literal]                         = receiverOut.collectAll[Literal].nextOption()
  def _callViaReceiverOut: Option[Call]                               = receiverOut.collectAll[Call].nextOption()
  def _typeRefViaReceiverOut: overflowdb.traversal.Traversal[TypeRef] = receiverOut.collectAll[TypeRef]
  def _methodRefViaReceiverOut: Option[MethodRef]                     = receiverOut.collectAll[MethodRef].nextOption()
  def _controlStructureViaReceiverOut: overflowdb.traversal.Traversal[ControlStructure] =
    receiverOut.collectAll[ControlStructure]
  def _identifierViaReceiverOut: Option[Identifier] = receiverOut.collectAll[Identifier].nextOption()

  def postDominateOut: overflowdb.traversal.Traversal[CfgNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[CfgNode](12))
  override def _postDominateOut = createAdjacentNodeIteratorByOffSet[StoredNode](12)
  def _blockViaPostDominateOut: overflowdb.traversal.Traversal[Block]     = postDominateOut.collectAll[Block]
  def _literalViaPostDominateOut: overflowdb.traversal.Traversal[Literal] = postDominateOut.collectAll[Literal]
  def _unknownViaPostDominateOut: overflowdb.traversal.Traversal[Unknown] = postDominateOut.collectAll[Unknown]
  def _typeRefViaPostDominateOut: overflowdb.traversal.Traversal[TypeRef] = postDominateOut.collectAll[TypeRef]
  def _fieldIdentifierViaPostDominateOut: overflowdb.traversal.Traversal[FieldIdentifier] =
    postDominateOut.collectAll[FieldIdentifier]
  def _callViaPostDominateOut: overflowdb.traversal.Traversal[Call]             = postDominateOut.collectAll[Call]
  def _jumpTargetViaPostDominateOut: overflowdb.traversal.Traversal[JumpTarget] = postDominateOut.collectAll[JumpTarget]
  def _identifierViaPostDominateOut: overflowdb.traversal.Traversal[Identifier] = postDominateOut.collectAll[Identifier]
  def _controlStructureViaPostDominateOut: overflowdb.traversal.Traversal[ControlStructure] =
    postDominateOut.collectAll[ControlStructure]
  def _methodRefViaPostDominateOut: overflowdb.traversal.Traversal[MethodRef] = postDominateOut.collectAll[MethodRef]
  def _returnViaPostDominateOut: overflowdb.traversal.Traversal[Return]       = postDominateOut.collectAll[Return]
  def _methodViaPostDominateOut: overflowdb.traversal.Traversal[Method]       = postDominateOut.collectAll[Method]

  def argumentIn: overflowdb.traversal.Traversal[Expression] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[Expression](13))
  override def _argumentIn                 = createAdjacentNodeIteratorByOffSet[StoredNode](13)
  def _callViaArgumentIn: Option[Call]     = argumentIn.collectAll[Call].nextOption()
  def _returnViaArgumentIn: Option[Return] = argumentIn.collectAll[Return].nextOption()

  def pointsToIn: overflowdb.traversal.Traversal[CfgNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[CfgNode](14))
  override def _pointsToIn = createAdjacentNodeIteratorByOffSet[StoredNode](14)

  def conditionIn: overflowdb.traversal.Traversal[ControlStructure] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[ControlStructure](15))
  override def _conditionIn = createAdjacentNodeIteratorByOffSet[StoredNode](15)
  def _controlStructureViaConditionIn: overflowdb.traversal.Traversal[ControlStructure] =
    conditionIn.collectAll[ControlStructure]

  def astIn: overflowdb.traversal.Traversal[Expression] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[Expression](16))
  override def _astIn                                           = createAdjacentNodeIteratorByOffSet[StoredNode](16)
  def _blockViaAstIn: overflowdb.traversal.Traversal[Block]     = astIn.collectAll[Block]
  def _callViaAstIn: overflowdb.traversal.Traversal[Call]       = astIn.collectAll[Call]
  def _unknownViaAstIn: overflowdb.traversal.Traversal[Unknown] = astIn.collectAll[Unknown]
  def _controlStructureViaAstIn: ControlStructure = try { astIn.collectAll[ControlStructure].next() }
  catch {
    case e: java.util.NoSuchElementException =>
      throw new overflowdb.SchemaViolationException(
        "IN edge with label AST to an adjacent CONTROL_STRUCTURE is mandatory, but not defined for this CALL node with id=" + id,
        e
      )
  }
  def _returnViaAstIn: overflowdb.traversal.Traversal[Return] = astIn.collectAll[Return]

  def cfgIn: overflowdb.traversal.Traversal[CfgNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[CfgNode](17))
  override def _cfgIn = createAdjacentNodeIteratorByOffSet[StoredNode](17)

  def containsIn: overflowdb.traversal.Traversal[Method] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[Method](18))
  override def _containsIn                                         = createAdjacentNodeIteratorByOffSet[StoredNode](18)
  def _methodViaContainsIn: overflowdb.traversal.Traversal[Method] = containsIn.collectAll[Method]

  def cdgIn: overflowdb.traversal.Traversal[CfgNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[CfgNode](19))
  override def _cdgIn = createAdjacentNodeIteratorByOffSet[StoredNode](19)
  def _jumpTargetViaCdgIn: overflowdb.traversal.Traversal[JumpTarget]             = cdgIn.collectAll[JumpTarget]
  def _methodRefViaCdgIn: overflowdb.traversal.Traversal[MethodRef]               = cdgIn.collectAll[MethodRef]
  def _literalViaCdgIn: overflowdb.traversal.Traversal[Literal]                   = cdgIn.collectAll[Literal]
  def _blockViaCdgIn: overflowdb.traversal.Traversal[Block]                       = cdgIn.collectAll[Block]
  def _typeRefViaCdgIn: overflowdb.traversal.Traversal[TypeRef]                   = cdgIn.collectAll[TypeRef]
  def _callViaCdgIn: overflowdb.traversal.Traversal[Call]                         = cdgIn.collectAll[Call]
  def _fieldIdentifierViaCdgIn: overflowdb.traversal.Traversal[FieldIdentifier]   = cdgIn.collectAll[FieldIdentifier]
  def _identifierViaCdgIn: overflowdb.traversal.Traversal[Identifier]             = cdgIn.collectAll[Identifier]
  def _unknownViaCdgIn: overflowdb.traversal.Traversal[Unknown]                   = cdgIn.collectAll[Unknown]
  def _controlStructureViaCdgIn: overflowdb.traversal.Traversal[ControlStructure] = cdgIn.collectAll[ControlStructure]

  def dominateIn: overflowdb.traversal.Traversal[CfgNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[CfgNode](20))
  override def _dominateIn                                         = createAdjacentNodeIteratorByOffSet[StoredNode](20)
  def _methodViaDominateIn: overflowdb.traversal.Traversal[Method] = dominateIn.collectAll[Method]
  def _literalViaDominateIn: overflowdb.traversal.Traversal[Literal]       = dominateIn.collectAll[Literal]
  def _methodRefViaDominateIn: overflowdb.traversal.Traversal[MethodRef]   = dominateIn.collectAll[MethodRef]
  def _callViaDominateIn: overflowdb.traversal.Traversal[Call]             = dominateIn.collectAll[Call]
  def _unknownViaDominateIn: overflowdb.traversal.Traversal[Unknown]       = dominateIn.collectAll[Unknown]
  def _identifierViaDominateIn: overflowdb.traversal.Traversal[Identifier] = dominateIn.collectAll[Identifier]
  def _jumpTargetViaDominateIn: overflowdb.traversal.Traversal[JumpTarget] = dominateIn.collectAll[JumpTarget]
  def _controlStructureViaDominateIn: overflowdb.traversal.Traversal[ControlStructure] =
    dominateIn.collectAll[ControlStructure]
  def _returnViaDominateIn: overflowdb.traversal.Traversal[Return]   = dominateIn.collectAll[Return]
  def _typeRefViaDominateIn: overflowdb.traversal.Traversal[TypeRef] = dominateIn.collectAll[TypeRef]
  def _blockViaDominateIn: overflowdb.traversal.Traversal[Block]     = dominateIn.collectAll[Block]
  def _fieldIdentifierViaDominateIn: overflowdb.traversal.Traversal[FieldIdentifier] =
    dominateIn.collectAll[FieldIdentifier]

  def reachingDefIn: overflowdb.traversal.Traversal[CfgNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[CfgNode](21))
  override def _reachingDefIn = createAdjacentNodeIteratorByOffSet[StoredNode](21)
  def _unknownViaReachingDefIn: overflowdb.traversal.Traversal[Unknown]       = reachingDefIn.collectAll[Unknown]
  def _callViaReachingDefIn: overflowdb.traversal.Traversal[Call]             = reachingDefIn.collectAll[Call]
  def _identifierViaReachingDefIn: overflowdb.traversal.Traversal[Identifier] = reachingDefIn.collectAll[Identifier]
  def _controlStructureViaReachingDefIn: overflowdb.traversal.Traversal[ControlStructure] =
    reachingDefIn.collectAll[ControlStructure]
  def _methodParameterOutViaReachingDefIn: overflowdb.traversal.Traversal[MethodParameterOut] =
    reachingDefIn.collectAll[MethodParameterOut]
  def _blockViaReachingDefIn: overflowdb.traversal.Traversal[Block] = reachingDefIn.collectAll[Block]
  def _methodParameterInViaReachingDefIn: overflowdb.traversal.Traversal[MethodParameterIn] =
    reachingDefIn.collectAll[MethodParameterIn]
  def _methodRefViaReachingDefIn: overflowdb.traversal.Traversal[MethodRef] = reachingDefIn.collectAll[MethodRef]
  def _typeRefViaReachingDefIn: overflowdb.traversal.Traversal[TypeRef]     = reachingDefIn.collectAll[TypeRef]
  def _literalViaReachingDefIn: overflowdb.traversal.Traversal[Literal]     = reachingDefIn.collectAll[Literal]
  def _methodViaReachingDefIn: overflowdb.traversal.Traversal[Method]       = reachingDefIn.collectAll[Method]

  def receiverIn: overflowdb.traversal.Traversal[Call] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[Call](22))
  override def _receiverIn             = createAdjacentNodeIteratorByOffSet[StoredNode](22)
  def _callViaReceiverIn: Option[Call] = receiverIn.collectAll[Call].nextOption()

  def postDominateIn: overflowdb.traversal.Traversal[CfgNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[CfgNode](23))
  override def _postDominateIn = createAdjacentNodeIteratorByOffSet[StoredNode](23)
  def _blockViaPostDominateIn: overflowdb.traversal.Traversal[Block]     = postDominateIn.collectAll[Block]
  def _literalViaPostDominateIn: overflowdb.traversal.Traversal[Literal] = postDominateIn.collectAll[Literal]
  def _unknownViaPostDominateIn: overflowdb.traversal.Traversal[Unknown] = postDominateIn.collectAll[Unknown]
  def _typeRefViaPostDominateIn: overflowdb.traversal.Traversal[TypeRef] = postDominateIn.collectAll[TypeRef]
  def _fieldIdentifierViaPostDominateIn: overflowdb.traversal.Traversal[FieldIdentifier] =
    postDominateIn.collectAll[FieldIdentifier]
  def _methodReturnViaPostDominateIn: overflowdb.traversal.Traversal[MethodReturn] =
    postDominateIn.collectAll[MethodReturn]
  def _callViaPostDominateIn: overflowdb.traversal.Traversal[Call]             = postDominateIn.collectAll[Call]
  def _jumpTargetViaPostDominateIn: overflowdb.traversal.Traversal[JumpTarget] = postDominateIn.collectAll[JumpTarget]
  def _identifierViaPostDominateIn: overflowdb.traversal.Traversal[Identifier] = postDominateIn.collectAll[Identifier]
  def _controlStructureViaPostDominateIn: overflowdb.traversal.Traversal[ControlStructure] =
    postDominateIn.collectAll[ControlStructure]
  def _methodRefViaPostDominateIn: overflowdb.traversal.Traversal[MethodRef] = postDominateIn.collectAll[MethodRef]
  def _returnViaPostDominateIn: overflowdb.traversal.Traversal[Return]       = postDominateIn.collectAll[Return]

  override def label: String = {
    Call.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0  => "id"
      case 1  => "argumentIndex"
      case 2  => "argumentName"
      case 3  => "code"
      case 4  => "columnNumber"
      case 5  => "dispatchType"
      case 6  => "dynamicTypeHintFullName"
      case 7  => "lineNumber"
      case 8  => "methodFullName"
      case 9  => "name"
      case 10 => "order"
      case 11 => "signature"
      case 12 => "typeFullName"
    }

  override def productElement(n: Int): Any =
    n match {
      case 0  => id
      case 1  => argumentIndex
      case 2  => argumentName
      case 3  => code
      case 4  => columnNumber
      case 5  => dispatchType
      case 6  => dynamicTypeHintFullName
      case 7  => lineNumber
      case 8  => methodFullName
      case 9  => name
      case 10 => order
      case 11 => signature
      case 12 => typeFullName
    }

  override def productPrefix = "Call"
  override def productArity  = 13

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[CallDb]

  override def property(key: String): Any = {
    key match {
      case "ARGUMENT_INDEX"              => this._argumentIndex
      case "ARGUMENT_NAME"               => this._argumentName
      case "CODE"                        => this._code
      case "COLUMN_NUMBER"               => this._columnNumber
      case "DISPATCH_TYPE"               => this._dispatchType
      case "DYNAMIC_TYPE_HINT_FULL_NAME" => this._dynamicTypeHintFullName
      case "LINE_NUMBER"                 => this._lineNumber
      case "METHOD_FULL_NAME"            => this._methodFullName
      case "NAME"                        => this._name
      case "ORDER"                       => this._order
      case "SIGNATURE"                   => this._signature
      case "TYPE_FULL_NAME"              => this._typeFullName

      case _ => null
    }
  }

  override protected def updateSpecificProperty(key: String, value: Object): Unit = {
    key match {
      case "ARGUMENT_INDEX" => this._argumentIndex = value.asInstanceOf[scala.Int]
      case "ARGUMENT_NAME"  => this._argumentName = value.asInstanceOf[String]
      case "CODE"           => this._code = value.asInstanceOf[String]
      case "COLUMN_NUMBER"  => this._columnNumber = value.asInstanceOf[Integer]
      case "DISPATCH_TYPE"  => this._dispatchType = value.asInstanceOf[String]
      case "DYNAMIC_TYPE_HINT_FULL_NAME" =>
        this._dynamicTypeHintFullName = value match {
          case null                                             => collection.immutable.ArraySeq.empty
          case singleValue: String                              => collection.immutable.ArraySeq(singleValue)
          case coll: IterableOnce[Any] if coll.iterator.isEmpty => collection.immutable.ArraySeq.empty
          case arr: Array[_] if arr.isEmpty                     => collection.immutable.ArraySeq.empty
          case arr: Array[_] => collection.immutable.ArraySeq.unsafeWrapArray(arr).asInstanceOf[IndexedSeq[String]]
          case jCollection: java.lang.Iterable[_] =>
            if (jCollection.iterator.hasNext) {
              collection.immutable.ArraySeq.unsafeWrapArray(
                jCollection.asInstanceOf[java.util.Collection[String]].iterator.asScala.toArray
              )
            } else collection.immutable.ArraySeq.empty
          case iter: Iterable[_] =>
            if (iter.nonEmpty) {
              collection.immutable.ArraySeq.unsafeWrapArray(iter.asInstanceOf[Iterable[String]].toArray)
            } else collection.immutable.ArraySeq.empty
        }
      case "LINE_NUMBER"      => this._lineNumber = value.asInstanceOf[Integer]
      case "METHOD_FULL_NAME" => this._methodFullName = value.asInstanceOf[String]
      case "NAME"             => this._name = value.asInstanceOf[String]
      case "ORDER"            => this._order = value.asInstanceOf[scala.Int]
      case "SIGNATURE"        => this._signature = value.asInstanceOf[String]
      case "TYPE_FULL_NAME"   => this._typeFullName = value.asInstanceOf[String]

      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

  override def removeSpecificProperty(key: String): Unit =
    this.updateSpecificProperty(key, null)

  override def _initializeFromDetached(
    data: overflowdb.DetachedNodeData,
    mapper: java.util.function.Function[overflowdb.DetachedNodeData, Node]
  ) =
    fromNewNode(data.asInstanceOf[NewNode], nn => mapper.apply(nn).asInstanceOf[StoredNode])

  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = {
    this._argumentIndex = newNode.asInstanceOf[NewCall].argumentIndex
    this._argumentName = newNode.asInstanceOf[NewCall].argumentName.orNull
    this._code = newNode.asInstanceOf[NewCall].code
    this._columnNumber = newNode.asInstanceOf[NewCall].columnNumber.orNull
    this._dispatchType = newNode.asInstanceOf[NewCall].dispatchType
    this._dynamicTypeHintFullName =
      if (newNode.asInstanceOf[NewCall].dynamicTypeHintFullName != null)
        newNode.asInstanceOf[NewCall].dynamicTypeHintFullName
      else collection.immutable.ArraySeq.empty
    this._lineNumber = newNode.asInstanceOf[NewCall].lineNumber.orNull
    this._methodFullName = newNode.asInstanceOf[NewCall].methodFullName
    this._name = newNode.asInstanceOf[NewCall].name
    this._order = newNode.asInstanceOf[NewCall].order
    this._signature = newNode.asInstanceOf[NewCall].signature
    this._typeFullName = newNode.asInstanceOf[NewCall].typeFullName

  }

}
