package io.shiftleft.codepropertygraph.generated.traversal

import overflowdb.traversal._
import io.shiftleft.codepropertygraph.generated.nodes._

/** Traversal steps for ConfigFile */
class ConfigFileTraversalExtGen[NodeType <: ConfigFile](val traversal: IterableOnce[NodeType]) extends AnyVal {

  /** Traverse to content property */
  def content: Traversal[String] =
    traversal.map(_.content)

  /** Traverse to nodes where the content matches the regular expression `value`
    */
  def content(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.content == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal)(_.content, pattern)
    }
  }

  /** Traverse to nodes where the content matches at least one of the regular expressions in `values`
    */
  def content(patterns: String*): Traversal[NodeType] =
    overflowdb.traversal.filter.StringPropertyFilter.regexpMultiple(traversal)(_.content, patterns)

  /** Traverse to nodes where content matches `value` exactly.
    */
  def contentExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.content == value }

  /** Traverse to nodes where content matches one of the elements in `values` exactly.
    */
  def contentExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => vset.contains(node.content) }
  }

  /** Traverse to nodes where content does not match the regular expression `value`.
    */
  def contentNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.content != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexpNot(traversal)(_.content, pattern)
    }
  }

  /** Traverse to nodes where content does not match any of the regular expressions in `values`.
    */
  def contentNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter.regexpNotMultiple(traversal)(_.content, patterns)
  }

  /** Traverse to name property */
  def name: Traversal[String] =
    traversal.map(_.name)

  /** Traverse to nodes where the name matches the regular expression `value`
    */
  def name(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.name == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal)(_.name, pattern)
    }
  }

  /** Traverse to nodes where the name matches at least one of the regular expressions in `values`
    */
  def name(patterns: String*): Traversal[NodeType] =
    overflowdb.traversal.filter.StringPropertyFilter.regexpMultiple(traversal)(_.name, patterns)

  /** Traverse to nodes where name matches `value` exactly.
    */
  def nameExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.name == value }

  /** Traverse to nodes where name matches one of the elements in `values` exactly.
    */
  def nameExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => vset.contains(node.name) }
  }

  /** Traverse to nodes where name does not match the regular expression `value`.
    */
  def nameNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.name != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexpNot(traversal)(_.name, pattern)
    }
  }

  /** Traverse to nodes where name does not match any of the regular expressions in `values`.
    */
  def nameNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter.regexpNotMultiple(traversal)(_.name, patterns)
  }

}
