package io.shiftleft.codepropertygraph.generated.traversal

import overflowdb.traversal._
import io.shiftleft.codepropertygraph.generated.nodes._

/** Traversal steps for Location */
class LocationTraversalExtGen[NodeType <: Location](val traversal: IterableOnce[NodeType]) extends AnyVal {

  /** Traverse to className property */
  def className: Traversal[String] =
    traversal.map(_.className)

  /** Traverse to nodes where the className matches the regular expression `value`
    */
  def className(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.className == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal)(_.className, pattern)
    }
  }

  /** Traverse to nodes where the className matches at least one of the regular expressions in `values`
    */
  def className(patterns: String*): Traversal[NodeType] =
    overflowdb.traversal.filter.StringPropertyFilter.regexpMultiple(traversal)(_.className, patterns)

  /** Traverse to nodes where className matches `value` exactly.
    */
  def classNameExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.className == value }

  /** Traverse to nodes where className matches one of the elements in `values` exactly.
    */
  def classNameExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => vset.contains(node.className) }
  }

  /** Traverse to nodes where className does not match the regular expression `value`.
    */
  def classNameNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.className != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexpNot(traversal)(_.className, pattern)
    }
  }

  /** Traverse to nodes where className does not match any of the regular expressions in `values`.
    */
  def classNameNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter.regexpNotMultiple(traversal)(_.className, patterns)
  }

  /** Traverse to classShortName property */
  def classShortName: Traversal[String] =
    traversal.map(_.classShortName)

  /** Traverse to nodes where the classShortName matches the regular expression `value`
    */
  def classShortName(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.classShortName == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal)(_.classShortName, pattern)
    }
  }

  /** Traverse to nodes where the classShortName matches at least one of the regular expressions in `values`
    */
  def classShortName(patterns: String*): Traversal[NodeType] =
    overflowdb.traversal.filter.StringPropertyFilter.regexpMultiple(traversal)(_.classShortName, patterns)

  /** Traverse to nodes where classShortName matches `value` exactly.
    */
  def classShortNameExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.classShortName == value }

  /** Traverse to nodes where classShortName matches one of the elements in `values` exactly.
    */
  def classShortNameExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => vset.contains(node.classShortName) }
  }

  /** Traverse to nodes where classShortName does not match the regular expression `value`.
    */
  def classShortNameNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.classShortName != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexpNot(traversal)(_.classShortName, pattern)
    }
  }

  /** Traverse to nodes where classShortName does not match any of the regular expressions in `values`.
    */
  def classShortNameNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter.regexpNotMultiple(traversal)(_.classShortName, patterns)
  }

  /** Traverse to filename property */
  def filename: Traversal[String] =
    traversal.map(_.filename)

  /** Traverse to nodes where the filename matches the regular expression `value`
    */
  def filename(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.filename == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal)(_.filename, pattern)
    }
  }

  /** Traverse to nodes where the filename matches at least one of the regular expressions in `values`
    */
  def filename(patterns: String*): Traversal[NodeType] =
    overflowdb.traversal.filter.StringPropertyFilter.regexpMultiple(traversal)(_.filename, patterns)

  /** Traverse to nodes where filename matches `value` exactly.
    */
  def filenameExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.filename == value }

  /** Traverse to nodes where filename matches one of the elements in `values` exactly.
    */
  def filenameExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => vset.contains(node.filename) }
  }

  /** Traverse to nodes where filename does not match the regular expression `value`.
    */
  def filenameNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.filename != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexpNot(traversal)(_.filename, pattern)
    }
  }

  /** Traverse to nodes where filename does not match any of the regular expressions in `values`.
    */
  def filenameNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter.regexpNotMultiple(traversal)(_.filename, patterns)
  }

  /** Traverse to lineNumber property */
  def lineNumber: Traversal[Integer] =
    traversal.flatMap(_.lineNumber)

  /** Traverse to nodes where the lineNumber equals the given `value`
    */
  def lineNumber(value: Integer): Traversal[NodeType] =
    traversal.filter { node => node.lineNumber.isDefined && node.lineNumber.get == value }

  /** Traverse to nodes where the lineNumber equals at least one of the given `values`
    */
  def lineNumber(values: Integer*): Traversal[NodeType] = {
    val vset = values.toSet
    traversal.filter { node => node.lineNumber.isDefined && vset.contains(node.lineNumber.get) }
  }

  /** Traverse to nodes where the lineNumber is greater than the given `value`
    */
  def lineNumberGt(value: Integer): Traversal[NodeType] =
    traversal.filter { node => node.lineNumber.isDefined && node.lineNumber.get > value }

  /** Traverse to nodes where the lineNumber is greater than or equal the given `value`
    */
  def lineNumberGte(value: Integer): Traversal[NodeType] =
    traversal.filter { node => node.lineNumber.isDefined && node.lineNumber.get >= value }

  /** Traverse to nodes where the lineNumber is less than the given `value`
    */
  def lineNumberLt(value: Integer): Traversal[NodeType] =
    traversal.filter { node => node.lineNumber.isDefined && node.lineNumber.get < value }

  /** Traverse to nodes where the lineNumber is less than or equal the given `value`
    */
  def lineNumberLte(value: Integer): Traversal[NodeType] =
    traversal.filter { node => node.lineNumber.isDefined && node.lineNumber.get <= value }

  /** Traverse to nodes where lineNumber is not equal to the given `value`.
    */
  def lineNumberNot(value: Integer): Traversal[NodeType] =
    traversal.filter { node => !node.lineNumber.isDefined || node.lineNumber.get != value }

  /** Traverse to nodes where lineNumber is not equal to any of the given `values`.
    */
  def lineNumberNot(values: Integer*): Traversal[NodeType] = {
    val vset = values.toSet
    traversal.filter { node => !node.lineNumber.isDefined || !vset.contains(node.lineNumber.get) }
  }

  /** Traverse to methodFullName property */
  def methodFullName: Traversal[String] =
    traversal.map(_.methodFullName)

  /** Traverse to nodes where the methodFullName matches the regular expression `value`
    */
  def methodFullName(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.methodFullName == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal)(_.methodFullName, pattern)
    }
  }

  /** Traverse to nodes where the methodFullName matches at least one of the regular expressions in `values`
    */
  def methodFullName(patterns: String*): Traversal[NodeType] =
    overflowdb.traversal.filter.StringPropertyFilter.regexpMultiple(traversal)(_.methodFullName, patterns)

  /** Traverse to nodes where methodFullName matches `value` exactly.
    */
  def methodFullNameExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.methodFullName == value }

  /** Traverse to nodes where methodFullName matches one of the elements in `values` exactly.
    */
  def methodFullNameExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => vset.contains(node.methodFullName) }
  }

  /** Traverse to nodes where methodFullName does not match the regular expression `value`.
    */
  def methodFullNameNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.methodFullName != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexpNot(traversal)(_.methodFullName, pattern)
    }
  }

  /** Traverse to nodes where methodFullName does not match any of the regular expressions in `values`.
    */
  def methodFullNameNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter.regexpNotMultiple(traversal)(_.methodFullName, patterns)
  }

  /** Traverse to methodShortName property */
  def methodShortName: Traversal[String] =
    traversal.map(_.methodShortName)

  /** Traverse to nodes where the methodShortName matches the regular expression `value`
    */
  def methodShortName(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.methodShortName == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal)(_.methodShortName, pattern)
    }
  }

  /** Traverse to nodes where the methodShortName matches at least one of the regular expressions in `values`
    */
  def methodShortName(patterns: String*): Traversal[NodeType] =
    overflowdb.traversal.filter.StringPropertyFilter.regexpMultiple(traversal)(_.methodShortName, patterns)

  /** Traverse to nodes where methodShortName matches `value` exactly.
    */
  def methodShortNameExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.methodShortName == value }

  /** Traverse to nodes where methodShortName matches one of the elements in `values` exactly.
    */
  def methodShortNameExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => vset.contains(node.methodShortName) }
  }

  /** Traverse to nodes where methodShortName does not match the regular expression `value`.
    */
  def methodShortNameNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.methodShortName != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexpNot(traversal)(_.methodShortName, pattern)
    }
  }

  /** Traverse to nodes where methodShortName does not match any of the regular expressions in `values`.
    */
  def methodShortNameNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter.regexpNotMultiple(traversal)(_.methodShortName, patterns)
  }

  /** Traverse to nodeLabel property */
  def nodeLabel: Traversal[String] =
    traversal.map(_.nodeLabel)

  /** Traverse to nodes where the nodeLabel matches the regular expression `value`
    */
  def nodeLabel(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.nodeLabel == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal)(_.nodeLabel, pattern)
    }
  }

  /** Traverse to nodes where the nodeLabel matches at least one of the regular expressions in `values`
    */
  def nodeLabel(patterns: String*): Traversal[NodeType] =
    overflowdb.traversal.filter.StringPropertyFilter.regexpMultiple(traversal)(_.nodeLabel, patterns)

  /** Traverse to nodes where nodeLabel matches `value` exactly.
    */
  def nodeLabelExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.nodeLabel == value }

  /** Traverse to nodes where nodeLabel matches one of the elements in `values` exactly.
    */
  def nodeLabelExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => vset.contains(node.nodeLabel) }
  }

  /** Traverse to nodes where nodeLabel does not match the regular expression `value`.
    */
  def nodeLabelNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.nodeLabel != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexpNot(traversal)(_.nodeLabel, pattern)
    }
  }

  /** Traverse to nodes where nodeLabel does not match any of the regular expressions in `values`.
    */
  def nodeLabelNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter.regexpNotMultiple(traversal)(_.nodeLabel, patterns)
  }

  /** Traverse to packageName property */
  def packageName: Traversal[String] =
    traversal.map(_.packageName)

  /** Traverse to nodes where the packageName matches the regular expression `value`
    */
  def packageName(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.packageName == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal)(_.packageName, pattern)
    }
  }

  /** Traverse to nodes where the packageName matches at least one of the regular expressions in `values`
    */
  def packageName(patterns: String*): Traversal[NodeType] =
    overflowdb.traversal.filter.StringPropertyFilter.regexpMultiple(traversal)(_.packageName, patterns)

  /** Traverse to nodes where packageName matches `value` exactly.
    */
  def packageNameExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.packageName == value }

  /** Traverse to nodes where packageName matches one of the elements in `values` exactly.
    */
  def packageNameExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => vset.contains(node.packageName) }
  }

  /** Traverse to nodes where packageName does not match the regular expression `value`.
    */
  def packageNameNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.packageName != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexpNot(traversal)(_.packageName, pattern)
    }
  }

  /** Traverse to nodes where packageName does not match any of the regular expressions in `values`.
    */
  def packageNameNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter.regexpNotMultiple(traversal)(_.packageName, patterns)
  }

  /** Traverse to symbol property */
  def symbol: Traversal[String] =
    traversal.map(_.symbol)

  /** Traverse to nodes where the symbol matches the regular expression `value`
    */
  def symbol(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.symbol == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal)(_.symbol, pattern)
    }
  }

  /** Traverse to nodes where the symbol matches at least one of the regular expressions in `values`
    */
  def symbol(patterns: String*): Traversal[NodeType] =
    overflowdb.traversal.filter.StringPropertyFilter.regexpMultiple(traversal)(_.symbol, patterns)

  /** Traverse to nodes where symbol matches `value` exactly.
    */
  def symbolExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.symbol == value }

  /** Traverse to nodes where symbol matches one of the elements in `values` exactly.
    */
  def symbolExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => vset.contains(node.symbol) }
  }

  /** Traverse to nodes where symbol does not match the regular expression `value`.
    */
  def symbolNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.symbol != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexpNot(traversal)(_.symbol, pattern)
    }
  }

  /** Traverse to nodes where symbol does not match any of the regular expressions in `values`.
    */
  def symbolNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter.regexpNotMultiple(traversal)(_.symbol, patterns)
  }

}
