package io.shiftleft.codepropertygraph.generated.traversal

import overflowdb.traversal._
import io.shiftleft.codepropertygraph.generated.nodes._

/** Traversal steps for Dependency */
class DependencyTraversalExtGen[NodeType <: Dependency](val traversal: IterableOnce[NodeType]) extends AnyVal {

  /** Traverse to dependencyGroupId property */
  def dependencyGroupId: Traversal[String] =
    traversal.flatMap(_.dependencyGroupId)

  /** Traverse to nodes where the dependencyGroupId matches the regular expression `value`
    */
  def dependencyGroupId(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.dependencyGroupId.isDefined && node.dependencyGroupId.get == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter
        .regexp(traversal.filter(_.dependencyGroupId.isDefined))(_.dependencyGroupId.get, pattern)
    }
  }

  /** Traverse to nodes where the dependencyGroupId matches at least one of the regular expressions in `values`
    */
  def dependencyGroupId(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter
      .regexpMultiple(traversal.filter(_.dependencyGroupId.isDefined))(_.dependencyGroupId.get, patterns)
  }

  /** Traverse to nodes where dependencyGroupId matches `value` exactly.
    */
  def dependencyGroupIdExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.dependencyGroupId.isDefined && node.dependencyGroupId.get == value }

  /** Traverse to nodes where dependencyGroupId matches one of the elements in `values` exactly.
    */
  def dependencyGroupIdExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => node.dependencyGroupId.isDefined && vset.contains(node.dependencyGroupId.get) }
  }

  /** Traverse to nodes where dependencyGroupId does not match the regular expression `value`.
    */
  def dependencyGroupIdNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.dependencyGroupId.isEmpty || node.dependencyGroupId.get != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter
        .regexpNot(traversal.filter(_.dependencyGroupId.isDefined))(_.dependencyGroupId.get, pattern)
    }
  }

  /** Traverse to nodes where dependencyGroupId does not match any of the regular expressions in `values`.
    */
  def dependencyGroupIdNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter
      .regexpNotMultiple(traversal.filter(_.dependencyGroupId.isDefined))(_.dependencyGroupId.get, patterns)
  }

  /** Traverse to name property */
  def name: Traversal[String] =
    traversal.map(_.name)

  /** Traverse to nodes where the name matches the regular expression `value`
    */
  def name(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.name == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal)(_.name, pattern)
    }
  }

  /** Traverse to nodes where the name matches at least one of the regular expressions in `values`
    */
  def name(patterns: String*): Traversal[NodeType] =
    overflowdb.traversal.filter.StringPropertyFilter.regexpMultiple(traversal)(_.name, patterns)

  /** Traverse to nodes where name matches `value` exactly.
    */
  def nameExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.name == value }

  /** Traverse to nodes where name matches one of the elements in `values` exactly.
    */
  def nameExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => vset.contains(node.name) }
  }

  /** Traverse to nodes where name does not match the regular expression `value`.
    */
  def nameNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.name != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexpNot(traversal)(_.name, pattern)
    }
  }

  /** Traverse to nodes where name does not match any of the regular expressions in `values`.
    */
  def nameNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter.regexpNotMultiple(traversal)(_.name, patterns)
  }

  /** Traverse to usedIn property */
  def usedIn: Traversal[String] =
    traversal.flatMap(_.usedIn)

  /** Traverse to nodes where the usedIn matches the regular expression `value`
    */
  def usedIn(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.usedIn.isDefined && node.usedIn.get == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter
        .regexp(traversal.filter(_.usedIn.isDefined))(_.usedIn.get, pattern)
    }
  }

  /** Traverse to nodes where the usedIn matches at least one of the regular expressions in `values`
    */
  def usedIn(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter
      .regexpMultiple(traversal.filter(_.usedIn.isDefined))(_.usedIn.get, patterns)
  }

  /** Traverse to nodes where usedIn matches `value` exactly.
    */
  def usedInExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.usedIn.isDefined && node.usedIn.get == value }

  /** Traverse to nodes where usedIn matches one of the elements in `values` exactly.
    */
  def usedInExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => node.usedIn.isDefined && vset.contains(node.usedIn.get) }
  }

  /** Traverse to nodes where usedIn does not match the regular expression `value`.
    */
  def usedInNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.usedIn.isEmpty || node.usedIn.get != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter
        .regexpNot(traversal.filter(_.usedIn.isDefined))(_.usedIn.get, pattern)
    }
  }

  /** Traverse to nodes where usedIn does not match any of the regular expressions in `values`.
    */
  def usedInNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter
      .regexpNotMultiple(traversal.filter(_.usedIn.isDefined))(_.usedIn.get, patterns)
  }

  /** Traverse to version property */
  def version: Traversal[String] =
    traversal.map(_.version)

  /** Traverse to nodes where the version matches the regular expression `value`
    */
  def version(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.version == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal)(_.version, pattern)
    }
  }

  /** Traverse to nodes where the version matches at least one of the regular expressions in `values`
    */
  def version(patterns: String*): Traversal[NodeType] =
    overflowdb.traversal.filter.StringPropertyFilter.regexpMultiple(traversal)(_.version, patterns)

  /** Traverse to nodes where version matches `value` exactly.
    */
  def versionExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.version == value }

  /** Traverse to nodes where version matches one of the elements in `values` exactly.
    */
  def versionExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => vset.contains(node.version) }
  }

  /** Traverse to nodes where version does not match the regular expression `value`.
    */
  def versionNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.version != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexpNot(traversal)(_.version, pattern)
    }
  }

  /** Traverse to nodes where version does not match any of the regular expressions in `values`.
    */
  def versionNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter.regexpNotMultiple(traversal)(_.version, patterns)
  }

}
