package io.shiftleft.codepropertygraph.generated.nodes

import overflowdb._
import scala.jdk.CollectionConverters._

object MethodParameterOut {
  def apply(graph: Graph, id: Long) = new MethodParameterOut(graph, id)

  val Label = "METHOD_PARAMETER_OUT"

  object PropertyNames {
    val Code               = "CODE"
    val ColumnNumber       = "COLUMN_NUMBER"
    val EvaluationStrategy = "EVALUATION_STRATEGY"
    val IsVariadic         = "IS_VARIADIC"
    val LineNumber         = "LINE_NUMBER"
    val Name               = "NAME"
    val Order              = "ORDER"
    val TypeFullName       = "TYPE_FULL_NAME"
    val all: Set[String] =
      Set(Code, ColumnNumber, EvaluationStrategy, IsVariadic, LineNumber, Name, Order, TypeFullName)
    val allAsJava: java.util.Set[String] = all.asJava
  }

  object Properties {
    val Code               = new overflowdb.PropertyKey[String]("CODE")
    val ColumnNumber       = new overflowdb.PropertyKey[Integer]("COLUMN_NUMBER")
    val EvaluationStrategy = new overflowdb.PropertyKey[String]("EVALUATION_STRATEGY")
    val IsVariadic         = new overflowdb.PropertyKey[Boolean]("IS_VARIADIC")
    val LineNumber         = new overflowdb.PropertyKey[Integer]("LINE_NUMBER")
    val Name               = new overflowdb.PropertyKey[String]("NAME")
    val Order              = new overflowdb.PropertyKey[scala.Int]("ORDER")
    val TypeFullName       = new overflowdb.PropertyKey[String]("TYPE_FULL_NAME")

  }

  object PropertyDefaults {
    val Code               = "<empty>"
    val EvaluationStrategy = "<empty>"
    val IsVariadic         = false
    val Name               = "<empty>"
    val Order              = -1: Int
    val TypeFullName       = "<empty>"
  }

  val layoutInformation = new NodeLayoutInformation(
    Label,
    PropertyNames.allAsJava,
    List(
      io.shiftleft.codepropertygraph.generated.edges.EvalType.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.TaggedBy.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.DataFlow.layoutInformation
    ).asJava,
    List(
      io.shiftleft.codepropertygraph.generated.edges.Ast.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.ParameterLink.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.DataFlow.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.Cfg.layoutInformation
    ).asJava
  )

  object Edges {
    val Out: Array[String] = Array("DATA_FLOW", "EVAL_TYPE", "TAGGED_BY")
    val In: Array[String]  = Array("AST", "CFG", "DATA_FLOW", "PARAMETER_LINK")
  }

  val factory = new NodeFactory[MethodParameterOutDb] {
    override val forLabel = MethodParameterOut.Label

    override def createNode(ref: NodeRef[MethodParameterOutDb]) =
      new MethodParameterOutDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = MethodParameterOut(graph, id)
  }
}

trait MethodParameterOutBase
    extends AbstractNode
    with DeclarationBase
    with CfgNodeBase
    with AstNodeBase
    with HasCode
    with HasColumnNumber
    with HasEvaluationStrategy
    with HasIsVariadic
    with HasLineNumber
    with HasName
    with HasOrder
    with HasTypeFullName {
  def asStored: StoredNode = this.asInstanceOf[StoredNode]

}

class MethodParameterOut(graph: Graph, id: Long)
    extends NodeRef[MethodParameterOutDb](graph, id)
    with MethodParameterOutBase
    with StoredNode
    with Declaration
    with CfgNode
    with AstNode {
  override def code: String                  = get().code
  override def columnNumber: Option[Integer] = get().columnNumber
  override def evaluationStrategy: String    = get().evaluationStrategy
  override def isVariadic: Boolean           = get().isVariadic
  override def lineNumber: Option[Integer]   = get().lineNumber
  override def name: String                  = get().name
  override def order: scala.Int              = get().order
  override def typeFullName: String          = get().typeFullName
  override def propertyDefaultValue(propertyKey: String) =
    propertyKey match {
      case "CODE"                => MethodParameterOut.PropertyDefaults.Code
      case "EVALUATION_STRATEGY" => MethodParameterOut.PropertyDefaults.EvaluationStrategy
      case "IS_VARIADIC"         => MethodParameterOut.PropertyDefaults.IsVariadic
      case "NAME"                => MethodParameterOut.PropertyDefaults.Name
      case "ORDER"               => MethodParameterOut.PropertyDefaults.Order
      case "TYPE_FULL_NAME"      => MethodParameterOut.PropertyDefaults.TypeFullName
      case _                     => super.propertyDefaultValue(propertyKey)
    }

  def evalTypeOut: overflowdb.traversal.Traversal[Type] = get().evalTypeOut
  override def _evalTypeOut                             = get()._evalTypeOut

  /** Traverse to parameter type Traverse to TYPE via EVAL_TYPE OUT edge.
    */
  /** Traverse to parameter type */
  @overflowdb.traversal.help.Doc(info = """Traverse to parameter type""")
  def typ: overflowdb.traversal.Traversal[Type] = get().typ

  def taggedByOut: overflowdb.traversal.Traversal[Tag] = get().taggedByOut
  override def _taggedByOut                            = get()._taggedByOut

  /** Traverse to TAG via TAGGED_BY OUT edge.
    */
  def _tagViaTaggedByOut: overflowdb.traversal.Traversal[Tag] = get()._tagViaTaggedByOut

  def dataFlowOut: overflowdb.traversal.Traversal[CfgNode] = get().dataFlowOut
  override def _dataFlowOut                                = get()._dataFlowOut

  def astIn: overflowdb.traversal.Traversal[Method] = get().astIn
  override def _astIn                               = get()._astIn

  /** Traverse to METHOD via AST IN edge.
    */
  def method: Method = get().method

  def parameterLinkIn: overflowdb.traversal.Traversal[MethodParameterIn] = get().parameterLinkIn
  override def _parameterLinkIn                                          = get()._parameterLinkIn

  /** Traverse to METHOD_PARAMETER_IN via PARAMETER_LINK IN edge.
    */
  def asInput: overflowdb.traversal.Traversal[MethodParameterIn] = get().asInput

  def dataFlowIn: overflowdb.traversal.Traversal[CfgNode] = get().dataFlowIn
  override def _dataFlowIn                                = get()._dataFlowIn

  def cfgIn: overflowdb.traversal.Traversal[CfgNode] = get().cfgIn
  override def _cfgIn                                = get()._cfgIn

  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def canEqual(that: Any): Boolean                                        = get.canEqual(that)
  override def label: String = {
    MethodParameterOut.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id"
      case 1 => "code"
      case 2 => "columnNumber"
      case 3 => "evaluationStrategy"
      case 4 => "isVariadic"
      case 5 => "lineNumber"
      case 6 => "name"
      case 7 => "order"
      case 8 => "typeFullName"
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
      case 1 => code
      case 2 => columnNumber
      case 3 => evaluationStrategy
      case 4 => isVariadic
      case 5 => lineNumber
      case 6 => name
      case 7 => order
      case 8 => typeFullName
    }

  override def productPrefix = "MethodParameterOut"
  override def productArity  = 9
}

class MethodParameterOutDb(ref: NodeRef[NodeDb])
    extends NodeDb(ref)
    with StoredNode
    with Declaration
    with CfgNode
    with AstNode
    with MethodParameterOutBase {

  override def layoutInformation: NodeLayoutInformation = MethodParameterOut.layoutInformation

  private var _code: String               = MethodParameterOut.PropertyDefaults.Code
  def code: String                        = _code
  private var _columnNumber: Integer      = null
  def columnNumber: Option[Integer]       = Option(_columnNumber)
  private var _evaluationStrategy: String = MethodParameterOut.PropertyDefaults.EvaluationStrategy
  def evaluationStrategy: String          = _evaluationStrategy
  private var _isVariadic: Boolean        = MethodParameterOut.PropertyDefaults.IsVariadic
  def isVariadic: Boolean                 = _isVariadic
  private var _lineNumber: Integer        = null
  def lineNumber: Option[Integer]         = Option(_lineNumber)
  private var _name: String               = MethodParameterOut.PropertyDefaults.Name
  def name: String                        = _name
  private var _order: scala.Int           = MethodParameterOut.PropertyDefaults.Order
  def order: scala.Int                    = _order
  private var _typeFullName: String       = MethodParameterOut.PropertyDefaults.TypeFullName
  def typeFullName: String                = _typeFullName

  /** faster than the default implementation */
  override def propertiesMap: java.util.Map[String, Any] = {
    val properties = new java.util.HashMap[String, Any]
    properties.put("CODE", code)
    columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
    properties.put("EVALUATION_STRATEGY", evaluationStrategy)
    properties.put("IS_VARIADIC", isVariadic)
    lineNumber.map { value => properties.put("LINE_NUMBER", value) }
    properties.put("NAME", name)
    properties.put("ORDER", order)
    properties.put("TYPE_FULL_NAME", typeFullName)

    properties
  }

  /** faster than the default implementation */
  override def propertiesMapForStorage: java.util.Map[String, Any] = {
    val properties = new java.util.HashMap[String, Any]
    if (!(("<empty>") == code)) { properties.put("CODE", code) }
    columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
    if (!(("<empty>") == evaluationStrategy)) { properties.put("EVALUATION_STRATEGY", evaluationStrategy) }
    if (!((false) == isVariadic)) { properties.put("IS_VARIADIC", isVariadic) }
    lineNumber.map { value => properties.put("LINE_NUMBER", value) }
    if (!(("<empty>") == name)) { properties.put("NAME", name) }
    if (!((-1: Int) == order)) { properties.put("ORDER", order) }
    if (!(("<empty>") == typeFullName)) { properties.put("TYPE_FULL_NAME", typeFullName) }

    properties
  }

  def evalTypeOut: overflowdb.traversal.Traversal[Type] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[Type](0))
  override def _evalTypeOut                     = createAdjacentNodeIteratorByOffSet[StoredNode](0)
  def typ: overflowdb.traversal.Traversal[Type] = evalTypeOut.collectAll[Type]

  def taggedByOut: overflowdb.traversal.Traversal[Tag] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[Tag](1))
  override def _taggedByOut                                   = createAdjacentNodeIteratorByOffSet[StoredNode](1)
  def _tagViaTaggedByOut: overflowdb.traversal.Traversal[Tag] = taggedByOut.collectAll[Tag]

  def dataFlowOut: overflowdb.traversal.Traversal[CfgNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[CfgNode](2))
  override def _dataFlowOut = createAdjacentNodeIteratorByOffSet[StoredNode](2)

  def astIn: overflowdb.traversal.Traversal[Method] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[Method](3))
  override def _astIn = createAdjacentNodeIteratorByOffSet[StoredNode](3)
  def method: Method = try { astIn.collectAll[Method].next() }
  catch {
    case e: java.util.NoSuchElementException =>
      throw new overflowdb.SchemaViolationException(
        "IN edge with label AST to an adjacent METHOD is mandatory, but not defined for this METHOD_PARAMETER_OUT node with id=" + id,
        e
      )
  }

  def parameterLinkIn: overflowdb.traversal.Traversal[MethodParameterIn] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[MethodParameterIn](4))
  override def _parameterLinkIn                                  = createAdjacentNodeIteratorByOffSet[StoredNode](4)
  def asInput: overflowdb.traversal.Traversal[MethodParameterIn] = parameterLinkIn.collectAll[MethodParameterIn]

  def dataFlowIn: overflowdb.traversal.Traversal[CfgNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[CfgNode](5))
  override def _dataFlowIn = createAdjacentNodeIteratorByOffSet[StoredNode](5)

  def cfgIn: overflowdb.traversal.Traversal[CfgNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[CfgNode](6))
  override def _cfgIn = createAdjacentNodeIteratorByOffSet[StoredNode](6)

  override def label: String = {
    MethodParameterOut.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id"
      case 1 => "code"
      case 2 => "columnNumber"
      case 3 => "evaluationStrategy"
      case 4 => "isVariadic"
      case 5 => "lineNumber"
      case 6 => "name"
      case 7 => "order"
      case 8 => "typeFullName"
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
      case 1 => code
      case 2 => columnNumber
      case 3 => evaluationStrategy
      case 4 => isVariadic
      case 5 => lineNumber
      case 6 => name
      case 7 => order
      case 8 => typeFullName
    }

  override def productPrefix = "MethodParameterOut"
  override def productArity  = 9

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MethodParameterOutDb]

  override def property(key: String): Any = {
    key match {
      case "CODE"                => this._code
      case "COLUMN_NUMBER"       => this._columnNumber
      case "EVALUATION_STRATEGY" => this._evaluationStrategy
      case "IS_VARIADIC"         => this._isVariadic
      case "LINE_NUMBER"         => this._lineNumber
      case "NAME"                => this._name
      case "ORDER"               => this._order
      case "TYPE_FULL_NAME"      => this._typeFullName

      case _ => null
    }
  }

  override protected def updateSpecificProperty(key: String, value: Object): Unit = {
    key match {
      case "CODE"                => this._code = value.asInstanceOf[String]
      case "COLUMN_NUMBER"       => this._columnNumber = value.asInstanceOf[Integer]
      case "EVALUATION_STRATEGY" => this._evaluationStrategy = value.asInstanceOf[String]
      case "IS_VARIADIC"         => this._isVariadic = value.asInstanceOf[Boolean]
      case "LINE_NUMBER"         => this._lineNumber = value.asInstanceOf[Integer]
      case "NAME"                => this._name = value.asInstanceOf[String]
      case "ORDER"               => this._order = value.asInstanceOf[scala.Int]
      case "TYPE_FULL_NAME"      => this._typeFullName = value.asInstanceOf[String]

      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

  override def removeSpecificProperty(key: String): Unit =
    this.updateSpecificProperty(key, null)

  override def _initializeFromDetached(
    data: overflowdb.DetachedNodeData,
    mapper: java.util.function.Function[overflowdb.DetachedNodeData, Node]
  ) =
    fromNewNode(data.asInstanceOf[NewNode], nn => mapper.apply(nn).asInstanceOf[StoredNode])

  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = {
    this._code = newNode.asInstanceOf[NewMethodParameterOut].code
    this._columnNumber = newNode.asInstanceOf[NewMethodParameterOut].columnNumber.orNull
    this._evaluationStrategy = newNode.asInstanceOf[NewMethodParameterOut].evaluationStrategy
    this._isVariadic = newNode.asInstanceOf[NewMethodParameterOut].isVariadic
    this._lineNumber = newNode.asInstanceOf[NewMethodParameterOut].lineNumber.orNull
    this._name = newNode.asInstanceOf[NewMethodParameterOut].name
    this._order = newNode.asInstanceOf[NewMethodParameterOut].order
    this._typeFullName = newNode.asInstanceOf[NewMethodParameterOut].typeFullName

  }

}
