package io.shiftleft.codepropertygraph.generated.traversal

import overflowdb.traversal._
import io.shiftleft.codepropertygraph.generated.nodes._

/** Traversal steps for KeyValuePair */
class KeyValuePairTraversalExtGen[NodeType <: KeyValuePair](val traversal: IterableOnce[NodeType]) extends AnyVal {

  /** Traverse to key property */
  def key: Traversal[String] =
    traversal.map(_.key)

  /** Traverse to nodes where the key matches the regular expression `value`
    */
  def key(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.key == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal)(_.key, pattern)
    }
  }

  /** Traverse to nodes where the key matches at least one of the regular expressions in `values`
    */
  def key(patterns: String*): Traversal[NodeType] =
    overflowdb.traversal.filter.StringPropertyFilter.regexpMultiple(traversal)(_.key, patterns)

  /** Traverse to nodes where key matches `value` exactly.
    */
  def keyExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.key == value }

  /** Traverse to nodes where key matches one of the elements in `values` exactly.
    */
  def keyExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => vset.contains(node.key) }
  }

  /** Traverse to nodes where key does not match the regular expression `value`.
    */
  def keyNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.key != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexpNot(traversal)(_.key, pattern)
    }
  }

  /** Traverse to nodes where key does not match any of the regular expressions in `values`.
    */
  def keyNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter.regexpNotMultiple(traversal)(_.key, patterns)
  }

  /** Traverse to value property */
  def value: Traversal[String] =
    traversal.map(_.value)

  /** Traverse to nodes where the value matches the regular expression `value`
    */
  def value(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.value == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal)(_.value, pattern)
    }
  }

  /** Traverse to nodes where the value matches at least one of the regular expressions in `values`
    */
  def value(patterns: String*): Traversal[NodeType] =
    overflowdb.traversal.filter.StringPropertyFilter.regexpMultiple(traversal)(_.value, patterns)

  /** Traverse to nodes where value matches `value` exactly.
    */
  def valueExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.value == value }

  /** Traverse to nodes where value matches one of the elements in `values` exactly.
    */
  def valueExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => vset.contains(node.value) }
  }

  /** Traverse to nodes where value does not match the regular expression `value`.
    */
  def valueNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.value != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexpNot(traversal)(_.value, pattern)
    }
  }

  /** Traverse to nodes where value does not match any of the regular expressions in `values`.
    */
  def valueNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter.regexpNotMultiple(traversal)(_.value, patterns)
  }

}
