package io.shiftleft.codepropertygraph.generated.nodes

import overflowdb._
import scala.jdk.CollectionConverters._

object PropertyErrorRegister {
  private var errorMap = Set[(Class[_], String)]()
  private val logger   = org.slf4j.LoggerFactory.getLogger(getClass)

  def logPropertyErrorIfFirst(clazz: Class[_], propertyName: String): Unit = {
    if (!errorMap.contains((clazz, propertyName))) {
      logger.warn("Property " + propertyName + " is deprecated for " + clazz.getName + ".")
      errorMap += ((clazz, propertyName))
    }
  }
}

object Misc {
  val reChars                           = "[](){}*+&|?.,\\$"
  def isRegex(pattern: String): Boolean = pattern.exists(reChars.contains(_))
}

/** Abstract supertype for overflowdb.Node and NewNode */
trait AbstractNode extends overflowdb.NodeOrDetachedNode {
  def label: String
}

/* A node that is stored inside an Graph (rather than e.g. DiffGraph) */
trait StoredNode extends Node with AbstractNode with Product {
  /* underlying Node in the graph.
   * since this is a StoredNode, this is always set */
  def underlying: Node = this

  /** labels of product elements, used e.g. for pretty-printing */
  def productElementLabel(n: Int): String

  /* all properties plus label and id */
  def toMap: Map[String, Any] = {
    val map = propertiesMap()
    map.put("_label", label)
    map.put("_id", id: java.lang.Long)
    map.asScala.toMap
  }

  /*Sets fields from newNode*/
  def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = ???

  def _aliasOfIn: java.util.Iterator[StoredNode]        = { java.util.Collections.emptyIterator() }
  def _argumentIn: java.util.Iterator[StoredNode]       = { java.util.Collections.emptyIterator() }
  def _astIn: java.util.Iterator[StoredNode]            = { java.util.Collections.emptyIterator() }
  def _bindsIn: java.util.Iterator[StoredNode]          = { java.util.Collections.emptyIterator() }
  def _bindsToIn: java.util.Iterator[StoredNode]        = { java.util.Collections.emptyIterator() }
  def _callIn: java.util.Iterator[StoredNode]           = { java.util.Collections.emptyIterator() }
  def _captureIn: java.util.Iterator[StoredNode]        = { java.util.Collections.emptyIterator() }
  def _capturedByIn: java.util.Iterator[StoredNode]     = { java.util.Collections.emptyIterator() }
  def _cdgIn: java.util.Iterator[StoredNode]            = { java.util.Collections.emptyIterator() }
  def _cfgIn: java.util.Iterator[StoredNode]            = { java.util.Collections.emptyIterator() }
  def _conditionIn: java.util.Iterator[StoredNode]      = { java.util.Collections.emptyIterator() }
  def _containsIn: java.util.Iterator[StoredNode]       = { java.util.Collections.emptyIterator() }
  def _dataFlowIn: java.util.Iterator[StoredNode]       = { java.util.Collections.emptyIterator() }
  def _dominateIn: java.util.Iterator[StoredNode]       = { java.util.Collections.emptyIterator() }
  def _evalTypeIn: java.util.Iterator[StoredNode]       = { java.util.Collections.emptyIterator() }
  def _inheritsFromIn: java.util.Iterator[StoredNode]   = { java.util.Collections.emptyIterator() }
  def _parameterLinkIn: java.util.Iterator[StoredNode]  = { java.util.Collections.emptyIterator() }
  def _postDominateIn: java.util.Iterator[StoredNode]   = { java.util.Collections.emptyIterator() }
  def _reachingDefIn: java.util.Iterator[StoredNode]    = { java.util.Collections.emptyIterator() }
  def _receiverIn: java.util.Iterator[StoredNode]       = { java.util.Collections.emptyIterator() }
  def _refIn: java.util.Iterator[StoredNode]            = { java.util.Collections.emptyIterator() }
  def _sourceFileIn: java.util.Iterator[StoredNode]     = { java.util.Collections.emptyIterator() }
  def _taggedByIn: java.util.Iterator[StoredNode]       = { java.util.Collections.emptyIterator() }
  def _aliasOfOut: java.util.Iterator[StoredNode]       = { java.util.Collections.emptyIterator() }
  def _argumentOut: java.util.Iterator[StoredNode]      = { java.util.Collections.emptyIterator() }
  def _astOut: java.util.Iterator[StoredNode]           = { java.util.Collections.emptyIterator() }
  def _bindsOut: java.util.Iterator[StoredNode]         = { java.util.Collections.emptyIterator() }
  def _bindsToOut: java.util.Iterator[StoredNode]       = { java.util.Collections.emptyIterator() }
  def _callOut: java.util.Iterator[StoredNode]          = { java.util.Collections.emptyIterator() }
  def _captureOut: java.util.Iterator[StoredNode]       = { java.util.Collections.emptyIterator() }
  def _capturedByOut: java.util.Iterator[StoredNode]    = { java.util.Collections.emptyIterator() }
  def _cdgOut: java.util.Iterator[StoredNode]           = { java.util.Collections.emptyIterator() }
  def _cfgOut: java.util.Iterator[StoredNode]           = { java.util.Collections.emptyIterator() }
  def _conditionOut: java.util.Iterator[StoredNode]     = { java.util.Collections.emptyIterator() }
  def _containsOut: java.util.Iterator[StoredNode]      = { java.util.Collections.emptyIterator() }
  def _dataFlowOut: java.util.Iterator[StoredNode]      = { java.util.Collections.emptyIterator() }
  def _dominateOut: java.util.Iterator[StoredNode]      = { java.util.Collections.emptyIterator() }
  def _evalTypeOut: java.util.Iterator[StoredNode]      = { java.util.Collections.emptyIterator() }
  def _inheritsFromOut: java.util.Iterator[StoredNode]  = { java.util.Collections.emptyIterator() }
  def _parameterLinkOut: java.util.Iterator[StoredNode] = { java.util.Collections.emptyIterator() }
  def _postDominateOut: java.util.Iterator[StoredNode]  = { java.util.Collections.emptyIterator() }
  def _reachingDefOut: java.util.Iterator[StoredNode]   = { java.util.Collections.emptyIterator() }
  def _receiverOut: java.util.Iterator[StoredNode]      = { java.util.Collections.emptyIterator() }
  def _refOut: java.util.Iterator[StoredNode]           = { java.util.Collections.emptyIterator() }
  def _sourceFileOut: java.util.Iterator[StoredNode]    = { java.util.Collections.emptyIterator() }
  def _taggedByOut: java.util.Iterator[StoredNode]      = { java.util.Collections.emptyIterator() }
}

trait HasAliasTypeFullName {
  def aliasTypeFullName: Option[String]
}
trait HasAliasTypeFullNameMutable extends HasAliasTypeFullName {
  def aliasTypeFullName_=(value: Option[String]): Unit
}

trait HasArgumentIndex {
  def argumentIndex: scala.Int
}
trait HasArgumentIndexMutable extends HasArgumentIndex {
  def argumentIndex_=(value: scala.Int): Unit
}

trait HasArgumentName {
  def argumentName: Option[String]
}
trait HasArgumentNameMutable extends HasArgumentName {
  def argumentName_=(value: Option[String]): Unit
}

trait HasAstParentFullName {
  def astParentFullName: String
}
trait HasAstParentFullNameMutable extends HasAstParentFullName {
  def astParentFullName_=(value: String): Unit
}

trait HasAstParentType {
  def astParentType: String
}
trait HasAstParentTypeMutable extends HasAstParentType {
  def astParentType_=(value: String): Unit
}

trait HasCanonicalName {
  def canonicalName: String
}
trait HasCanonicalNameMutable extends HasCanonicalName {
  def canonicalName_=(value: String): Unit
}

trait HasClassName {
  def className: String
}
trait HasClassNameMutable extends HasClassName {
  def className_=(value: String): Unit
}

trait HasClassShortName {
  def classShortName: String
}
trait HasClassShortNameMutable extends HasClassShortName {
  def classShortName_=(value: String): Unit
}

trait HasClosureBindingId {
  def closureBindingId: Option[String]
}
trait HasClosureBindingIdMutable extends HasClosureBindingId {
  def closureBindingId_=(value: Option[String]): Unit
}

trait HasClosureOriginalName {
  def closureOriginalName: Option[String]
}
trait HasClosureOriginalNameMutable extends HasClosureOriginalName {
  def closureOriginalName_=(value: Option[String]): Unit
}

trait HasCode {
  def code: String
}
trait HasCodeMutable extends HasCode {
  def code_=(value: String): Unit
}

trait HasColumnNumber {
  def columnNumber: Option[Integer]
}
trait HasColumnNumberMutable extends HasColumnNumber {
  def columnNumber_=(value: Option[Integer]): Unit
}

trait HasColumnNumberEnd {
  def columnNumberEnd: Option[Integer]
}
trait HasColumnNumberEndMutable extends HasColumnNumberEnd {
  def columnNumberEnd_=(value: Option[Integer]): Unit
}

trait HasContainedRef {
  def containedRef: String
}
trait HasContainedRefMutable extends HasContainedRef {
  def containedRef_=(value: String): Unit
}

trait HasContent {
  def content: String
}
trait HasContentMutable extends HasContent {
  def content_=(value: String): Unit
}

trait HasControlStructureType {
  def controlStructureType: String
}
trait HasControlStructureTypeMutable extends HasControlStructureType {
  def controlStructureType_=(value: String): Unit
}

trait HasDependencyGroupId {
  def dependencyGroupId: Option[String]
}
trait HasDependencyGroupIdMutable extends HasDependencyGroupId {
  def dependencyGroupId_=(value: Option[String]): Unit
}

trait HasDispatchType {
  def dispatchType: String
}
trait HasDispatchTypeMutable extends HasDispatchType {
  def dispatchType_=(value: String): Unit
}

trait HasDynamicTypeHintFullName {
  def dynamicTypeHintFullName: IndexedSeq[String]
}
trait HasDynamicTypeHintFullNameMutable extends HasDynamicTypeHintFullName {
  def dynamicTypeHintFullName_=(value: IndexedSeq[String]): Unit
}

trait HasEvaluationStrategy {
  def evaluationStrategy: String
}
trait HasEvaluationStrategyMutable extends HasEvaluationStrategy {
  def evaluationStrategy_=(value: String): Unit
}

trait HasExplicitAs {
  def explicitAs: Option[java.lang.Boolean]
}
trait HasExplicitAsMutable extends HasExplicitAs {
  def explicitAs_=(value: Option[java.lang.Boolean]): Unit
}

trait HasFilename {
  def filename: String
}
trait HasFilenameMutable extends HasFilename {
  def filename_=(value: String): Unit
}

trait HasFullName {
  def fullName: String
}
trait HasFullNameMutable extends HasFullName {
  def fullName_=(value: String): Unit
}

trait HasHash {
  def hash: Option[String]
}
trait HasHashMutable extends HasHash {
  def hash_=(value: Option[String]): Unit
}

trait HasImportedAs {
  def importedAs: Option[String]
}
trait HasImportedAsMutable extends HasImportedAs {
  def importedAs_=(value: Option[String]): Unit
}

trait HasImportedEntity {
  def importedEntity: Option[String]
}
trait HasImportedEntityMutable extends HasImportedEntity {
  def importedEntity_=(value: Option[String]): Unit
}

trait HasInheritsFromTypeFullName {
  def inheritsFromTypeFullName: IndexedSeq[String]
}
trait HasInheritsFromTypeFullNameMutable extends HasInheritsFromTypeFullName {
  def inheritsFromTypeFullName_=(value: IndexedSeq[String]): Unit
}

trait HasIsExplicit {
  def isExplicit: Option[java.lang.Boolean]
}
trait HasIsExplicitMutable extends HasIsExplicit {
  def isExplicit_=(value: Option[java.lang.Boolean]): Unit
}

trait HasIsExternal {
  def isExternal: Boolean
}
trait HasIsExternalMutable extends HasIsExternal {
  def isExternal_=(value: Boolean): Unit
}

trait HasIsVariadic {
  def isVariadic: Boolean
}
trait HasIsVariadicMutable extends HasIsVariadic {
  def isVariadic_=(value: Boolean): Unit
}

trait HasIsWildcard {
  def isWildcard: Option[java.lang.Boolean]
}
trait HasIsWildcardMutable extends HasIsWildcard {
  def isWildcard_=(value: Option[java.lang.Boolean]): Unit
}

trait HasKey {
  def key: String
}
trait HasKeyMutable extends HasKey {
  def key_=(value: String): Unit
}

trait HasLanguage {
  def language: String
}
trait HasLanguageMutable extends HasLanguage {
  def language_=(value: String): Unit
}

trait HasLineNumber {
  def lineNumber: Option[Integer]
}
trait HasLineNumberMutable extends HasLineNumber {
  def lineNumber_=(value: Option[Integer]): Unit
}

trait HasLineNumberEnd {
  def lineNumberEnd: Option[Integer]
}
trait HasLineNumberEndMutable extends HasLineNumberEnd {
  def lineNumberEnd_=(value: Option[Integer]): Unit
}

trait HasMethodFullName {
  def methodFullName: String
}
trait HasMethodFullNameMutable extends HasMethodFullName {
  def methodFullName_=(value: String): Unit
}

trait HasMethodShortName {
  def methodShortName: String
}
trait HasMethodShortNameMutable extends HasMethodShortName {
  def methodShortName_=(value: String): Unit
}

trait HasModifierType {
  def modifierType: String
}
trait HasModifierTypeMutable extends HasModifierType {
  def modifierType_=(value: String): Unit
}

trait HasName {
  def name: String
}
trait HasNameMutable extends HasName {
  def name_=(value: String): Unit
}

trait HasNodeLabel {
  def nodeLabel: String
}
trait HasNodeLabelMutable extends HasNodeLabel {
  def nodeLabel_=(value: String): Unit
}

trait HasOrder {
  def order: scala.Int
}
trait HasOrderMutable extends HasOrder {
  def order_=(value: scala.Int): Unit
}

trait HasOverlays {
  def overlays: IndexedSeq[String]
}
trait HasOverlaysMutable extends HasOverlays {
  def overlays_=(value: IndexedSeq[String]): Unit
}

trait HasPackageName {
  def packageName: String
}
trait HasPackageNameMutable extends HasPackageName {
  def packageName_=(value: String): Unit
}

trait HasParserTypeName {
  def parserTypeName: String
}
trait HasParserTypeNameMutable extends HasParserTypeName {
  def parserTypeName_=(value: String): Unit
}

trait HasSignature {
  def signature: String
}
trait HasSignatureMutable extends HasSignature {
  def signature_=(value: String): Unit
}

trait HasSymbol {
  def symbol: String
}
trait HasSymbolMutable extends HasSymbol {
  def symbol_=(value: String): Unit
}

trait HasTypeDeclFullName {
  def typeDeclFullName: String
}
trait HasTypeDeclFullNameMutable extends HasTypeDeclFullName {
  def typeDeclFullName_=(value: String): Unit
}

trait HasTypeFullName {
  def typeFullName: String
}
trait HasTypeFullNameMutable extends HasTypeFullName {
  def typeFullName_=(value: String): Unit
}

trait HasUsedIn {
  def usedIn: Option[String]
}
trait HasUsedInMutable extends HasUsedIn {
  def usedIn_=(value: Option[String]): Unit
}

trait HasValue {
  def value: String
}
trait HasValueMutable extends HasValue {
  def value_=(value: String): Unit
}

trait HasVersion {
  def version: String
}
trait HasVersionMutable extends HasVersion {
  def version_=(value: String): Unit
}

object Factories {
  lazy val all: Seq[NodeFactory[_]] = Seq(
    Binding.factory,
    Block.factory,
    Call.factory,
    ClosureBinding.factory,
    Comment.factory,
    ConfigFile.factory,
    ControlStructure.factory,
    Dependency.factory,
    FieldIdentifier.factory,
    File.factory,
    Finding.factory,
    Identifier.factory,
    Import.factory,
    JumpLabel.factory,
    JumpTarget.factory,
    KeyValuePair.factory,
    Literal.factory,
    Local.factory,
    Location.factory,
    Member.factory,
    MetaData.factory,
    Method.factory,
    MethodParameterIn.factory,
    MethodParameterOut.factory,
    MethodRef.factory,
    MethodReturn.factory,
    Modifier.factory,
    Namespace.factory,
    NamespaceBlock.factory,
    Return.factory,
    Tag.factory,
    TagNodePair.factory,
    Type.factory,
    TypeArgument.factory,
    TypeDecl.factory,
    TypeParameter.factory,
    TypeRef.factory,
    Unknown.factory
  )
  lazy val allAsJava: java.util.List[NodeFactory[_]] = all.asJava
}
