package io.shiftleft.codepropertygraph.generated.nodes

object AstNode {
  object PropertyNames {
    val Code             = "CODE"
    val ColumnNumber     = "COLUMN_NUMBER"
    val LineNumber       = "LINE_NUMBER"
    val Order            = "ORDER"
    val all: Set[String] = Set(Code, ColumnNumber, LineNumber, Order)
  }

  object Properties {
    val Code         = new overflowdb.PropertyKey[String]("CODE")
    val ColumnNumber = new overflowdb.PropertyKey[Integer]("COLUMN_NUMBER")
    val LineNumber   = new overflowdb.PropertyKey[Integer]("LINE_NUMBER")
    val Order        = new overflowdb.PropertyKey[scala.Int]("ORDER")
  }

  object PropertyDefaults {
    val Code  = "<empty>"
    val Order = -1: Int
  }

  object Edges {
    val Out: Array[String] = Array()
    val In: Array[String]  = Array()
  }

}

trait AstNodeBase extends AbstractNode with HasCode with HasColumnNumber with HasLineNumber with HasOrder

trait AstNodeNew
    extends NewNode
    with HasCodeMutable
    with HasColumnNumberMutable
    with HasLineNumberMutable
    with HasOrderMutable

trait AstNode extends StoredNode with AstNodeBase {}
