package io.shiftleft.codepropertygraph.generated.nodes

import overflowdb._
import scala.jdk.CollectionConverters._

object Member {
  def apply(graph: Graph, id: Long) = new Member(graph, id)

  val Label = "MEMBER"

  object PropertyNames {
    val Code                    = "CODE"
    val ColumnNumber            = "COLUMN_NUMBER"
    val DynamicTypeHintFullName = "DYNAMIC_TYPE_HINT_FULL_NAME"
    val LineNumber              = "LINE_NUMBER"
    val Name                    = "NAME"
    val Order                   = "ORDER"
    val TypeFullName            = "TYPE_FULL_NAME"
    val all: Set[String] = Set(Code, ColumnNumber, DynamicTypeHintFullName, LineNumber, Name, Order, TypeFullName)
    val allAsJava: java.util.Set[String] = all.asJava
  }

  object Properties {
    val Code                    = new overflowdb.PropertyKey[String]("CODE")
    val ColumnNumber            = new overflowdb.PropertyKey[Integer]("COLUMN_NUMBER")
    val DynamicTypeHintFullName = new overflowdb.PropertyKey[IndexedSeq[String]]("DYNAMIC_TYPE_HINT_FULL_NAME")
    val LineNumber              = new overflowdb.PropertyKey[Integer]("LINE_NUMBER")
    val Name                    = new overflowdb.PropertyKey[String]("NAME")
    val Order                   = new overflowdb.PropertyKey[scala.Int]("ORDER")
    val TypeFullName            = new overflowdb.PropertyKey[String]("TYPE_FULL_NAME")

  }

  object PropertyDefaults {
    val Code         = "<empty>"
    val Name         = "<empty>"
    val Order        = -1: Int
    val TypeFullName = "<empty>"
  }

  val layoutInformation = new NodeLayoutInformation(
    Label,
    PropertyNames.allAsJava,
    List(
      io.shiftleft.codepropertygraph.generated.edges.TaggedBy.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.EvalType.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.Ast.layoutInformation
    ).asJava,
    List(
      io.shiftleft.codepropertygraph.generated.edges.Ref.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.Ast.layoutInformation
    ).asJava
  )

  object Edges {
    val Out: Array[String] = Array("AST", "EVAL_TYPE", "TAGGED_BY")
    val In: Array[String]  = Array("AST", "REF")
  }

  val factory = new NodeFactory[MemberDb] {
    override val forLabel = Member.Label

    override def createNode(ref: NodeRef[MemberDb]) =
      new MemberDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = Member(graph, id)
  }
}

trait MemberBase
    extends AbstractNode
    with AstNodeBase
    with DeclarationBase
    with HasCode
    with HasColumnNumber
    with HasDynamicTypeHintFullName
    with HasLineNumber
    with HasName
    with HasOrder
    with HasTypeFullName {
  def asStored: StoredNode = this.asInstanceOf[StoredNode]

}

class Member(graph: Graph, id: Long)
    extends NodeRef[MemberDb](graph, id)
    with MemberBase
    with StoredNode
    with AstNode
    with Declaration {
  override def code: String                                = get().code
  override def columnNumber: Option[Integer]               = get().columnNumber
  override def dynamicTypeHintFullName: IndexedSeq[String] = get().dynamicTypeHintFullName
  override def lineNumber: Option[Integer]                 = get().lineNumber
  override def name: String                                = get().name
  override def order: scala.Int                            = get().order
  override def typeFullName: String                        = get().typeFullName
  override def propertyDefaultValue(propertyKey: String) =
    propertyKey match {
      case "CODE"           => Member.PropertyDefaults.Code
      case "NAME"           => Member.PropertyDefaults.Name
      case "ORDER"          => Member.PropertyDefaults.Order
      case "TYPE_FULL_NAME" => Member.PropertyDefaults.TypeFullName
      case _                => super.propertyDefaultValue(propertyKey)
    }

  def taggedByOut: overflowdb.traversal.Traversal[Tag] = get().taggedByOut
  override def _taggedByOut                            = get()._taggedByOut

  /** Traverse to TAG via TAGGED_BY OUT edge.
    */
  def _tagViaTaggedByOut: overflowdb.traversal.Traversal[Tag] = get()._tagViaTaggedByOut

  def evalTypeOut: overflowdb.traversal.Traversal[Type] = get().evalTypeOut
  override def _evalTypeOut                             = get()._evalTypeOut

  /** Traverse to member type Traverse to TYPE via EVAL_TYPE OUT edge.
    */
  /** Traverse to member type */
  @overflowdb.traversal.help.Doc(info = """Traverse to member type""")
  def typ: overflowdb.traversal.Traversal[Type] = get().typ

  def astOut: overflowdb.traversal.Traversal[Modifier] = get().astOut
  override def _astOut                                 = get()._astOut

  /** Traverse to MODIFIER via AST OUT edge.
    */
  def _modifierViaAstOut: overflowdb.traversal.Traversal[Modifier] = get()._modifierViaAstOut

  def refIn: overflowdb.traversal.Traversal[Call] = get().refIn
  override def _refIn                             = get()._refIn

  /** Traverse to CALL via REF IN edge.
    */
  def _callViaRefIn: overflowdb.traversal.Traversal[Call] = get()._callViaRefIn

  def astIn: overflowdb.traversal.Traversal[AstNode] = get().astIn
  override def _astIn                                = get()._astIn

  /** Traverse to UNKNOWN via AST IN edge.
    */
  def _unknownViaAstIn: overflowdb.traversal.Traversal[Unknown] = get()._unknownViaAstIn

  /** The type declaration this member is defined in Traverse to TYPE_DECL via AST IN edge.
    */
  /** The type declaration this member is defined in */
  @overflowdb.traversal.help.Doc(info = """The type declaration this member is defined in""")
  def typeDecl: TypeDecl = get().typeDecl

  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def canEqual(that: Any): Boolean                                        = get.canEqual(that)
  override def label: String = {
    Member.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id"
      case 1 => "code"
      case 2 => "columnNumber"
      case 3 => "dynamicTypeHintFullName"
      case 4 => "lineNumber"
      case 5 => "name"
      case 6 => "order"
      case 7 => "typeFullName"
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
      case 1 => code
      case 2 => columnNumber
      case 3 => dynamicTypeHintFullName
      case 4 => lineNumber
      case 5 => name
      case 6 => order
      case 7 => typeFullName
    }

  override def productPrefix = "Member"
  override def productArity  = 8
}

class MemberDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode with AstNode with Declaration with MemberBase {

  override def layoutInformation: NodeLayoutInformation = Member.layoutInformation

  private var _code: String                                = Member.PropertyDefaults.Code
  def code: String                                         = _code
  private var _columnNumber: Integer                       = null
  def columnNumber: Option[Integer]                        = Option(_columnNumber)
  private var _dynamicTypeHintFullName: IndexedSeq[String] = collection.immutable.ArraySeq.empty
  def dynamicTypeHintFullName: IndexedSeq[String]          = _dynamicTypeHintFullName
  private var _lineNumber: Integer                         = null
  def lineNumber: Option[Integer]                          = Option(_lineNumber)
  private var _name: String                                = Member.PropertyDefaults.Name
  def name: String                                         = _name
  private var _order: scala.Int                            = Member.PropertyDefaults.Order
  def order: scala.Int                                     = _order
  private var _typeFullName: String                        = Member.PropertyDefaults.TypeFullName
  def typeFullName: String                                 = _typeFullName

  /** faster than the default implementation */
  override def propertiesMap: java.util.Map[String, Any] = {
    val properties = new java.util.HashMap[String, Any]
    properties.put("CODE", code)
    columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
    if (this._dynamicTypeHintFullName != null && this._dynamicTypeHintFullName.nonEmpty) {
      properties.put("DYNAMIC_TYPE_HINT_FULL_NAME", dynamicTypeHintFullName)
    }
    lineNumber.map { value => properties.put("LINE_NUMBER", value) }
    properties.put("NAME", name)
    properties.put("ORDER", order)
    properties.put("TYPE_FULL_NAME", typeFullName)

    properties
  }

  /** faster than the default implementation */
  override def propertiesMapForStorage: java.util.Map[String, Any] = {
    val properties = new java.util.HashMap[String, Any]
    if (!(("<empty>") == code)) { properties.put("CODE", code) }
    columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
    if (this._dynamicTypeHintFullName != null && this._dynamicTypeHintFullName.nonEmpty) {
      properties.put("DYNAMIC_TYPE_HINT_FULL_NAME", dynamicTypeHintFullName)
    }
    lineNumber.map { value => properties.put("LINE_NUMBER", value) }
    if (!(("<empty>") == name)) { properties.put("NAME", name) }
    if (!((-1: Int) == order)) { properties.put("ORDER", order) }
    if (!(("<empty>") == typeFullName)) { properties.put("TYPE_FULL_NAME", typeFullName) }

    properties
  }

  def taggedByOut: overflowdb.traversal.Traversal[Tag] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[Tag](0))
  override def _taggedByOut                                   = createAdjacentNodeIteratorByOffSet[StoredNode](0)
  def _tagViaTaggedByOut: overflowdb.traversal.Traversal[Tag] = taggedByOut.collectAll[Tag]

  def evalTypeOut: overflowdb.traversal.Traversal[Type] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[Type](1))
  override def _evalTypeOut                     = createAdjacentNodeIteratorByOffSet[StoredNode](1)
  def typ: overflowdb.traversal.Traversal[Type] = evalTypeOut.collectAll[Type]

  def astOut: overflowdb.traversal.Traversal[Modifier] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[Modifier](2))
  override def _astOut                                             = createAdjacentNodeIteratorByOffSet[StoredNode](2)
  def _modifierViaAstOut: overflowdb.traversal.Traversal[Modifier] = astOut.collectAll[Modifier]

  def refIn: overflowdb.traversal.Traversal[Call] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[Call](3))
  override def _refIn                                     = createAdjacentNodeIteratorByOffSet[StoredNode](3)
  def _callViaRefIn: overflowdb.traversal.Traversal[Call] = refIn.collectAll[Call]

  def astIn: overflowdb.traversal.Traversal[AstNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[AstNode](4))
  override def _astIn                                           = createAdjacentNodeIteratorByOffSet[StoredNode](4)
  def _unknownViaAstIn: overflowdb.traversal.Traversal[Unknown] = astIn.collectAll[Unknown]
  def typeDecl: TypeDecl = try { astIn.collectAll[TypeDecl].next() }
  catch {
    case e: java.util.NoSuchElementException =>
      throw new overflowdb.SchemaViolationException(
        "IN edge with label AST to an adjacent TYPE_DECL is mandatory, but not defined for this MEMBER node with id=" + id,
        e
      )
  }

  override def label: String = {
    Member.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id"
      case 1 => "code"
      case 2 => "columnNumber"
      case 3 => "dynamicTypeHintFullName"
      case 4 => "lineNumber"
      case 5 => "name"
      case 6 => "order"
      case 7 => "typeFullName"
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
      case 1 => code
      case 2 => columnNumber
      case 3 => dynamicTypeHintFullName
      case 4 => lineNumber
      case 5 => name
      case 6 => order
      case 7 => typeFullName
    }

  override def productPrefix = "Member"
  override def productArity  = 8

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MemberDb]

  override def property(key: String): Any = {
    key match {
      case "CODE"                        => this._code
      case "COLUMN_NUMBER"               => this._columnNumber
      case "DYNAMIC_TYPE_HINT_FULL_NAME" => this._dynamicTypeHintFullName
      case "LINE_NUMBER"                 => this._lineNumber
      case "NAME"                        => this._name
      case "ORDER"                       => this._order
      case "TYPE_FULL_NAME"              => this._typeFullName

      case _ => null
    }
  }

  override protected def updateSpecificProperty(key: String, value: Object): Unit = {
    key match {
      case "CODE"          => this._code = value.asInstanceOf[String]
      case "COLUMN_NUMBER" => this._columnNumber = value.asInstanceOf[Integer]
      case "DYNAMIC_TYPE_HINT_FULL_NAME" =>
        this._dynamicTypeHintFullName = value match {
          case null                                             => collection.immutable.ArraySeq.empty
          case singleValue: String                              => collection.immutable.ArraySeq(singleValue)
          case coll: IterableOnce[Any] if coll.iterator.isEmpty => collection.immutable.ArraySeq.empty
          case arr: Array[_] if arr.isEmpty                     => collection.immutable.ArraySeq.empty
          case arr: Array[_] => collection.immutable.ArraySeq.unsafeWrapArray(arr).asInstanceOf[IndexedSeq[String]]
          case jCollection: java.lang.Iterable[_] =>
            if (jCollection.iterator.hasNext) {
              collection.immutable.ArraySeq.unsafeWrapArray(
                jCollection.asInstanceOf[java.util.Collection[String]].iterator.asScala.toArray
              )
            } else collection.immutable.ArraySeq.empty
          case iter: Iterable[_] =>
            if (iter.nonEmpty) {
              collection.immutable.ArraySeq.unsafeWrapArray(iter.asInstanceOf[Iterable[String]].toArray)
            } else collection.immutable.ArraySeq.empty
        }
      case "LINE_NUMBER"    => this._lineNumber = value.asInstanceOf[Integer]
      case "NAME"           => this._name = value.asInstanceOf[String]
      case "ORDER"          => this._order = value.asInstanceOf[scala.Int]
      case "TYPE_FULL_NAME" => this._typeFullName = value.asInstanceOf[String]

      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

  override def removeSpecificProperty(key: String): Unit =
    this.updateSpecificProperty(key, null)

  override def _initializeFromDetached(
    data: overflowdb.DetachedNodeData,
    mapper: java.util.function.Function[overflowdb.DetachedNodeData, Node]
  ) =
    fromNewNode(data.asInstanceOf[NewNode], nn => mapper.apply(nn).asInstanceOf[StoredNode])

  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = {
    this._code = newNode.asInstanceOf[NewMember].code
    this._columnNumber = newNode.asInstanceOf[NewMember].columnNumber.orNull
    this._dynamicTypeHintFullName =
      if (newNode.asInstanceOf[NewMember].dynamicTypeHintFullName != null)
        newNode.asInstanceOf[NewMember].dynamicTypeHintFullName
      else collection.immutable.ArraySeq.empty
    this._lineNumber = newNode.asInstanceOf[NewMember].lineNumber.orNull
    this._name = newNode.asInstanceOf[NewMember].name
    this._order = newNode.asInstanceOf[NewMember].order
    this._typeFullName = newNode.asInstanceOf[NewMember].typeFullName

  }

}
