package io.shiftleft.codepropertygraph.generated.nodes

object CfgNode {
  object PropertyNames {
    val Code             = "CODE"
    val ColumnNumber     = "COLUMN_NUMBER"
    val LineNumber       = "LINE_NUMBER"
    val Order            = "ORDER"
    val all: Set[String] = Set(Code, ColumnNumber, LineNumber, Order)
  }

  object Properties {
    val Code         = new overflowdb.PropertyKey[String]("CODE")
    val ColumnNumber = new overflowdb.PropertyKey[Integer]("COLUMN_NUMBER")
    val LineNumber   = new overflowdb.PropertyKey[Integer]("LINE_NUMBER")
    val Order        = new overflowdb.PropertyKey[scala.Int]("ORDER")
  }

  object PropertyDefaults {
    val Code  = "<empty>"
    val Order = -1: Int
  }

  object Edges {
    val Out: Array[String] = Array("DATA_FLOW")
    val In: Array[String] =
      Array("CFG", "CFG", "CFG", "CFG", "CFG", "CFG", "CFG", "CFG", "CFG", "CFG", "CFG", "DATA_FLOW")
  }

}

trait CfgNodeBase
    extends AbstractNode
    with HasCode
    with HasColumnNumber
    with HasLineNumber
    with HasOrder
    with AstNodeBase

trait CfgNodeNew
    extends NewNode
    with HasCodeMutable
    with HasColumnNumberMutable
    with HasLineNumberMutable
    with HasOrderMutable
    with AstNodeNew

trait CfgNode extends StoredNode with CfgNodeBase with AstNode {
  def dataFlowOut: overflowdb.traversal.Traversal[_ <: StoredNode]

  /** Traverse to RETURN via DATA_FLOW OUT edge.
    */
  def _returnViaDataFlowOut: overflowdb.traversal.Traversal[Return] =
    dataFlowOut.collectAll[Return]

  /** Traverse to CALL via DATA_FLOW OUT edge.
    */
  def _callViaDataFlowOut: overflowdb.traversal.Traversal[Call] =
    dataFlowOut.collectAll[Call]

  /** Traverse to METHOD via DATA_FLOW OUT edge.
    */
  def _methodViaDataFlowOut: overflowdb.traversal.Traversal[Method] =
    dataFlowOut.collectAll[Method]

  /** Traverse to AST_NODE via DATA_FLOW OUT edge.
    */
  def _astNodeViaDataFlowOut: overflowdb.traversal.Traversal[AstNode] =
    dataFlowOut.collectAll[AstNode]

  /** Traverse to EXPRESSION via DATA_FLOW OUT edge.
    */
  def _expressionViaDataFlowOut: overflowdb.traversal.Traversal[Expression] =
    dataFlowOut.collectAll[Expression]

  /** Traverse to LITERAL via DATA_FLOW OUT edge.
    */
  def _literalViaDataFlowOut: overflowdb.traversal.Traversal[Literal] =
    dataFlowOut.collectAll[Literal]

  /** Traverse to JUMP_TARGET via DATA_FLOW OUT edge.
    */
  def _jumpTargetViaDataFlowOut: overflowdb.traversal.Traversal[JumpTarget] =
    dataFlowOut.collectAll[JumpTarget]

  /** Traverse to FIELD_IDENTIFIER via DATA_FLOW OUT edge.
    */
  def _fieldIdentifierViaDataFlowOut: overflowdb.traversal.Traversal[FieldIdentifier] =
    dataFlowOut.collectAll[FieldIdentifier]

  /** Traverse to CFG_NODE via DATA_FLOW OUT edge.
    */
  def _cfgNodeViaDataFlowOut: overflowdb.traversal.Traversal[CfgNode] =
    dataFlowOut.collectAll[CfgNode]

  /** Traverse to METHOD_PARAMETER_IN via DATA_FLOW OUT edge.
    */
  def _methodParameterInViaDataFlowOut: overflowdb.traversal.Traversal[MethodParameterIn] =
    dataFlowOut.collectAll[MethodParameterIn]

  /** Traverse to IDENTIFIER via DATA_FLOW OUT edge.
    */
  def _identifierViaDataFlowOut: overflowdb.traversal.Traversal[Identifier] =
    dataFlowOut.collectAll[Identifier]

  /** Traverse to UNKNOWN via DATA_FLOW OUT edge.
    */
  def _unknownViaDataFlowOut: overflowdb.traversal.Traversal[Unknown] =
    dataFlowOut.collectAll[Unknown]

  /** Traverse to METHOD_PARAMETER_OUT via DATA_FLOW OUT edge.
    */
  def _methodParameterOutViaDataFlowOut: overflowdb.traversal.Traversal[MethodParameterOut] =
    dataFlowOut.collectAll[MethodParameterOut]

  /** Traverse to CONTROL_STRUCTURE via DATA_FLOW OUT edge.
    */
  def _controlStructureViaDataFlowOut: overflowdb.traversal.Traversal[ControlStructure] =
    dataFlowOut.collectAll[ControlStructure]

  /** Traverse to CALL_REPR via DATA_FLOW OUT edge.
    */
  def _callReprViaDataFlowOut: overflowdb.traversal.Traversal[CallRepr] =
    dataFlowOut.collectAll[CallRepr]

  /** Traverse to TYPE_REF via DATA_FLOW OUT edge.
    */
  def _typeRefViaDataFlowOut: overflowdb.traversal.Traversal[TypeRef] =
    dataFlowOut.collectAll[TypeRef]

  /** Traverse to METHOD_RETURN via DATA_FLOW OUT edge.
    */
  def _methodReturnViaDataFlowOut: overflowdb.traversal.Traversal[MethodReturn] =
    dataFlowOut.collectAll[MethodReturn]

  /** Traverse to BLOCK via DATA_FLOW OUT edge.
    */
  def _blockViaDataFlowOut: overflowdb.traversal.Traversal[Block] =
    dataFlowOut.collectAll[Block]

  /** Traverse to METHOD_REF via DATA_FLOW OUT edge.
    */
  def _methodRefViaDataFlowOut: overflowdb.traversal.Traversal[MethodRef] =
    dataFlowOut.collectAll[MethodRef]

  def cfgIn: overflowdb.traversal.Traversal[_ <: StoredNode]

  /** Traverse to EXPRESSION via CFG IN edge.
    */
  def _expressionViaCfgIn: overflowdb.traversal.Traversal[Expression] =
    cfgIn.collectAll[Expression]

  /** Traverse to AST_NODE via CFG IN edge.
    */
  def _astNodeViaCfgIn: overflowdb.traversal.Traversal[AstNode] =
    cfgIn.collectAll[AstNode]

  /** Traverse to CFG_NODE via CFG IN edge.
    */
  def _cfgNodeViaCfgIn: overflowdb.traversal.Traversal[CfgNode] =
    cfgIn.collectAll[CfgNode]

  /** Traverse to LITERAL via CFG IN edge.
    */
  def _literalViaCfgIn: overflowdb.traversal.Traversal[Literal] =
    cfgIn.collectAll[Literal]

  /** Traverse to IDENTIFIER via CFG IN edge.
    */
  def _identifierViaCfgIn: overflowdb.traversal.Traversal[Identifier] =
    cfgIn.collectAll[Identifier]

  /** Traverse to UNKNOWN via CFG IN edge.
    */
  def _unknownViaCfgIn: overflowdb.traversal.Traversal[Unknown] =
    cfgIn.collectAll[Unknown]

  /** Traverse to JUMP_TARGET via CFG IN edge.
    */
  def _jumpTargetViaCfgIn: overflowdb.traversal.Traversal[JumpTarget] =
    cfgIn.collectAll[JumpTarget]

  /** Traverse to METHOD_REF via CFG IN edge.
    */
  def _methodRefViaCfgIn: overflowdb.traversal.Traversal[MethodRef] =
    cfgIn.collectAll[MethodRef]

  /** Traverse to TYPE_REF via CFG IN edge.
    */
  def _typeRefViaCfgIn: overflowdb.traversal.Traversal[TypeRef] =
    cfgIn.collectAll[TypeRef]

  /** Traverse to DECLARATION via CFG IN edge.
    */
  def _declarationViaCfgIn: overflowdb.traversal.Traversal[Declaration] =
    cfgIn.collectAll[Declaration]

  /** Traverse to METHOD via CFG IN edge.
    */
  def _methodViaCfgIn: overflowdb.traversal.Traversal[Method] =
    cfgIn.collectAll[Method]

  /** Traverse to CALL via CFG IN edge.
    */
  def _callViaCfgIn: overflowdb.traversal.Traversal[Call] =
    cfgIn.collectAll[Call]

  /** Traverse to CALL_REPR via CFG IN edge.
    */
  def _callReprViaCfgIn: overflowdb.traversal.Traversal[CallRepr] =
    cfgIn.collectAll[CallRepr]

  /** Traverse to CONTROL_STRUCTURE via CFG IN edge.
    */
  def _controlStructureViaCfgIn: overflowdb.traversal.Traversal[ControlStructure] =
    cfgIn.collectAll[ControlStructure]

  /** Traverse to BLOCK via CFG IN edge.
    */
  def _blockViaCfgIn: overflowdb.traversal.Traversal[Block] =
    cfgIn.collectAll[Block]

  /** Traverse to FIELD_IDENTIFIER via CFG IN edge.
    */
  def _fieldIdentifierViaCfgIn: overflowdb.traversal.Traversal[FieldIdentifier] =
    cfgIn.collectAll[FieldIdentifier]

  def dataFlowIn: overflowdb.traversal.Traversal[_ <: StoredNode]

  /** Traverse to CONTROL_STRUCTURE via DATA_FLOW IN edge.
    */
  def _controlStructureViaDataFlowIn: overflowdb.traversal.Traversal[ControlStructure] =
    dataFlowIn.collectAll[ControlStructure]

  /** Traverse to IDENTIFIER via DATA_FLOW IN edge.
    */
  def _identifierViaDataFlowIn: overflowdb.traversal.Traversal[Identifier] =
    dataFlowIn.collectAll[Identifier]

  /** Traverse to CFG_NODE via DATA_FLOW IN edge.
    */
  def _cfgNodeViaDataFlowIn: overflowdb.traversal.Traversal[CfgNode] =
    dataFlowIn.collectAll[CfgNode]

  /** Traverse to METHOD_PARAMETER_OUT via DATA_FLOW IN edge.
    */
  def _methodParameterOutViaDataFlowIn: overflowdb.traversal.Traversal[MethodParameterOut] =
    dataFlowIn.collectAll[MethodParameterOut]

  /** Traverse to JUMP_TARGET via DATA_FLOW IN edge.
    */
  def _jumpTargetViaDataFlowIn: overflowdb.traversal.Traversal[JumpTarget] =
    dataFlowIn.collectAll[JumpTarget]

  /** Traverse to METHOD_REF via DATA_FLOW IN edge.
    */
  def _methodRefViaDataFlowIn: overflowdb.traversal.Traversal[MethodRef] =
    dataFlowIn.collectAll[MethodRef]

  /** Traverse to METHOD_RETURN via DATA_FLOW IN edge.
    */
  def _methodReturnViaDataFlowIn: overflowdb.traversal.Traversal[MethodReturn] =
    dataFlowIn.collectAll[MethodReturn]

  /** Traverse to TYPE_REF via DATA_FLOW IN edge.
    */
  def _typeRefViaDataFlowIn: overflowdb.traversal.Traversal[TypeRef] =
    dataFlowIn.collectAll[TypeRef]

  /** Traverse to BLOCK via DATA_FLOW IN edge.
    */
  def _blockViaDataFlowIn: overflowdb.traversal.Traversal[Block] =
    dataFlowIn.collectAll[Block]

  /** Traverse to METHOD_PARAMETER_IN via DATA_FLOW IN edge.
    */
  def _methodParameterInViaDataFlowIn: overflowdb.traversal.Traversal[MethodParameterIn] =
    dataFlowIn.collectAll[MethodParameterIn]

  /** Traverse to UNKNOWN via DATA_FLOW IN edge.
    */
  def _unknownViaDataFlowIn: overflowdb.traversal.Traversal[Unknown] =
    dataFlowIn.collectAll[Unknown]

  /** Traverse to EXPRESSION via DATA_FLOW IN edge.
    */
  def _expressionViaDataFlowIn: overflowdb.traversal.Traversal[Expression] =
    dataFlowIn.collectAll[Expression]

  /** Traverse to CALL_REPR via DATA_FLOW IN edge.
    */
  def _callReprViaDataFlowIn: overflowdb.traversal.Traversal[CallRepr] =
    dataFlowIn.collectAll[CallRepr]

  /** Traverse to AST_NODE via DATA_FLOW IN edge.
    */
  def _astNodeViaDataFlowIn: overflowdb.traversal.Traversal[AstNode] =
    dataFlowIn.collectAll[AstNode]

  /** Traverse to CALL via DATA_FLOW IN edge.
    */
  def _callViaDataFlowIn: overflowdb.traversal.Traversal[Call] =
    dataFlowIn.collectAll[Call]

  /** Traverse to FIELD_IDENTIFIER via DATA_FLOW IN edge.
    */
  def _fieldIdentifierViaDataFlowIn: overflowdb.traversal.Traversal[FieldIdentifier] =
    dataFlowIn.collectAll[FieldIdentifier]

  /** Traverse to METHOD via DATA_FLOW IN edge.
    */
  def _methodViaDataFlowIn: overflowdb.traversal.Traversal[Method] =
    dataFlowIn.collectAll[Method]

  /** Traverse to RETURN via DATA_FLOW IN edge.
    */
  def _returnViaDataFlowIn: overflowdb.traversal.Traversal[Return] =
    dataFlowIn.collectAll[Return]

  /** Traverse to LITERAL via DATA_FLOW IN edge.
    */
  def _literalViaDataFlowIn: overflowdb.traversal.Traversal[Literal] =
    dataFlowIn.collectAll[Literal]

}
