/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.traffic.resilience.http;

import io.servicetalk.capacity.limiter.api.CapacityLimiter;
import io.servicetalk.capacity.limiter.api.Classification;
import io.servicetalk.capacity.limiter.api.RequestDroppedException;
import io.servicetalk.circuit.breaker.api.CircuitBreaker;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.ThrowableUtils;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.traffic.resilience.http.AbstractTrafficResilienceHttpFilter;
import io.servicetalk.traffic.resilience.http.ClientPeerRejectionPolicy;
import io.servicetalk.traffic.resilience.http.DelayedRetryRequestDroppedException;
import io.servicetalk.traffic.resilience.http.NoOpTrafficResiliencyObserver;
import io.servicetalk.traffic.resilience.http.RetryableRequestDroppedException;
import io.servicetalk.traffic.resilience.http.SafeTrafficResiliencyObserver;
import io.servicetalk.traffic.resilience.http.TrackPendingRequestsHttpFilter;
import io.servicetalk.traffic.resilience.http.TrafficResiliencyObserver;
import io.servicetalk.transport.api.ServerListenContext;
import io.servicetalk.utils.internal.DurationUtils;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class TrafficResilienceHttpClientFilter
extends AbstractTrafficResilienceHttpFilter
implements StreamingHttpClientFilterFactory {
    private static final RequestDroppedException LOCAL_REJECTION_RETRYABLE_EXCEPTION = (RequestDroppedException)ThrowableUtils.unknownStackTrace((Throwable)((Object)new RetryableRequestDroppedException("Local capacity rejection", null, false, true)), TrafficResilienceHttpClientFilter.class, (String)"localRejection");
    private static final Single<StreamingHttpResponse> RETRYABLE_LOCAL_CAPACITY_REJECTION = Single.failed((Throwable)LOCAL_REJECTION_RETRYABLE_EXCEPTION);
    public static final Predicate<HttpResponseMetaData> DEFAULT_BREAKER_REJECTION_PREDICATE = metaData -> metaData.status().code() == HttpResponseStatus.SERVICE_UNAVAILABLE.code();
    private final ClientPeerRejectionPolicy clientPeerRejectionPolicy;
    private final boolean forceOpenCircuitOnPeerCircuitRejections;
    @Nullable
    private final Supplier<Function<HttpResponseMetaData, Duration>> focreOpenCircuitOnPeerCircuitRejectionsDelayProvider;
    @Nullable
    private final Executor circuitBreakerResetExecutor;

    private TrafficResilienceHttpClientFilter(Supplier<Function<HttpRequestMetaData, CapacityLimiter>> capacityPartitionsSupplier, boolean rejectWhenNotMatchedCapacityPartition, Supplier<Function<HttpRequestMetaData, CircuitBreaker>> circuitBreakerPartitionsSupplier, Supplier<Function<HttpRequestMetaData, Classification>> classifier, ClientPeerRejectionPolicy clientPeerRejectionPolicy, Predicate<HttpResponseMetaData> breakerRejectionPredicate, Consumer<CapacityLimiter.Ticket> onCompletion, Consumer<CapacityLimiter.Ticket> onCancellation, BiConsumer<CapacityLimiter.Ticket, Throwable> onError, boolean forceOpenCircuitOnPeerCircuitRejections, @Nullable Supplier<Function<HttpResponseMetaData, Duration>> focreOpenCircuitOnPeerCircuitRejectionsDelayProvider, @Nullable Executor circuitBreakerResetExecutor, TrafficResiliencyObserver observer, boolean dryRun) {
        super(capacityPartitionsSupplier, rejectWhenNotMatchedCapacityPartition, classifier, clientPeerRejectionPolicy.predicate(), breakerRejectionPredicate, onCompletion, onCancellation, onError, circuitBreakerPartitionsSupplier, observer, true, dryRun);
        this.clientPeerRejectionPolicy = clientPeerRejectionPolicy;
        this.forceOpenCircuitOnPeerCircuitRejections = forceOpenCircuitOnPeerCircuitRejections;
        this.focreOpenCircuitOnPeerCircuitRejectionsDelayProvider = focreOpenCircuitOnPeerCircuitRejectionsDelayProvider;
        this.circuitBreakerResetExecutor = circuitBreakerResetExecutor;
    }

    public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
        return TrackPendingRequestsHttpFilter.BEFORE.create((FilterableStreamingHttpClient)new StreamingHttpClientFilter((FilterableStreamingHttpClient)TrackPendingRequestsHttpFilter.AFTER.create(client)){
            final Function<HttpRequestMetaData, CapacityLimiter> capacityPartitions;
            final Function<HttpRequestMetaData, CircuitBreaker> circuitBreakerPartitions;
            final Function<HttpRequestMetaData, Classification> classifier;
            final Function<HttpResponseMetaData, Duration> delayProvider;
            {
                this.capacityPartitions = TrafficResilienceHttpClientFilter.this.newCapacityPartitions();
                this.circuitBreakerPartitions = TrafficResilienceHttpClientFilter.this.newCircuitBreakerPartitions();
                this.classifier = TrafficResilienceHttpClientFilter.this.newClassifier();
                this.delayProvider = TrafficResilienceHttpClientFilter.this.newDelayProvider();
            }

            protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request) {
                return TrafficResilienceHttpClientFilter.this.applyCapacityControl(this.capacityPartitions, this.circuitBreakerPartitions, this.classifier, this.delayProvider, null, request, null, arg_0 -> ((StreamingHttpRequester)delegate).request(arg_0)).onErrorResume(ClientPeerRejectionPolicy.PassthroughRequestDroppedException.class, t -> Single.succeeded((Object)t.response()));
            }
        });
    }

    @Override
    Single<StreamingHttpResponse> handleLocalBreakerRejection(StreamingHttpRequest request, @Nullable StreamingHttpResponseFactory responseFactory, CircuitBreaker breaker) {
        return DEFAULT_BREAKER_REJECTION;
    }

    @Override
    Single<StreamingHttpResponse> handleLocalCapacityRejection(@Nullable ServerListenContext serverListenContext, StreamingHttpRequest request, @Nullable StreamingHttpResponseFactory responseFactory) {
        return RETRYABLE_LOCAL_CAPACITY_REJECTION;
    }

    @Override
    RuntimeException peerRejection(StreamingHttpResponse resp) {
        ClientPeerRejectionPolicy.Type type = this.clientPeerRejectionPolicy.type();
        if (type == ClientPeerRejectionPolicy.Type.REJECT_RETRY) {
            Duration delay = this.clientPeerRejectionPolicy.delayProvider().apply((HttpResponseMetaData)resp);
            return new DelayedRetryRequestDroppedException(delay);
        }
        if (type == ClientPeerRejectionPolicy.Type.REJECT) {
            return super.peerRejection(resp);
        }
        if (type == ClientPeerRejectionPolicy.Type.REJECT_PASSTHROUGH) {
            return new ClientPeerRejectionPolicy.PassthroughRequestDroppedException("Service under heavy load", resp);
        }
        return new IllegalStateException("Unexpected ClientPeerRejectionPolicy.Type: " + (Object)((Object)type));
    }

    @Override
    RuntimeException peerBreakerRejection(HttpResponseMetaData resp, CircuitBreaker breaker, Function<HttpResponseMetaData, Duration> delayProvider) {
        if (this.forceOpenCircuitOnPeerCircuitRejections) {
            assert (this.circuitBreakerResetExecutor != null);
            Duration delay = delayProvider.apply(resp);
            if (DurationUtils.isPositive((Duration)delay)) {
                breaker.forceOpenState();
                this.circuitBreakerResetExecutor.schedule(() -> ((CircuitBreaker)breaker).reset(), delay);
            }
        }
        return super.peerBreakerRejection(resp, breaker, delayProvider);
    }

    @Override
    Function<HttpResponseMetaData, Duration> newDelayProvider() {
        if (this.focreOpenCircuitOnPeerCircuitRejectionsDelayProvider == null) {
            return __ -> Duration.ZERO;
        }
        return this.focreOpenCircuitOnPeerCircuitRejectionsDelayProvider.get();
    }

    public static final class Builder {
        private Supplier<Function<HttpRequestMetaData, CapacityLimiter>> capacityPartitionsSupplier;
        private boolean rejectWhenNotMatchedCapacityPartition;
        private Supplier<Function<HttpRequestMetaData, CircuitBreaker>> circuitBreakerPartitionsSupplier = () -> __ -> null;
        private Supplier<Function<HttpRequestMetaData, Classification>> classifier = () -> __ -> () -> Integer.MAX_VALUE;
        private ClientPeerRejectionPolicy clientPeerRejectionPolicy = ClientPeerRejectionPolicy.DEFAULT_PEER_REJECTION_POLICY;
        private Predicate<HttpResponseMetaData> peerUnavailableRejectionPredicate = DEFAULT_BREAKER_REJECTION_PREDICATE;
        private final Consumer<CapacityLimiter.Ticket> onCompletionTicketTerminal = CapacityLimiter.Ticket::completed;
        private Consumer<CapacityLimiter.Ticket> onCancellationTicketTerminal = CapacityLimiter.Ticket::dropped;
        private BiConsumer<CapacityLimiter.Ticket, Throwable> onErrorTicketTerminal = (ticket, throwable) -> {
            if (throwable instanceof RequestDroppedException || throwable instanceof TimeoutException) {
                ticket.dropped();
            } else {
                ticket.failed(throwable);
            }
        };
        private boolean forceOpenCircuitOnPeerCircuitRejections;
        @Nullable
        private Supplier<Function<HttpResponseMetaData, Duration>> focreOpenCircuitOnPeerCircuitRejectionsDelayProvider;
        @Nullable
        private Executor circuitBreakerResetExecutor;
        private TrafficResiliencyObserver observer = NoOpTrafficResiliencyObserver.INSTANCE;
        private boolean dryRun;

        public Builder(Supplier<CapacityLimiter> capacityLimiterSupplier) {
            Objects.requireNonNull(capacityLimiterSupplier);
            this.capacityPartitionsSupplier = () -> {
                CapacityLimiter capacityLimiter = (CapacityLimiter)capacityLimiterSupplier.get();
                return __ -> capacityLimiter;
            };
            this.rejectWhenNotMatchedCapacityPartition = true;
        }

        public Builder(Supplier<Function<HttpRequestMetaData, CapacityLimiter>> capacityPartitionsSupplier, boolean rejectNotMatched) {
            this.capacityPartitionsSupplier = Objects.requireNonNull(capacityPartitionsSupplier);
            this.rejectWhenNotMatchedCapacityPartition = rejectNotMatched;
        }

        public Builder capacityPartitions(Supplier<Function<HttpRequestMetaData, CapacityLimiter>> capacityPartitionsSupplier, boolean rejectNotMatched) {
            this.capacityPartitionsSupplier = Objects.requireNonNull(capacityPartitionsSupplier);
            this.rejectWhenNotMatchedCapacityPartition = rejectNotMatched;
            return this;
        }

        public Builder classifier(Supplier<Function<HttpRequestMetaData, Classification>> classifier) {
            this.classifier = Objects.requireNonNull(classifier);
            return this;
        }

        public Builder circuitBreakerPartitions(Supplier<Function<HttpRequestMetaData, CircuitBreaker>> circuitBreakerPartitionsSupplier) {
            this.circuitBreakerPartitionsSupplier = Objects.requireNonNull(circuitBreakerPartitionsSupplier);
            return this;
        }

        public Builder rejectionPolicy(ClientPeerRejectionPolicy policy) {
            this.clientPeerRejectionPolicy = Objects.requireNonNull(policy);
            return this;
        }

        public Builder peerUnavailableRejectionPredicate(Predicate<HttpResponseMetaData> rejectionPredicate) {
            this.peerUnavailableRejectionPredicate = Objects.requireNonNull(rejectionPredicate);
            return this;
        }

        public Builder forceOpenCircuitOnPeerCircuitRejections(Supplier<Function<HttpResponseMetaData, Duration>> delayProvider, Executor executor) {
            this.forceOpenCircuitOnPeerCircuitRejections = true;
            this.focreOpenCircuitOnPeerCircuitRejectionsDelayProvider = Objects.requireNonNull(delayProvider);
            this.circuitBreakerResetExecutor = Objects.requireNonNull(executor);
            return this;
        }

        public Builder dontForceOpenCircuitOnPeerCircuitRejections() {
            this.forceOpenCircuitOnPeerCircuitRejections = false;
            this.focreOpenCircuitOnPeerCircuitRejectionsDelayProvider = null;
            this.circuitBreakerResetExecutor = null;
            return this;
        }

        public Builder onErrorTicketTerminal(BiConsumer<CapacityLimiter.Ticket, Throwable> onError) {
            this.onErrorTicketTerminal = Objects.requireNonNull(onError);
            return this;
        }

        public Builder onCancelTicketTerminal(Consumer<CapacityLimiter.Ticket> onCancellation) {
            this.onCancellationTicketTerminal = Objects.requireNonNull(onCancellation);
            return this;
        }

        public Builder observer(TrafficResiliencyObserver observer) {
            this.observer = new SafeTrafficResiliencyObserver(observer);
            return this;
        }

        public Builder dryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public TrafficResilienceHttpClientFilter build() {
            return new TrafficResilienceHttpClientFilter(this.capacityPartitionsSupplier, this.rejectWhenNotMatchedCapacityPartition, this.circuitBreakerPartitionsSupplier, this.classifier, this.clientPeerRejectionPolicy, this.peerUnavailableRejectionPredicate, this.onCompletionTicketTerminal, this.onCancellationTicketTerminal, this.onErrorTicketTerminal, this.forceOpenCircuitOnPeerCircuitRejections, this.focreOpenCircuitOnPeerCircuitRejectionsDelayProvider, this.circuitBreakerResetExecutor, this.observer, this.dryRun);
        }
    }
}

