/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.traffic.resilience.http;

import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SingleOperator;
import io.servicetalk.concurrent.api.TerminalSignalConsumer;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.http.utils.BeforeFinallyHttpOperator;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class TrackPendingRequestsHttpFilter
implements StreamingHttpClientFilterFactory,
StreamingHttpServiceFilterFactory {
    static final TrackPendingRequestsHttpFilter BEFORE = new TrackPendingRequestsHttpFilter(Position.BEFORE);
    static final TrackPendingRequestsHttpFilter AFTER = new TrackPendingRequestsHttpFilter(Position.AFTER);
    private final Position position;

    private TrackPendingRequestsHttpFilter(Position position) {
        this.position = position;
    }

    public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
        return new TrackPendingRequestsHttpClientFilter(client, this.position);
    }

    public StreamingHttpServiceFilter create(StreamingHttpService service) {
        return new TrackPendingRequestsHttpServiceFilter(service, this.position);
    }

    public HttpExecutionStrategy requiredOffloads() {
        return HttpExecutionStrategies.offloadNone();
    }

    private static final class TrackPendingRequestsHttpServiceFilter
    extends StreamingHttpServiceFilter {
        private static final AtomicIntegerFieldUpdater<TrackPendingRequestsHttpServiceFilter> pendingUpdater = AtomicIntegerFieldUpdater.newUpdater(TrackPendingRequestsHttpServiceFilter.class, "pending");
        private volatile int pending;
        private final Position position;

        TrackPendingRequestsHttpServiceFilter(StreamingHttpService service, Position position) {
            super(service);
            this.position = position;
        }

        public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
            return Single.defer(() -> {
                pendingUpdater.incrementAndGet(this);
                return this.delegate().handle(ctx, request, responseFactory).liftSync((SingleOperator)new BeforeFinallyHttpOperator(new TerminalSignalConsumer(){

                    public void onComplete() {
                        this.decrement();
                    }

                    public void onError(Throwable throwable) {
                        this.decrement();
                    }

                    public void cancel() {
                        this.decrement();
                    }

                    private void decrement() {
                        pendingUpdater.decrementAndGet(this);
                    }
                })).shareContextOnSubscribe();
            });
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "{pending=" + this.pending + ", position=" + (Object)((Object)this.position) + '}';
        }
    }

    private static final class TrackPendingRequestsHttpClientFilter
    extends StreamingHttpClientFilter {
        private static final AtomicIntegerFieldUpdater<TrackPendingRequestsHttpClientFilter> pendingUpdater = AtomicIntegerFieldUpdater.newUpdater(TrackPendingRequestsHttpClientFilter.class, "pending");
        private volatile int pending;
        private final Position position;

        TrackPendingRequestsHttpClientFilter(FilterableStreamingHttpClient client, Position position) {
            super(client);
            this.position = position;
        }

        protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request) {
            return Single.defer(() -> {
                pendingUpdater.incrementAndGet(this);
                return delegate.request(request).liftSync((SingleOperator)new BeforeFinallyHttpOperator(new TerminalSignalConsumer(){

                    public void onComplete() {
                        this.decrement();
                    }

                    public void onError(Throwable throwable) {
                        this.decrement();
                    }

                    public void cancel() {
                        this.decrement();
                    }

                    private void decrement() {
                        pendingUpdater.decrementAndGet(this);
                    }
                })).shareContextOnSubscribe();
            });
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "{pending=" + this.pending + ", position=" + (Object)((Object)this.position) + '}';
        }
    }

    private static enum Position {
        BEFORE,
        AFTER;

    }
}

