/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeSingle;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.TaskBasedAsyncCompletableOperator;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.concurrent.internal.TerminalNotification;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class TaskBasedAsyncSingleOperator<T>
extends AbstractNoHandleSubscribeSingle<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskBasedAsyncSingleOperator.class);
    private static final Object NULL_WRAPPER = new Object(){

        public String toString() {
            return "NULL_WRAPPER";
        }
    };
    private final Single<T> original;
    private final BooleanSupplier shouldOffload;
    private final Executor executor;

    TaskBasedAsyncSingleOperator(Single<T> original, BooleanSupplier shouldOffload, Executor executor) {
        this.original = original;
        this.shouldOffload = Objects.requireNonNull(shouldOffload, "shouldOffload");
        this.executor = Objects.requireNonNull(executor, "executor");
    }

    final BooleanSupplier shouldOffload() {
        return this.shouldOffload;
    }

    final Executor executor() {
        return this.executor;
    }

    @Override
    void handleSubscribe(SingleSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(subscriber, contextMap, contextProvider);
    }

    static final class SingleSubscriberOffloadedCancellable<T>
    implements SingleSource.Subscriber<T> {
        private final SingleSource.Subscriber<? super T> subscriber;
        private final BooleanSupplier shouldOffload;
        private final Executor executor;

        SingleSubscriberOffloadedCancellable(SingleSource.Subscriber<? super T> subscriber, BooleanSupplier shouldOffload, Executor executor) {
            this.subscriber = Objects.requireNonNull(subscriber);
            this.shouldOffload = shouldOffload;
            this.executor = executor;
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
            this.subscriber.onSubscribe(new TaskBasedAsyncCompletableOperator.OffloadedCancellable(cancellable, this.shouldOffload, this.executor));
        }

        @Override
        public void onSuccess(@Nullable T result) {
            this.subscriber.onSuccess(result);
        }

        @Override
        public void onError(Throwable t) {
            this.subscriber.onError(t);
        }
    }

    static final class SingleSubscriberOffloadedTerminals<T>
    extends TaskBasedAsyncCompletableOperator.AbstractOffloadedSingleValueSubscriber
    implements SingleSource.Subscriber<T> {
        private final SingleSource.Subscriber<T> target;

        SingleSubscriberOffloadedTerminals(SingleSource.Subscriber<T> target, BooleanSupplier shouldOffload, Executor executor) {
            super(shouldOffload, executor);
            this.target = Objects.requireNonNull(target);
        }

        @Override
        public void onSuccess(@Nullable T result) {
            this.terminal(result == null ? NULL_WRAPPER : result);
        }

        @Override
        public void onError(Throwable t) {
            this.terminal(TerminalNotification.error((Throwable)t));
        }

        @Override
        void terminateOnEnqueueFailure(Throwable cause) {
            LOGGER.warn("Failed to execute task on the executor {}. Invoking Subscriber (onError()) in the caller thread. Subscriber {}.", new Object[]{this.executor, this.target, cause});
            this.target.onError(cause);
        }

        @Override
        void deliverTerminalToSubscriber(Object terminal) {
            if (terminal instanceof TerminalNotification) {
                Throwable error = ((TerminalNotification)terminal).cause();
                assert (error != null);
                SubscriberUtils.safeOnError(this.target, (Throwable)error);
            } else {
                SubscriberUtils.safeOnSuccess(this.target, this.uncheckCast(terminal));
            }
        }

        @Override
        void sendOnSubscribe(Cancellable cancellable) {
            try {
                this.target.onSubscribe(cancellable);
            }
            catch (Throwable t) {
                this.onSubscribeFailed();
                SubscriberUtils.safeOnError(this.target, (Throwable)t);
                SubscriberUtils.safeCancel((Cancellable)cancellable);
            }
        }

        @Nullable
        private T uncheckCast(Object signal) {
            return (T)(signal == NULL_WRAPPER ? null : signal);
        }
    }
}

