/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.BlockingProcessorSignalsHolder;
import io.servicetalk.concurrent.api.CompletableProcessor;
import io.servicetalk.concurrent.api.DefaultBlockingIterableProcessor;
import io.servicetalk.concurrent.api.DefaultBlockingProcessorSignalsHolder;
import io.servicetalk.concurrent.api.PublisherProcessor;
import io.servicetalk.concurrent.api.PublisherProcessorSignalHolders;
import io.servicetalk.concurrent.api.PublisherProcessorSignalsHolder;
import io.servicetalk.concurrent.api.SingleProcessor;

public final class Processors {
    private Processors() {
    }

    public static CompletableSource.Processor newCompletableProcessor() {
        return new CompletableProcessor();
    }

    public static <T> SingleSource.Processor<T, T> newSingleProcessor() {
        return new SingleProcessor();
    }

    public static <T> PublisherSource.Processor<T, T> newPublisherProcessor() {
        return Processors.newPublisherProcessor(32);
    }

    public static <T> PublisherSource.Processor<T, T> newPublisherProcessor(int maxBuffer) {
        return Processors.newPublisherProcessor(PublisherProcessorSignalHolders.fixedSize(maxBuffer));
    }

    public static <T> PublisherSource.Processor<T, T> newPublisherProcessorDropHeadOnOverflow(int maxBuffer) {
        return Processors.newPublisherProcessor(PublisherProcessorSignalHolders.fixedSizeDropHead(maxBuffer));
    }

    public static <T> PublisherSource.Processor<T, T> newPublisherProcessorDropTailOnOverflow(int maxBuffer) {
        return Processors.newPublisherProcessor(PublisherProcessorSignalHolders.fixedSizeDropTail(maxBuffer));
    }

    public static <T> PublisherSource.Processor<T, T> newPublisherProcessor(PublisherProcessorSignalsHolder<T> holder) {
        return new PublisherProcessor<T>(holder);
    }

    public static <T> BlockingIterable.Processor<T> newBlockingIterableProcessor() {
        return Processors.newBlockingIterableProcessor(32);
    }

    public static <T> BlockingIterable.Processor<T> newBlockingIterableProcessor(int maxBufferSize) {
        return new DefaultBlockingIterableProcessor(new DefaultBlockingProcessorSignalsHolder(maxBufferSize));
    }

    public static <T> BlockingIterable.Processor<T> newBlockingIterableProcessor(BlockingProcessorSignalsHolder<T> holder) {
        return new DefaultBlockingIterableProcessor<T>(holder);
    }
}

