/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.OnSubscribeIgnoringSubscriberForOffloading;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.context.api.ContextMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;

final class SingleToPublisher<T>
extends AbstractNoHandleSubscribePublisher<T> {
    private final Single<T> original;

    SingleToPublisher(Single<T> original) {
        this.original = original;
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new ConversionSubscriber<T>(subscriber, contextMap, contextProvider), contextMap, contextProvider);
    }

    private static final class ConversionSubscriber<T>
    extends SequentialCancellable
    implements PublisherSource.Subscription,
    SingleSource.Subscriber<T> {
        private static final int STATE_IDLE = 0;
        private static final int STATE_REQUESTED = 1;
        private static final int STATE_AWAITING_REQUESTED = 2;
        private static final int STATE_TERMINATED = 3;
        private static final AtomicIntegerFieldUpdater<ConversionSubscriber> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(ConversionSubscriber.class, "state");
        private final PublisherSource.Subscriber<? super T> subscriber;
        private final ContextMap contextMap;
        private final AsyncContextProvider contextProvider;
        @Nullable
        private T result;
        private volatile int state;

        ConversionSubscriber(PublisherSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
            this.subscriber = subscriber;
            this.contextMap = contextMap;
            this.contextProvider = contextProvider;
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
            this.nextCancellable(cancellable);
            this.subscriber.onSubscribe(this);
        }

        @Override
        public void onSuccess(@Nullable T result) {
            int cState;
            this.result = result;
            do {
                if ((cState = this.state) == 1 && stateUpdater.compareAndSet(this, 1, 3)) {
                    this.terminateSuccessfully(result, this.subscriber);
                    return;
                }
                if (cState != 0 || !stateUpdater.compareAndSet(this, 0, 2)) continue;
                return;
            } while (cState != 2 && cState != 3);
        }

        @Override
        public void onError(Throwable t) {
            if (stateUpdater.getAndSet(this, 3) != 3) {
                this.subscriber.onError(t);
            }
        }

        @Override
        public void request(long n) {
            if (SubscriberUtils.isRequestNValid((long)n)) {
                int cState;
                do {
                    if ((cState = this.state) == 2 && stateUpdater.compareAndSet(this, 2, 3)) {
                        this.terminateSuccessfully(this.result, OnSubscribeIgnoringSubscriberForOffloading.wrapWithDummyOnSubscribe(this.subscriber, this.contextMap, this.contextProvider));
                        return;
                    }
                    if (cState != 0 || !stateUpdater.compareAndSet(this, 0, 1)) continue;
                    return;
                } while (cState != 3 && cState != 1);
                return;
            }
            if (stateUpdater.getAndSet(this, 3) != 3) {
                PublisherSource.Subscriber<T> wrapped = OnSubscribeIgnoringSubscriberForOffloading.wrapWithDummyOnSubscribe(this.subscriber, this.contextMap, this.contextProvider);
                try {
                    this.cancel();
                }
                catch (Throwable t) {
                    wrapped.onError(t);
                    return;
                }
                wrapped.onError(SubscriberUtils.newExceptionForInvalidRequestN((long)n));
            }
        }

        private void terminateSuccessfully(@Nullable T result, PublisherSource.Subscriber<? super T> subscriber) {
            try {
                subscriber.onNext(result);
            }
            catch (Throwable cause) {
                subscriber.onError(cause);
                return;
            }
            subscriber.onComplete();
        }
    }
}

