/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.netty;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.grpc.api.GrpcHeaderNames;
import io.servicetalk.grpc.api.GrpcLifecycleObserver;
import io.servicetalk.grpc.api.GrpcStatus;
import io.servicetalk.grpc.api.GrpcStatusCode;
import io.servicetalk.grpc.internal.GrpcStatusUtils;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpLifecycleObserver;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.transport.api.ConnectionInfo;
import java.util.Objects;
import javax.annotation.Nullable;

final class GrpcToHttpLifecycleObserverBridge
implements HttpLifecycleObserver {
    private final GrpcLifecycleObserver observer;

    GrpcToHttpLifecycleObserverBridge(GrpcLifecycleObserver observer) {
        this.observer = Objects.requireNonNull(observer);
    }

    public HttpLifecycleObserver.HttpExchangeObserver onNewExchange() {
        return new GrpcToHttpExchangeObserverBridge(this.observer.onNewExchange());
    }

    private static final class GrpcToHttpResponseObserver
    implements HttpLifecycleObserver.HttpResponseObserver {
        private final GrpcLifecycleObserver.GrpcResponseObserver observer;

        GrpcToHttpResponseObserver(GrpcLifecycleObserver.GrpcResponseObserver observer, HttpResponseMetaData responseMetaData) {
            this.observer = observer;
            GrpcStatus grpcStatus = GrpcToHttpResponseObserver.status(responseMetaData.headers());
            if (grpcStatus != null) {
                observer.onGrpcStatus(grpcStatus);
            }
        }

        public void onResponseDataRequested(long n) {
            this.observer.onResponseDataRequested(n);
        }

        public void onResponseData(Buffer data) {
            this.observer.onResponseData(data);
        }

        public void onResponseTrailers(HttpHeaders trailers) {
            this.observer.onResponseTrailers(trailers);
            GrpcStatus grpcStatus = GrpcToHttpResponseObserver.status(trailers);
            if (grpcStatus != null) {
                this.observer.onGrpcStatus(grpcStatus);
            }
        }

        public void onResponseComplete() {
            this.observer.onResponseComplete();
        }

        public void onResponseError(Throwable cause) {
            this.observer.onResponseError(cause);
        }

        public void onResponseCancel() {
            this.observer.onResponseCancel();
        }

        @Nullable
        static GrpcStatus status(@Nullable HttpHeaders headers) {
            if (headers == null) {
                return null;
            }
            CharSequence statusStr = headers.get(GrpcHeaderNames.GRPC_STATUS);
            if (statusStr == null) {
                return null;
            }
            CharSequence statusMsg = GrpcStatusUtils.getStatusMessage((HttpHeaders)headers);
            return new GrpcStatus(GrpcStatusCode.fromCodeValue((CharSequence)statusStr), statusMsg == null ? null : statusMsg.toString());
        }
    }

    private static final class GrpcToHttpRequestObserver
    implements HttpLifecycleObserver.HttpRequestObserver {
        private final GrpcLifecycleObserver.GrpcRequestObserver observer;

        GrpcToHttpRequestObserver(GrpcLifecycleObserver.GrpcRequestObserver observer) {
            this.observer = observer;
        }

        public void onRequestDataRequested(long n) {
            this.observer.onRequestDataRequested(n);
        }

        public void onRequestData(Buffer data) {
            this.observer.onRequestData(data);
        }

        public void onRequestTrailers(HttpHeaders trailers) {
            this.observer.onRequestTrailers(trailers);
        }

        public void onRequestComplete() {
            this.observer.onRequestComplete();
        }

        public void onRequestError(Throwable cause) {
            this.observer.onRequestError(cause);
        }

        public void onRequestCancel() {
            this.observer.onRequestCancel();
        }
    }

    private static final class GrpcToHttpExchangeObserverBridge
    implements HttpLifecycleObserver.HttpExchangeObserver {
        private final GrpcLifecycleObserver.GrpcExchangeObserver observer;

        GrpcToHttpExchangeObserverBridge(GrpcLifecycleObserver.GrpcExchangeObserver observer) {
            this.observer = observer;
        }

        public void onConnectionSelected(ConnectionInfo info) {
            this.observer.onConnectionSelected(info);
        }

        public HttpLifecycleObserver.HttpRequestObserver onRequest(HttpRequestMetaData requestMetaData) {
            return new GrpcToHttpRequestObserver(this.observer.onRequest(requestMetaData));
        }

        public HttpLifecycleObserver.HttpResponseObserver onResponse(HttpResponseMetaData responseMetaData) {
            return new GrpcToHttpResponseObserver(this.observer.onResponse(responseMetaData), responseMetaData);
        }

        public void onResponseError(Throwable cause) {
            this.observer.onResponseError(cause);
        }

        public void onResponseCancel() {
            this.observer.onResponseCancel();
        }

        public void onExchangeFinally() {
            this.observer.onExchangeFinally();
        }
    }
}

