/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.netty;

import io.servicetalk.grpc.api.GrpcProviders;
import io.servicetalk.grpc.api.GrpcServerBuilder;
import io.servicetalk.grpc.netty.DefaultGrpcServerBuilder;
import io.servicetalk.http.netty.HttpServers;
import io.servicetalk.utils.internal.ServiceLoaderUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrpcServers {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcServers.class);
    private static final List<GrpcProviders.GrpcServerBuilderProvider> PROVIDERS;

    private GrpcServers() {
    }

    private static GrpcServerBuilder applyProviders(SocketAddress address, GrpcServerBuilder builder) {
        for (GrpcProviders.GrpcServerBuilderProvider provider : PROVIDERS) {
            builder = provider.newBuilder(address, builder);
        }
        return builder;
    }

    public static GrpcServerBuilder forPort(int port) {
        InetSocketAddress address = new InetSocketAddress(port);
        return GrpcServers.forAddress(address);
    }

    public static GrpcServerBuilder forAddress(SocketAddress address) {
        return GrpcServers.applyProviders(address, new DefaultGrpcServerBuilder(() -> HttpServers.forAddress((SocketAddress)address)));
    }

    static {
        ClassLoader classLoader = GrpcServers.class.getClassLoader();
        PROVIDERS = ServiceLoaderUtils.loadProviders(GrpcProviders.GrpcServerBuilderProvider.class, (ClassLoader)classLoader, (Logger)LOGGER);
    }
}

