/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.netty;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.client.api.AutoRetryStrategyProvider;
import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.grpc.api.GrpcClientBuilder;
import io.servicetalk.grpc.api.GrpcClientCallFactory;
import io.servicetalk.grpc.api.GrpcClientSecurityConfigurator;
import io.servicetalk.grpc.api.GrpcExecutionStrategy;
import io.servicetalk.grpc.api.GrpcStatus;
import io.servicetalk.grpc.api.GrpcStatusException;
import io.servicetalk.grpc.internal.DeadlineUtils;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpLoadBalancerFactory;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.ReservedStreamingHttpConnectionFilter;
import io.servicetalk.http.api.SingleAddressHttpClientBuilder;
import io.servicetalk.http.api.SingleAddressHttpClientSecurityConfigurator;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.netty.HttpProtocolConfigs;
import io.servicetalk.http.utils.TimeoutFromRequest;
import io.servicetalk.http.utils.TimeoutHttpRequesterFilter;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.api.ClientSslConfig;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.api.SecurityConfigurator;
import io.servicetalk.utils.internal.DurationUtils;
import java.io.InputStream;
import java.net.SocketOption;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

final class DefaultGrpcClientBuilder<U, R>
extends GrpcClientBuilder<U, R> {
    private static final TimeoutFromRequest GRPC_TIMEOUT_REQHDR = new TimeoutFromRequest(){

        @Nullable
        public Duration apply(HttpRequestMetaData request) {
            return DeadlineUtils.readTimeoutHeader((HttpRequestMetaData)request);
        }

        public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
            return strategy;
        }
    };
    @Nullable
    private Duration defaultTimeout;
    private GrpcClientBuilder.HttpInitializer<U, R> httpInitializer = builder -> {};
    private GrpcClientBuilder.HttpInitializer<U, R> directHttpInitializer = builder -> {};
    private final Supplier<SingleAddressHttpClientBuilder<U, R>> httpClientBuilderSupplier;

    DefaultGrpcClientBuilder(Supplier<SingleAddressHttpClientBuilder<U, R>> httpClientBuilderSupplier) {
        this.httpClientBuilderSupplier = httpClientBuilderSupplier;
    }

    public GrpcClientBuilder<U, R> initializeHttp(GrpcClientBuilder.HttpInitializer<U, R> initializer) {
        this.httpInitializer = Objects.requireNonNull(initializer);
        return this;
    }

    public GrpcClientBuilder<U, R> defaultTimeout(Duration defaultTimeout) {
        this.defaultTimeout = DurationUtils.ensurePositive((Duration)defaultTimeout, (String)"defaultTimeout");
        return this;
    }

    public GrpcClientBuilder<U, R> executor(Executor executor) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.executor(executor));
        return this;
    }

    public GrpcClientBuilder<U, R> ioExecutor(IoExecutor ioExecutor) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.ioExecutor(ioExecutor));
        return this;
    }

    public GrpcClientBuilder<U, R> bufferAllocator(BufferAllocator allocator) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.bufferAllocator(allocator));
        return this;
    }

    public GrpcClientBuilder<U, R> executionStrategy(GrpcExecutionStrategy strategy) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.executionStrategy((HttpExecutionStrategy)strategy));
        return this;
    }

    public <T> GrpcClientBuilder<U, R> socketOption(SocketOption<T> option, T value) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.socketOption(option, value));
        return this;
    }

    public GrpcClientBuilder<U, R> enableWireLogging(String loggerName, LogLevel logLevel, BooleanSupplier logUserData) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.enableWireLogging(loggerName, logLevel, logUserData));
        return this;
    }

    public GrpcClientBuilder<U, R> enableWireLogging(String loggerName) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.enableWireLogging(loggerName));
        return this;
    }

    public GrpcClientBuilder<U, R> protocols(HttpProtocolConfig ... protocols) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.protocols(protocols));
        return this;
    }

    public GrpcClientBuilder<U, R> appendConnectionFactoryFilter(ConnectionFactoryFilter<R, FilterableStreamingHttpConnection> factory) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.appendConnectionFactoryFilter(factory));
        return this;
    }

    public GrpcClientBuilder<U, R> appendConnectionFilter(StreamingHttpConnectionFilterFactory factory) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.appendConnectionFilter(factory));
        return this;
    }

    public GrpcClientBuilder<U, R> appendConnectionFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpConnectionFilterFactory factory) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.appendConnectionFilter(predicate, factory));
        return this;
    }

    @Deprecated
    public GrpcClientSecurityConfigurator<U, R> secure() {
        return new LazyGrpcClientConfigurator();
    }

    public GrpcClientBuilder<U, R> sslConfig(ClientSslConfig sslConfig) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.sslConfig(sslConfig));
        return this;
    }

    public GrpcClientBuilder<U, R> inferPeerHost(boolean shouldInfer) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.inferPeerHost(shouldInfer));
        return this;
    }

    public GrpcClientBuilder<U, R> inferPeerPort(boolean shouldInfer) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.inferPeerPort(shouldInfer));
        return this;
    }

    public GrpcClientBuilder<U, R> inferSniHostname(boolean shouldInfer) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.inferSniHostname(shouldInfer));
        return this;
    }

    public GrpcClientBuilder<U, R> autoRetryStrategy(AutoRetryStrategyProvider autoRetryStrategyProvider) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.autoRetryStrategy(autoRetryStrategyProvider));
        return this;
    }

    public GrpcClientBuilder<U, R> unresolvedAddressToHost(Function<U, CharSequence> unresolvedAddressToHostFunction) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.unresolvedAddressToHost(unresolvedAddressToHostFunction));
        return this;
    }

    public GrpcClientBuilder<U, R> hostHeaderFallback(boolean enable) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.hostHeaderFallback(enable));
        return this;
    }

    public GrpcClientBuilder<U, R> serviceDiscoverer(ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> serviceDiscoverer) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.serviceDiscoverer(serviceDiscoverer));
        return this;
    }

    public GrpcClientBuilder<U, R> loadBalancerFactory(HttpLoadBalancerFactory<R> loadBalancerFactory) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.loadBalancerFactory(loadBalancerFactory));
        return this;
    }

    protected GrpcClientCallFactory newGrpcClientCallFactory() {
        SingleAddressHttpClientBuilder builder = this.httpClientBuilderSupplier.get().protocols(new HttpProtocolConfig[]{HttpProtocolConfigs.h2Default()});
        builder.appendClientFilter(CatchAllHttpClientFilter.INSTANCE);
        this.directHttpInitializer.initialize(builder);
        this.httpInitializer.initialize(builder);
        builder.appendClientFilter((StreamingHttpClientFilterFactory)new TimeoutHttpRequesterFilter(GRPC_TIMEOUT_REQHDR, true));
        Duration timeout = DurationUtils.isInfinite((Duration)this.defaultTimeout, (Duration)DeadlineUtils.GRPC_MAX_TIMEOUT) ? null : this.defaultTimeout;
        return GrpcClientCallFactory.from((StreamingHttpClient)builder.buildStreaming(), (Duration)timeout);
    }

    protected void doAppendHttpClientFilter(StreamingHttpClientFilterFactory factory) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.appendClientFilter(factory));
    }

    public void doAppendHttpClientFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpClientFilterFactory factory) {
        this.directHttpInitializer = this.directHttpInitializer.append(builder -> builder.appendClientFilter(predicate, factory));
    }

    private final class LazyGrpcClientConfigurator
    implements GrpcClientSecurityConfigurator<U, R> {
        @Nullable
        SingleAddressHttpClientSecurityConfigurator<U, R> delegate;
        GrpcClientBuilder.HttpInitializer<U, R> initializer = builder -> {
            this.delegate = Objects.requireNonNull(builder.secure());
        };

        private LazyGrpcClientConfigurator() {
        }

        public GrpcClientBuilder commit() {
            this.initializer = this.initializer.append(builder -> this.delegate.commit());
            DefaultGrpcClientBuilder.this.directHttpInitializer = DefaultGrpcClientBuilder.this.directHttpInitializer.append(this.initializer);
            return DefaultGrpcClientBuilder.this;
        }

        public GrpcClientSecurityConfigurator trustManager(Supplier<InputStream> trustCertChainSupplier) {
            this.initializer = this.initializer.append(builder -> this.delegate.trustManager(trustCertChainSupplier));
            return this;
        }

        public GrpcClientSecurityConfigurator trustManager(TrustManagerFactory trustManagerFactory) {
            this.initializer = this.initializer.append(builder -> this.delegate.trustManager(trustManagerFactory));
            return this;
        }

        public GrpcClientSecurityConfigurator protocols(String ... protocols) {
            this.initializer = this.initializer.append(builder -> this.delegate.protocols(protocols));
            return this;
        }

        public GrpcClientSecurityConfigurator ciphers(Iterable ciphers) {
            this.initializer = this.initializer.append(builder -> this.delegate.ciphers(ciphers));
            return this;
        }

        public GrpcClientSecurityConfigurator sessionCacheSize(long sessionCacheSize) {
            this.initializer = this.initializer.append(builder -> this.delegate.sessionCacheSize(sessionCacheSize));
            return this;
        }

        public GrpcClientSecurityConfigurator sessionTimeout(long sessionTimeout) {
            this.initializer = this.initializer.append(builder -> this.delegate.sessionTimeout(sessionTimeout));
            return this;
        }

        public GrpcClientSecurityConfigurator provider(SecurityConfigurator.SslProvider provider) {
            this.initializer = this.initializer.append(builder -> this.delegate.provider(provider));
            return this;
        }

        public GrpcClientSecurityConfigurator hostnameVerificationAlgorithm(String hostNameVerificationAlgorithm) {
            this.initializer = this.initializer.append(builder -> this.delegate.hostnameVerificationAlgorithm(hostNameVerificationAlgorithm));
            return this;
        }

        public GrpcClientSecurityConfigurator hostnameVerification(String hostNameVerificationAlgorithm, String hostNameVerificationHost) {
            this.initializer = this.initializer.append(builder -> this.delegate.hostnameVerification(hostNameVerificationAlgorithm, hostNameVerificationHost));
            return this;
        }

        public GrpcClientSecurityConfigurator hostnameVerification(String hostNameVerificationAlgorithm, String hostNameVerificationHost, int hostNameVerificationPort) {
            this.initializer = this.initializer.append(builder -> this.delegate.hostnameVerification(hostNameVerificationAlgorithm, hostNameVerificationHost, hostNameVerificationPort));
            return this;
        }

        public GrpcClientSecurityConfigurator hostnameVerification(String hostNameVerificationHost) {
            this.initializer = this.initializer.append(builder -> this.delegate.hostnameVerification(hostNameVerificationHost));
            return this;
        }

        public GrpcClientSecurityConfigurator hostnameVerification(String hostNameVerificationHost, int hostNameVerificationPort) {
            this.initializer = this.initializer.append(builder -> this.delegate.hostnameVerification(hostNameVerificationHost, hostNameVerificationPort));
            return this;
        }

        public GrpcClientSecurityConfigurator sniHostname(String sniHostname) {
            this.initializer = this.initializer.append(builder -> this.delegate.sniHostname(sniHostname));
            return this;
        }

        public GrpcClientSecurityConfigurator disableHostnameVerification() {
            this.initializer = this.initializer.append(builder -> this.delegate.disableHostnameVerification());
            return this;
        }

        public GrpcClientSecurityConfigurator keyManager(KeyManagerFactory keyManagerFactory) {
            this.initializer = this.initializer.append(builder -> this.delegate.keyManager(keyManagerFactory));
            return this;
        }

        public GrpcClientSecurityConfigurator keyManager(Supplier<InputStream> keyCertChainSupplier, Supplier<InputStream> keySupplier) {
            this.initializer = this.initializer.append(builder -> this.delegate.keyManager(keyCertChainSupplier, keySupplier));
            return this;
        }

        public GrpcClientSecurityConfigurator keyManager(Supplier<InputStream> keyCertChainSupplier, Supplier<InputStream> keySupplier, String keyPassword) {
            this.initializer = this.initializer.append(builder -> this.delegate.keyManager(keyCertChainSupplier, keySupplier, keyPassword));
            return this;
        }
    }

    static final class CatchAllHttpClientFilter
    implements StreamingHttpClientFilterFactory,
    HttpExecutionStrategyInfluencer {
        static final StreamingHttpClientFilterFactory INSTANCE = new CatchAllHttpClientFilter();

        private CatchAllHttpClientFilter() {
        }

        public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
            return new StreamingHttpClientFilter(client){

                protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                    return CatchAllHttpClientFilter.request(delegate, strategy, request);
                }

                public Single<? extends FilterableReservedStreamingHttpConnection> reserveConnection(HttpExecutionStrategy strategy, HttpRequestMetaData metaData) {
                    return this.delegate().reserveConnection(strategy, metaData).map(r -> new ReservedStreamingHttpConnectionFilter((FilterableReservedStreamingHttpConnection)r){

                        protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                            return CatchAllHttpClientFilter.request(delegate, strategy, request);
                        }
                    });
                }
            };
        }

        private static Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
            Single resp;
            try {
                resp = delegate.request(strategy, request);
            }
            catch (Throwable t) {
                return Single.failed((Throwable)CatchAllHttpClientFilter.toGrpcException(t));
            }
            return resp.onErrorMap(CatchAllHttpClientFilter::toGrpcException);
        }

        private static GrpcStatusException toGrpcException(Throwable cause) {
            return GrpcStatus.fromThrowable((Throwable)cause).asException();
        }

        public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
            return strategy;
        }
    }
}

