/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.netty;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.client.api.AutoRetryStrategyProvider;
import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.grpc.api.GrpcClientBuilder;
import io.servicetalk.grpc.api.GrpcClientCallFactory;
import io.servicetalk.grpc.api.GrpcClientMetadata;
import io.servicetalk.grpc.api.GrpcClientSecurityConfigurator;
import io.servicetalk.grpc.api.GrpcExecutionStrategy;
import io.servicetalk.grpc.netty.DefaultGrpcClientSecurityConfigurator;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpLoadBalancerFactory;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.SingleAddressHttpClientBuilder;
import io.servicetalk.http.api.SingleAddressHttpClientSecurityConfigurator;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.netty.HttpProtocolConfigs;
import io.servicetalk.http.utils.TimeoutFromRequest;
import io.servicetalk.http.utils.TimeoutHttpRequesterFilter;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.api.ClientSslConfig;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.utils.internal.DurationUtils;
import java.net.SocketOption;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class DefaultGrpcClientBuilder<U, R>
extends GrpcClientBuilder<U, R> {
    private static final CharSequence GRPC_TIMEOUT_HEADER_KEY = CharSequences.newAsciiString((String)"grpc-timeout");
    private static final TimeoutFromRequest GRPC_TIMEOUT_REQHDR = new TimeoutFromRequest(){

        @Nullable
        public Duration apply(HttpRequestMetaData request) {
            return DefaultGrpcClientBuilder.readTimeoutHeader(request);
        }

        public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
            return strategy;
        }
    };
    @Nullable
    private Duration defaultTimeout;
    private boolean invokedBuild;
    private final SingleAddressHttpClientBuilder<U, R> httpClientBuilder;

    DefaultGrpcClientBuilder(SingleAddressHttpClientBuilder<U, R> httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder.protocols(new HttpProtocolConfig[]{HttpProtocolConfigs.h2Default()});
    }

    public GrpcClientBuilder<U, R> defaultTimeout(Duration defaultTimeout) {
        if (this.invokedBuild) {
            throw new IllegalStateException("default timeout cannot be modified after build, create a new builder");
        }
        this.defaultTimeout = DurationUtils.ensurePositive((Duration)defaultTimeout, (String)"defaultTimeout");
        return this;
    }

    public GrpcClientBuilder<U, R> ioExecutor(IoExecutor ioExecutor) {
        this.httpClientBuilder.ioExecutor(ioExecutor);
        return this;
    }

    public GrpcClientBuilder<U, R> bufferAllocator(BufferAllocator allocator) {
        this.httpClientBuilder.bufferAllocator(allocator);
        return this;
    }

    public GrpcClientBuilder<U, R> executionStrategy(GrpcExecutionStrategy strategy) {
        this.httpClientBuilder.executionStrategy((HttpExecutionStrategy)strategy);
        return this;
    }

    public <T> GrpcClientBuilder<U, R> socketOption(SocketOption<T> option, T value) {
        this.httpClientBuilder.socketOption(option, value);
        return this;
    }

    @Deprecated
    public GrpcClientBuilder<U, R> enableWireLogging(String loggerName) {
        this.httpClientBuilder.enableWireLogging(loggerName);
        return this;
    }

    public GrpcClientBuilder<U, R> enableWireLogging(String loggerName, LogLevel logLevel, BooleanSupplier logUserData) {
        this.httpClientBuilder.enableWireLogging(loggerName, logLevel, logUserData);
        return this;
    }

    public GrpcClientBuilder<U, R> protocols(HttpProtocolConfig ... protocols) {
        this.httpClientBuilder.protocols(protocols);
        return this;
    }

    public GrpcClientBuilder<U, R> appendConnectionFactoryFilter(ConnectionFactoryFilter<R, FilterableStreamingHttpConnection> factory) {
        this.httpClientBuilder.appendConnectionFactoryFilter(factory);
        return this;
    }

    public GrpcClientBuilder<U, R> appendConnectionFilter(StreamingHttpConnectionFilterFactory factory) {
        this.httpClientBuilder.appendConnectionFilter(factory);
        return this;
    }

    public GrpcClientBuilder<U, R> appendConnectionFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpConnectionFilterFactory factory) {
        this.httpClientBuilder.appendConnectionFilter(predicate, factory);
        return this;
    }

    @Deprecated
    public GrpcClientSecurityConfigurator<U, R> secure() {
        SingleAddressHttpClientSecurityConfigurator httpConfigurator = this.httpClientBuilder.secure();
        return new DefaultGrpcClientSecurityConfigurator(httpConfigurator, this);
    }

    public GrpcClientBuilder<U, R> sslConfig(ClientSslConfig sslConfig) {
        this.httpClientBuilder.sslConfig(sslConfig);
        return this;
    }

    public GrpcClientBuilder<U, R> autoRetryStrategy(AutoRetryStrategyProvider autoRetryStrategyProvider) {
        this.httpClientBuilder.autoRetryStrategy(autoRetryStrategyProvider);
        return this;
    }

    public GrpcClientBuilder<U, R> unresolvedAddressToHost(Function<U, CharSequence> unresolvedAddressToHostFunction) {
        this.httpClientBuilder.unresolvedAddressToHost(unresolvedAddressToHostFunction);
        return this;
    }

    public GrpcClientBuilder<U, R> disableHostHeaderFallback() {
        this.httpClientBuilder.disableHostHeaderFallback();
        return this;
    }

    public GrpcClientBuilder<U, R> serviceDiscoverer(ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> serviceDiscoverer) {
        this.httpClientBuilder.serviceDiscoverer(serviceDiscoverer);
        return this;
    }

    public GrpcClientBuilder<U, R> loadBalancerFactory(HttpLoadBalancerFactory<R> loadBalancerFactory) {
        this.httpClientBuilder.loadBalancerFactory(loadBalancerFactory);
        return this;
    }

    protected GrpcClientCallFactory newGrpcClientCallFactory() {
        Duration timeout;
        Duration duration = timeout = DurationUtils.isInfinite((Duration)this.defaultTimeout, (Duration)GrpcClientMetadata.GRPC_MAX_TIMEOUT) ? null : this.defaultTimeout;
        if (!this.invokedBuild && null != timeout) {
            this.httpClientBuilder.appendClientFilter((StreamingHttpClientFilterFactory)new TimeoutHttpRequesterFilter(GRPC_TIMEOUT_REQHDR, true));
        }
        this.invokedBuild = true;
        return GrpcClientCallFactory.from((StreamingHttpClient)this.httpClientBuilder.buildStreaming(), (Duration)timeout);
    }

    protected void doAppendHttpClientFilter(StreamingHttpClientFilterFactory factory) {
        this.httpClientBuilder.appendClientFilter(factory);
    }

    public void doAppendHttpClientFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpClientFilterFactory factory) {
        this.httpClientBuilder.appendClientFilter(predicate, factory);
    }

    @Nullable
    static Duration readTimeoutHeader(HttpRequestMetaData request) {
        CharSequence grpcTimeoutValue = request.headers().get(GRPC_TIMEOUT_HEADER_KEY);
        return null == grpcTimeoutValue ? null : DefaultGrpcClientBuilder.parseTimeoutHeader(grpcTimeoutValue);
    }

    private static Duration parseTimeoutHeader(CharSequence grpcTimeoutValue) throws IllegalArgumentException {
        LongFunction<Duration> toDuration;
        if (grpcTimeoutValue.length() < 2 || grpcTimeoutValue.length() > 9) {
            throw new IllegalArgumentException("grpcTimeoutValue: " + grpcTimeoutValue + " (expected 2-9 characters)");
        }
        long runningTotal = 0L;
        for (int digitIdx = 0; digitIdx < grpcTimeoutValue.length() - 1; ++digitIdx) {
            char digitChar = grpcTimeoutValue.charAt(digitIdx);
            if (digitChar < '0' || digitChar > '9') {
                throw new NumberFormatException("grpcTimeoutValue: " + grpcTimeoutValue + " (Bad digit '" + digitChar + "')");
            }
            runningTotal = runningTotal * 10L + (long)(digitChar - 48);
        }
        char unitChar = grpcTimeoutValue.charAt(grpcTimeoutValue.length() - 1);
        switch (unitChar) {
            case 'n': {
                toDuration = Duration::ofNanos;
                break;
            }
            case 'u': {
                toDuration = micros -> Duration.of(micros, ChronoUnit.MICROS);
                break;
            }
            case 'm': {
                toDuration = Duration::ofMillis;
                break;
            }
            case 'S': {
                toDuration = Duration::ofSeconds;
                break;
            }
            case 'M': {
                toDuration = Duration::ofMinutes;
                break;
            }
            case 'H': {
                toDuration = Duration::ofHours;
                break;
            }
            default: {
                throw new IllegalArgumentException("grpcTimeoutValue: " + grpcTimeoutValue + " (Bad time unit '" + unitChar + "')");
            }
        }
        return toDuration.apply(runningTotal);
    }
}

