/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.encoding.netty;

import io.netty.handler.codec.compression.JdkZlibDecoder;
import io.netty.handler.codec.compression.JdkZlibEncoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.encoding.netty.NettyChannelContentCodec;

@Deprecated
public abstract class ZipContentCodecBuilder {
    private static final int DEFAULT_MAX_CHUNK_SIZE = 0x400000;
    private int maxChunkSize = 0x400000;
    private int compressionLevel = 6;

    ZipContentCodecBuilder() {
    }

    public final ZipContentCodecBuilder withCompressionLevel(int compressionLevel) {
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("compressionLevel: " + compressionLevel + " (expected: 0-9)");
        }
        this.compressionLevel = compressionLevel;
        return this;
    }

    public final ZipContentCodecBuilder maxChunkSize(int maxChunkSize) {
        if (maxChunkSize <= 0) {
            throw new IllegalArgumentException("maxChunkSize: " + maxChunkSize + " (expected > 0)");
        }
        this.maxChunkSize = maxChunkSize;
        return this;
    }

    public abstract ContentCodec build();

    final int compressionLevel() {
        return this.compressionLevel;
    }

    final int maxChunkSize() {
        return this.maxChunkSize;
    }

    static final class DeflateContentCodecBuilder
    extends ZipContentCodecBuilder {
        private static final CharSequence DEFLATE = CharSequences.newAsciiString((CharSequence)"deflate");

        DeflateContentCodecBuilder() {
        }

        @Override
        public ContentCodec build() {
            return new NettyChannelContentCodec(DEFLATE, () -> new JdkZlibEncoder(ZlibWrapper.ZLIB, this.compressionLevel()), () -> new JdkZlibDecoder(ZlibWrapper.ZLIB, this.maxChunkSize()));
        }
    }

    static final class GzipContentCodecBuilder
    extends ZipContentCodecBuilder {
        private static final CharSequence GZIP = CharSequences.newAsciiString((CharSequence)"gzip");

        GzipContentCodecBuilder() {
        }

        @Override
        public ContentCodec build() {
            return new NettyChannelContentCodec(GZIP, () -> new JdkZlibEncoder(ZlibWrapper.GZIP, this.compressionLevel()), () -> new JdkZlibDecoder(ZlibWrapper.GZIP, this.maxChunkSize()));
        }
    }
}

