/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpLifecycleObserver;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.transport.api.ConnectionInfo;
import java.util.Objects;

final class BiHttpLifecycleObserver
implements HttpLifecycleObserver {
    private final HttpLifecycleObserver first;
    private final HttpLifecycleObserver second;

    BiHttpLifecycleObserver(HttpLifecycleObserver first, HttpLifecycleObserver second) {
        this.first = Objects.requireNonNull(first);
        this.second = Objects.requireNonNull(second);
    }

    @Override
    public HttpLifecycleObserver.HttpExchangeObserver onNewExchange() {
        HttpLifecycleObserver.HttpExchangeObserver s;
        HttpLifecycleObserver.HttpExchangeObserver f;
        try {
            f = this.first.onNewExchange();
        }
        finally {
            s = this.second.onNewExchange();
        }
        return new BiHttpExchangeObserver(f, s);
    }

    private static final class BiHttpResponseObserver
    implements HttpLifecycleObserver.HttpResponseObserver {
        private final HttpLifecycleObserver.HttpResponseObserver first;
        private final HttpLifecycleObserver.HttpResponseObserver second;

        private BiHttpResponseObserver(HttpLifecycleObserver.HttpResponseObserver first, HttpLifecycleObserver.HttpResponseObserver second) {
            this.first = Objects.requireNonNull(first);
            this.second = Objects.requireNonNull(second);
        }

        @Override
        public void onResponseData(Buffer data) {
            try {
                this.first.onResponseData(data);
            }
            finally {
                this.second.onResponseData(data);
            }
        }

        @Override
        public void onResponseTrailers(HttpHeaders trailers) {
            try {
                this.first.onResponseTrailers(trailers);
            }
            finally {
                this.second.onResponseTrailers(trailers);
            }
        }

        @Override
        public void onResponseComplete() {
            try {
                this.first.onResponseComplete();
            }
            finally {
                this.second.onResponseComplete();
            }
        }

        @Override
        public void onResponseError(Throwable cause) {
            try {
                this.first.onResponseError(cause);
            }
            finally {
                this.second.onResponseError(cause);
            }
        }

        @Override
        public void onResponseCancel() {
            try {
                this.first.onResponseCancel();
            }
            finally {
                this.second.onResponseCancel();
            }
        }
    }

    private static final class BiHttpRequestObserver
    implements HttpLifecycleObserver.HttpRequestObserver {
        private final HttpLifecycleObserver.HttpRequestObserver first;
        private final HttpLifecycleObserver.HttpRequestObserver second;

        BiHttpRequestObserver(HttpLifecycleObserver.HttpRequestObserver first, HttpLifecycleObserver.HttpRequestObserver second) {
            this.first = Objects.requireNonNull(first);
            this.second = Objects.requireNonNull(second);
        }

        @Override
        public void onRequestData(Buffer data) {
            try {
                this.first.onRequestData(data);
            }
            finally {
                this.second.onRequestData(data);
            }
        }

        @Override
        public void onRequestTrailers(HttpHeaders trailers) {
            try {
                this.first.onRequestTrailers(trailers);
            }
            finally {
                this.second.onRequestTrailers(trailers);
            }
        }

        @Override
        public void onRequestComplete() {
            try {
                this.first.onRequestComplete();
            }
            finally {
                this.second.onRequestComplete();
            }
        }

        @Override
        public void onRequestError(Throwable cause) {
            try {
                this.first.onRequestError(cause);
            }
            finally {
                this.second.onRequestError(cause);
            }
        }

        @Override
        public void onRequestCancel() {
            try {
                this.first.onRequestCancel();
            }
            finally {
                this.second.onRequestCancel();
            }
        }
    }

    private static final class BiHttpExchangeObserver
    implements HttpLifecycleObserver.HttpExchangeObserver {
        private final HttpLifecycleObserver.HttpExchangeObserver first;
        private final HttpLifecycleObserver.HttpExchangeObserver second;

        BiHttpExchangeObserver(HttpLifecycleObserver.HttpExchangeObserver first, HttpLifecycleObserver.HttpExchangeObserver second) {
            this.first = Objects.requireNonNull(first);
            this.second = Objects.requireNonNull(second);
        }

        @Override
        public void onConnectionSelected(ConnectionInfo info) {
            try {
                this.first.onConnectionSelected(info);
            }
            finally {
                this.second.onConnectionSelected(info);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HttpLifecycleObserver.HttpRequestObserver onRequest(HttpRequestMetaData requestMetaData) {
            HttpLifecycleObserver.HttpRequestObserver s;
            HttpLifecycleObserver.HttpRequestObserver f;
            try {
                f = this.first.onRequest(requestMetaData);
            }
            finally {
                s = this.second.onRequest(requestMetaData);
            }
            return new BiHttpRequestObserver(f, s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HttpLifecycleObserver.HttpResponseObserver onResponse(HttpResponseMetaData responseMetaData) {
            HttpLifecycleObserver.HttpResponseObserver s;
            HttpLifecycleObserver.HttpResponseObserver f;
            try {
                f = this.first.onResponse(responseMetaData);
            }
            finally {
                s = this.second.onResponse(responseMetaData);
            }
            return new BiHttpResponseObserver(f, s);
        }

        @Override
        public void onResponseError(Throwable cause) {
            try {
                this.first.onResponseError(cause);
            }
            finally {
                this.second.onResponseError(cause);
            }
        }

        @Override
        public void onResponseCancel() {
            try {
                this.first.onResponseCancel();
            }
            finally {
                this.second.onResponseCancel();
            }
        }

        @Override
        public void onExchangeFinally() {
            try {
                this.first.onExchangeFinally();
            }
            finally {
                this.second.onExchangeFinally();
            }
        }
    }
}

