/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.OpenSslCertificateCompressionConfig;
import io.netty.handler.ssl.OpenSslContextOption;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslContextOption;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.util.AttributeKey;
import io.servicetalk.transport.api.CertificateCompressionAlgorithm;
import io.servicetalk.transport.api.ClientSslConfig;
import io.servicetalk.transport.api.ServerSslConfig;
import io.servicetalk.transport.api.SslConfig;
import io.servicetalk.transport.netty.internal.BuilderUtils;
import io.servicetalk.transport.netty.internal.SslUtils;
import io.servicetalk.transport.netty.internal.ZlibOpenSslCertificateCompressionAlgorithm;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SslContextFactory {
    static final AttributeKey<Long> HANDSHAKE_TIMEOUT_MILLIS;
    private static final Logger LOGGER;
    @Nullable
    private static final MethodHandle SSL_PROVIDER_OPTION_SUPPORTED;
    @Nullable
    private static final MethodHandle ENDPOINT_IDENTIFICATION_ALGORITHM;

    private SslContextFactory() {
    }

    private static boolean isOptionSupported(MethodHandle isOptionSupportedMethod, SslProvider sslProvider, SslContextOption<?> option) {
        try {
            return isOptionSupportedMethod.invokeExact(sslProvider, option);
        }
        catch (Throwable t) {
            ThrowableUtils.throwException(t);
            return false;
        }
    }

    private static SslContextBuilder setEndpointIdentificationAlgorithm(@Nullable MethodHandle methodHandle, SslContextBuilder builderInstance, @Nullable String algorithm) {
        if (methodHandle == null) {
            return builderInstance;
        }
        try {
            return methodHandle.invokeExact(builderInstance, algorithm == null ? "" : algorithm);
        }
        catch (Throwable t) {
            ThrowableUtils.throwException(t);
            return builderInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SslContext forClient(ClientSslConfig config) {
        SslContextBuilder builder = SslContextBuilder.forClient();
        SslContextFactory.setEndpointIdentificationAlgorithm(ENDPOINT_IDENTIFICATION_ALGORITHM, builder, config.hostnameVerificationAlgorithm());
        KeyManagerFactory keyManagerFactory = config.keyManagerFactory();
        if (keyManagerFactory != null) {
            builder.keyManager(keyManagerFactory);
            return SslContextFactory.configureBuilder(config, builder, false);
        }
        InputStream keyCertChainSupplier = null;
        InputStream keySupplier = null;
        try {
            keyCertChainSupplier = SslContextFactory.supplierNullSafe(config.keyCertChainSupplier());
            keySupplier = SslContextFactory.supplierNullSafe(config.keySupplier());
            builder.keyManager(keyCertChainSupplier, keySupplier, config.keyPassword());
        }
        catch (Throwable throwable) {
            try {
                BuilderUtils.closeAndRethrowUnchecked(keyCertChainSupplier);
                throw throwable;
            }
            finally {
                BuilderUtils.closeAndRethrowUnchecked(keySupplier);
            }
        }
        try {
            BuilderUtils.closeAndRethrowUnchecked(keyCertChainSupplier);
            return SslContextFactory.configureBuilder(config, builder, false);
        }
        finally {
            BuilderUtils.closeAndRethrowUnchecked(keySupplier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SslContext forServer(ServerSslConfig config) {
        SslContextBuilder builder;
        KeyManagerFactory keyManagerFactory = config.keyManagerFactory();
        if (keyManagerFactory != null) {
            builder = SslContextBuilder.forServer(keyManagerFactory);
        } else {
            InputStream keyCertChainSupplier = null;
            InputStream keySupplier = null;
            try {
                keyCertChainSupplier = SslContextFactory.supplierNullSafe(config.keyCertChainSupplier());
                keySupplier = SslContextFactory.supplierNullSafe(config.keySupplier());
                builder = SslContextBuilder.forServer(keyCertChainSupplier, keySupplier, config.keyPassword());
            }
            catch (Throwable throwable) {
                try {
                    BuilderUtils.closeAndRethrowUnchecked(keyCertChainSupplier);
                    throw throwable;
                }
                finally {
                    BuilderUtils.closeAndRethrowUnchecked(keySupplier);
                }
            }
            try {
                BuilderUtils.closeAndRethrowUnchecked(keyCertChainSupplier);
            }
            finally {
                BuilderUtils.closeAndRethrowUnchecked(keySupplier);
            }
        }
        switch (config.clientAuthMode()) {
            case NONE: {
                builder.clientAuth(ClientAuth.NONE);
                return SslContextFactory.configureBuilder(config, builder, true);
            }
            case OPTIONAL: {
                builder.clientAuth(ClientAuth.OPTIONAL);
                return SslContextFactory.configureBuilder(config, builder, true);
            }
            case REQUIRE: {
                builder.clientAuth(ClientAuth.REQUIRE);
                return SslContextFactory.configureBuilder(config, builder, true);
            }
        }
        throw new IllegalArgumentException("Unsupported SslClientAuthMode: " + (Object)((Object)config.clientAuthMode()));
    }

    private static void configureTrustManager(SslConfig config, SslContextBuilder builder) {
        if (config.trustManagerFactory() != null) {
            builder.trustManager(config.trustManagerFactory());
        } else {
            InputStream trustManagerStream = SslContextFactory.supplierNullSafe(config.trustCertChainSupplier());
            try {
                builder.trustManager(trustManagerStream);
            }
            finally {
                BuilderUtils.closeAndRethrowUnchecked(trustManagerStream);
            }
        }
    }

    private static void configureCertificateCompression(SslConfig config, SslContextBuilder builder, @Nullable SslProvider nettySslProvider, boolean forServer) {
        List<CertificateCompressionAlgorithm> algorithms = config.certificateCompressionAlgorithms();
        if (algorithms == null || algorithms.isEmpty()) {
            return;
        }
        if (nettySslProvider == null) {
            nettySslProvider = forServer ? SslContext.defaultServerProvider() : SslContext.defaultClientProvider();
        }
        try {
            if (SSL_PROVIDER_OPTION_SUPPORTED != null ? !SslContextFactory.isOptionSupported(SSL_PROVIDER_OPTION_SUPPORTED, nettySslProvider, OpenSslContextOption.CERTIFICATE_COMPRESSION_ALGORITHMS) : nettySslProvider != SslProvider.OPENSSL) {
                return;
            }
        }
        catch (Throwable throwable) {
            ThrowableUtils.throwException(throwable);
        }
        OpenSslCertificateCompressionConfig.Builder configBuilder = OpenSslCertificateCompressionConfig.newBuilder();
        for (CertificateCompressionAlgorithm algorithm : algorithms) {
            if (algorithm.algorithmId() == 1) {
                configBuilder.addAlgorithm(ZlibOpenSslCertificateCompressionAlgorithm.INSTANCE, OpenSslCertificateCompressionConfig.AlgorithmMode.Both);
                continue;
            }
            throw new IllegalArgumentException("Unsupported: " + algorithm);
        }
        builder.option(OpenSslContextOption.CERTIFICATE_COMPRESSION_ALGORITHMS, configBuilder.build());
    }

    private static void configureNettyOptions(SslConfig config, SslContextBuilder builder) {
        int maxCertificateListBytes = config.maxCertificateListBytes();
        if (maxCertificateListBytes > 0) {
            builder.option(OpenSslContextOption.MAX_CERTIFICATE_LIST_BYTES, maxCertificateListBytes);
        }
    }

    private static SslContext configureBuilder(SslConfig config, SslContextBuilder builder, boolean forServer) {
        SslContext sslContext;
        SslContextFactory.configureTrustManager(config, builder);
        List<String> alpnProtocols = config.alpnProtocols();
        SslProvider nettySslProvider = SslUtils.toNettySslProvider(config.provider(), alpnProtocols != null && !alpnProtocols.isEmpty());
        builder.sessionCacheSize(config.sessionCacheSize()).sessionTimeout(config.sessionTimeout()).applicationProtocolConfig(SslUtils.nettyApplicationProtocol(alpnProtocols)).sslProvider(SslUtils.toNettySslProvider(config.provider(), alpnProtocols != null && !alpnProtocols.isEmpty())).protocols(config.sslProtocols()).ciphers(config.ciphers(), SslContextFactory.toNettyCipherSuiteFilter(config.cipherSuiteFilter()));
        SslContextFactory.configureCertificateCompression(config, builder, nettySslProvider, forServer);
        SslContextFactory.configureNettyOptions(config, builder);
        try {
            sslContext = builder.build();
        }
        catch (SSLException e) {
            throw new IllegalArgumentException("Failed to build SslContext", e);
        }
        sslContext.attributes().attr(HANDSHAKE_TIMEOUT_MILLIS).set(config.handshakeTimeout().toMillis());
        return sslContext;
    }

    @Nullable
    private static <T> T supplierNullSafe(@Nullable Supplier<T> supplier) {
        return supplier == null ? null : (T)supplier.get();
    }

    private static CipherSuiteFilter toNettyCipherSuiteFilter(SslConfig.CipherSuiteFilter cipherSuiteFilter) {
        switch (cipherSuiteFilter) {
            case PROVIDED: {
                return IdentityCipherSuiteFilter.INSTANCE;
            }
            case SUPPORTED: {
                return SupportedCipherSuiteFilter.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Unsupported CipherSuiteFilter: " + (Object)((Object)cipherSuiteFilter));
    }

    static {
        MethodHandle endpointIdentificationAlgorithm;
        MethodHandle sslProviderOptionSupported;
        HANDSHAKE_TIMEOUT_MILLIS = AttributeKey.newInstance("HANDSHAKE_TIMEOUT_MILLIS");
        LOGGER = LoggerFactory.getLogger(SslContextFactory.class);
        try {
            sslProviderOptionSupported = MethodHandles.publicLookup().findStatic(SslProvider.class, "isOptionSupported", MethodType.methodType(Boolean.TYPE, SslProvider.class, SslContextOption.class));
            SslContextFactory.isOptionSupported(sslProviderOptionSupported, SslContext.defaultClientProvider(), OpenSslContextOption.CERTIFICATE_COMPRESSION_ALGORITHMS);
        }
        catch (Throwable cause) {
            LOGGER.debug("SSLProvider#isOptionSupported(SslProvider, SslContextOption) is available only starting from Netty 4.1.88.Final. Detected Netty version: {}", (Object)SslProvider.class.getPackage().getImplementationVersion(), (Object)cause);
            sslProviderOptionSupported = null;
        }
        SSL_PROVIDER_OPTION_SUPPORTED = sslProviderOptionSupported;
        try {
            endpointIdentificationAlgorithm = MethodHandles.publicLookup().findVirtual(SslContextBuilder.class, "endpointIdentificationAlgorithm", MethodType.methodType(SslContextBuilder.class, String.class));
            SslContextFactory.setEndpointIdentificationAlgorithm(endpointIdentificationAlgorithm, SslContextBuilder.forClient(), "HTTPS");
        }
        catch (Throwable cause) {
            LOGGER.debug("SslContextBuilder#endpointIdentificationAlgorithm(String) is available only starting from Netty 4.2.0.Final. Detected Netty version: {}", (Object)SslContextBuilder.class.getPackage().getImplementationVersion(), (Object)cause);
            endpointIdentificationAlgorithm = null;
        }
        ENDPOINT_IDENTIFICATION_ALGORITHM = endpointIdentificationAlgorithm;
    }
}

