/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.Mapping;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import io.servicetalk.transport.netty.internal.SslUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SniServerChannelInitializer
implements ChannelInitializer {
    private static final Logger LOGGER;
    private static final Mapping<String, SslContext> NULL_MAPPING;
    private static final boolean CAN_SET_ALL_SETTINGS;
    private final Mapping<String, SslContext> sniMapping;
    private final int maxClientHelloLength;
    private final long clientHelloTimeoutMillis;

    @Deprecated
    public SniServerChannelInitializer(Mapping<String, SslContext> sniMapping) {
        this(sniMapping, 0, 0L);
    }

    public SniServerChannelInitializer(Mapping<String, SslContext> sniMapping, int maxClientHelloLength, long clientHelloTimeoutMillis) {
        this.sniMapping = Objects.requireNonNull(sniMapping);
        this.maxClientHelloLength = maxClientHelloLength;
        this.clientHelloTimeoutMillis = clientHelloTimeoutMillis;
    }

    @Override
    public void init(Channel channel) {
        channel.pipeline().addLast(CAN_SET_ALL_SETTINGS ? new SniHandlerWithAllSettings(this.sniMapping, this.maxClientHelloLength, this.clientHelloTimeoutMillis, channel) : new SniHandlerWithPooledAllocator(this.sniMapping, channel));
    }

    static {
        MethodHandle newCtor;
        LOGGER = LoggerFactory.getLogger(SniServerChannelInitializer.class);
        NULL_MAPPING = input -> null;
        try {
            newCtor = MethodHandles.publicLookup().findConstructor(SniHandler.class, MethodType.methodType(Void.TYPE, Mapping.class, Integer.TYPE, Long.TYPE));
            if (!(newCtor.invoke(NULL_MAPPING, 0, 0L) instanceof SniHandler)) {
                throw new IllegalStateException("MethodHandle did not return an instance of SniHandler");
            }
        }
        catch (Throwable cause) {
            LOGGER.debug("SniHandler(Mapping, int, long) constructor is available only starting from Netty 4.1.94.Final. Detected Netty version: {}", (Object)SniHandler.class.getPackage().getImplementationVersion(), (Object)cause);
            newCtor = null;
        }
        CAN_SET_ALL_SETTINGS = newCtor != null;
    }

    private static final class SniHandlerWithAllSettings
    extends SniHandler {
        private final Channel channel;

        SniHandlerWithAllSettings(Mapping<String, SslContext> mapping, int maxClientHelloLength, long clientHelloTimeoutMillis, Channel channel) {
            super(mapping, maxClientHelloLength, clientHelloTimeoutMillis);
            this.channel = channel;
        }

        @Override
        protected SslHandler newSslHandler(SslContext context, ByteBufAllocator ignore) {
            return SslUtils.newServerSslHandler(context, this.channel);
        }
    }

    private static final class SniHandlerWithPooledAllocator
    extends SniHandler {
        private final Channel channel;

        SniHandlerWithPooledAllocator(Mapping<String, SslContext> mapping, Channel channel) {
            super(mapping);
            this.channel = channel;
        }

        @Override
        protected SslHandler newSslHandler(SslContext context, ByteBufAllocator ignore) {
            return SslUtils.newServerSslHandler(context, this.channel);
        }
    }
}

