/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.incubator.channel.uring.IOUringEventLoopGroup;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.api.IoThreadFactory;
import io.servicetalk.transport.netty.internal.EventLoopAwareNettyIoExecutor;
import io.servicetalk.transport.netty.internal.EventLoopGroupIoExecutor;
import io.servicetalk.transport.netty.internal.EventLoopIoExecutor;
import io.servicetalk.transport.netty.internal.NativeTransportUtils;
import io.servicetalk.transport.netty.internal.NettyIoExecutor;
import io.servicetalk.transport.netty.internal.NettyIoThreadFactory;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyIoExecutors {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyIoExecutors.class);

    private NettyIoExecutors() {
    }

    public static EventLoopAwareNettyIoExecutor createIoExecutor() {
        return NettyIoExecutors.createIoExecutor(NettyIoExecutors.newIoThreadFactory());
    }

    public static EventLoopAwareNettyIoExecutor createIoExecutor(String threadNamePrefix) {
        return NettyIoExecutors.createIoExecutor(NettyIoExecutors.newIoThreadFactory(threadNamePrefix));
    }

    public static EventLoopAwareNettyIoExecutor createIoExecutor(int ioThreads) {
        return NettyIoExecutors.createIoExecutor(ioThreads, NettyIoExecutors.newIoThreadFactory());
    }

    public static EventLoopAwareNettyIoExecutor createIoExecutor(int ioThreads, String threadNamePrefix) {
        return NettyIoExecutors.createIoExecutor(ioThreads, NettyIoExecutors.newIoThreadFactory(threadNamePrefix));
    }

    public static <T extends Thread> EventLoopAwareNettyIoExecutor createIoExecutor(IoThreadFactory<T> threadFactory) {
        return NettyIoExecutors.createIoExecutor(0, threadFactory);
    }

    public static <T extends Thread> EventLoopAwareNettyIoExecutor createIoExecutor(int ioThreads, IoThreadFactory<T> threadFactory) {
        return new EventLoopGroupIoExecutor(NettyIoExecutors.createEventLoopGroup(ioThreads, threadFactory), true, true);
    }

    private static <T extends Thread> EventLoopGroup createEventLoopGroup(int ioThreads, IoThreadFactory<T> threadFactory) {
        NettyIoExecutors.validateIoThreads(ioThreads);
        MultithreadEventLoopGroup group = NativeTransportUtils.isIoUringAvailable() ? new IOUringEventLoopGroup(ioThreads, threadFactory) : (NativeTransportUtils.isEpollAvailable() ? new EpollEventLoopGroup(ioThreads, threadFactory) : (NativeTransportUtils.isKQueueAvailable() ? new KQueueEventLoopGroup(ioThreads, threadFactory) : new NioEventLoopGroup(ioThreads, threadFactory)));
        LOGGER.debug("Created {} for {} threads using {}.", group.getClass().getSimpleName(), ioThreads, threadFactory);
        return group;
    }

    @Deprecated
    public static NettyIoExecutor toNettyIoExecutor(IoExecutor ioExecutor) {
        Objects.requireNonNull(ioExecutor);
        if (ioExecutor instanceof NettyIoExecutor) {
            return (NettyIoExecutor)ioExecutor;
        }
        throw new IllegalArgumentException("Incompatible IoExecutor: " + ioExecutor + ". Not a netty based IoExecutor.");
    }

    @Deprecated
    public static NettyIoExecutor fromNettyEventLoop(EventLoop eventLoop) {
        return NettyIoExecutors.fromNettyEventLoop(eventLoop, false);
    }

    public static NettyIoExecutor fromNettyEventLoop(EventLoop eventLoop, boolean isIoThreadSupported) {
        return new EventLoopIoExecutor(eventLoop, true, isIoThreadSupported);
    }

    @Deprecated
    public static NettyIoExecutor fromNettyEventLoopGroup(EventLoopGroup eventLoopGroup) {
        return NettyIoExecutors.fromNettyEventLoopGroup(eventLoopGroup, false);
    }

    public static NettyIoExecutor fromNettyEventLoopGroup(EventLoopGroup eventLoopGroup, boolean isIoThreadSupported) {
        return new EventLoopGroupIoExecutor(eventLoopGroup, true, isIoThreadSupported);
    }

    private static void validateIoThreads(int ioThreads) {
        if (ioThreads < 0) {
            throw new IllegalArgumentException("ioThreads: " + ioThreads + " (expected >0)");
        }
    }

    private static NettyIoThreadFactory newIoThreadFactory() {
        return NettyIoExecutors.newIoThreadFactory(NettyIoExecutor.class.getSimpleName());
    }

    private static NettyIoThreadFactory newIoThreadFactory(String prefix) {
        return new NettyIoThreadFactory(prefix);
    }
}

