/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import io.servicetalk.utils.internal.NumberUtils;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleTimeoutInitializer
implements ChannelInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdleTimeoutInitializer.class);
    private final long timeoutMs;

    @Deprecated
    public IdleTimeoutInitializer(Duration idleTimeout) {
        this(idleTimeout.toMillis());
    }

    public IdleTimeoutInitializer(long idleTimeoutMillis) {
        this.timeoutMs = NumberUtils.ensurePositive(idleTimeoutMillis, "idleTimeoutMillis");
    }

    @Override
    public void init(Channel channel) {
        LOGGER.debug("{} Connection idle timeout is set to {}ms.", (Object)channel, (Object)this.timeoutMs);
        channel.pipeline().addLast(new IdleStateHandler(0L, 0L, this.timeoutMs, TimeUnit.MILLISECONDS){

            @Override
            protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) {
                if (evt.state() == IdleState.ALL_IDLE) {
                    ctx.pipeline().remove(this);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("{} Closing idle connection after {}ms of inactivity.", (Object)ctx.channel(), (Object)IdleTimeoutInitializer.this.timeoutMs);
                    }
                    ctx.fireUserEventTriggered(evt);
                    ctx.close();
                }
            }
        });
    }
}

