/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.servicetalk.transport.netty.internal.ChannelInitializer;

public final class CopyByteBufHandlerChannelInitializer
implements ChannelInitializer {
    public static final PooledByteBufAllocator POOLED_ALLOCATOR = PooledByteBufAllocator.DEFAULT;
    private final CopyByteBufHandler copyHandler;

    public CopyByteBufHandlerChannelInitializer(ByteBufAllocator unpooledAllocator) {
        this.copyHandler = new CopyByteBufHandler(unpooledAllocator);
    }

    @Override
    public void init(Channel channel) {
        channel.pipeline().addLast(this.copyHandler);
    }

    public static Class<? extends ChannelHandler> handlerClass() {
        return CopyByteBufHandler.class;
    }

    @ChannelHandler.Sharable
    static final class CopyByteBufHandler
    extends ChannelInboundHandlerAdapter {
        private final ByteBufAllocator unpooledAllocator;

        CopyByteBufHandler(ByteBufAllocator unpooledAllocator) {
            if (unpooledAllocator.isDirectBufferPooled()) {
                throw new IllegalArgumentException("ByteBufAllocator must be unpooled");
            }
            this.unpooledAllocator = unpooledAllocator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            boolean release = true;
            try {
                if (msg instanceof ByteBuf) {
                    ByteBuf original = (ByteBuf)msg;
                    assert (original.alloc().isDirectBufferPooled());
                    ByteBuf unpooled = this.unpooledAllocator.buffer(original.readableBytes()).writeBytes(original);
                    original.release();
                    release = false;
                    ctx.fireChannelRead(unpooled);
                } else {
                    if (msg instanceof ReferenceCounted) {
                        throw new IllegalArgumentException("Unexpected ReferenceCounted msg: " + msg.getClass() + ", expected: " + ByteBuf.class);
                    }
                    release = false;
                    ctx.fireChannelRead(msg);
                }
            }
            finally {
                if (release) {
                    ReferenceCountUtil.release(msg);
                }
            }
        }
    }
}

