/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.api;

import io.servicetalk.transport.api.AbstractSslConfigBuilder;
import io.servicetalk.transport.api.CertificateCompressionAlgorithm;
import io.servicetalk.transport.api.SslProvider;
import java.io.InputStream;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public interface SslConfig {
    @Nullable
    public TrustManagerFactory trustManagerFactory();

    @Nullable
    public Supplier<InputStream> trustCertChainSupplier();

    @Nullable
    public KeyManagerFactory keyManagerFactory();

    @Nullable
    public Supplier<InputStream> keyCertChainSupplier();

    @Nullable
    public Supplier<InputStream> keySupplier();

    @Nullable
    public String keyPassword();

    @Nullable
    public List<String> sslProtocols();

    @Nullable
    public List<String> alpnProtocols();

    @Nullable
    public List<String> ciphers();

    default public CipherSuiteFilter cipherSuiteFilter() {
        return CipherSuiteFilter.PROVIDED;
    }

    public long sessionCacheSize();

    public long sessionTimeout();

    @Nullable
    public SslProvider provider();

    @Nullable
    default public List<CertificateCompressionAlgorithm> certificateCompressionAlgorithms() {
        return null;
    }

    default public Duration handshakeTimeout() {
        return AbstractSslConfigBuilder.DEFAULT_HANDSHAKE_TIMEOUT;
    }

    default public int maxCertificateListBytes() {
        return 0;
    }

    public static enum CipherSuiteFilter {
        PROVIDED,
        SUPPORTED;

    }
}

