/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.api;

import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.utils.internal.NetworkUtils;
import java.util.Objects;
import javax.annotation.Nullable;

final class DefaultHostAndPort
implements HostAndPort {
    private static final int MAX_IPV4_LEN = 21;
    private static final int MAX_IPV6_LEN = 59;
    private static final String STR_IPV6 = "_ipv6_";
    private final String hostName;
    @Nullable
    private String toString;
    private final int port;

    DefaultHostAndPort(String hostName, int port) {
        if (NetworkUtils.isValidIpV6Address(Objects.requireNonNull(hostName))) {
            this.hostName = hostName.charAt(0) == '[' ? DefaultHostAndPort.compressIPv6(hostName, 1, hostName.length() - 1) : DefaultHostAndPort.compressIPv6(hostName, 0, hostName.length());
            this.toString = STR_IPV6;
        } else {
            this.hostName = hostName;
        }
        this.port = port;
    }

    DefaultHostAndPort(String hostName, int port, boolean isIPv6) {
        this.hostName = Objects.requireNonNull(hostName);
        this.port = port;
        this.toString = isIPv6 ? STR_IPV6 : null;
    }

    static HostAndPort parseFromIpPort(String ipPort, int startIndex) {
        int port;
        boolean isv6;
        String inetAddress;
        int i;
        if (ipPort.charAt(startIndex) == '[') {
            if (ipPort.length() - startIndex > 59) {
                throw new IllegalArgumentException("Invalid IPv6 address: " + ipPort.substring(startIndex));
            }
            i = ipPort.indexOf(93);
            if (i <= startIndex) {
                throw new IllegalArgumentException("unable to find end ']' of IPv6 address: " + ipPort.substring(startIndex));
            }
            inetAddress = ipPort.substring(startIndex + 1, i);
            isv6 = true;
            if (++i >= ipPort.length()) {
                throw new IllegalArgumentException("no port found after ']' of IPv6 address: " + ipPort.substring(startIndex));
            }
            if (ipPort.charAt(i) != ':') {
                throw new IllegalArgumentException("':' expected after ']' for IPv6 address: " + ipPort.substring(startIndex));
            }
        } else {
            if (ipPort.length() - startIndex > 21) {
                throw new IllegalArgumentException("Invalid IPv4 address: " + ipPort.substring(startIndex));
            }
            i = ipPort.lastIndexOf(58);
            if (i < 0) {
                throw new IllegalArgumentException("no port found: " + ipPort.substring(startIndex));
            }
            inetAddress = ipPort.substring(startIndex, i);
            isv6 = false;
        }
        try {
            port = Integer.parseInt(ipPort.substring(i + 1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid port " + ipPort.substring(startIndex), e);
        }
        if (!DefaultHostAndPort.isValidPort(port) || ipPort.charAt(i + 1) == '+') {
            throw new IllegalArgumentException("invalid port " + ipPort.substring(startIndex));
        }
        if (isv6) {
            if (!NetworkUtils.isValidIpV6Address(inetAddress)) {
                throw new IllegalArgumentException("Invalid IPv6 address: " + inetAddress);
            }
            inetAddress = DefaultHostAndPort.compressIPv6(inetAddress, 0, inetAddress.length());
            return new DefaultHostAndPort(inetAddress, port, true);
        }
        if (!NetworkUtils.isValidIpV4Address(inetAddress)) {
            throw new IllegalArgumentException("Invalid IPv4 address: " + inetAddress);
        }
        return new DefaultHostAndPort(inetAddress, port, false);
    }

    @Override
    public String hostName() {
        return this.hostName;
    }

    @Override
    public int port() {
        return this.port;
    }

    public String toString() {
        String str = this.toString;
        if (str == null) {
            this.toString = str = this.hostName + ':' + this.port;
        } else if (STR_IPV6.equals(str)) {
            this.toString = str = '[' + this.hostName + "]:" + this.port;
        }
        return str;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultHostAndPort that = (DefaultHostAndPort)o;
        return this.port == that.port && this.hostName.equalsIgnoreCase(that.hostName);
    }

    public int hashCode() {
        return CharSequences.caseInsensitiveHashCode(this.hostName) + this.port;
    }

    private static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    private static String compressIPv6(String rawIp, int start, int end) {
        if (end - start <= 0) {
            throw new IllegalArgumentException("Empty IPv6 address");
        }
        int longestZerosCount = 0;
        int longestZerosBegin = -1;
        int longestZerosEnd = -1;
        int zerosCount = 0;
        int zerosBegin = rawIp.charAt(start) != '0' ? -1 : 0;
        int zerosEnd = -1;
        boolean isCompressed = false;
        int prevChar = 0;
        StringBuilder compressedIPv6Builder = new StringBuilder(end - start);
        for (int i = start; i < end; ++i) {
            char c = rawIp.charAt(i);
            switch (c) {
                case '0': {
                    if (zerosBegin >= 0 && i != end - 1) break;
                    compressedIPv6Builder.append('0');
                    break;
                }
                case ':': {
                    if (prevChar == 58) {
                        isCompressed = true;
                        compressedIPv6Builder.append(':');
                        break;
                    }
                    if (zerosBegin >= 0) {
                        ++zerosCount;
                        compressedIPv6Builder.append("0:");
                        zerosEnd = compressedIPv6Builder.length();
                        break;
                    }
                    compressedIPv6Builder.append(':');
                    zerosBegin = compressedIPv6Builder.length();
                    break;
                }
                default: {
                    if (zerosEnd > 0 && zerosCount > longestZerosCount) {
                        longestZerosCount = zerosCount;
                        longestZerosBegin = zerosBegin;
                        longestZerosEnd = zerosEnd;
                    }
                    zerosEnd = -1;
                    zerosBegin = -1;
                    zerosCount = 0;
                    compressedIPv6Builder.append(c);
                }
            }
            prevChar = c;
        }
        if (!isCompressed && longestZerosBegin >= 0 && longestZerosCount > 1) {
            compressedIPv6Builder.replace(longestZerosBegin, longestZerosEnd, longestZerosBegin == 0 ? "::" : ":");
        }
        return compressedIPv6Builder.toString();
    }
}

